/*
 * Copyright 2019 NXP.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Peripherals v6.0
processor: MIMXRT1052xxxxB
package_id: MIMXRT1052DVL6B
mcu_data: ksdk2_0
processor_version: 6.0.1
board: IMXRT1050-EVKB
functionalGroups:
- name: BOARD_InitPeripherals
  called_from_default_init: true
  selectedCore: core0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'system'
- type_id: 'system_54b53072540eeeb8f8e9343e71f28176'
- global_system_definitions: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'msg'
- type_id: 'msg_6e2baaf3b97dbeef01c0043275f9a0e7'
- global_messages: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "peripherals.h"

/***********************************************************************************************************************
 * BOARD_InitPeripherals functional group
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * LPUART_1 initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'LPUART_1'
- type: 'lpuart'
- mode: 'polling'
- type_id: 'lpuart_bebe3e12b6ec22bbd14199038f2bf459'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'LPUART1'
- config_sets:
  - lpuartConfig_t:
    - lpuartConfig:
      - clockSource: 'LpuartClock'
      - lpuartSrcClkFreq: 'BOARD_BootClockRUN'
      - baudRate_Bps: '115200'
      - parityMode: 'kLPUART_ParityDisabled'
      - dataBitsCount: 'kLPUART_EightDataBits'
      - isMsb: 'false'
      - stopBitCount: 'kLPUART_OneStopBit'
      - txFifoWatermark: '0'
      - rxFifoWatermark: '1'
      - enableRxRTS: 'false'
      - enableTxCTS: 'false'
      - txCtsSource: 'kLPUART_CtsSourcePin'
      - txCtsConfig: 'kLPUART_CtsSampleAtStart'
      - rxIdleType: 'kLPUART_IdleTypeStartBit'
      - rxIdleConfig: 'kLPUART_IdleCharacter1'
      - enableTx: 'true'
      - enableRx: 'true'
    - quick_selection: 'QuickSelection1'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const lpuart_config_t LPUART_1_config = {.baudRate_Bps    = 115200,
                                         .parityMode      = kLPUART_ParityDisabled,
                                         .dataBitsCount   = kLPUART_EightDataBits,
                                         .isMsb           = false,
                                         .stopBitCount    = kLPUART_OneStopBit,
                                         .txFifoWatermark = 0,
                                         .rxFifoWatermark = 1,
                                         .enableRxRTS     = false,
                                         .enableTxCTS     = false,
                                         .txCtsSource     = kLPUART_CtsSourcePin,
                                         .txCtsConfig     = kLPUART_CtsSampleAtStart,
                                         .rxIdleType      = kLPUART_IdleTypeStartBit,
                                         .rxIdleConfig    = kLPUART_IdleCharacter1,
                                         .enableTx        = true,
                                         .enableRx        = true};

void LPUART_1_init(void)
{
    LPUART_Init(LPUART_1_PERIPHERAL, &LPUART_1_config, LPUART_1_CLOCK_SOURCE);
}

/***********************************************************************************************************************
 * LPI2C_1 initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'LPI2C_1'
- type: 'lpi2c'
- mode: 'master'
- type_id: 'lpi2c_db68d4f4f06a22e25ab51fe9bd6db4d2'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'LPI2C1'
- config_sets:
  - main:
    - clockSource: 'Lpi2cClock'
    - clockSourceFreq: 'BOARD_BootClockRUN'
    - interrupt:
      - IRQn: 'LPI2C1_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - quick_selection: 'qs_interrupt'
  - master:
    - mode: 'transfer'
    - config:
      - enableMaster: 'true'
      - enableDoze: 'true'
      - debugEnable: 'false'
      - ignoreAck: 'false'
      - pinConfig: 'kLPI2C_2PinOpenDrain'
      - baudRate_Hz: '100000'
      - busIdleTimeout_ns: '0'
      - pinLowTimeout_ns: '0'
      - sdaGlitchFilterWidth_ns: '0'
      - sclGlitchFilterWidth_ns: '0'
      - hostRequest:
        - enable: 'false'
        - source: 'kLPI2C_HostRequestExternalPin'
        - polarity: 'kLPI2C_HostRequestPinActiveHigh'
    - transfer:
      - blocking: 'true'
      - flags: ''
      - slaveAddress: '0'
      - direction: 'kLPI2C_Write'
      - subaddress: '0'
      - subaddressSize: '1'
      - dataSize: '32'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const lpi2c_master_config_t LPI2C_1_masterConfig = {
    .enableMaster            = true,
    .enableDoze              = true,
    .debugEnable             = false,
    .ignoreAck               = false,
    .pinConfig               = kLPI2C_2PinOpenDrain,
    .baudRate_Hz             = 100000,
    .busIdleTimeout_ns       = 0,
    .pinLowTimeout_ns        = 0,
    .sdaGlitchFilterWidth_ns = 0,
    .sclGlitchFilterWidth_ns = 0,
    .hostRequest             = {
        .enable = false, .source = kLPI2C_HostRequestExternalPin, .polarity = kLPI2C_HostRequestPinActiveHigh}};
lpi2c_master_transfer_t LPI2C_1_masterTransfer = {.flags          = kLPI2C_TransferDefaultFlag,
                                                  .slaveAddress   = 0,
                                                  .direction      = kLPI2C_Write,
                                                  .subaddress     = 0,
                                                  .subaddressSize = 1,
                                                  .data           = LPI2C_1_masterBuffer,
                                                  .dataSize       = 32};
uint8_t LPI2C_1_masterBuffer[LPI2C_1_MASTER_BUFFER_SIZE];

void LPI2C_1_init(void)
{
    LPI2C_MasterInit(LPI2C_1_PERIPHERAL, &LPI2C_1_masterConfig, LPI2C_1_CLOCK_FREQ);
}

/***********************************************************************************************************************
 * eLCDIF initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'eLCDIF'
- type: 'elcdif'
- mode: 'rgbMode'
- type_id: 'elcdif_1c39bcb43ed1a24bc8980672c7378576'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'LCDIF'
- config_sets:
  - fsl_elcdif:
    - config:
      - panelWidthInt: '480'
      - panelHeightInt: '272'
      - hsw: '41'
      - hfp: '4'
      - hbp: '8'
      - vsw: '10'
      - vfp: '4'
      - vbp: '2'
      - frameRate: '60 Hz'
      - polarityFlags_st:
        - vSyncActive: 'kELCDIF_VsyncActiveLow'
        - hSyncActive: 'kELCDIF_HsyncActiveLow'
        - dataEnableActive: 'kELCDIF_DataEnableActiveHigh'
        - driveDataClkEdge: 'kELCDIF_DriveDataOnRisingClkEdge'
      - bufferName: 'defaultBuffer'
      - bufferAlign: '64'
      - pixelFormat: 'kELCDIF_PixelFormatRGB565'
      - dataBus: 'kELCDIF_DataBus16Bit'
      - enablePxpHandShake: 'false'
      - start: 'true'
    - isInterruptEnabled: 'false'
    - elcdifInterruptSources: 'kELCDIF_CurFrameDoneInterruptEnable kELCDIF_TxFifoUnderflowInterruptEnable'
    - interrupt:
      - IRQn: 'LCDIF_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
/* RGB mode configuration */
const elcdif_rgb_mode_config_t eLCDIF_rgbConfig = {
    .panelWidth    = ELCDIF_PANEL_WIDTH,
    .panelHeight   = ELCDIF_PANEL_HEIGHT,
    .hsw           = 41,
    .hfp           = 4,
    .hbp           = 8,
    .vsw           = 10,
    .vfp           = 4,
    .vbp           = 2,
    .polarityFlags = (kELCDIF_VsyncActiveLow | kELCDIF_HsyncActiveLow | kELCDIF_DataEnableActiveHigh |
                      kELCDIF_DriveDataOnRisingClkEdge),
    .bufferAddr    = (uint32_t)eLCDIF_Buffer[0],
    .pixelFormat   = kELCDIF_PixelFormatRGB565,
    .dataBus       = kELCDIF_DataBus16Bit};
/* RGB buffer */
AT_NONCACHEABLE_SECTION_ALIGN(uint16_t eLCDIF_Buffer[2][ELCDIF_PANEL_HEIGHT][ELCDIF_PANEL_WIDTH],
                              ELCDIF_RGB_BUFFER_ALIGN);

void eLCDIF_init(void)
{
    /* RGB mode initialization */
    ELCDIF_RgbModeInit(ELCDIF_PERIPHERAL, &eLCDIF_rgbConfig);
    /* Enable interrupts */
    ELCDIF_EnableInterrupts(ELCDIF_PERIPHERAL,
                            (kELCDIF_CurFrameDoneInterruptEnable | kELCDIF_TxFifoUnderflowInterruptEnable));
    /* RGB mode start */
    ELCDIF_RgbModeStart(ELCDIF_PERIPHERAL);
}

/***********************************************************************************************************************
 * GPIO_1 initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'GPIO_1'
- type: 'igpio'
- mode: 'GPIO'
- type_id: 'igpio_b1c1fa279aa7069dca167502b8589cb7'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'GPIO1'
- config_sets:
  - fsl_gpio:
    - enable_irq_comb_0_15: 'false'
    - gpio_interrupt_comb_0_15:
      - IRQn: 'GPIO1_Combined_0_15_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_comb_16_31: 'false'
    - gpio_interrupt_comb_16_31:
      - IRQn: 'GPIO1_Combined_16_31_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int0: 'false'
    - gpio_interrupt_int0:
      - IRQn: 'GPIO1_INT0_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int1: 'false'
    - gpio_interrupt_int1:
      - IRQn: 'GPIO1_INT1_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int2: 'false'
    - gpio_interrupt_int2:
      - IRQn: 'GPIO1_INT2_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int3: 'false'
    - gpio_interrupt_int3:
      - IRQn: 'GPIO1_INT3_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int4: 'false'
    - gpio_interrupt_int4:
      - IRQn: 'GPIO1_INT4_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int5: 'false'
    - gpio_interrupt_int5:
      - IRQn: 'GPIO1_INT5_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int6: 'false'
    - gpio_interrupt_int6:
      - IRQn: 'GPIO1_INT6_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int7: 'false'
    - gpio_interrupt_int7:
      - IRQn: 'GPIO1_INT7_IRQn'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

void GPIO_1_init(void)
{
    /* Make sure, the clock gate for GPIO1 is enabled (e. g. in pin_mux.c) */
}

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/
void BOARD_InitPeripherals(void)
{
    /* Initialize components */
    LPUART_1_init();
    LPI2C_1_init();
    eLCDIF_init();
    GPIO_1_init();
}

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void)
{
    BOARD_InitPeripherals();
}
