/*
 * Copyright 2020-2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/* GPIO_AD_B0_13 (coord L14), UART1_RXD */
#define BOARD_UART1_RXD_PERIPHERAL                                       LPUART1   /*!< Device name: LPUART1 */
#define BOARD_UART1_RXD_SIGNAL                                                RX   /*!< LPUART1 signal: RX */

/* GPIO_AD_B0_12 (coord K14), UART1_TXD */
#define BOARD_UART1_TXD_PERIPHERAL                                       LPUART1   /*!< Device name: LPUART1 */
#define BOARD_UART1_TXD_SIGNAL                                                TX   /*!< LPUART1 signal: TX */

/* GPIO_B0_00 (coord D7), LCDIF_CLK */
#define BOARD_LCDIF_CLK_PERIPHERAL                                         LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_CLK_SIGNAL                                         lcdif_clk   /*!< LCDIF signal: lcdif_clk */

/* GPIO_B0_04 (coord C8), LCDIF_D0/BT_CFG[0] */
#define BOARD_LCDIF_D0_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D0_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D0_CHANNEL                                                0U   /*!< LCDIF lcdif_data channel: 00 */

/* GPIO_B0_05 (coord B8), LCDIF_D1/BT_CFG[1] */
#define BOARD_LCDIF_D1_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D1_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D1_CHANNEL                                                1U   /*!< LCDIF lcdif_data channel: 01 */

/* GPIO_B0_06 (coord A8), LCDIF_D2/BT_CFG[2] */
#define BOARD_LCDIF_D2_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D2_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D2_CHANNEL                                                2U   /*!< LCDIF lcdif_data channel: 02 */

/* GPIO_B0_07 (coord A9), LCDIF_D3/BT_CFG[3] */
#define BOARD_LCDIF_D3_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D3_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D3_CHANNEL                                                3U   /*!< LCDIF lcdif_data channel: 03 */

/* GPIO_B0_08 (coord B9), LCDIF_D4/BT_CFG[4] */
#define BOARD_LCDIF_D4_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D4_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D4_CHANNEL                                                4U   /*!< LCDIF lcdif_data channel: 04 */

/* GPIO_B0_09 (coord C9), LCDIF_D5/BT_CFG[5] */
#define BOARD_LCDIF_D5_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D5_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D5_CHANNEL                                                5U   /*!< LCDIF lcdif_data channel: 05 */

/* GPIO_B0_10 (coord D9), LCDIF_D6/BT_CFG[6] */
#define BOARD_LCDIF_D6_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D6_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D6_CHANNEL                                                6U   /*!< LCDIF lcdif_data channel: 06 */

/* GPIO_B0_11 (coord A10), LCDIF_D7/BT_CFG[7] */
#define BOARD_LCDIF_D7_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D7_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D7_CHANNEL                                                7U   /*!< LCDIF lcdif_data channel: 07 */

/* GPIO_B0_12 (coord C10), LCDIF_D8/BT_CFG[8] */
#define BOARD_LCDIF_D8_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D8_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D8_CHANNEL                                                8U   /*!< LCDIF lcdif_data channel: 08 */

/* GPIO_B0_13 (coord D10), LCDIF_D9/BT_CFG[9] */
#define BOARD_LCDIF_D9_PERIPHERAL                                          LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D9_SIGNAL                                         lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D9_CHANNEL                                                9U   /*!< LCDIF lcdif_data channel: 09 */

/* GPIO_B0_14 (coord E10), LCDIF_D10/BT_CFG[10] */
#define BOARD_LCDIF_D10_PERIPHERAL                                         LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D10_SIGNAL                                        lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D10_CHANNEL                                              10U   /*!< LCDIF lcdif_data channel: 10 */

/* GPIO_B0_15 (coord E11), LCDIF_D11/BT_CFG[11] */
#define BOARD_LCDIF_D11_PERIPHERAL                                         LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D11_SIGNAL                                        lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D11_CHANNEL                                              11U   /*!< LCDIF lcdif_data channel: 11 */

/* GPIO_B1_00 (coord A11), LCDIF_D12 */
#define BOARD_LCDIF_D12_PERIPHERAL                                         LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D12_SIGNAL                                        lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D12_CHANNEL                                              12U   /*!< LCDIF lcdif_data channel: 12 */

/* GPIO_B1_01 (coord B11), LCDIF_D13 */
#define BOARD_LCDIF_D13_PERIPHERAL                                         LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D13_SIGNAL                                        lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D13_CHANNEL                                              13U   /*!< LCDIF lcdif_data channel: 13 */

/* GPIO_B1_02 (coord C11), LCDIF_D14 */
#define BOARD_LCDIF_D14_PERIPHERAL                                         LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D14_SIGNAL                                        lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D14_CHANNEL                                              14U   /*!< LCDIF lcdif_data channel: 14 */

/* GPIO_B1_03 (coord D11), LCDIF_D15 */
#define BOARD_LCDIF_D15_PERIPHERAL                                         LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_D15_SIGNAL                                        lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_LCDIF_D15_CHANNEL                                              15U   /*!< LCDIF lcdif_data channel: 15 */

/* GPIO_B0_01 (coord E7), LCDIF_ENABLE */
#define BOARD_LCDIF_ENABLE_PERIPHERAL                                      LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_ENABLE_SIGNAL                                   lcdif_enable   /*!< LCDIF signal: lcdif_enable */

/* GPIO_B0_02 (coord E8), LCDIF_HSYNC */
#define BOARD_LCDIF_HSYNC_PERIPHERAL                                       LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_HSYNC_SIGNAL                                     lcdif_hsync   /*!< LCDIF signal: lcdif_hsync */

/* GPIO_B0_03 (coord D8), LCDIF_VSYNC */
#define BOARD_LCDIF_VSYNC_PERIPHERAL                                       LCDIF   /*!< Device name: LCDIF */
#define BOARD_LCDIF_VSYNC_SIGNAL                                     lcdif_vsync   /*!< LCDIF signal: lcdif_vsync */

/* GPIO_B1_15 (coord B14), USB_HOST_PWR/BACKLIGHT_CTL */
#define BOARD_BACKLIGHT_CTL_GPIO                                           GPIO2   /*!< GPIO device name: GPIO2 */
#define BOARD_BACKLIGHT_CTL_PORT                                           GPIO2   /*!< PORT device name: GPIO2 */
#define BOARD_BACKLIGHT_CTL_PIN                                              31U   /*!< GPIO2 pin index: 31 */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/* GPIO_EMC_09 (coord C2), SEMC_A0 */
#define BOARD_INITSEMCPINS_SEMC_A0_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A0_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A0_CHANNEL                                    0U   /*!< SEMC ADDR channel: 00 */

/* GPIO_EMC_10 (coord G1), SEMC_A1 */
#define BOARD_INITSEMCPINS_SEMC_A1_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A1_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A1_CHANNEL                                    1U   /*!< SEMC ADDR channel: 01 */

/* GPIO_EMC_11 (coord G3), SEMC_A2 */
#define BOARD_INITSEMCPINS_SEMC_A2_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A2_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A2_CHANNEL                                    2U   /*!< SEMC ADDR channel: 02 */

/* GPIO_EMC_12 (coord H1), SEMC_A3 */
#define BOARD_INITSEMCPINS_SEMC_A3_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A3_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A3_CHANNEL                                    3U   /*!< SEMC ADDR channel: 03 */

/* GPIO_EMC_13 (coord A6), SEMC_A4 */
#define BOARD_INITSEMCPINS_SEMC_A4_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A4_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A4_CHANNEL                                    4U   /*!< SEMC ADDR channel: 04 */

/* GPIO_EMC_14 (coord B6), SEMC_A5 */
#define BOARD_INITSEMCPINS_SEMC_A5_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A5_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A5_CHANNEL                                    5U   /*!< SEMC ADDR channel: 05 */

/* GPIO_EMC_15 (coord B1), SEMC_A6 */
#define BOARD_INITSEMCPINS_SEMC_A6_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A6_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A6_CHANNEL                                    6U   /*!< SEMC ADDR channel: 06 */

/* GPIO_EMC_16 (coord A5), SEMC_A7 */
#define BOARD_INITSEMCPINS_SEMC_A7_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A7_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A7_CHANNEL                                    7U   /*!< SEMC ADDR channel: 07 */

/* GPIO_EMC_17 (coord A4), SEMC_A8 */
#define BOARD_INITSEMCPINS_SEMC_A8_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A8_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A8_CHANNEL                                    8U   /*!< SEMC ADDR channel: 08 */

/* GPIO_EMC_18 (coord B2), SEMC_A9 */
#define BOARD_INITSEMCPINS_SEMC_A9_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A9_SIGNAL                                   ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A9_CHANNEL                                    9U   /*!< SEMC ADDR channel: 09 */

/* GPIO_EMC_23 (coord G2), SEMC_A10 */
#define BOARD_INITSEMCPINS_SEMC_A10_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A10_SIGNAL                                  ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A10_CHANNEL                                  10U   /*!< SEMC ADDR channel: 10 */

/* GPIO_EMC_19 (coord B4), SEMC_A11 */
#define BOARD_INITSEMCPINS_SEMC_A11_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A11_SIGNAL                                  ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A11_CHANNEL                                  11U   /*!< SEMC ADDR channel: 11 */

/* GPIO_EMC_20 (coord A3), SEMC_A12 */
#define BOARD_INITSEMCPINS_SEMC_A12_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_A12_SIGNAL                                  ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSEMCPINS_SEMC_A12_CHANNEL                                  12U   /*!< SEMC ADDR channel: 12 */

/* GPIO_EMC_21 (coord C1), SEMC_BA0 */
#define BOARD_INITSEMCPINS_SEMC_BA0_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_BA0_SIGNAL                                    BA   /*!< SEMC signal: BA */
#define BOARD_INITSEMCPINS_SEMC_BA0_CHANNEL                                   0U   /*!< SEMC BA channel: 0 */

/* GPIO_EMC_22 (coord F1), SEMC_BA1 */
#define BOARD_INITSEMCPINS_SEMC_BA1_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_BA1_SIGNAL                                    BA   /*!< SEMC signal: BA */
#define BOARD_INITSEMCPINS_SEMC_BA1_CHANNEL                                   1U   /*!< SEMC BA channel: 1 */

/* GPIO_EMC_24 (coord D3), SEMC_CAS */
#define BOARD_INITSEMCPINS_SEMC_CAS_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_CAS_SIGNAL                              semc_cas   /*!< SEMC signal: semc_cas */

/* GPIO_EMC_27 (coord A2), SEMC_CKE */
#define BOARD_INITSEMCPINS_SEMC_CKE_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_CKE_SIGNAL                              semc_cke   /*!< SEMC signal: semc_cke */

/* GPIO_EMC_26 (coord B3), SEMC_CLK */
#define BOARD_INITSEMCPINS_SEMC_CLK_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_CLK_SIGNAL                              semc_clk   /*!< SEMC signal: semc_clk */

/* GPIO_EMC_29 (coord E1), SEMC_CS0 */
#define BOARD_INITSEMCPINS_SEMC_CS0_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_CS0_SIGNAL                                    CS   /*!< SEMC signal: CS */
#define BOARD_INITSEMCPINS_SEMC_CS0_CHANNEL                                   0U   /*!< SEMC CS channel: 0 */

/* GPIO_EMC_00 (coord E3), SEMC_D0 */
#define BOARD_INITSEMCPINS_SEMC_D0_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D0_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D0_CHANNEL                                    0U   /*!< SEMC DATA channel: 00 */

/* GPIO_EMC_01 (coord F3), SEMC_D1 */
#define BOARD_INITSEMCPINS_SEMC_D1_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D1_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D1_CHANNEL                                    1U   /*!< SEMC DATA channel: 01 */

/* GPIO_EMC_02 (coord F4), SEMC_D2 */
#define BOARD_INITSEMCPINS_SEMC_D2_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D2_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D2_CHANNEL                                    2U   /*!< SEMC DATA channel: 02 */

/* GPIO_EMC_03 (coord G4), SEMC_D3 */
#define BOARD_INITSEMCPINS_SEMC_D3_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D3_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D3_CHANNEL                                    3U   /*!< SEMC DATA channel: 03 */

/* GPIO_EMC_04 (coord F2), SEMC_D4 */
#define BOARD_INITSEMCPINS_SEMC_D4_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D4_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D4_CHANNEL                                    4U   /*!< SEMC DATA channel: 04 */

/* GPIO_EMC_05 (coord G5), SEMC_D5 */
#define BOARD_INITSEMCPINS_SEMC_D5_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D5_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D5_CHANNEL                                    5U   /*!< SEMC DATA channel: 05 */

/* GPIO_EMC_06 (coord H5), SEMC_D6 */
#define BOARD_INITSEMCPINS_SEMC_D6_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D6_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D6_CHANNEL                                    6U   /*!< SEMC DATA channel: 06 */

/* GPIO_EMC_07 (coord H4), SEMC_D7 */
#define BOARD_INITSEMCPINS_SEMC_D7_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D7_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D7_CHANNEL                                    7U   /*!< SEMC DATA channel: 07 */

/* GPIO_EMC_30 (coord C6), SEMC_D8 */
#define BOARD_INITSEMCPINS_SEMC_D8_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D8_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D8_CHANNEL                                    8U   /*!< SEMC DATA channel: 08 */

/* GPIO_EMC_31 (coord C5), SEMC_D9 */
#define BOARD_INITSEMCPINS_SEMC_D9_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D9_SIGNAL                                   DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D9_CHANNEL                                    9U   /*!< SEMC DATA channel: 09 */

/* GPIO_EMC_32 (coord D5), SEMC_D10 */
#define BOARD_INITSEMCPINS_SEMC_D10_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D10_SIGNAL                                  DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D10_CHANNEL                                  10U   /*!< SEMC DATA channel: 10 */

/* GPIO_EMC_33 (coord C4), SEMC_D11 */
#define BOARD_INITSEMCPINS_SEMC_D11_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D11_SIGNAL                                  DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D11_CHANNEL                                  11U   /*!< SEMC DATA channel: 11 */

/* GPIO_EMC_34 (coord D4), SEMC_D12 */
#define BOARD_INITSEMCPINS_SEMC_D12_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D12_SIGNAL                                  DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D12_CHANNEL                                  12U   /*!< SEMC DATA channel: 12 */

/* GPIO_EMC_35 (coord E5), SEMC_D13 */
#define BOARD_INITSEMCPINS_SEMC_D13_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D13_SIGNAL                                  DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D13_CHANNEL                                  13U   /*!< SEMC DATA channel: 13 */

/* GPIO_EMC_36 (coord C3), SEMC_D14 */
#define BOARD_INITSEMCPINS_SEMC_D14_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D14_SIGNAL                                  DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D14_CHANNEL                                  14U   /*!< SEMC DATA channel: 14 */

/* GPIO_EMC_37 (coord E4), SEMC_D15 */
#define BOARD_INITSEMCPINS_SEMC_D15_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_D15_SIGNAL                                  DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSEMCPINS_SEMC_D15_CHANNEL                                  15U   /*!< SEMC DATA channel: 15 */

/* GPIO_EMC_08 (coord H3), SEMC_DM0 */
#define BOARD_INITSEMCPINS_SEMC_DM0_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_DM0_SIGNAL                                    DM   /*!< SEMC signal: DM */
#define BOARD_INITSEMCPINS_SEMC_DM0_CHANNEL                                   0U   /*!< SEMC DM channel: 0 */

/* GPIO_EMC_38 (coord D6), SEMC_DM1 */
#define BOARD_INITSEMCPINS_SEMC_DM1_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_DM1_SIGNAL                                    DM   /*!< SEMC signal: DM */
#define BOARD_INITSEMCPINS_SEMC_DM1_CHANNEL                                   1U   /*!< SEMC DM channel: 1 */

/* GPIO_EMC_25 (coord D2), SEMC_RAS */
#define BOARD_INITSEMCPINS_SEMC_RAS_PERIPHERAL                              SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_RAS_SIGNAL                              semc_ras   /*!< SEMC signal: semc_ras */

/* GPIO_EMC_28 (coord D1), SEMC_WE */
#define BOARD_INITSEMCPINS_SEMC_WE_PERIPHERAL                               SEMC   /*!< Device name: SEMC */
#define BOARD_INITSEMCPINS_SEMC_WE_SIGNAL                                semc_we   /*!< SEMC signal: semc_we */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitSemcPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitI2C1Pins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
