# Fuzz Testing on Google Cloud IoT Device SDK Embedded C Library

- uses the llvm’s ```libFuzzer``` library that has to be built using clang-4.0 compiler ( or newer )
- uses the ```clang-4.0``` feature of generating the coverage data from the compiler
- uses the clang's address sanitizer in order to detect errors

Full documentation of libFuzzer you can be found here http://llvm.org/docs/LibFuzzer.html

## Directory layout:

Fuzz tests are located under the ```src/tests/fuzztests```. Each file in this directory is a \*.cpp file ( yes it requires c++ compiler ) Each \*.cpp file contains the implementation of the test. Each fuzz test ( the \*.cpp ) file is compiled and linked against the ```libFuzzer```.

Under the ```src/tests/fuzztests/corpuses``` folder are located folders with generated test data. One corpus data folder per each fuzz test.

So if there is a ```src/tests/fuzztests/iotc_fuzztest_mqtt_parser.cpp``` there will be ```src/tests/fuzztests/corpuses/iotc_fuzztest_mqtt_parser``` folder with test data generated for this particular fuzz test.

## Running fuzz tests:

In order to run the fuzz tests one will need a linux environment - the best will be ubuntu x86 version.

Using ```make PRESET=FUZZ_TESTS fuzz_tests``` our makefile system will try to download and install ```clang-4.0``` and ```libFuzzer``` under the ```src/import/clang_tools/``` folder.

* Additional paramters:
    * ```IOTC_FTEST_MAX_TOTAL_TIME=``` time of maximum execution of the test in seconds, 0 means run forever.
    * ```IOTC_FTEST_MAX_LEN=``` maximum size of generated data.

## Writing new fuzz tests:

* To create new fuzz test create a new test implementation in the ```src/tests/fuzztests/``` directory.  The source file must have the extension \*.cpp.

* Within the \*.cpp file create an implementation of the fuzz test driver function:

```
extern "C" int LLVMFuzzerTestOneInput(const uint8_t *Data, size_t Size) {
  DoSomethingInterestingWithMyAPI(Data, Size);
  return 0;  // Non-zero return values are reserved for future use.
}
```

* ```LLVMFuzzerTestOneInput``` function parameters details are as follows:
    * The ```Data``` argument contains the pointer to the data buffer generated by ```libFuzzer```
    * The ```Size``` parameter is the size of that buffer.
* The ```LLVMFuzzerTestOneInput``` function will be called by the ```libFuzzer``` library with generated data throughout the whole test run.


* After running fuzz tests, a directory with fuzz test corpus data will be created automatically.


* The following is advised for new fuzz tests:
    * Run fuzz tests locally a few times. It will generate an initial data set to cover some of the functions under test, potentially excerising more paths than just a single execution.
    * Manually create test data if the function under test relies on a specific data layout and if randomized data might not be enough to cover most of the processing paths.

