#include "../../lvgl.h"

/*******************************************************************************
 * Size: 22 px
 * Bpp: 4
 * Opts: --no-compress --no-prefilter --bpp 4 --size 22 --font Roboto-Regular.woff -r 0x20-0x7F --font FontAwesome5-Solid+Brands+Regular.woff -r 61441,61448,61451,61452,61452,61453,61457,61459,61461,61465,61468,61473,61478,61479,61480,61502,61512,61515,61516,61517,61521,61522,61523,61524,61543,61544,61550,61552,61553,61556,61559,61560,61561,61563,61587,61589,61636,61637,61639,61671,61674,61683,61724,61732,61787,61931,62016,62017,62018,62019,62020,62087,62099,62212,62189,62810,63426,63650 --format lvgl -o lv_font_roboto_22.c --force-fast-kern-format
 ******************************************************************************/

#ifndef LV_FONT_ROBOTO_22
#define LV_FONT_ROBOTO_22 1
#endif

#if LV_FONT_ROBOTO_22

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x3f, 0xd0, 0x2f, 0xd0, 0x2f, 0xd0, 0x2f, 0xd0,
    0x2f, 0xd0, 0x2f, 0xc0, 0x2f, 0xc0, 0x1f, 0xc0,
    0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xb0, 0x6, 0x40,
    0x0, 0x0, 0x3, 0x20, 0x2f, 0xf0, 0x1e, 0xc0,

    /* U+22 "\"" */
    0x8f, 0xa, 0xe8, 0xf0, 0xad, 0x8e, 0xa, 0xc8,
    0xc0, 0xab, 0x8b, 0xa, 0x93, 0x40, 0x33,

    /* U+23 "#" */
    0x0, 0x0, 0x9, 0xe0, 0x3, 0xf5, 0x0, 0x0,
    0x0, 0xdb, 0x0, 0x7f, 0x10, 0x0, 0x0, 0xf,
    0x80, 0xa, 0xe0, 0x0, 0x0, 0x4, 0xf4, 0x0,
    0xea, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x38, 0x8d, 0xe8, 0x8a, 0xf9, 0x85, 0x0,
    0x0, 0xdb, 0x0, 0x7f, 0x10, 0x0, 0x0, 0xf,
    0x80, 0xa, 0xe0, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0xcb, 0x0, 0x0, 0x22, 0x6f, 0x52, 0x2f, 0xa2,
    0x20, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1,
    0x55, 0xdd, 0x55, 0x9f, 0x75, 0x40, 0x0, 0xe,
    0xa0, 0x8, 0xf0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0xbd, 0x0, 0x0, 0x0, 0x4f, 0x40, 0xe, 0xa0,
    0x0, 0x0, 0x7, 0xf1, 0x1, 0xf7, 0x0, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0x6,
    0xf3, 0x0, 0x0, 0x0, 0x4, 0xbf, 0xa3, 0x0,
    0x0, 0x1b, 0xff, 0xff, 0xf9, 0x0, 0x9, 0xfc,
    0x42, 0x6f, 0xf5, 0x1, 0xff, 0x10, 0x0, 0x6f,
    0xc0, 0x3f, 0xc0, 0x0, 0x1, 0xff, 0x2, 0xfe,
    0x0, 0x0, 0x8, 0x80, 0xe, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xfd, 0x60, 0x0, 0x0, 0x0,
    0x4e, 0xff, 0xf8, 0x10, 0x0, 0x0, 0x5, 0xbf,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x3d, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xf1, 0xcf, 0x30, 0x0,
    0x0, 0xdf, 0x2a, 0xf7, 0x0, 0x0, 0xf, 0xf1,
    0x4f, 0xf4, 0x0, 0x1a, 0xfc, 0x0, 0x9f, 0xfe,
    0xdf, 0xfe, 0x20, 0x0, 0x5b, 0xff, 0xc8, 0x10,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0,

    /* U+25 "%" */
    0x6, 0xef, 0xc3, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf9, 0x5c, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x1f, 0x60, 0x2, 0xf3, 0x0, 0xd, 0x90,
    0x0, 0xf8, 0x0, 0xcc, 0x0, 0x0, 0xcb, 0x0,
    0xf, 0x70, 0x6f, 0x20, 0x0, 0x8, 0xf5, 0x19,
    0xf2, 0x1f, 0x80, 0x0, 0x0, 0xa, 0xff, 0xf6,
    0xa, 0xd0, 0x0, 0x0, 0x0, 0x1, 0x30, 0x4,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xea,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0x11,
    0xbf, 0xfa, 0x10, 0x0, 0x0, 0x3f, 0x60, 0xce,
    0x56, 0xeb, 0x0, 0x0, 0xc, 0xc0, 0x2f, 0x50,
    0x7, 0xf0, 0x0, 0x7, 0xf2, 0x3, 0xf3, 0x0,
    0x5f, 0x20, 0x1, 0xf8, 0x0, 0x2f, 0x50, 0x7,
    0xf0, 0x0, 0x6, 0x0, 0x0, 0xce, 0x67, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xae, 0xe9, 0x0,

    /* U+26 "&" */
    0x0, 0x19, 0xef, 0xc4, 0x0, 0x0, 0x0, 0xd,
    0xfd, 0xbf, 0xf5, 0x0, 0x0, 0x7, 0xfb, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x9f, 0x60, 0x0, 0xef,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x3f, 0xb0, 0x0,
    0x0, 0x3f, 0xe1, 0x4e, 0xf3, 0x0, 0x0, 0x0,
    0x9f, 0xdf, 0xe3, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xe1, 0x0, 0x0, 0x0, 0x4, 0xff, 0xef, 0x60,
    0x0, 0x53, 0x3, 0xff, 0x53, 0xff, 0x40, 0x3f,
    0xa0, 0xbf, 0x70, 0x5, 0xfe, 0x25, 0xf8, 0xe,
    0xf1, 0x0, 0x8, 0xfd, 0xbf, 0x40, 0xdf, 0x30,
    0x0, 0xa, 0xff, 0xd0, 0x8, 0xfa, 0x0, 0x0,
    0x5f, 0xf9, 0x0, 0xc, 0xfd, 0x87, 0xbf, 0xff,
    0xf5, 0x0, 0x6, 0xcf, 0xfd, 0x92, 0x3f, 0xf3,

    /* U+27 "'" */
    0xeb, 0xeb, 0xea, 0xe9, 0xe8, 0x31,

    /* U+28 "(" */
    0x0, 0x0, 0x18, 0x0, 0x0, 0x1d, 0xe0, 0x0,
    0xc, 0xe2, 0x0, 0x7, 0xf5, 0x0, 0x0, 0xfd,
    0x0, 0x0, 0x6f, 0x60, 0x0, 0xc, 0xf1, 0x0,
    0x0, 0xfd, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x6,
    0xf8, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x8, 0xf6,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x6, 0xf8, 0x0,
    0x0, 0x5f, 0x90, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0x8f, 0x50, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x9, 0xf3, 0x0, 0x0, 0x1e,
    0xd0, 0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x0,

    /* U+29 ")" */
    0x45, 0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x8,
    0xf4, 0x0, 0x0, 0xd, 0xe0, 0x0, 0x0, 0x5f,
    0x70, 0x0, 0x0, 0xee, 0x0, 0x0, 0x9, 0xf4,
    0x0, 0x0, 0x5f, 0x80, 0x0, 0x2, 0xfc, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xe, 0xf1, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x4f, 0x90,
    0x0, 0x8, 0xf5, 0x0, 0x0, 0xcf, 0x10, 0x0,
    0x2f, 0x90, 0x0, 0xa, 0xf2, 0x0, 0x4, 0xf7,
    0x0, 0x3, 0xfa, 0x0, 0x0, 0x69, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x23, 0x0, 0xf8, 0x0, 0x30, 0x8f,
    0xd7, 0xfa, 0x9e, 0xe0, 0x38, 0xdf, 0xff, 0xfc,
    0x70, 0x0, 0xb, 0xff, 0x20, 0x0, 0x0, 0x6f,
    0x8f, 0xc0, 0x0, 0x2, 0xfc, 0x7, 0xf7, 0x0,
    0x3, 0xd2, 0x0, 0xc8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x6, 0x81, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x2e, 0xee,
    0xef, 0xfe, 0xee, 0xe8, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,

    /* U+2C "," */
    0xa, 0xf5, 0xa, 0xf4, 0xb, 0xf3, 0x1f, 0xd0,
    0x7f, 0x50, 0x5, 0x0,

    /* U+2D "-" */
    0x6a, 0xaa, 0xa6, 0x9f, 0xff, 0xfa,

    /* U+2E "." */
    0x5, 0x20, 0x5f, 0xe0, 0x3e, 0xb0,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0xd,
    0xd0, 0x0, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x0,
    0xaf, 0x10, 0x0, 0x0, 0xf, 0xb0, 0x0, 0x0,
    0x6, 0xf5, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0,
    0x0, 0x2f, 0x80, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x5f, 0x60,
    0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x1, 0xfa,
    0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0xd,
    0xd0, 0x0, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x0,
    0x9f, 0x10, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x4c, 0xff, 0xd7, 0x0, 0x0, 0x6f, 0xfc,
    0xbe, 0xfb, 0x0, 0x1f, 0xf3, 0x0, 0xc, 0xf5,
    0x6, 0xfa, 0x0, 0x0, 0x4f, 0xb0, 0x9f, 0x50,
    0x0, 0x0, 0xfe, 0xb, 0xf4, 0x0, 0x0, 0xe,
    0xf0, 0xcf, 0x30, 0x0, 0x0, 0xef, 0x1c, 0xf3,
    0x0, 0x0, 0xe, 0xf1, 0xcf, 0x30, 0x0, 0x0,
    0xef, 0x1b, 0xf3, 0x0, 0x0, 0xe, 0xf1, 0xbf,
    0x40, 0x0, 0x0, 0xef, 0x9, 0xf6, 0x0, 0x0,
    0xf, 0xe0, 0x5f, 0xa0, 0x0, 0x4, 0xfb, 0x0,
    0xff, 0x40, 0x0, 0xdf, 0x50, 0x5, 0xff, 0xba,
    0xef, 0xb0, 0x0, 0x4, 0xbf, 0xfd, 0x80, 0x0,

    /* U+31 "1" */
    0x0, 0x0, 0x39, 0xc0, 0x17, 0xdf, 0xfd, 0x2f,
    0xff, 0xbf, 0xd2, 0xc6, 0x2, 0xfd, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f,
    0xd0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2,
    0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2, 0xfd,

    /* U+32 "2" */
    0x0, 0x6c, 0xff, 0xd8, 0x0, 0x0, 0xbf, 0xfc,
    0xbf, 0xfc, 0x0, 0x6f, 0xd1, 0x0, 0x1d, 0xf7,
    0xc, 0xf4, 0x0, 0x0, 0x5f, 0xb0, 0xdd, 0x0,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x7, 0xfa, 0x0, 0x0, 0x0, 0x5, 0xfd,
    0x10, 0x0, 0x0, 0x3, 0xfe, 0x20, 0x0, 0x0,
    0x2, 0xef, 0x30, 0x0, 0x0, 0x1, 0xef, 0x50,
    0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0xbf, 0x70, 0x0, 0x0, 0x0, 0x9f, 0xfa, 0xaa,
    0xaa, 0xaa, 0x5b, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+33 "3" */
    0x0, 0x6c, 0xff, 0xc7, 0x0, 0xb, 0xff, 0xbb,
    0xff, 0xb0, 0x6f, 0xc1, 0x0, 0x1d, 0xf5, 0xbf,
    0x40, 0x0, 0x6, 0xf9, 0x34, 0x0, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x9, 0xf7, 0x0, 0x0,
    0x1, 0x8f, 0xd0, 0x0, 0xd, 0xff, 0xfb, 0x10,
    0x0, 0x8, 0xac, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x1d, 0xf6, 0x0, 0x0, 0x0, 0x4, 0xfc, 0x55,
    0x0, 0x0, 0x1, 0xfe, 0xef, 0x20, 0x0, 0x3,
    0xfc, 0x9f, 0xb0, 0x0, 0x1c, 0xf7, 0x1d, 0xfe,
    0xbb, 0xef, 0xb0, 0x0, 0x7d, 0xff, 0xc7, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0xb, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xfb, 0x0, 0x0, 0x0, 0x9, 0xfa, 0xfb, 0x0,
    0x0, 0x0, 0x3f, 0xb5, 0xfb, 0x0, 0x0, 0x0,
    0xcf, 0x25, 0xfb, 0x0, 0x0, 0x6, 0xf8, 0x5,
    0xfb, 0x0, 0x0, 0x1e, 0xe0, 0x5, 0xfb, 0x0,
    0x0, 0xaf, 0x50, 0x5, 0xfb, 0x0, 0x3, 0xfb,
    0x0, 0x5, 0xfb, 0x0, 0xd, 0xf2, 0x0, 0x5,
    0xfb, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x4a, 0xaa, 0xaa, 0xac, 0xfe, 0xa9, 0x0, 0x0,
    0x0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfb, 0x0,

    /* U+35 "5" */
    0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x2f, 0xfd,
    0xdd, 0xdd, 0xd0, 0x3, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x70, 0x0, 0x0, 0x0, 0x7, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x79, 0xbb, 0x71,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x9f,
    0x81, 0x3, 0xdf, 0xc0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x20, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x72, 0x74, 0x0, 0x0,
    0x9, 0xf6, 0x2f, 0xc0, 0x0, 0x0, 0xdf, 0x30,
    0xcf, 0x70, 0x0, 0x8f, 0xd0, 0x2, 0xef, 0xda,
    0xdf, 0xf3, 0x0, 0x2, 0x9e, 0xfe, 0xa2, 0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x5b, 0xef, 0x10, 0x0, 0x1, 0xcf,
    0xfd, 0xb1, 0x0, 0x0, 0xcf, 0xb2, 0x0, 0x0,
    0x0, 0x6f, 0xa0, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x2, 0xfb, 0x17, 0xa9, 0x50,
    0x0, 0x6f, 0xcf, 0xff, 0xff, 0xb0, 0x8, 0xff,
    0xb3, 0x3, 0xef, 0x80, 0x9f, 0xc0, 0x0, 0x3,
    0xfe, 0x9, 0xf6, 0x0, 0x0, 0xd, 0xf3, 0x8f,
    0x70, 0x0, 0x0, 0xbf, 0x46, 0xf9, 0x0, 0x0,
    0xc, 0xf3, 0x2f, 0xe0, 0x0, 0x1, 0xff, 0x0,
    0xaf, 0x90, 0x0, 0xaf, 0xa0, 0x1, 0xdf, 0xeb,
    0xef, 0xd1, 0x0, 0x1, 0x9e, 0xfe, 0x81, 0x0,

    /* U+37 "7" */
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x1a, 0xaa,
    0xaa, 0xaa, 0xae, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x50,
    0x0, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0, 0x0,
    0x3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x70, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x4b, 0xff, 0xd7, 0x0, 0x0, 0x7f, 0xfc,
    0xbf, 0xfc, 0x0, 0x1f, 0xf4, 0x0, 0x1d, 0xf6,
    0x5, 0xfb, 0x0, 0x0, 0x5f, 0xb0, 0x6f, 0x90,
    0x0, 0x4, 0xfb, 0x3, 0xfd, 0x0, 0x0, 0x7f,
    0x80, 0xb, 0xf9, 0x10, 0x5f, 0xe1, 0x0, 0xa,
    0xff, 0xff, 0xd2, 0x0, 0x4, 0xef, 0xcb, 0xef,
    0x80, 0x2, 0xfe, 0x20, 0x0, 0xbf, 0x70, 0x9f,
    0x60, 0x0, 0x1, 0xff, 0xc, 0xf3, 0x0, 0x0,
    0xe, 0xf1, 0xbf, 0x50, 0x0, 0x0, 0xff, 0x6,
    0xfd, 0x10, 0x0, 0x9f, 0xb0, 0xb, 0xff, 0xbb,
    0xef, 0xe2, 0x0, 0x6, 0xcf, 0xfd, 0x81, 0x0,

    /* U+39 "9" */
    0x0, 0x5c, 0xfe, 0xb3, 0x0, 0x9, 0xff, 0xbc,
    0xff, 0x50, 0x4f, 0xe2, 0x0, 0x5f, 0xf1, 0xaf,
    0x60, 0x0, 0x9, 0xf7, 0xdf, 0x20, 0x0, 0x4,
    0xfb, 0xef, 0x10, 0x0, 0x1, 0xfd, 0xcf, 0x30,
    0x0, 0x1, 0xfe, 0x9f, 0x80, 0x0, 0x7, 0xfe,
    0x2f, 0xf7, 0x1, 0x8f, 0xfd, 0x6, 0xff, 0xff,
    0xf9, 0xfb, 0x0, 0x28, 0xa8, 0x24, 0xf8, 0x0,
    0x0, 0x0, 0x9, 0xf4, 0x0, 0x0, 0x0, 0x2f,
    0xd0, 0x0, 0x0, 0x5, 0xef, 0x50, 0x0, 0x8c,
    0xff, 0xf6, 0x0, 0x0, 0xbe, 0xc8, 0x20, 0x0,

    /* U+3A ":" */
    0x4f, 0x97, 0xfd, 0x5, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x52, 0x7f,
    0xd4, 0xf9,

    /* U+3B ";" */
    0x8, 0xf5, 0xb, 0xf9, 0x1, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x94, 0x8, 0xf7, 0x8, 0xf6,
    0xb, 0xf2, 0x3f, 0xb0, 0x3b, 0x10,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x77, 0x0, 0x0, 0x1,
    0x8e, 0xf9, 0x0, 0x2, 0x9f, 0xff, 0xa2, 0x2,
    0xaf, 0xfd, 0x71, 0x0, 0x3f, 0xfb, 0x40, 0x0,
    0x0, 0x2f, 0xfb, 0x50, 0x0, 0x0, 0x1, 0x8f,
    0xfe, 0x81, 0x0, 0x0, 0x1, 0x8e, 0xff, 0xa3,
    0x0, 0x0, 0x0, 0x7e, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x66,

    /* U+3D "=" */
    0x5f, 0xff, 0xff, 0xff, 0xf9, 0x4c, 0xcc, 0xcc,
    0xcc, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4b, 0xbb, 0xbb, 0xbb,
    0xb6, 0x5f, 0xff, 0xff, 0xff, 0xf9,

    /* U+3E ">" */
    0x77, 0x10, 0x0, 0x0, 0x0, 0x9f, 0xf9, 0x20,
    0x0, 0x0, 0x18, 0xef, 0xfb, 0x30, 0x0, 0x0,
    0x5, 0xbf, 0xfc, 0x50, 0x0, 0x0, 0x1, 0x8e,
    0xf9, 0x0, 0x0, 0x4, 0xaf, 0xf8, 0x0, 0x17,
    0xdf, 0xfa, 0x30, 0x2a, 0xff, 0xf9, 0x20, 0x0,
    0x9f, 0xe7, 0x10, 0x0, 0x0, 0x66, 0x0, 0x0,
    0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x3b, 0xef, 0xd8, 0x0, 0x4, 0xff, 0xed,
    0xff, 0xb0, 0xe, 0xf6, 0x0, 0x2e, 0xf3, 0x2e,
    0xc0, 0x0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x0, 0xd, 0xf3, 0x0, 0x0,
    0x0, 0x8f, 0xb0, 0x0, 0x0, 0x7, 0xfe, 0x10,
    0x0, 0x0, 0x5f, 0xe2, 0x0, 0x0, 0x0, 0xdf,
    0x40, 0x0, 0x0, 0x1, 0xff, 0x0, 0x0, 0x0,
    0x1, 0x76, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x2,
    0xff, 0x0, 0x0, 0x0, 0x1, 0xed, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x1, 0x7c, 0xef, 0xec, 0x71, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfb, 0x87, 0x8b, 0xfe,
    0x50, 0x0, 0x0, 0x8, 0xf9, 0x10, 0x0, 0x0,
    0x19, 0xf6, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x2, 0xfa, 0x0, 0x0,
    0x1, 0x0, 0x0, 0xc, 0xa0, 0x9, 0xf1, 0x0,
    0x5, 0xdf, 0xfa, 0x10, 0x5, 0xf1, 0xf, 0x90,
    0x0, 0x5f, 0xb5, 0x6f, 0x90, 0x0, 0xf4, 0x4f,
    0x40, 0x1, 0xfb, 0x0, 0x1f, 0x80, 0x0, 0xe7,
    0x8f, 0x0, 0x7, 0xf3, 0x0, 0x2f, 0x60, 0x0,
    0xc9, 0xae, 0x0, 0xc, 0xe0, 0x0, 0x3f, 0x50,
    0x0, 0xc9, 0xbd, 0x0, 0xf, 0xb0, 0x0, 0x5f,
    0x30, 0x0, 0xc9, 0xbc, 0x0, 0x1f, 0x90, 0x0,
    0x6f, 0x20, 0x0, 0xe7, 0xbd, 0x0, 0x1f, 0xa0,
    0x0, 0xaf, 0x10, 0x2, 0xf4, 0x9f, 0x0, 0xf,
    0xe0, 0x3, 0xff, 0x20, 0xa, 0xd0, 0x6f, 0x20,
    0x9, 0xfd, 0xaf, 0x9f, 0xb5, 0x9f, 0x40, 0x2f,
    0x70, 0x0, 0xaf, 0xd6, 0x6, 0xef, 0xc4, 0x0,
    0xb, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xb1, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0, 0x0, 0x6, 0xef, 0xb7, 0x67,
    0xae, 0x60, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce,
    0xff, 0xc7, 0x10, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x0, 0xef, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xfe, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfd, 0x7f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x72, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xf2, 0xc, 0xf2, 0x0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x8f, 0x60,
    0x1, 0xfe, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0x4, 0xfb, 0x0, 0x0,
    0x5f, 0xa0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xf, 0xfb, 0xbb, 0xbb, 0xbd,
    0xf6, 0x0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0x4f,
    0xc0, 0x0, 0xcf, 0x40, 0x0, 0x0, 0x0, 0xef,
    0x20, 0x2f, 0xe0, 0x0, 0x0, 0x0, 0x9, 0xf8,
    0x8, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0,

    /* U+42 "B" */
    0x3f, 0xff, 0xff, 0xfd, 0x91, 0x0, 0x3f, 0xfb,
    0xbb, 0xcf, 0xfe, 0x20, 0x3f, 0xe0, 0x0, 0x0,
    0xbf, 0xb0, 0x3f, 0xe0, 0x0, 0x0, 0x2f, 0xf0,
    0x3f, 0xe0, 0x0, 0x0, 0x1f, 0xf0, 0x3f, 0xe0,
    0x0, 0x0, 0x5f, 0xd0, 0x3f, 0xe0, 0x0, 0x15,
    0xef, 0x40, 0x3f, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x3f, 0xfb, 0xbb, 0xbd, 0xfd, 0x20, 0x3f, 0xe0,
    0x0, 0x0, 0x6f, 0xe0, 0x3f, 0xe0, 0x0, 0x0,
    0xc, 0xf4, 0x3f, 0xe0, 0x0, 0x0, 0xa, 0xf7,
    0x3f, 0xe0, 0x0, 0x0, 0xd, 0xf5, 0x3f, 0xe0,
    0x0, 0x0, 0x8f, 0xf1, 0x3f, 0xfb, 0xbb, 0xbe,
    0xff, 0x50, 0x3f, 0xff, 0xff, 0xfe, 0xa3, 0x0,

    /* U+43 "C" */
    0x0, 0x3, 0xae, 0xfe, 0xb5, 0x0, 0x0, 0x8,
    0xff, 0xdc, 0xdf, 0xf9, 0x0, 0x6, 0xfe, 0x40,
    0x0, 0x3e, 0xf6, 0x0, 0xef, 0x40, 0x0, 0x0,
    0x4f, 0xe0, 0x5f, 0xc0, 0x0, 0x0, 0x0, 0xef,
    0x38, 0xf8, 0x0, 0x0, 0x0, 0x2, 0x31, 0xaf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x80, 0x0, 0x0, 0x0, 0x22, 0x5,
    0xfc, 0x0, 0x0, 0x0, 0xe, 0xf3, 0xe, 0xf4,
    0x0, 0x0, 0x4, 0xfe, 0x0, 0x6f, 0xe3, 0x0,
    0x3, 0xdf, 0x60, 0x0, 0x8f, 0xfd, 0xbd, 0xff,
    0x90, 0x0, 0x0, 0x4b, 0xef, 0xeb, 0x40, 0x0,

    /* U+44 "D" */
    0x3f, 0xff, 0xff, 0xea, 0x30, 0x0, 0x3, 0xff,
    0xbb, 0xbe, 0xff, 0x90, 0x0, 0x3f, 0xe0, 0x0,
    0x3, 0xdf, 0x80, 0x3, 0xfe, 0x0, 0x0, 0x1,
    0xef, 0x30, 0x3f, 0xe0, 0x0, 0x0, 0x7, 0xf9,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x2f, 0xe0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0xff, 0x3, 0xfe, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x3f, 0xe0, 0x0, 0x0,
    0x0, 0xef, 0x13, 0xfe, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x3f, 0xe0, 0x0, 0x0, 0x2, 0xfe, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x7f, 0xa0, 0x3f, 0xe0,
    0x0, 0x0, 0x2f, 0xf3, 0x3, 0xfe, 0x0, 0x0,
    0x4e, 0xf9, 0x0, 0x3f, 0xfb, 0xbb, 0xef, 0xf9,
    0x0, 0x3, 0xff, 0xff, 0xfd, 0x93, 0x0, 0x0,

    /* U+45 "E" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xa3, 0xff, 0xbb,
    0xbb, 0xbb, 0xb7, 0x3f, 0xe0, 0x0, 0x0, 0x0,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0x3f, 0xfb, 0xbb, 0xbb,
    0xb7, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfb, 0xbb,
    0xbb, 0xbb, 0x83, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+46 "F" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x83, 0xff, 0xbb,
    0xbb, 0xbb, 0xb5, 0x3f, 0xe0, 0x0, 0x0, 0x0,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xbb, 0xbb, 0xbb, 0x40, 0x3f, 0xff, 0xff, 0xff,
    0xf7, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0,
    0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x4, 0xae, 0xfe, 0xb6, 0x0, 0x0, 0x9,
    0xff, 0xdb, 0xdf, 0xfb, 0x0, 0x6, 0xfe, 0x40,
    0x0, 0x3d, 0xf9, 0x0, 0xef, 0x40, 0x0, 0x0,
    0x2f, 0xf1, 0x5f, 0xd0, 0x0, 0x0, 0x0, 0xac,
    0x38, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x5f,
    0xff, 0xff, 0x59, 0xf7, 0x0, 0x3, 0xbb, 0xbe,
    0xf5, 0x8f, 0x90, 0x0, 0x0, 0x0, 0xbf, 0x54,
    0xfe, 0x0, 0x0, 0x0, 0xb, 0xf5, 0xd, 0xf7,
    0x0, 0x0, 0x0, 0xbf, 0x50, 0x4f, 0xf6, 0x0,
    0x0, 0x3e, 0xf5, 0x0, 0x5f, 0xfe, 0xbb, 0xef,
    0xfa, 0x0, 0x0, 0x29, 0xdf, 0xfd, 0xa4, 0x0,

    /* U+48 "H" */
    0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3f, 0xd3, 0xfe,
    0x0, 0x0, 0x0, 0x3, 0xfd, 0x3f, 0xe0, 0x0,
    0x0, 0x0, 0x3f, 0xd3, 0xfe, 0x0, 0x0, 0x0,
    0x3, 0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3f,
    0xd3, 0xfe, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3f, 0xd3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x3f, 0xfb, 0xbb, 0xbb,
    0xbb, 0xcf, 0xd3, 0xfe, 0x0, 0x0, 0x0, 0x3,
    0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3f, 0xd3,
    0xfe, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3f, 0xd3, 0xfe, 0x0, 0x0,
    0x0, 0x3, 0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x0,
    0x3f, 0xd3, 0xfe, 0x0, 0x0, 0x0, 0x3, 0xfd,

    /* U+49 "I" */
    0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,
    0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,
    0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,
    0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x70, 0x0, 0x0,
    0x0, 0xa, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x70, 0x0, 0x0, 0x0, 0xa, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x70, 0x0, 0x0, 0x0, 0xa,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x70, 0x0,
    0x0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x70, 0x0, 0x0, 0x0, 0xa, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x73, 0x96, 0x0, 0x0,
    0xa, 0xf6, 0x5f, 0xd0, 0x0, 0x0, 0xef, 0x41,
    0xff, 0x70, 0x0, 0x8f, 0xe0, 0x6, 0xff, 0xdb,
    0xef, 0xf4, 0x0, 0x3, 0xbe, 0xfe, 0xa2, 0x0,

    /* U+4B "K" */
    0x3f, 0xe0, 0x0, 0x0, 0x9, 0xfd, 0x3, 0xfe,
    0x0, 0x0, 0x7, 0xfe, 0x10, 0x3f, 0xe0, 0x0,
    0x5, 0xff, 0x30, 0x3, 0xfe, 0x0, 0x4, 0xff,
    0x40, 0x0, 0x3f, 0xe0, 0x2, 0xff, 0x60, 0x0,
    0x3, 0xfe, 0x1, 0xef, 0x80, 0x0, 0x0, 0x3f,
    0xe0, 0xdf, 0xa0, 0x0, 0x0, 0x3, 0xfe, 0xbf,
    0xf7, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xdf, 0xf3,
    0x0, 0x0, 0x3, 0xff, 0xd1, 0x8f, 0xe1, 0x0,
    0x0, 0x3f, 0xf1, 0x0, 0xcf, 0xb0, 0x0, 0x3,
    0xfe, 0x0, 0x1, 0xef, 0x70, 0x0, 0x3f, 0xe0,
    0x0, 0x4, 0xff, 0x30, 0x3, 0xfe, 0x0, 0x0,
    0x8, 0xfd, 0x10, 0x3f, 0xe0, 0x0, 0x0, 0xc,
    0xfa, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x1e, 0xf6,

    /* U+4C "L" */
    0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfb, 0xbb,
    0xbb, 0xbb, 0x33, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+4D "M" */
    0x3f, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0x63, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf6, 0x3f, 0xff, 0x70, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0x63, 0xfd, 0xfd, 0x0, 0x0, 0x0, 0xa,
    0xfd, 0xf6, 0x3f, 0xbc, 0xf3, 0x0, 0x0, 0x1,
    0xfe, 0x8f, 0x63, 0xfb, 0x5f, 0xa0, 0x0, 0x0,
    0x7f, 0x88, 0xf6, 0x3f, 0xc0, 0xef, 0x0, 0x0,
    0xd, 0xf2, 0x9f, 0x63, 0xfc, 0x9, 0xf6, 0x0,
    0x3, 0xfb, 0x9, 0xf6, 0x3f, 0xd0, 0x2f, 0xc0,
    0x0, 0xaf, 0x50, 0xaf, 0x63, 0xfd, 0x0, 0xcf,
    0x30, 0xf, 0xe0, 0xa, 0xf6, 0x3f, 0xe0, 0x6,
    0xf9, 0x6, 0xf8, 0x0, 0xbf, 0x63, 0xfe, 0x0,
    0xf, 0xf0, 0xcf, 0x20, 0xb, 0xf6, 0x3f, 0xe0,
    0x0, 0x9f, 0x8f, 0xc0, 0x0, 0xbf, 0x63, 0xfe,
    0x0, 0x3, 0xff, 0xf5, 0x0, 0xb, 0xf6, 0x3f,
    0xe0, 0x0, 0xc, 0xfe, 0x0, 0x0, 0xbf, 0x63,
    0xfe, 0x0, 0x0, 0x6f, 0x90, 0x0, 0xb, 0xf6,

    /* U+4E "N" */
    0x3f, 0xf3, 0x0, 0x0, 0x0, 0x3f, 0xd3, 0xff,
    0xd0, 0x0, 0x0, 0x3, 0xfd, 0x3f, 0xff, 0x70,
    0x0, 0x0, 0x3f, 0xd3, 0xff, 0xff, 0x20, 0x0,
    0x3, 0xfd, 0x3f, 0xe9, 0xfc, 0x0, 0x0, 0x3f,
    0xd3, 0xfe, 0xe, 0xf6, 0x0, 0x3, 0xfd, 0x3f,
    0xe0, 0x4f, 0xe1, 0x0, 0x3f, 0xd3, 0xfe, 0x0,
    0xaf, 0xa0, 0x3, 0xfd, 0x3f, 0xe0, 0x1, 0xef,
    0x40, 0x3f, 0xd3, 0xfe, 0x0, 0x6, 0xfe, 0x3,
    0xfd, 0x3f, 0xe0, 0x0, 0xb, 0xf9, 0x3f, 0xd3,
    0xfe, 0x0, 0x0, 0x2f, 0xf7, 0xfd, 0x3f, 0xe0,
    0x0, 0x0, 0x7f, 0xff, 0xd3, 0xfe, 0x0, 0x0,
    0x0, 0xdf, 0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xd3, 0xfe, 0x0, 0x0, 0x0, 0x8, 0xfd,

    /* U+4F "O" */
    0x0, 0x3, 0xae, 0xfe, 0xa4, 0x0, 0x0, 0x7,
    0xff, 0xed, 0xef, 0xf9, 0x0, 0x5, 0xff, 0x60,
    0x0, 0x4e, 0xf7, 0x0, 0xef, 0x50, 0x0, 0x0,
    0x3f, 0xf0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0xbf,
    0x68, 0xf8, 0x0, 0x0, 0x0, 0x6, 0xfa, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0xcb, 0xf5, 0x0,
    0x0, 0x0, 0x3, 0xfd, 0xbf, 0x50, 0x0, 0x0,
    0x0, 0x3f, 0xda, 0xf5, 0x0, 0x0, 0x0, 0x4,
    0xfc, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x6f, 0xa4,
    0xfd, 0x0, 0x0, 0x0, 0xa, 0xf6, 0xe, 0xf5,
    0x0, 0x0, 0x3, 0xff, 0x10, 0x5f, 0xf5, 0x0,
    0x3, 0xef, 0x70, 0x0, 0x6f, 0xfe, 0xce, 0xff,
    0x90, 0x0, 0x0, 0x3a, 0xef, 0xeb, 0x40, 0x0,

    /* U+50 "P" */
    0x3f, 0xff, 0xff, 0xfe, 0xb6, 0x0, 0x3, 0xff,
    0xbb, 0xbb, 0xdf, 0xfb, 0x0, 0x3f, 0xe0, 0x0,
    0x0, 0x3e, 0xf7, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x5f, 0xd0, 0x3f, 0xe0, 0x0, 0x0, 0x1, 0xff,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x1f, 0xf0, 0x3f,
    0xe0, 0x0, 0x0, 0x6, 0xfd, 0x3, 0xfe, 0x0,
    0x0, 0x17, 0xff, 0x60, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x3, 0xff, 0xbb, 0xbb, 0xa7, 0x20,
    0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x3, 0xae, 0xfe, 0xa3, 0x0, 0x0, 0x8,
    0xff, 0xed, 0xef, 0xf8, 0x0, 0x6, 0xfe, 0x50,
    0x0, 0x5f, 0xf6, 0x0, 0xff, 0x40, 0x0, 0x0,
    0x4f, 0xe0, 0x6f, 0xb0, 0x0, 0x0, 0x0, 0xcf,
    0x5a, 0xf7, 0x0, 0x0, 0x0, 0x8, 0xf9, 0xcf,
    0x40, 0x0, 0x0, 0x0, 0x5f, 0xbd, 0xf3, 0x0,
    0x0, 0x0, 0x4, 0xfc, 0xdf, 0x30, 0x0, 0x0,
    0x0, 0x4f, 0xcc, 0xf4, 0x0, 0x0, 0x0, 0x5,
    0xfa, 0xaf, 0x70, 0x0, 0x0, 0x0, 0x7f, 0x96,
    0xfb, 0x0, 0x0, 0x0, 0xc, 0xf4, 0xf, 0xf4,
    0x0, 0x0, 0x4, 0xfe, 0x0, 0x6f, 0xe4, 0x0,
    0x4, 0xef, 0x50, 0x0, 0x8f, 0xfe, 0xce, 0xff,
    0x70, 0x0, 0x0, 0x3a, 0xef, 0xef, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x1b, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x0,

    /* U+52 "R" */
    0x3f, 0xff, 0xff, 0xfd, 0x92, 0x0, 0x3, 0xff,
    0xbb, 0xbc, 0xff, 0xf4, 0x0, 0x3f, 0xe0, 0x0,
    0x0, 0x9f, 0xe0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0xef, 0x40, 0x3f, 0xe0, 0x0, 0x0, 0xa, 0xf6,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0xbf, 0x60, 0x3f,
    0xe0, 0x0, 0x0, 0x1f, 0xf2, 0x3, 0xfe, 0x0,
    0x1, 0x4d, 0xfa, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x3, 0xff, 0xbb, 0xbd, 0xfb, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x1f, 0xf2, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x7f, 0xb0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0xef, 0x30, 0x3, 0xfe, 0x0, 0x0,
    0x6, 0xfc, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0xd,
    0xf5, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x5f, 0xd0,

    /* U+53 "S" */
    0x0, 0x3, 0xae, 0xfe, 0xb6, 0x0, 0x0, 0x7,
    0xff, 0xec, 0xdf, 0xfb, 0x0, 0x3, 0xff, 0x50,
    0x0, 0x2c, 0xf9, 0x0, 0x8f, 0x90, 0x0, 0x0,
    0x2f, 0xf0, 0x9, 0xf8, 0x0, 0x0, 0x0, 0xbb,
    0x10, 0x6f, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xe7, 0x10, 0x0, 0x0, 0x0, 0x1, 0x9f,
    0xff, 0xc7, 0x10, 0x0, 0x0, 0x0, 0x27, 0xdf,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x29, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xe, 0xf2, 0xe, 0xf3,
    0x0, 0x0, 0x0, 0xff, 0x20, 0x7f, 0xe4, 0x0,
    0x0, 0xaf, 0xd0, 0x0, 0x9f, 0xfd, 0xbc, 0xff,
    0xe3, 0x0, 0x0, 0x3a, 0xef, 0xfd, 0x81, 0x0,

    /* U+54 "T" */
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa5, 0xbb,
    0xbb, 0xdf, 0xeb, 0xbb, 0xb7, 0x0, 0x0, 0x7,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x90, 0x0, 0x0,

    /* U+55 "U" */
    0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80,
    0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0,
    0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd,
    0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80,
    0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0,
    0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd,
    0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80,
    0x0, 0x0, 0x4, 0xfd, 0x7f, 0x80, 0x0, 0x0,
    0x4, 0xfd, 0x6f, 0xa0, 0x0, 0x0, 0x5, 0xfc,
    0x3f, 0xe0, 0x0, 0x0, 0xa, 0xf8, 0xc, 0xfb,
    0x10, 0x0, 0x7f, 0xf1, 0x2, 0xdf, 0xfc, 0xce,
    0xff, 0x40, 0x0, 0x7, 0xcf, 0xfd, 0x92, 0x0,

    /* U+56 "V" */
    0x8f, 0xb0, 0x0, 0x0, 0x0, 0xb, 0xf8, 0x2f,
    0xf1, 0x0, 0x0, 0x0, 0x1f, 0xf2, 0xc, 0xf6,
    0x0, 0x0, 0x0, 0x6f, 0xc0, 0x6, 0xfb, 0x0,
    0x0, 0x0, 0xbf, 0x70, 0x1, 0xff, 0x10, 0x0,
    0x1, 0xff, 0x10, 0x0, 0xbf, 0x60, 0x0, 0x6,
    0xfb, 0x0, 0x0, 0x5f, 0xc0, 0x0, 0xc, 0xf5,
    0x0, 0x0, 0xf, 0xf1, 0x0, 0x1f, 0xf0, 0x0,
    0x0, 0xa, 0xf7, 0x0, 0x7f, 0xa0, 0x0, 0x0,
    0x4, 0xfc, 0x0, 0xcf, 0x40, 0x0, 0x0, 0x0,
    0xef, 0x22, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x77, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xcc,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0,

    /* U+57 "W" */
    0x3f, 0xd0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0,
    0x2f, 0xe0, 0xf, 0xf0, 0x0, 0x0, 0x6f, 0xf2,
    0x0, 0x0, 0x5f, 0xb0, 0xc, 0xf4, 0x0, 0x0,
    0xaf, 0xf7, 0x0, 0x0, 0x9f, 0x70, 0x8, 0xf8,
    0x0, 0x0, 0xed, 0xfb, 0x0, 0x0, 0xcf, 0x30,
    0x4, 0xfb, 0x0, 0x3, 0xf9, 0xcf, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xff, 0x0, 0x7, 0xf5, 0x8f,
    0x30, 0x4, 0xfb, 0x0, 0x0, 0xcf, 0x20, 0xc,
    0xf0, 0x4f, 0x80, 0x7, 0xf8, 0x0, 0x0, 0x9f,
    0x60, 0x1f, 0xb0, 0xf, 0xc0, 0xb, 0xf4, 0x0,
    0x0, 0x5f, 0xa0, 0x5f, 0x70, 0xb, 0xf1, 0xe,
    0xf0, 0x0, 0x0, 0x1f, 0xd0, 0x9f, 0x20, 0x6,
    0xf5, 0x2f, 0xc0, 0x0, 0x0, 0xd, 0xf1, 0xee,
    0x0, 0x2, 0xf9, 0x5f, 0x80, 0x0, 0x0, 0xa,
    0xf6, 0xf9, 0x0, 0x0, 0xdd, 0x8f, 0x50, 0x0,
    0x0, 0x6, 0xfc, 0xf5, 0x0, 0x0, 0x9f, 0xcf,
    0x10, 0x0, 0x0, 0x2, 0xff, 0xf0, 0x0, 0x0,
    0x5f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xef, 0xb0,
    0x0, 0x0, 0xf, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x70, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,

    /* U+58 "X" */
    0xe, 0xf7, 0x0, 0x0, 0x0, 0xaf, 0xc0, 0x5,
    0xff, 0x10, 0x0, 0x4, 0xff, 0x20, 0x0, 0xbf,
    0xb0, 0x0, 0xd, 0xf8, 0x0, 0x0, 0x2f, 0xf5,
    0x0, 0x7f, 0xe0, 0x0, 0x0, 0x7, 0xfe, 0x2,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xdf, 0x9b, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x7a, 0xfc, 0x0, 0x0, 0x0, 0x8, 0xfd,
    0x1, 0xef, 0x60, 0x0, 0x0, 0x3f, 0xf3, 0x0,
    0x6f, 0xe1, 0x0, 0x0, 0xcf, 0x90, 0x0, 0xc,
    0xfa, 0x0, 0x7, 0xfe, 0x10, 0x0, 0x2, 0xff,
    0x40, 0x1f, 0xf5, 0x0, 0x0, 0x0, 0x8f, 0xd0,

    /* U+59 "Y" */
    0x9f, 0xc0, 0x0, 0x0, 0x0, 0x9f, 0xb0, 0x1f,
    0xf4, 0x0, 0x0, 0x1, 0xff, 0x30, 0x8, 0xfc,
    0x0, 0x0, 0x9, 0xfa, 0x0, 0x0, 0xef, 0x40,
    0x0, 0x2f, 0xf2, 0x0, 0x0, 0x6f, 0xd0, 0x0,
    0xaf, 0x90, 0x0, 0x0, 0xd, 0xf5, 0x2, 0xff,
    0x10, 0x0, 0x0, 0x5, 0xfd, 0xa, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x8f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf9, 0x0, 0x0, 0x0,

    /* U+5A "Z" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xab,
    0xbb, 0xbb, 0xbb, 0xef, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xfd, 0xbb, 0xbb, 0xbb,
    0xbb, 0x31, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+5B "[" */
    0x4a, 0xaa, 0x67, 0xff, 0xfa, 0x7f, 0x90, 0x7,
    0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f,
    0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9,
    0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90,
    0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0,
    0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7,
    0xf9, 0x0, 0x7f, 0xda, 0x67, 0xff, 0xfa,

    /* U+5C "\\" */
    0x5f, 0x80, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x0, 0x9, 0xf4, 0x0, 0x0, 0x0, 0x3f, 0xa0,
    0x0, 0x0, 0x0, 0xdf, 0x10, 0x0, 0x0, 0x7,
    0xf7, 0x0, 0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0xaf, 0x30, 0x0, 0x0, 0x4, 0xf9, 0x0,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0x50, 0x0, 0x0, 0x2, 0xfb, 0x0, 0x0, 0x0,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0x9, 0xf4,
    0x0, 0x0, 0x0, 0x3f, 0xa0,

    /* U+5D "]" */
    0x9a, 0xaa, 0x1e, 0xff, 0xf2, 0x0, 0xdf, 0x20,
    0xd, 0xf2, 0x0, 0xdf, 0x20, 0xd, 0xf2, 0x0,
    0xdf, 0x20, 0xd, 0xf2, 0x0, 0xdf, 0x20, 0xd,
    0xf2, 0x0, 0xdf, 0x20, 0xd, 0xf2, 0x0, 0xdf,
    0x20, 0xd, 0xf2, 0x0, 0xdf, 0x20, 0xd, 0xf2,
    0x0, 0xdf, 0x20, 0xd, 0xf2, 0x0, 0xdf, 0x20,
    0xd, 0xf2, 0x9a, 0xff, 0x2e, 0xff, 0xf2,

    /* U+5E "^" */
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0xbf, 0xd0,
    0x0, 0x0, 0x1f, 0xff, 0x40, 0x0, 0x8, 0xf6,
    0xfa, 0x0, 0x0, 0xee, 0xb, 0xf1, 0x0, 0x4f,
    0x80, 0x5f, 0x70, 0xb, 0xf1, 0x0, 0xed, 0x1,
    0xfb, 0x0, 0x9, 0xf4,

    /* U+5F "_" */
    0x9a, 0xaa, 0xaa, 0xaa, 0xa9, 0xff, 0xff, 0xff,
    0xff, 0xfe,

    /* U+60 "`" */
    0x1d, 0xf5, 0x0, 0x1, 0xef, 0x10, 0x0, 0x2e,
    0xb0,

    /* U+61 "a" */
    0x0, 0x5c, 0xfe, 0xc5, 0x0, 0xa, 0xfe, 0xbb,
    0xff, 0x90, 0x5f, 0xc0, 0x0, 0x2f, 0xf2, 0x48,
    0x30, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x1, 0x1a,
    0xf5, 0x1, 0x9e, 0xff, 0xff, 0xf5, 0x2e, 0xfa,
    0x65, 0x4b, 0xf5, 0xaf, 0x70, 0x0, 0xa, 0xf5,
    0xcf, 0x30, 0x0, 0xb, 0xf5, 0xaf, 0x90, 0x0,
    0x7f, 0xf6, 0x2f, 0xfe, 0xce, 0xfd, 0xf7, 0x2,
    0xbf, 0xfc, 0x45, 0xc8,

    /* U+62 "b" */
    0x8f, 0x70, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0,
    0x8, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x75,
    0xcf, 0xea, 0x10, 0x8, 0xfd, 0xfd, 0xce, 0xfe,
    0x10, 0x8f, 0xf5, 0x0, 0xc, 0xfa, 0x8, 0xf9,
    0x0, 0x0, 0x2f, 0xf0, 0x8f, 0x70, 0x0, 0x0,
    0xcf, 0x38, 0xf7, 0x0, 0x0, 0xa, 0xf5, 0x8f,
    0x70, 0x0, 0x0, 0xaf, 0x58, 0xf7, 0x0, 0x0,
    0xc, 0xf3, 0x8f, 0x90, 0x0, 0x2, 0xff, 0x8,
    0xff, 0x50, 0x0, 0xcf, 0xa0, 0x8f, 0xdf, 0xdb,
    0xef, 0xe1, 0x8, 0xf5, 0x5c, 0xfe, 0xa1, 0x0,

    /* U+63 "c" */
    0x0, 0x4, 0xbe, 0xfc, 0x50, 0x0, 0x7, 0xff,
    0xbb, 0xff, 0xa0, 0x3, 0xfe, 0x30, 0x1, 0xdf,
    0x50, 0xaf, 0x70, 0x0, 0x4, 0xfa, 0xe, 0xf1,
    0x0, 0x0, 0x3, 0x20, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0, 0x0,
    0x3e, 0x90, 0x3f, 0xe2, 0x0, 0x1c, 0xf5, 0x0,
    0x7f, 0xfb, 0xbe, 0xf9, 0x0, 0x0, 0x4b, 0xff,
    0xc5, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0x0, 0x2, 0xfd, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x6d, 0xfe, 0x93,
    0xfd, 0x9, 0xff, 0xcc, 0xfe, 0xfd, 0x3f, 0xf4,
    0x0, 0x1c, 0xfd, 0xaf, 0x80, 0x0, 0x3, 0xfd,
    0xdf, 0x30, 0x0, 0x2, 0xfd, 0xff, 0x10, 0x0,
    0x2, 0xfd, 0xff, 0x0, 0x0, 0x2, 0xfd, 0xdf,
    0x20, 0x0, 0x2, 0xfd, 0xaf, 0x60, 0x0, 0x2,
    0xfd, 0x3f, 0xe1, 0x0, 0xa, 0xfd, 0x9, 0xfe,
    0x98, 0xdf, 0xfd, 0x0, 0x6d, 0xfe, 0xa2, 0xfd,

    /* U+65 "e" */
    0x0, 0x3b, 0xef, 0xc5, 0x0, 0x5, 0xff, 0xcb,
    0xff, 0x80, 0x2f, 0xf3, 0x0, 0x2e, 0xf3, 0x9f,
    0x70, 0x0, 0x6, 0xf8, 0xdf, 0x20, 0x0, 0x2,
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xaa,
    0xaa, 0xaa, 0xa9, 0xef, 0x20, 0x0, 0x0, 0x0,
    0xaf, 0x70, 0x0, 0x0, 0x0, 0x3f, 0xf4, 0x0,
    0x4, 0xe5, 0x7, 0xff, 0xca, 0xcf, 0xe2, 0x0,
    0x4b, 0xef, 0xd9, 0x10,

    /* U+66 "f" */
    0x0, 0x1, 0x9d, 0xf8, 0x0, 0xc, 0xfe, 0xc7,
    0x0, 0x5f, 0xd0, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x5f, 0xff, 0xff, 0xf0,
    0x39, 0xcf, 0xc9, 0x80, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0,

    /* U+67 "g" */
    0x0, 0x6d, 0xfe, 0x91, 0xfd, 0x9, 0xff, 0xcc,
    0xfd, 0xfd, 0x3f, 0xf4, 0x0, 0x1c, 0xfd, 0xaf,
    0x80, 0x0, 0x3, 0xfd, 0xdf, 0x30, 0x0, 0x2,
    0xfd, 0xff, 0x10, 0x0, 0x2, 0xfd, 0xff, 0x10,
    0x0, 0x2, 0xfd, 0xdf, 0x20, 0x0, 0x2, 0xfd,
    0xaf, 0x80, 0x0, 0x3, 0xfd, 0x3f, 0xf4, 0x0,
    0x1c, 0xfd, 0x9, 0xff, 0xcc, 0xfe, 0xfd, 0x0,
    0x6d, 0xfe, 0x93, 0xfd, 0x0, 0x0, 0x0, 0x3,
    0xfc, 0x3, 0x0, 0x0, 0x7, 0xfa, 0x2f, 0x90,
    0x0, 0x3f, 0xf4, 0xc, 0xfe, 0xac, 0xff, 0x90,
    0x0, 0x6c, 0xff, 0xc5, 0x0,

    /* U+68 "h" */
    0x8f, 0x70, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x8f,
    0x70, 0x0, 0x0, 0x0, 0x8f, 0x74, 0xbf, 0xeb,
    0x20, 0x8f, 0xcf, 0xdc, 0xef, 0xe1, 0x8f, 0xf6,
    0x0, 0xd, 0xf6, 0x8f, 0x90, 0x0, 0x7, 0xf9,
    0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0,
    0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f,
    0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5,
    0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70,
    0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa,

    /* U+69 "i" */
    0x3f, 0x96, 0xfc, 0x4, 0x10, 0x0, 0x5f, 0xa5,
    0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f,
    0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa,

    /* U+6A "j" */
    0x0, 0x6f, 0x60, 0x8, 0xf9, 0x0, 0x4, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0,
    0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7,
    0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f,
    0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9,
    0x0, 0x7f, 0x90, 0x7, 0xf8, 0x0, 0x9f, 0x78,
    0xcf, 0xf2, 0xaf, 0xd5, 0x0,

    /* U+6B "k" */
    0x7f, 0x80, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x80,
    0x0, 0x4f, 0xf3, 0x7, 0xf8, 0x0, 0x3f, 0xf4,
    0x0, 0x7f, 0x80, 0x2e, 0xf5, 0x0, 0x7, 0xf8,
    0x2e, 0xf7, 0x0, 0x0, 0x7f, 0x8d, 0xf8, 0x0,
    0x0, 0x7, 0xff, 0xff, 0x60, 0x0, 0x0, 0x7f,
    0xfc, 0xff, 0x20, 0x0, 0x7, 0xfc, 0x7, 0xfd,
    0x0, 0x0, 0x7f, 0x80, 0xc, 0xf9, 0x0, 0x7,
    0xf8, 0x0, 0x1e, 0xf5, 0x0, 0x7f, 0x80, 0x0,
    0x4f, 0xe1, 0x7, 0xf8, 0x0, 0x0, 0x9f, 0xc0,

    /* U+6C "l" */
    0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5,
    0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f,
    0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa,

    /* U+6D "m" */
    0x8f, 0x65, 0xcf, 0xea, 0x10, 0x4c, 0xfe, 0xb3,
    0x8, 0xfd, 0xfc, 0xcf, 0xfe, 0x7f, 0xec, 0xef,
    0xf2, 0x8f, 0xf3, 0x0, 0x1e, 0xff, 0x70, 0x0,
    0xbf, 0x88, 0xf8, 0x0, 0x0, 0x7f, 0xd0, 0x0,
    0x4, 0xfb, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x3f, 0xc8, 0xf7, 0x0, 0x0, 0x5f, 0xa0,
    0x0, 0x3, 0xfc, 0x8f, 0x70, 0x0, 0x5, 0xfa,
    0x0, 0x0, 0x3f, 0xc8, 0xf7, 0x0, 0x0, 0x5f,
    0xa0, 0x0, 0x3, 0xfc, 0x8f, 0x70, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x3f, 0xc8, 0xf7, 0x0, 0x0,
    0x5f, 0xa0, 0x0, 0x3, 0xfc, 0x8f, 0x70, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x3f, 0xc8, 0xf7, 0x0,
    0x0, 0x5f, 0xa0, 0x0, 0x3, 0xfc,

    /* U+6E "n" */
    0x8f, 0x64, 0xbf, 0xeb, 0x20, 0x8f, 0xcf, 0xdc,
    0xef, 0xe1, 0x8f, 0xf6, 0x0, 0xd, 0xf6, 0x8f,
    0x90, 0x0, 0x7, 0xf9, 0x8f, 0x70, 0x0, 0x5,
    0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70,
    0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa,
    0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0,
    0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f,
    0x70, 0x0, 0x5, 0xfa,

    /* U+6F "o" */
    0x0, 0x3, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x6f,
    0xfc, 0xbe, 0xfd, 0x10, 0x2, 0xff, 0x50, 0x0,
    0xbf, 0xa0, 0x9, 0xf8, 0x0, 0x0, 0xf, 0xf2,
    0xd, 0xf2, 0x0, 0x0, 0x9, 0xf6, 0xf, 0xf0,
    0x0, 0x0, 0x7, 0xf8, 0xf, 0xf0, 0x0, 0x0,
    0x7, 0xf8, 0xe, 0xf2, 0x0, 0x0, 0x9, 0xf6,
    0x9, 0xf8, 0x0, 0x0, 0xe, 0xf2, 0x2, 0xff,
    0x40, 0x0, 0xaf, 0xb0, 0x0, 0x6f, 0xfc, 0xae,
    0xfd, 0x10, 0x0, 0x3, 0xbe, 0xfd, 0x80, 0x0,

    /* U+70 "p" */
    0x8f, 0x57, 0xdf, 0xea, 0x10, 0x8, 0xff, 0xe9,
    0x8d, 0xfe, 0x10, 0x8f, 0xd1, 0x0, 0xb, 0xfa,
    0x8, 0xf7, 0x0, 0x0, 0x2f, 0xf0, 0x8f, 0x70,
    0x0, 0x0, 0xdf, 0x38, 0xf7, 0x0, 0x0, 0xb,
    0xf4, 0x8f, 0x70, 0x0, 0x0, 0xbf, 0x48, 0xf7,
    0x0, 0x0, 0xd, 0xf3, 0x8f, 0x80, 0x0, 0x3,
    0xff, 0x8, 0xfe, 0x20, 0x1, 0xcf, 0x90, 0x8f,
    0xef, 0xba, 0xef, 0xe1, 0x8, 0xf7, 0x6d, 0xfe,
    0xa1, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x70, 0x0, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x6d, 0xfe, 0x92, 0xfd, 0x9, 0xff, 0xcb,
    0xfe, 0xfd, 0x4f, 0xf4, 0x0, 0xb, 0xfd, 0xaf,
    0x80, 0x0, 0x2, 0xfd, 0xdf, 0x20, 0x0, 0x2,
    0xfd, 0xff, 0x0, 0x0, 0x2, 0xfd, 0xff, 0x0,
    0x0, 0x2, 0xfd, 0xdf, 0x20, 0x0, 0x2, 0xfd,
    0xaf, 0x70, 0x0, 0x3, 0xfd, 0x3f, 0xf3, 0x0,
    0xc, 0xfd, 0x9, 0xff, 0xba, 0xef, 0xfd, 0x0,
    0x6d, 0xfe, 0x94, 0xfd, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0x0, 0x0, 0x0, 0x2, 0xfd, 0x0, 0x0,
    0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x2, 0xfd,
    0x0, 0x0, 0x0, 0x2, 0xfd,

    /* U+72 "r" */
    0x8f, 0x78, 0xef, 0x18, 0xff, 0xfd, 0xc1, 0x8f,
    0xf3, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x8, 0xf7, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x8, 0xf7,
    0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x7d, 0xfe, 0xb3, 0x0, 0xc, 0xfe, 0xbc,
    0xff, 0x50, 0x6f, 0xb0, 0x0, 0x6f, 0xe0, 0x8f,
    0x70, 0x0, 0x9, 0xa1, 0x5f, 0xe5, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfc, 0x71, 0x0, 0x0, 0x16,
    0xae, 0xff, 0x50, 0x0, 0x0, 0x0, 0x6f, 0xf1,
    0xbc, 0x10, 0x0, 0xc, 0xf3, 0xbf, 0x90, 0x0,
    0x2f, 0xf1, 0x2e, 0xfe, 0xab, 0xff, 0x80, 0x1,
    0x9d, 0xfe, 0xb5, 0x0,

    /* U+74 "t" */
    0x0, 0xcf, 0x30, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0xcf, 0x30, 0xe, 0xff, 0xff, 0xf6, 0x89, 0xef,
    0xa9, 0x30, 0xc, 0xf3, 0x0, 0x0, 0xcf, 0x30,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0xcf, 0x30, 0x0, 0xc,
    0xf3, 0x0, 0x0, 0xbf, 0x50, 0x0, 0x7, 0xff,
    0xb5, 0x0, 0x9, 0xff, 0x50,

    /* U+75 "u" */
    0x8f, 0x70, 0x0, 0x6, 0xf9, 0x8f, 0x70, 0x0,
    0x6, 0xf9, 0x8f, 0x70, 0x0, 0x6, 0xf9, 0x8f,
    0x70, 0x0, 0x6, 0xf9, 0x8f, 0x70, 0x0, 0x6,
    0xf9, 0x8f, 0x70, 0x0, 0x6, 0xf9, 0x8f, 0x70,
    0x0, 0x6, 0xf9, 0x8f, 0x70, 0x0, 0x6, 0xf9,
    0x7f, 0x90, 0x0, 0x6, 0xf9, 0x4f, 0xe1, 0x0,
    0x3e, 0xf9, 0xc, 0xfe, 0xbd, 0xfe, 0xf9, 0x1,
    0xae, 0xfd, 0x85, 0xf9,

    /* U+76 "v" */
    0x7f, 0x80, 0x0, 0x0, 0xef, 0x11, 0xfe, 0x0,
    0x0, 0x4f, 0xb0, 0xc, 0xf3, 0x0, 0x9, 0xf6,
    0x0, 0x6f, 0x80, 0x0, 0xef, 0x0, 0x1, 0xfd,
    0x0, 0x3f, 0xa0, 0x0, 0xb, 0xf2, 0x8, 0xf5,
    0x0, 0x0, 0x5f, 0x80, 0xdf, 0x0, 0x0, 0x0,
    0xfd, 0x2f, 0xa0, 0x0, 0x0, 0xa, 0xfa, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xef, 0x90, 0x0, 0x0, 0x0, 0x9, 0xf4,
    0x0, 0x0,

    /* U+77 "w" */
    0x6f, 0x90, 0x0, 0xb, 0xf2, 0x0, 0x1, 0xfd,
    0x1, 0xfd, 0x0, 0x0, 0xff, 0x70, 0x0, 0x5f,
    0x90, 0xd, 0xf1, 0x0, 0x5f, 0xfc, 0x0, 0x9,
    0xf5, 0x0, 0x8f, 0x50, 0x9, 0xfa, 0xf1, 0x0,
    0xdf, 0x0, 0x4, 0xf9, 0x0, 0xeb, 0x4f, 0x60,
    0x1f, 0xc0, 0x0, 0xf, 0xd0, 0x3f, 0x60, 0xfb,
    0x5, 0xf7, 0x0, 0x0, 0xbf, 0x18, 0xf1, 0xb,
    0xf0, 0x9f, 0x30, 0x0, 0x6, 0xf5, 0xdd, 0x0,
    0x6f, 0x5d, 0xe0, 0x0, 0x0, 0x2f, 0xbf, 0x80,
    0x1, 0xfb, 0xfa, 0x0, 0x0, 0x0, 0xdf, 0xf3,
    0x0, 0xc, 0xff, 0x50, 0x0, 0x0, 0x9, 0xfe,
    0x0, 0x0, 0x7f, 0xf1, 0x0, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x2, 0xfc, 0x0, 0x0,

    /* U+78 "x" */
    0x2f, 0xf2, 0x0, 0x5, 0xfe, 0x10, 0x7f, 0xb0,
    0x0, 0xef, 0x50, 0x0, 0xdf, 0x50, 0x8f, 0xb0,
    0x0, 0x3, 0xfe, 0x3f, 0xf1, 0x0, 0x0, 0x9,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0xe, 0xfc, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xd0, 0x0, 0x0, 0x0,
    0xaf, 0xdf, 0x80, 0x0, 0x0, 0x4f, 0xd1, 0xef,
    0x20, 0x0, 0xe, 0xf3, 0x6, 0xfc, 0x0, 0x9,
    0xfa, 0x0, 0xc, 0xf7, 0x3, 0xff, 0x10, 0x0,
    0x3f, 0xf2,

    /* U+79 "y" */
    0x9f, 0x90, 0x0, 0x2, 0xff, 0x3, 0xfe, 0x0,
    0x0, 0x7f, 0xa0, 0xe, 0xf3, 0x0, 0xc, 0xf4,
    0x0, 0x8f, 0x80, 0x1, 0xff, 0x0, 0x3, 0xfe,
    0x0, 0x5f, 0xa0, 0x0, 0xd, 0xf3, 0xa, 0xf4,
    0x0, 0x0, 0x8f, 0x80, 0xff, 0x0, 0x0, 0x2,
    0xfd, 0x4f, 0xa0, 0x0, 0x0, 0xd, 0xfc, 0xf4,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xc, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xa0, 0x0, 0x0, 0x0, 0xb, 0xf3,
    0x0, 0x0, 0x1, 0xdf, 0xfa, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x0, 0x0,

    /* U+7A "z" */
    0xf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xaa, 0xaa,
    0xaa, 0xef, 0xb0, 0x0, 0x0, 0x0, 0x4f, 0xf2,
    0x0, 0x0, 0x0, 0x1e, 0xf5, 0x0, 0x0, 0x0,
    0xb, 0xf9, 0x0, 0x0, 0x0, 0x6, 0xfd, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x30, 0x0, 0x0, 0x0,
    0xdf, 0x70, 0x0, 0x0, 0x0, 0x9f, 0xb0, 0x0,
    0x0, 0x0, 0x5f, 0xe1, 0x0, 0x0, 0x0, 0xe,
    0xfd, 0xaa, 0xaa, 0xaa, 0x10, 0xff, 0xff, 0xff,
    0xff, 0xf2,

    /* U+7B "{" */
    0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x4e, 0xf1,
    0x0, 0x2, 0xfe, 0x20, 0x0, 0xa, 0xf5, 0x0,
    0x0, 0xe, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x7f, 0xa0, 0x0,
    0x3b, 0xfe, 0x10, 0x0, 0x5f, 0xf9, 0x0, 0x0,
    0x2, 0xcf, 0x60, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0x0, 0x0, 0xaf, 0xb1, 0x0, 0x0, 0x5, 0xb0,

    /* U+7C "|" */
    0x2f, 0x72, 0xf7, 0x2f, 0x72, 0xf7, 0x2f, 0x72,
    0xf7, 0x2f, 0x72, 0xf7, 0x2f, 0x72, 0xf7, 0x2f,
    0x72, 0xf7, 0x2f, 0x72, 0xf7, 0x2f, 0x72, 0xf7,
    0x2f, 0x72, 0xf7, 0x2f, 0x70,

    /* U+7D "}" */
    0x22, 0x0, 0x0, 0xa, 0xf9, 0x0, 0x0, 0xa,
    0xf9, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x8, 0xf6, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x3, 0xfd, 0x0, 0x0, 0x8, 0xfd, 0x70, 0x0,
    0x2e, 0xfb, 0x0, 0x1e, 0xf5, 0x0, 0x6, 0xfa,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x9, 0xf5, 0x0, 0x0,
    0xcf, 0x30, 0x0, 0x4f, 0xd0, 0x0, 0x6f, 0xe2,
    0x0, 0x7, 0x81, 0x0, 0x0,

    /* U+7E "~" */
    0x1, 0xaf, 0xea, 0x20, 0x0, 0x1b, 0x60, 0xdf,
    0xde, 0xff, 0x60, 0x8, 0xf5, 0x6f, 0x70, 0x7,
    0xff, 0xed, 0xfc, 0x5, 0xa1, 0x0, 0x2, 0xaf,
    0xfa, 0x10,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x9e, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0xbf,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x48, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x1, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x94, 0xe, 0xfd, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xfc, 0x72, 0x0, 0x0, 0xef, 0xd0,
    0x0, 0x0, 0xa, 0xff, 0xea, 0x50, 0x0, 0x0,
    0x0, 0xe, 0xfd, 0x0, 0x0, 0x0, 0xaf, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xd0, 0x0,
    0x0, 0xa, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xfd, 0x0, 0x0, 0x0, 0xaf, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xd0, 0x0, 0x0,
    0xa, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xfd, 0x0, 0x0, 0x0, 0xaf, 0xf1, 0x0, 0x0,
    0x0, 0x3, 0x54, 0xff, 0xd0, 0x0, 0x0, 0xa,
    0xff, 0x10, 0x0, 0x0, 0x5e, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0xaf, 0xf1, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xd0, 0x1, 0x69, 0x9d, 0xff,
    0x10, 0x0, 0x6, 0xff, 0xff, 0xff, 0xfc, 0x6,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x1e, 0xff,
    0xff, 0xff, 0x61, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x2a, 0xff, 0xfc, 0x50, 0x1f, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xcc,
    0xa3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F008 "" */
    0x42, 0x0, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x0, 0x24, 0xf8, 0x22, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x22, 0x8f, 0xff, 0xff,
    0xff, 0xb9, 0x99, 0x99, 0x99, 0x9b, 0xff, 0xff,
    0xff, 0xf9, 0x44, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x44, 0x9f, 0xf6, 0x0, 0xef, 0x30,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x6f, 0xf7,
    0x0, 0xef, 0x30, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xfa, 0x66, 0xff,
    0x74, 0x44, 0x44, 0x44, 0x47, 0xff, 0x66, 0xaf,
    0xf6, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x6f, 0xf6, 0x0, 0xef, 0xdc, 0xcc,
    0xcc, 0xcc, 0xcd, 0xfe, 0x0, 0x6f, 0xff, 0xee,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x3, 0xff, 0xee,
    0xff, 0xfc, 0x88, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x88, 0xcf, 0xf6, 0x0, 0xef, 0x30,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x6f, 0xf6,
    0x0, 0xef, 0x30, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x0, 0x6f, 0xfe, 0xcc, 0xff, 0x41, 0x11, 0x11,
    0x11, 0x14, 0xff, 0xcc, 0xef, 0xfd, 0xaa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xdf,
    0xc6, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x6c,

    /* U+F00B "" */
    0xbf, 0xff, 0xfe, 0x31, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0x63, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x63, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x63, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58,
    0x88, 0x87, 0x0, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x85, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0x31, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0x63, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x63, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x53, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x47, 0x88, 0x87, 0x0,
    0x68, 0x88, 0x88, 0x88, 0x88, 0x88, 0x74, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0x31, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
    0x63, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x63, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x52, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x37, 0x77, 0x76, 0x0, 0x57, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x74,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x16, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xef, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0x30, 0x4, 0xe8, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xf3, 0x0, 0x4f, 0xff, 0x80,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0x30, 0x0,
    0xef, 0xff, 0xf8, 0x0, 0x0, 0x2e, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x80, 0x2,
    0xef, 0xff, 0xff, 0x30, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xf8, 0x2e, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xd3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x8, 0xc4, 0x0, 0x0, 0x0, 0x2, 0xc9, 0x0,
    0x9f, 0xff, 0x40, 0x0, 0x0, 0x2e, 0xff, 0xb0,
    0xff, 0xff, 0xf4, 0x0, 0x2, 0xef, 0xff, 0xf1,
    0x7f, 0xff, 0xff, 0x40, 0x2e, 0xff, 0xff, 0x90,
    0x8, 0xff, 0xff, 0xf6, 0xef, 0xff, 0xfa, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x2, 0xef, 0xff, 0xfd, 0xff, 0xff, 0xf4, 0x0,
    0x2e, 0xff, 0xff, 0xa0, 0x8f, 0xff, 0xff, 0x40,
    0xdf, 0xff, 0xfa, 0x0, 0x8, 0xff, 0xff, 0xf0,
    0xdf, 0xff, 0xa0, 0x0, 0x0, 0x8f, 0xff, 0xe0,
    0x2e, 0xfa, 0x0, 0x0, 0x0, 0x8, 0xff, 0x30,
    0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x33, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x50, 0xe, 0xff, 0x80,
    0xb, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xff, 0xe0,
    0xe, 0xff, 0x80, 0x4f, 0xff, 0x50, 0x0, 0x0,
    0x9f, 0xff, 0xe0, 0xe, 0xff, 0x80, 0x5f, 0xff,
    0xf2, 0x0, 0x3, 0xff, 0xfe, 0x30, 0xe, 0xff,
    0x80, 0x8, 0xff, 0xfc, 0x0, 0xb, 0xff, 0xf3,
    0x0, 0xe, 0xff, 0x80, 0x0, 0xaf, 0xff, 0x50,
    0x1f, 0xff, 0x90, 0x0, 0xe, 0xff, 0x80, 0x0,
    0x1f, 0xff, 0xb0, 0x6f, 0xff, 0x30, 0x0, 0xe,
    0xff, 0x80, 0x0, 0x9, 0xff, 0xf0, 0x8f, 0xff,
    0x0, 0x0, 0xe, 0xff, 0x80, 0x0, 0x5, 0xff,
    0xf2, 0xaf, 0xfd, 0x0, 0x0, 0xe, 0xff, 0x80,
    0x0, 0x3, 0xff, 0xf3, 0x9f, 0xfd, 0x0, 0x0,
    0xc, 0xff, 0x50, 0x0, 0x4, 0xff, 0xf2, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x6,
    0xff, 0xf1, 0x4f, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xe0, 0xf, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x90,
    0x8, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xff, 0x20, 0x1, 0xef, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x2d, 0xff, 0xf9, 0x0, 0x0, 0x4f,
    0xff, 0xfd, 0x62, 0x1, 0x49, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0xff, 0xff, 0xff, 0xb4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0x65,
    0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6c,
    0xee, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x30, 0x2a,
    0xff, 0xff, 0xff, 0xb2, 0x3, 0x80, 0x0, 0x0,
    0x8f, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0xf8, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x1f, 0xff, 0xff, 0xff, 0xfa, 0x55, 0xaf, 0xff,
    0xff, 0xff, 0xf2, 0x6, 0xef, 0xff, 0xff, 0x70,
    0x0, 0x7, 0xff, 0xff, 0xff, 0x60, 0x0, 0x2f,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xf3,
    0x0, 0x0, 0x3f, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xf3, 0x0, 0x0, 0x2f, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xf3, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0x20, 0x0, 0x1, 0xff, 0xff,
    0xf9, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xd3, 0x0,
    0x3d, 0xff, 0xff, 0xff, 0xe1, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xee, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x2f,
    0xb2, 0x9f, 0xff, 0xff, 0xff, 0xfa, 0x2a, 0xf3,
    0x0, 0x0, 0x1, 0x0, 0x2, 0xdf, 0xff, 0xfe,
    0x30, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x14, 0x66,
    0x41, 0x0, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xe9, 0x0,
    0x5, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xfc, 0x10, 0x7f, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xfe, 0x37, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xb4, 0xdf, 0xff, 0xbf, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xff, 0x80,
    0x1, 0xbf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0x50, 0x8f, 0x50, 0x9f, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x4, 0xff, 0xfe, 0x30,
    0xbf, 0xff, 0x70, 0x6f, 0xff, 0xf1, 0x0, 0x0,
    0x7, 0xff, 0xfc, 0x12, 0xdf, 0xff, 0xff, 0xa0,
    0x3e, 0xff, 0xe3, 0x0, 0xa, 0xff, 0xfa, 0x3,
    0xef, 0xff, 0xff, 0xff, 0xc1, 0x2d, 0xff, 0xf6,
    0xc, 0xff, 0xf7, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe3, 0xb, 0xff, 0xf8, 0x9f, 0xf5, 0x9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x8,
    0xff, 0x50, 0x93, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x5, 0x70, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xcc, 0xcf, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0x50, 0x0, 0x9f, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xf5, 0x0, 0x9, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0x50, 0x0, 0x9f,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0xff, 0xf5, 0x0, 0x9, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0x40, 0x0,
    0x8f, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x2,
    0x44, 0x44, 0x40, 0x0, 0x1, 0x44, 0x44, 0x41,
    0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x22, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xee, 0xee, 0xff,
    0xff, 0xff, 0xee, 0xee, 0x20, 0x0, 0x0, 0x2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xfc, 0x4, 0xff, 0x40, 0xcf,
    0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x23, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x44, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x6e, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xaf,
    0x5d, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F01C "" */
    0x0, 0x0, 0x4, 0xab, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x9f,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0x50, 0x0, 0x0, 0x4f, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xfe, 0x10, 0x0, 0xd,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xfa, 0x0, 0x9, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xf5, 0x3,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xe1, 0xdf, 0xfa, 0x44, 0x44,
    0x20, 0x0, 0x0, 0x0, 0x34, 0x44, 0x4d, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x88,
    0x88, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xbd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x10,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0x76, 0x0, 0x0, 0x0, 0x5, 0x9c,
    0xdd, 0xb8, 0x30, 0x0, 0xf, 0xff, 0x0, 0x0,
    0x6, 0xef, 0xff, 0xff, 0xff, 0xfc, 0x40, 0xf,
    0xff, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0xf, 0xff, 0x0, 0xc, 0xff, 0xff,
    0xa5, 0x34, 0x6b, 0xff, 0xff, 0xce, 0xff, 0x0,
    0xaf, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x2b, 0xff,
    0xff, 0xff, 0x5, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xd, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x7d, 0xdc, 0xbf, 0xff, 0xff,
    0x2f, 0xff, 0x20, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0x6f, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x2, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x22, 0x22, 0x22,
    0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xde,
    0xee, 0xee, 0xee, 0xe7, 0x0, 0x0, 0x0, 0x0,
    0x9e, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xf3, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x9, 0xff, 0xe0,
    0xff, 0xff, 0xf4, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0x70, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xfd, 0x0, 0xff, 0xff,
    0xff, 0xfd, 0x61, 0x0, 0x5, 0xcf, 0xff, 0xf2,
    0x0, 0xff, 0xe3, 0xef, 0xff, 0xff, 0xee, 0xff,
    0xff, 0xfe, 0x30, 0x0, 0xff, 0xf0, 0x19, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb1, 0x0, 0x0, 0xff,
    0xf0, 0x0, 0x28, 0xdf, 0xff, 0xfe, 0xa3, 0x0,
    0x0, 0x0, 0xab, 0xa0, 0x0, 0x0, 0x1, 0x33,
    0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x30, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xf0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x24, 0x44,
    0x47, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x24, 0x44, 0x47, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x75, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x2f, 0xf7, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x7f, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0xdf, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xf, 0xf3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xc, 0xfd, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x1, 0xfe, 0x20, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x73, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x30, 0x0,
    0x0, 0x0, 0x9f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x0, 0x0, 0x1, 0x0, 0x7f,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xf0,
    0x0, 0x5, 0xf9, 0x0, 0x9f, 0xe1, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0x0, 0x0, 0x4f, 0xfb,
    0x0, 0xdf, 0x80, 0x24, 0x44, 0x47, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x3f, 0xf7, 0x4, 0xff, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x86, 0x0,
    0x4f, 0xf1, 0xd, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x2f, 0xf7, 0x0, 0xcf, 0x60, 0x9f,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x6f,
    0xf1, 0x7, 0xf9, 0x6, 0xfa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xdf, 0x40, 0x5f, 0xb0,
    0x5f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1f, 0xf2, 0x5, 0xfa, 0x5, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xd, 0xfc, 0x0, 0x9f,
    0x80, 0x7f, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x1, 0xfd, 0x20, 0x1e, 0xf3, 0xb, 0xf6, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x1, 0x0, 0xa,
    0xfc, 0x1, 0xff, 0x20, 0x0, 0x0, 0x2e, 0xff,
    0xff, 0x0, 0x0, 0xb, 0xff, 0x20, 0x8f, 0xc0,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xf0, 0x0, 0x7,
    0xff, 0x40, 0x2f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0x0, 0x0, 0x19, 0x20, 0x1d, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0,
    0x0, 0x0, 0x2d, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xfd,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xfb, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F03E "" */
    0x5, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x50, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x1, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x0, 0xd, 0xff, 0xff, 0xff, 0xdb, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x2f, 0xff, 0xff,
    0xfd, 0x10, 0xaf, 0xff, 0xff, 0xff, 0xfb, 0x56,
    0xef, 0xff, 0xff, 0xd1, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xf7, 0x2e, 0xff,
    0xd1, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff,
    0x70, 0x2, 0xed, 0x10, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x21, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcf, 0xff, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe4,

    /* U+F048 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xc0, 0x0, 0x0, 0x0, 0xb, 0xd3, 0x2f,
    0xfe, 0x0, 0x0, 0x0, 0x1d, 0xff, 0x82, 0xff,
    0xe0, 0x0, 0x0, 0x2d, 0xff, 0xf9, 0x2f, 0xfe,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0x92, 0xff, 0xe0,
    0x0, 0x3e, 0xff, 0xff, 0xf9, 0x2f, 0xfe, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0x92, 0xff, 0xe0, 0x5f,
    0xff, 0xff, 0xff, 0xf9, 0x2f, 0xfe, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x2f, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0x92, 0xff, 0xe0, 0xbf, 0xff, 0xff, 0xff,
    0xf9, 0x2f, 0xfe, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0x92, 0xff, 0xe0, 0x0, 0x8f, 0xff, 0xff, 0xf9,
    0x2f, 0xfe, 0x0, 0x0, 0x7f, 0xff, 0xff, 0x92,
    0xff, 0xe0, 0x0, 0x0, 0x6f, 0xff, 0xf9, 0x2f,
    0xfe, 0x0, 0x0, 0x0, 0x5f, 0xff, 0x92, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x4f, 0xf5, 0x4, 0x43,
    0x0, 0x0, 0x0, 0x0, 0x13, 0x0,

    /* U+F04B "" */
    0x2, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xfb, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xc2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x91,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x60, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x10, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x40, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x10, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xfd, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2a, 0xa3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x3d, 0xff, 0xff, 0xe6, 0x0, 0x3, 0xdf, 0xff,
    0xfe, 0x60, 0xdf, 0xff, 0xff, 0xff, 0x10, 0xd,
    0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff,
    0x30, 0xf, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xf, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xf, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x40, 0xf,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xf, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xf, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xf, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x40, 0xf,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xf, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xf, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xf, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x40, 0xf,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xf, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xf, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xf, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x30, 0xf,
    0xff, 0xff, 0xff, 0xf3, 0x8f, 0xff, 0xff, 0xfb,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xb0, 0x2, 0x44,
    0x44, 0x30, 0x0, 0x0, 0x24, 0x44, 0x43, 0x0,

    /* U+F04D "" */
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x60, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x2, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x0,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdc, 0x10, 0x0, 0x0, 0x0, 0xbf, 0xf3, 0x7f,
    0xfd, 0x20, 0x0, 0x0, 0xd, 0xff, 0x47, 0xff,
    0xfe, 0x30, 0x0, 0x0, 0xdf, 0xf4, 0x7f, 0xff,
    0xff, 0x40, 0x0, 0xd, 0xff, 0x47, 0xff, 0xff,
    0xff, 0x50, 0x0, 0xdf, 0xf4, 0x7f, 0xff, 0xff,
    0xff, 0x60, 0xd, 0xff, 0x47, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xdf, 0xf4, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0x8d, 0xff, 0x47, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x47, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xcd,
    0xff, 0x47, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xdf,
    0xf4, 0x7f, 0xff, 0xff, 0xff, 0xa0, 0xd, 0xff,
    0x47, 0xff, 0xff, 0xff, 0x90, 0x0, 0xdf, 0xf4,
    0x7f, 0xff, 0xff, 0x80, 0x0, 0xd, 0xff, 0x47,
    0xff, 0xff, 0x70, 0x0, 0x0, 0xdf, 0xf4, 0x7f,
    0xff, 0x60, 0x0, 0x0, 0xd, 0xff, 0x44, 0xff,
    0x50, 0x0, 0x0, 0x0, 0xcf, 0xf4, 0x2, 0x20,
    0x0, 0x0, 0x0, 0x2, 0x44, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xea, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x1, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x56,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x61,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x27, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x30,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x19, 0x20, 0x0, 0x0,
    0x0, 0x1, 0xdf, 0xe2, 0x0, 0x0, 0x0, 0x1d,
    0xff, 0xf8, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xd1,
    0x0, 0x0, 0x1d, 0xff, 0xfc, 0x10, 0x0, 0x1,
    0xdf, 0xff, 0xc1, 0x0, 0x0, 0x1d, 0xff, 0xfc,
    0x10, 0x0, 0x1, 0xdf, 0xff, 0xc1, 0x0, 0x0,
    0x1d, 0xff, 0xfc, 0x10, 0x0, 0x0, 0xbf, 0xff,
    0xd1, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+F054 "" */
    0x5, 0x80, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x3, 0xef, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x3, 0xef, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xf3, 0x0, 0x0, 0x9, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x9f, 0xff, 0xf4, 0x0, 0x0, 0x9,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x9f, 0xff, 0xf4,
    0x0, 0x0, 0x9, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x8f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x1c, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x1, 0xbe, 0xd3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x14, 0x55,
    0x55, 0x59, 0xff, 0xfc, 0x55, 0x55, 0x54, 0x20,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x6c, 0xdd,
    0xdd, 0xde, 0xff, 0xff, 0xdd, 0xdd, 0xdc, 0x90,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x36, 0x50, 0x0, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb0,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 0x43, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5b, 0xff, 0xff, 0xff, 0xea, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xef, 0xff, 0xfd, 0xce,
    0xff, 0xff, 0xc3, 0x0, 0x0, 0x0, 0x0, 0x1b,
    0xff, 0xff, 0x71, 0x0, 0x2, 0x9f, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x2d, 0xff, 0xfe, 0x20, 0x2,
    0x53, 0x0, 0x5f, 0xff, 0xfb, 0x0, 0x0, 0x1e,
    0xff, 0xff, 0x30, 0x0, 0x6f, 0xfc, 0x10, 0x7f,
    0xff, 0xfb, 0x0, 0xc, 0xff, 0xff, 0xa0, 0x0,
    0x6, 0xff, 0xfc, 0x0, 0xef, 0xff, 0xf8, 0x6,
    0xff, 0xff, 0xf5, 0x1, 0x3, 0xef, 0xff, 0xf4,
    0x9, 0xff, 0xff, 0xf3, 0xef, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0x70, 0x7f, 0xff, 0xff,
    0xad, 0xff, 0xff, 0xf3, 0xa, 0xff, 0xff, 0xff,
    0xf6, 0x7, 0xff, 0xff, 0xf9, 0x3f, 0xff, 0xff,
    0x60, 0x5f, 0xff, 0xff, 0xff, 0x10, 0xaf, 0xff,
    0xfe, 0x10, 0x8f, 0xff, 0xfc, 0x0, 0xaf, 0xff,
    0xff, 0x60, 0x1f, 0xff, 0xff, 0x50, 0x0, 0xaf,
    0xff, 0xf6, 0x0, 0x6c, 0xdb, 0x40, 0xa, 0xff,
    0xff, 0x70, 0x0, 0x0, 0xaf, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xfc, 0x52, 0x12, 0x6d, 0xff,
    0xfe, 0x40, 0x0, 0x0, 0x0, 0x0, 0x19, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x5a, 0xde, 0xfe, 0xd9,
    0x50, 0x0, 0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xd2, 0x0, 0x0, 0x0,
    0x24, 0x32, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0x60, 0x28, 0xcf, 0xff, 0xff,
    0xfb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b,
    0xff, 0xfc, 0xff, 0xff, 0xec, 0xdf, 0xff, 0xfe,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xa3, 0x0, 0x0, 0x6e, 0xff, 0xfc, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xef, 0xff, 0x70,
    0x15, 0x40, 0x1, 0xdf, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x1c, 0xff, 0xfb, 0x1f, 0xfe,
    0x50, 0x2f, 0xff, 0xff, 0x20, 0x0, 0x0, 0x7e,
    0x30, 0x0, 0x9f, 0xff, 0xef, 0xff, 0xf3, 0x8,
    0xff, 0xff, 0xd0, 0x0, 0x2, 0xff, 0xf6, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xfa, 0x3, 0xff, 0xff,
    0xf8, 0x0, 0x8, 0xff, 0xff, 0xa0, 0x0, 0x2d,
    0xff, 0xff, 0xfd, 0x1, 0xff, 0xff, 0xff, 0x0,
    0x6, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xaf, 0xff,
    0xfb, 0x2, 0xff, 0xff, 0xfe, 0x0, 0x0, 0xdf,
    0xff, 0xfd, 0x0, 0x0, 0x6, 0xff, 0xff, 0x55,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x3d, 0xff, 0xfe, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x4, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfb, 0x10, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xe8, 0x31, 0x20, 0x0, 0x3e,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xef, 0xff, 0xff, 0xfb, 0x0, 0x1, 0xbf, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x9c,
    0xef, 0xfd, 0x80, 0x0, 0x8, 0xff, 0xfd, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4e, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x60,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xfd, 0x88, 0x8f, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0x80,
    0x0, 0xcf, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xf9, 0x0, 0xd, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xa0, 0x0, 0xef, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xfb,
    0x0, 0xf, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0xff, 0xc0, 0x0, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xfd, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xfd, 0xcd, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xfe, 0x30, 0x6f,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x17,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x2, 0xbc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x90, 0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xf5,
    0x0, 0x12, 0x22, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x22, 0x9f, 0xff, 0x50, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x45, 0x55, 0xbf,
    0xff, 0x60, 0xaf, 0xff, 0xd5, 0xaf, 0xff, 0x80,
    0x0, 0x0, 0xb, 0xf8, 0xa, 0xff, 0xfe, 0x10,
    0x8f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x70, 0x9f,
    0xff, 0xe2, 0x0, 0x4f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xf3, 0x10,
    0x0, 0x2a, 0x30, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0x41, 0xda, 0x0, 0x7f, 0xf3, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xf4, 0xd, 0xff, 0x90, 0x8f,
    0xff, 0x30, 0xef, 0xff, 0xff, 0xff, 0x50, 0x2e,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xfa, 0x67, 0x77, 0x75, 0x0, 0x0,
    0x0, 0x3, 0x77, 0xbf, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x4e, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xfc, 0xff, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xfa, 0x5, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x4f, 0xff, 0xfa, 0x0, 0x5, 0xff,
    0xff, 0x70, 0x0, 0x4f, 0xff, 0xf9, 0x0, 0x0,
    0x6, 0xff, 0xff, 0x70, 0x3f, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0x7a, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x2e,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x50, 0x25, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x40,

    /* U+F078 "" */
    0x9, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xcb, 0x18, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xfc, 0x9f, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xd0, 0xbf, 0xff, 0xe3,
    0x0, 0x0, 0x1, 0xcf, 0xff, 0xd1, 0x0, 0xbf,
    0xff, 0xe3, 0x0, 0x1, 0xcf, 0xff, 0xd1, 0x0,
    0x0, 0xbf, 0xff, 0xe3, 0x1, 0xcf, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xe4, 0xcf, 0xff,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x61, 0x0, 0x0,
    0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x27, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xfd,
    0x10, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xd1, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xff, 0xfd, 0x15, 0xbb, 0xbb,
    0xbb, 0xbb, 0xef, 0xf1, 0x0, 0x0, 0xdf, 0xfb,
    0xef, 0xdc, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xf1, 0x0, 0x0, 0x9f, 0xc0, 0xef, 0xd1,
    0xdf, 0x70, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf1,
    0x0, 0x0, 0x3, 0x0, 0xef, 0xd0, 0x3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x50, 0xaf, 0xf1,
    0x19, 0x30, 0x0, 0x0, 0xef, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf6, 0xaf, 0xf3, 0xdf, 0xe0,
    0x0, 0x0, 0xef, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xef, 0xfe, 0xff, 0xd0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x17, 0xff,
    0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x6f, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x0, 0x6b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xba, 0x30, 0x6, 0xff, 0xfc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xc1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0,

    /* U+F07B "" */
    0x5, 0x78, 0x88, 0x88, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xcc,
    0xcc, 0xcc, 0xcb, 0x91, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe4,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xfc,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x11, 0x11, 0xef,
    0xff, 0xf9, 0x11, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xe0, 0xdf, 0xff, 0xf8, 0xe,
    0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xf3, 0x26,
    0x66, 0x50, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x52, 0x22, 0x25, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x6e, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xaf,
    0x5d, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xc8, 0x51, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x5, 0xb8, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x1, 0x8e, 0xff,
    0xf6, 0x0, 0x8, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xf4, 0x4d, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xb5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0xb9,
    0x74, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C4 "" */
    0x1, 0x8c, 0xda, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x20, 0x0, 0x1d, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0x80, 0xaf, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xf1, 0xef, 0xe1,
    0xc, 0xff, 0x20, 0x0, 0xbf, 0xff, 0xfe, 0x30,
    0xff, 0xd0, 0xa, 0xff, 0x30, 0xb, 0xff, 0xff,
    0xe3, 0x0, 0xbf, 0xfc, 0xbf, 0xff, 0x10, 0xcf,
    0xff, 0xfe, 0x30, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xdc, 0xff, 0xff, 0xe3, 0x0, 0x0, 0x3, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x1, 0x2d, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x1, 0x8c,
    0xef, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0x33, 0xef,
    0xff, 0xfc, 0x0, 0x0, 0xef, 0xe1, 0xc, 0xff,
    0x20, 0x2e, 0xff, 0xff, 0xc1, 0x0, 0xff, 0xd0,
    0xa, 0xff, 0x30, 0x2, 0xef, 0xff, 0xfc, 0x10,
    0xbf, 0xfc, 0xbf, 0xff, 0x0, 0x0, 0x1d, 0xff,
    0xff, 0xc0, 0x3f, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x1, 0xcf, 0xff, 0xd1, 0x3, 0xdf, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x4, 0x75, 0x0, 0x0, 0x1,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0x12, 0x22, 0x22, 0x22, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xfe, 0xe, 0x70, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xfe, 0xe, 0xf7, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xfe, 0xe, 0xff, 0x70,
    0x1, 0x22, 0x5, 0xff, 0xff, 0xff, 0xfe, 0xe,
    0xff, 0xf2, 0xdf, 0xff, 0x25, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x0, 0x0, 0xff, 0xff, 0x25, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0x25, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0x25, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0xff, 0xff, 0x25, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0x25, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0x25, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0x25, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0xff, 0xff, 0x25, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0x25, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0x25, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0x25, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0xff, 0xff, 0x24, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0x50, 0x56,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x50, 0xff, 0xff,
    0xe4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0x8b, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xb7, 0x0, 0x0, 0x0,

    /* U+F0C7 "" */
    0x2a, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x91,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x10, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd1, 0x0, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xfd, 0x10,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xd0, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xf5, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xf6, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xf6,
    0xff, 0xfb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbc, 0xff,
    0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff,
    0xff, 0xfe, 0x51, 0x3b, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xf6, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xf6, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x4, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xda, 0xbf, 0xff, 0xff,
    0xff, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,

    /* U+F0E7 "" */
    0x0, 0x3, 0x44, 0x44, 0x43, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xfe, 0x66, 0x66, 0x51, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x40, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x1, 0x22, 0x22, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0x90, 0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8c, 0xcc, 0xdf, 0xbc,
    0xfc, 0xcc, 0xc6, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xfe, 0x1, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xde, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x92,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xfc, 0x1, 0x22, 0x22, 0x22, 0x1, 0x0, 0x0,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xfc, 0xe,
    0x70, 0x0, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff,
    0xfc, 0xe, 0xf7, 0x0, 0xff, 0xff, 0xf8, 0x1f,
    0xff, 0xff, 0xfc, 0xe, 0xff, 0x70, 0xff, 0xff,
    0xf8, 0x1f, 0xff, 0xff, 0xfc, 0xe, 0xff, 0xf2,
    0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xfe, 0x10,
    0x0, 0x0, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xf8, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x58, 0x88, 0x84, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x8,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x80,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xef, 0xf9, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xfb, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x6c, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7b, 0x81, 0x0, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x19, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb7, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xfd, 0x0,
    0x8f, 0x10, 0x7f, 0x10, 0x5f, 0x30, 0x3f, 0x50,
    0x1f, 0xfc, 0xff, 0xc0, 0x7, 0xe0, 0x6, 0xf0,
    0x4, 0xf2, 0x2, 0xf4, 0x0, 0xff, 0xcf, 0xfc,
    0x0, 0x8f, 0x0, 0x7f, 0x10, 0x5f, 0x30, 0x3f,
    0x50, 0x1f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
    0xff, 0xfe, 0x66, 0xbf, 0x66, 0xaf, 0x76, 0x8f,
    0x86, 0x7f, 0xff, 0xfc, 0xff, 0xff, 0xd0, 0x6,
    0xf0, 0x5, 0xf1, 0x3, 0xf3, 0x1, 0xff, 0xff,
    0xcf, 0xff, 0xfd, 0x0, 0x7f, 0x0, 0x5f, 0x10,
    0x3f, 0x30, 0x1f, 0xff, 0xfc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xcf, 0xfe, 0x66, 0xcf, 0x76, 0x66, 0x66,
    0x66, 0x66, 0x9f, 0xa6, 0x7f, 0xfc, 0xff, 0xc0,
    0x7, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf4,
    0x0, 0xff, 0xcf, 0xfc, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x40, 0xf, 0xfc, 0xff,
    0xfc, 0xce, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcd,
    0xfd, 0xcc, 0xff, 0xbd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x10,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5c, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x7e, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x4, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x1, 0x22, 0x22,
    0x22, 0x7f, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xb8, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x37, 0x77, 0x77, 0x77, 0x74, 0x5, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xa0, 0xfa, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xf, 0xfa,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xa0, 0xff,
    0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xf,
    0xff, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xe3, 0x22, 0x22, 0x21, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x40,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x26, 0x9c, 0xde, 0xdc, 0xb8, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x8d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb5, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xdb, 0x99, 0x9a,
    0xcf, 0xff, 0xff, 0xff, 0xb1, 0x0, 0xa, 0xff,
    0xff, 0xfc, 0x61, 0x0, 0x0, 0x0, 0x0, 0x39,
    0xef, 0xff, 0xfe, 0x40, 0xcf, 0xff, 0xfb, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xf4, 0xaf, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0xf2,
    0xa, 0xd2, 0x0, 0x0, 0x4, 0x9c, 0xef, 0xed,
    0xb6, 0x20, 0x0, 0x0, 0x8e, 0x30, 0x0, 0x0,
    0x0, 0x6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xfb,
    0x87, 0x89, 0xdf, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0x3, 0xaf, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xba, 0x10, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xd4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xcf, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xeb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbd, 0xff, 0x50,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xf9, 0xff, 0xc0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x7, 0xff, 0xfa, 0xff, 0xc0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3,
    0x7f, 0xfa, 0xff, 0xc0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1f, 0xfa,
    0xff, 0xc0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x1f, 0xfa, 0xff, 0xc0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x5, 0xdf, 0xfa, 0xff, 0xc0, 0x78, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x7,
    0xff, 0xfa, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x19, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0x92, 0x0,

    /* U+F241 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xeb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbd, 0xff, 0x50,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xf9, 0xff, 0xc0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x7, 0xff, 0xfa, 0xff, 0xc0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x3,
    0x7f, 0xfa, 0xff, 0xc0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x1f, 0xfa,
    0xff, 0xc0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x1f, 0xfa, 0xff, 0xc0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x5, 0xdf, 0xfa, 0xff, 0xc0, 0x78, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x86, 0x0, 0x0, 0x7,
    0xff, 0xfa, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x19, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0x92, 0x0,

    /* U+F242 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xeb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbd, 0xff, 0x50,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xf9, 0xff, 0xc0,
    0xef, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfa, 0xff, 0xc0, 0xef, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x7f, 0xfa, 0xff, 0xc0, 0xef, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xfa,
    0xff, 0xc0, 0xef, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xfa, 0xff, 0xc0,
    0xef, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xfa, 0xff, 0xc0, 0x78, 0x88,
    0x88, 0x88, 0x85, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfa, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x19, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0x92, 0x0,

    /* U+F243 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xeb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbd, 0xff, 0x50,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xf9, 0xff, 0xc0,
    0xef, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfa, 0xff, 0xc0, 0xef, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x7f, 0xfa, 0xff, 0xc0, 0xef, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xfa,
    0xff, 0xc0, 0xef, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xfa, 0xff, 0xc0,
    0xef, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xfa, 0xff, 0xc0, 0x78, 0x88,
    0x84, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfa, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x19, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0x92, 0x0,

    /* U+F244 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xeb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbd, 0xff, 0x50,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xf9, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfa, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x7f, 0xfa, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xfa,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xfa, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xfa, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfa, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x19, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0x92, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18,
    0x92, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x12, 0xdf, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x76, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf6, 0x0, 0x4c,
    0xd5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x33,
    0x0, 0x0, 0xd, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xd2, 0x0,
    0x4f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0x40, 0x0, 0xaf, 0xff, 0xfc, 0x1, 0xde, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xfa, 0x10,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xdf, 0xff,
    0xff, 0x88, 0x88, 0x9f, 0xe8, 0x88, 0x88, 0x88,
    0x88, 0x8f, 0xff, 0x91, 0x5f, 0xff, 0xf8, 0x0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xc3, 0x0, 0x4, 0xbb, 0x60, 0x0, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x30,
    0x8, 0x88, 0x83, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xc1, 0x2f, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x27, 0x9f, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x9e, 0xff, 0xff, 0xc7, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xdf, 0xff, 0xfd,
    0x20, 0x0, 0x8, 0xff, 0xff, 0xf2, 0xdf, 0xff,
    0xfe, 0x0, 0x3, 0xff, 0xff, 0xff, 0x11, 0xdf,
    0xff, 0xf9, 0x0, 0xaf, 0xff, 0xff, 0xf1, 0x1,
    0xef, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xff, 0x12,
    0x12, 0xef, 0xff, 0x53, 0xff, 0xf4, 0x7f, 0xf1,
    0x3d, 0x13, 0xff, 0xf8, 0x6f, 0xff, 0x40, 0x7f,
    0x13, 0xf5, 0xc, 0xff, 0xb8, 0xff, 0xff, 0x40,
    0x71, 0x35, 0xa, 0xff, 0xfd, 0x9f, 0xff, 0xff,
    0x40, 0x0, 0x8, 0xff, 0xff, 0xea, 0xff, 0xff,
    0xff, 0x30, 0x6, 0xff, 0xff, 0xfe, 0xaf, 0xff,
    0xff, 0xf4, 0x0, 0x6f, 0xff, 0xff, 0xe9, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x7f, 0xff, 0xfe, 0x8f,
    0xff, 0xf4, 0x6, 0x13, 0x50, 0x8f, 0xff, 0xd6,
    0xff, 0xf4, 0x7, 0xf1, 0x3f, 0x40, 0x9f, 0xfb,
    0x3f, 0xff, 0x47, 0xff, 0x13, 0xd1, 0x1d, 0xff,
    0x90, 0xff, 0xff, 0xff, 0xf1, 0x21, 0x1d, 0xff,
    0xf5, 0xa, 0xff, 0xff, 0xff, 0x20, 0x2e, 0xff,
    0xff, 0x0, 0x2f, 0xff, 0xff, 0xf2, 0x2e, 0xff,
    0xff, 0x80, 0x0, 0x6f, 0xff, 0xff, 0x4e, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x0, 0x0, 0x0, 0x5, 0x9c, 0xdd,
    0xc9, 0x40, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x0, 0x2, 0x22, 0x22, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xe1, 0x0, 0x0, 0x0, 0xac, 0xcc, 0xcd, 0xff,
    0xff, 0xff, 0xfd, 0xcc, 0xcc, 0xc1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xca, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xa, 0xff, 0xe1, 0xef, 0xf2, 0xcf,
    0xf3, 0xbf, 0xfe, 0x0, 0xa, 0xff, 0xd0, 0xdf,
    0xf0, 0xbf, 0xf1, 0x9f, 0xfe, 0x0, 0xa, 0xff,
    0xd0, 0xdf, 0xf0, 0xbf, 0xf1, 0x9f, 0xfe, 0x0,
    0xa, 0xff, 0xd0, 0xdf, 0xf0, 0xbf, 0xf1, 0x9f,
    0xfe, 0x0, 0xa, 0xff, 0xd0, 0xdf, 0xf0, 0xbf,
    0xf1, 0x9f, 0xfe, 0x0, 0xa, 0xff, 0xd0, 0xdf,
    0xf0, 0xbf, 0xf1, 0x9f, 0xfe, 0x0, 0xa, 0xff,
    0xd0, 0xdf, 0xf0, 0xbf, 0xf1, 0x9f, 0xfe, 0x0,
    0xa, 0xff, 0xd0, 0xdf, 0xf0, 0xbf, 0xf1, 0x9f,
    0xfe, 0x0, 0xa, 0xff, 0xd0, 0xdf, 0xf0, 0xbf,
    0xf1, 0x9f, 0xfe, 0x0, 0xa, 0xff, 0xd0, 0xdf,
    0xf0, 0xbf, 0xf1, 0x9f, 0xfe, 0x0, 0xa, 0xff,
    0xe1, 0xef, 0xf1, 0xcf, 0xf3, 0xaf, 0xfe, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x7b, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcb, 0x91, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xc, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf4, 0xc, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xf4, 0xc, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xf4, 0xc, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xf4, 0xc, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xb9, 0x75,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x2, 0x68, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x75, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0x80, 0xcf,
    0xff, 0xc0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0xc, 0xfc, 0x0,
    0xc, 0xff, 0xff, 0xf8, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x90, 0x0, 0x5f, 0xff,
    0xff, 0xf8, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xf8,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xf8, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x10, 0x0, 0xcf, 0xff,
    0xff, 0xf8, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x5, 0xf5, 0x0, 0xd, 0xff, 0xff, 0xf8,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x5f,
    0xff, 0x50, 0x2e, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xe8, 0xff, 0xff, 0xf8,
    0xef, 0xff, 0xff, 0xf8, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x9, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x50,

    /* U+F7C2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xfe,
    0x70, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x2, 0xef, 0xbb, 0xfc, 0xbf, 0xdb,
    0xbf, 0xf9, 0x2, 0xef, 0xd0, 0x2f, 0x40, 0xe7,
    0x1, 0xff, 0xa2, 0xef, 0xfd, 0x2, 0xf4, 0xe,
    0x70, 0x1f, 0xfa, 0xef, 0xff, 0xd0, 0x2f, 0x40,
    0xe7, 0x1, 0xff, 0xaf, 0xff, 0xfd, 0x24, 0xf6,
    0x2e, 0x82, 0x3f, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x99, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x9, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd5, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xff, 0x10, 0x0, 0x3, 0xed, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xf1, 0x0, 0x4,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0x10, 0x5, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xf1, 0x6, 0xff, 0xff,
    0xf6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x9f, 0xff,
    0x17, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x13,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd0, 0x2, 0xef, 0xff, 0xf1, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0, 0x2,
    0xdf, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xdf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xb8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 87, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 91, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32, .adv_w = 113, .box_w = 5, .box_h = 6, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 47, .adv_w = 219, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 151, .adv_w = 198, .box_w = 11, .box_h = 21, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 267, .adv_w = 258, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 387, .adv_w = 219, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 491, .adv_w = 61, .box_w = 2, .box_h = 6, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 497, .adv_w = 120, .box_w = 7, .box_h = 24, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 581, .adv_w = 122, .box_w = 7, .box_h = 24, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 665, .adv_w = 152, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 715, .adv_w = 200, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 787, .adv_w = 69, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 799, .adv_w = 97, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 805, .adv_w = 93, .box_w = 4, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 811, .adv_w = 145, .box_w = 9, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 888, .adv_w = 198, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 976, .adv_w = 198, .box_w = 7, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1032, .adv_w = 198, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1120, .adv_w = 198, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1200, .adv_w = 198, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1296, .adv_w = 198, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1384, .adv_w = 197, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1472, .adv_w = 198, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1568, .adv_w = 198, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1656, .adv_w = 198, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1736, .adv_w = 85, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1754, .adv_w = 74, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1784, .adv_w = 179, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1834, .adv_w = 193, .box_w = 10, .box_h = 6, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 1864, .adv_w = 184, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1914, .adv_w = 166, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1994, .adv_w = 316, .box_w = 18, .box_h = 21, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 2183, .adv_w = 230, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2303, .adv_w = 219, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2399, .adv_w = 229, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2503, .adv_w = 231, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2607, .adv_w = 200, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2695, .adv_w = 195, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2783, .adv_w = 240, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2887, .adv_w = 251, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2991, .adv_w = 96, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3023, .adv_w = 194, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3111, .adv_w = 221, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3215, .adv_w = 189, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3303, .adv_w = 307, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3439, .adv_w = 251, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3543, .adv_w = 242, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3647, .adv_w = 222, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3751, .adv_w = 242, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3875, .adv_w = 217, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3979, .adv_w = 209, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4083, .adv_w = 210, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4187, .adv_w = 228, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4283, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4395, .adv_w = 312, .box_w = 20, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4555, .adv_w = 221, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4667, .adv_w = 211, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4779, .adv_w = 211, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4883, .adv_w = 93, .box_w = 5, .box_h = 22, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4938, .adv_w = 144, .box_w = 9, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5015, .adv_w = 93, .box_w = 5, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5070, .adv_w = 147, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 5106, .adv_w = 159, .box_w = 10, .box_h = 2, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5116, .adv_w = 109, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 14},
    {.bitmap_index = 5125, .adv_w = 191, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5185, .adv_w = 197, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5273, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5339, .adv_w = 199, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5419, .adv_w = 186, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5479, .adv_w = 122, .box_w = 8, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5547, .adv_w = 197, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 5632, .adv_w = 194, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5712, .adv_w = 85, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5736, .adv_w = 84, .box_w = 5, .box_h = 21, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 5789, .adv_w = 178, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5877, .adv_w = 85, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5901, .adv_w = 309, .box_w = 17, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6003, .adv_w = 194, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6063, .adv_w = 201, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6135, .adv_w = 197, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 6229, .adv_w = 200, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 6314, .adv_w = 119, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6356, .adv_w = 182, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6416, .adv_w = 115, .box_w = 7, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6469, .adv_w = 194, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6529, .adv_w = 171, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6595, .adv_w = 265, .box_w = 17, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6697, .adv_w = 174, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6763, .adv_w = 167, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 6857, .adv_w = 174, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6923, .adv_w = 119, .box_w = 8, .box_h = 22, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7011, .adv_w = 86, .box_w = 3, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 7040, .adv_w = 119, .box_w = 7, .box_h = 22, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7117, .adv_w = 239, .box_w = 13, .box_h = 4, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 7143, .adv_w = 352, .box_w = 23, .box_h = 23, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 7408, .adv_w = 352, .box_w = 22, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7595, .adv_w = 352, .box_w = 22, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7815, .adv_w = 352, .box_w = 22, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8002, .adv_w = 242, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8130, .adv_w = 352, .box_w = 22, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8383, .adv_w = 352, .box_w = 22, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8636, .adv_w = 396, .box_w = 25, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8886, .adv_w = 352, .box_w = 22, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9139, .adv_w = 396, .box_w = 25, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9352, .adv_w = 352, .box_w = 22, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9605, .adv_w = 176, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9704, .adv_w = 264, .box_w = 17, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9857, .adv_w = 396, .box_w = 25, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10132, .adv_w = 352, .box_w = 22, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10319, .adv_w = 308, .box_w = 15, .box_h = 21, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 10477, .adv_w = 308, .box_w = 20, .box_h = 24, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10717, .adv_w = 308, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10917, .adv_w = 308, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11117, .adv_w = 308, .box_w = 15, .box_h = 21, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 11275, .adv_w = 308, .box_w = 21, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 11485, .adv_w = 220, .box_w = 12, .box_h = 20, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11605, .adv_w = 220, .box_w = 12, .box_h = 20, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11725, .adv_w = 308, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11925, .adv_w = 308, .box_w = 20, .box_h = 5, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 11975, .adv_w = 396, .box_w = 25, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12188, .adv_w = 440, .box_w = 28, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12510, .adv_w = 396, .box_w = 27, .box_h = 23, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 12821, .adv_w = 352, .box_w = 22, .box_h = 21, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13052, .adv_w = 308, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 13166, .adv_w = 308, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 13280, .adv_w = 440, .box_w = 28, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13532, .adv_w = 352, .box_w = 22, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13719, .adv_w = 352, .box_w = 22, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13972, .adv_w = 352, .box_w = 23, .box_h = 23, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 14237, .adv_w = 308, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14437, .adv_w = 308, .box_w = 20, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14667, .adv_w = 308, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14867, .adv_w = 220, .box_w = 15, .box_h = 23, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 15040, .adv_w = 308, .box_w = 20, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15270, .adv_w = 308, .box_w = 20, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15500, .adv_w = 396, .box_w = 25, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15713, .adv_w = 352, .box_w = 24, .box_h = 23, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 15989, .adv_w = 264, .box_w = 17, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16185, .adv_w = 440, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16479, .adv_w = 440, .box_w = 28, .box_h = 15, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16689, .adv_w = 440, .box_w = 28, .box_h = 15, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16899, .adv_w = 440, .box_w = 28, .box_h = 15, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 17109, .adv_w = 440, .box_w = 28, .box_h = 15, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 17319, .adv_w = 440, .box_w = 28, .box_h = 15, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 17529, .adv_w = 440, .box_w = 28, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 17781, .adv_w = 308, .box_w = 17, .box_h = 23, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17977, .adv_w = 308, .box_w = 20, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 18207, .adv_w = 352, .box_w = 23, .box_h = 23, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 18472, .adv_w = 440, .box_w = 28, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18710, .adv_w = 264, .box_w = 17, .box_h = 23, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 18906, .adv_w = 354, .box_w = 23, .box_h = 14, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -18, 0, 0, 0,
    0, 0, 0, 0, -21, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -9, -10, 0, -3, -10, 0, -14, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 3, 0,
    4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -29, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -38, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -21, 0, 0, 0, 0, 0, 0, -10,
    0, -2, 0, 0, -22, -3, -15, -12,
    0, -16, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, -3, -2, -9, -6, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, -4, 0, 0, -9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, 0, 0, 0, 0, -18, 0, 0,
    0, -4, 0, 0, 0, -5, 0, -4,
    0, -4, -7, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, -3, 0, 0, 0,
    -3, -4, -4, 0, 0, 0, 0, 0,
    0, 0, 0, -40, 0, 0, 0, -29,
    0, -45, 0, 3, 0, 0, 0, 0,
    0, 0, 0, -6, -4, 0, 0, -4,
    -4, 0, 0, -4, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, -5, 0,
    0, 0, 3, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -11, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -4,
    -5, 0, 0, 0, -4, -7, -11, 0,
    0, 0, 0, -58, 0, 0, 0, 0,
    0, 0, 0, 3, -11, 0, 0, -47,
    -9, -30, -25, 0, -41, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    -23, -16, 0, 0, 0, 0, 0, 0,
    0, 0, -56, 0, 0, 0, -24, 0,
    -34, 0, 0, 0, 0, 0, -5, 0,
    -4, 0, -2, -2, 0, 0, -2, 0,
    0, 2, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, -5,
    -3, 0, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -14, 0, -3, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, -37, -40, 0, 0, -14,
    -5, -41, -3, 3, 0, 3, 3, 0,
    3, 0, 0, -19, -17, 0, -19, -17,
    -13, -20, 0, -16, -12, -10, -13, -10,
    0, 0, 0, 0, 3, 0, -39, -6,
    0, 0, -13, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, -8, -8,
    0, 0, -8, -5, 0, 0, -5, -2,
    0, 0, 0, 3, 0, 0, 0, 3,
    0, -21, -10, 0, 0, -7, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    2, -6, -5, 0, 0, -5, -4, 0,
    0, -3, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, -4, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    -4, 0, 0, 0, -4, -5, 0, 0,
    0, 0, 0, 0, -5, 3, -8, -36,
    -9, 0, 0, -16, -5, -16, -3, 3,
    -16, 3, 3, 2, 3, 0, 3, -13,
    -11, -4, -7, -11, -7, -10, -4, -7,
    -3, 0, -4, -5, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, -4, 0,
    0, 0, -3, -5, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, -3, -3,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    3, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, -18, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -23, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -4, -3, 0, 0, 3, 0, 0, 0,
    -21, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -7, -3, 3, 0, -3, 0, 0, 9,
    0, 3, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, -18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -2,
    2, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 35,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_roboto_22 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 26,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
    .subpx = LV_FONT_SUBPX_NONE,
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if LV_FONT_ROBOTO_22*/

