/*
 * Copyright 2016-2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_device_registers.h"

////////////////////////////////////////////////////////////////////////////////
// Definitions
////////////////////////////////////////////////////////////////////////////////

//! peripheral enable configurations
#define BL_ENABLE_PINMUX_UART1 (BL_CONFIG_LPUART_1)

#define UART1_RX_IOMUXC_MUX_FUNC IOMUXC_GPIO_AD_B0_13_LPUART1_RX
#define UART1_RX_IOMUXC_MUX_GPIO IOMUXC_GPIO_AD_B0_13_GPIO1_IO13
#define UART1_RX_IOMUXC_PAD_DEFAULT 0x000010B0
#define UART1_RX_GPIO_BASE GPIO1
#define UART1_RX_GPIO_PIN_NUM 13 // GPIO_AD_B0_13/GPIO1[13]
#define UART1_RX_GPIO_IRQn GPIO1_Combined_0_15_IRQn
#define UART1_RX_GPIO_IRQHandler GPIO1_Combined_0_15_IRQHandler

#define UART1_TX_IOMUXC_MUX_FUNC IOMUXC_GPIO_AD_B0_12_LPUART1_TX
#define UART1_TX_IOMUXC_PAD_DEFAULT 0x000010B0
#define UART1_TX_GPIO_PIN_NUM 12 // GPIO_AD_B0_12/GPIO1[12]

/*====================== LPUART IOMUXC Definitions ===========================*/
#define SW_MUX_CTL_PAD_LPUART1_TX_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_12
#define SW_PAD_CTL_PAD_LPUART1_TX_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_12
#define SW_MUX_CTL_PAD_LPUART1_RX_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_13
#define SW_PAD_CTL_PAD_LPUART1_RX_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_13
#define LPUART1_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(2)
#define LPUART1_PAD_CTRL                                                                            \
    (IOMUXC_SW_PAD_CTL_PAD_SRE(0) | IOMUXC_SW_PAD_CTL_PAD_DSE(6) | IOMUXC_SW_PAD_CTL_PAD_SPEED(2) | \
     IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(1))

/*====================== LPSPI IOMUXC Definitions ===========================*/
/* LPSPI1 PINMUX Info  */
#define SW_MUX_CTL_PAD_LPSPI1_PCS0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_01
#define SW_MUX_CTL_PAD_LPSPI1_SCK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_00
#define SW_MUX_CTL_PAD_LPSPI1_SIN_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_03
#define SW_MUX_CTL_PAD_LPSPI1_SOUT_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_02

#define SW_PAD_CTL_PAD_LPSPI1_PCS0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_01
#define SW_PAD_CTL_PAD_LPSPI1_SCK_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_00
#define SW_PAD_CTL_PAD_LPSPI1_SIN_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_03
#define SW_PAD_CTL_PAD_LPSPI1_SOUT_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B0_02

#define SELECT_INPUT_LPSPI1_SDI_IDX kIOMUXC_LPSPI1_SDI_SELECT_INPUT

#define LPSPI1_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(4)
#define GPIO_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(5)
#define LPSPI1_PCS_GPIO GPIO3
#define LPSPI1_PCS_GPIO_NUM 13

/* LPSPI2 PINMUX Info */
#define SW_MUX_CTL_PAD_LPSPI2_PCS0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_06
#define SW_MUX_CTL_PAD_LPSPI2_SCK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_07
#define SW_MUX_CTL_PAD_LPSPI2_SIN_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_09
#define SW_MUX_CTL_PAD_LPSPI2_SOUT_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_08

#define SW_PAD_CTL_PAD_LPSPI2_PCS0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_06
#define SW_PAD_CTL_PAD_LPSPI2_SCK_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_07
#define SW_PAD_CTL_PAD_LPSPI2_SIN_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_09
#define SW_PAD_CTL_PAD_LPSPI2_SOUT_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_08

#define SELECT_INPUT_LPSPI2_SDI_IDX kIOMUXC_LPSPI2_SDI_SELECT_INPUT

#define LPSPI2_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(4)
#define LPSPI2_PCS_GPIO GPIO3
#define LPSPI2_PCS_GPIO_NUM 6

/* LPSPI3 PINMUX Info */
#define SW_MUX_CTL_PAD_LPSPI3_PCS0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_03
#define SW_MUX_CTL_PAD_LPSPI3_SCK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_00
#define SW_MUX_CTL_PAD_LPSPI3_SIN_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_02
#define SW_MUX_CTL_PAD_LPSPI3_SOUT_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_01

#define SW_PAD_CTL_PAD_LPSPI3_PCS0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_03
#define SW_PAD_CTL_PAD_LPSPI3_SCK_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_00
#define SW_PAD_CTL_PAD_LPSPI3_SIN_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_02
#define SW_PAD_CTL_PAD_LPSPI3_SOUT_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_01

#define SELECT_INPUT_LPSPI3_SDI_IDX kIOMUXC_LPSPI3_SDI_SELECT_INPUT

#define LPSPI3_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(7)
#define LPSPI3_PCS_GPIO GPIO1
#define LPSPI3_PCS_GPIO_NUM 3

/* LPSPI4 PINMUX Info */
#define SW_MUX_CTL_PAD_LPSPI4_PCS0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_00
#define SW_MUX_CTL_PAD_LPSPI4_SCK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_03
#define SW_MUX_CTL_PAD_LPSPI4_SIN_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_01
#define SW_MUX_CTL_PAD_LPSPI4_SOUT_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_02

#define SW_PAD_CTL_PAD_LPSPI4_PCS0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_00
#define SW_PAD_CTL_PAD_LPSPI4_SCK_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_03
#define SW_PAD_CTL_PAD_LPSPI4_SIN_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_01
#define SW_PAD_CTL_PAD_LPSPI4_SOUT_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_02

#define SELECT_INPUT_LPSPI4_SDI_IDX kIOMUXC_LPSPI4_SDI_SELECT_INPUT

#define LPSPI4_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(3)
#define LPSPI4_PCS_GPIO GPIO2
#define LPSPI4_PCS_GPIO_NUM 0

// Fast Slew Rate
// Driver Strength: 260Ohm @3.3V, 150Ohm @1.8V, 240 Ohm for DDR
// Max Speed : 200MHz
// Pull enabled
// Pull
// 47K Ohm Pull up.
#define LPSPI_SW_PAD_CTL_VAL                                                                       \
    IOMUXC_SW_PAD_CTL_PAD_SRE(1) | IOMUXC_SW_PAD_CTL_PAD_DSE(1) | IOMUXC_SW_PAD_CTL_PAD_SPEED(0) | \
        IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(1)
#define GPIO_SW_PAD_CTL_VAL                                                                        \
    IOMUXC_SW_PAD_CTL_PAD_SRE(1) | IOMUXC_SW_PAD_CTL_PAD_DSE(1) | IOMUXC_SW_PAD_CTL_PAD_SPEED(0) | \
        IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(1)
#define LPSPI1_SDI_SELECT_INPUT_VAL IOMUXC_SELECT_INPUT_DAISY(1) // SELECT_GPIO_SD_B0_03_ALT4
#define LPSPI2_SDI_SELECT_INPUT_VAL IOMUXC_SELECT_INPUT_DAISY(0) // SELECT_GPIO_SD_B1_09_ALT4
#define LPSPI3_SDI_SELECT_INPUT_VAL IOMUXC_SELECT_INPUT_DAISY(0) // SELECT_GPIO_AD_B0_02_ALT7
#define LPSPI4_SDI_SELECT_INPUT_VAL IOMUXC_SELECT_INPUT_DAISY(0) // SELECT_GPIO_SD_B0_01_ALT3

/*====================== FLEXSPI IOMUXC Definitions ===========================*/
#define SW_MUX_CTL_PAD_FLEXSPIB_DQS_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_05
#define SW_MUX_CTL_PAD_FLEXSPIB_DATA3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_00
#define SW_MUX_CTL_PAD_FLEXSPIB_DATA2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_01
#define SW_MUX_CTL_PAD_FLEXSPIB_DATA1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_02
#define SW_MUX_CTL_PAD_FLEXSPIB_DATA0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_03
#define SW_MUX_CTL_PAD_FLEXSPIB_SS0_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_04
#define SW_MUX_CTL_PAD_FLEXSPIB_SS1_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_01
#define SW_MUX_CTL_PAD_FLEXSPIB_SCLK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_04

#define SW_MUX_CTL_PAD_FLEXSPIA_DQS_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_05
#define SW_MUX_CTL_PAD_FLEXSPIA_SS0_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_06
#define SW_MUX_CTL_PAD_FLEXSPIA_SS1_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_00
#define SW_MUX_CTL_PAD_FLEXSPIA_SCLK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_07
#define SW_MUX_CTL_PAD_FLEXSPIA_DATA0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_08
#define SW_MUX_CTL_PAD_FLEXSPIA_DATA1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_09
#define SW_MUX_CTL_PAD_FLEXSPIA_DATA2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_10
#define SW_MUX_CTL_PAD_FLEXSPIA_DATA3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_11
#define SW_MUX_CTL_PAD_FLEXSPIA_SCLK_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_04

#define SW_PAD_CTL_PAD_FLEXSPIB_DQS_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_05
#define SW_PAD_CTL_PAD_FLEXSPIB_DATA3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_00
#define SW_PAD_CTL_PAD_FLEXSPIB_DATA2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_01
#define SW_PAD_CTL_PAD_FLEXSPIB_DATA1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_02
#define SW_PAD_CTL_PAD_FLEXSPIB_DATA0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_03
#define SW_PAD_CTL_PAD_FLEXSPIB_SS0_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_04
#define SW_PAD_CTL_PAD_FLEXSPIB_SS1_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_01
#define SW_PAD_CTL_PAD_FLEXSPIB_SCLK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_04

#define SW_PAD_CTL_PAD_FLEXSPIA_DQS_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_05
#define SW_PAD_CTL_PAD_FLEXSPIA_SS0_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_06
#define SW_PAD_CTL_PAD_FLEXSPIA_SS1_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_00
#define SW_PAD_CTL_PAD_FLEXSPIA_SCLK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_07
#define SW_PAD_CTL_PAD_FLEXSPIA_DATA0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_08
#define SW_PAD_CTL_PAD_FLEXSPIA_DATA1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_09
#define SW_PAD_CTL_PAD_FLEXSPIA_DATA2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_10
#define SW_PAD_CTL_PAD_FLEXSPIA_DATA3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_11
#define SW_PAD_CTL_PAD_FLEXSPIA_SCLK_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_04

#define FLEXSPIA_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(1)
#define FLEXSPIB_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(1)
#define FLEXSPIA_SS1_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(6)
#define FLEXSPIB_SS1_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(6)
#define FLEXSPIB_SS0_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(4)
#define FLEXSPIB_DQS_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(4)

// Fast Slew Rate
// Driver Strength: R0=260Ohm @3.3V, 150Ohm @1.8V, 240 Ohm for DDR, Actual R = R0/6
// Max Speed : 200MHz
// Pull enabled
// Keeper
#define FLEXSPI_SW_PAD_CTL_VAL                                                                      \
    (IOMUXC_SW_PAD_CTL_PAD_SRE(1) | IOMUXC_SW_PAD_CTL_PAD_DSE(6) | IOMUXC_SW_PAD_CTL_PAD_SPEED(3) | \
     IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(0) | IOMUXC_SW_PAD_CTL_PAD_PUS(0))

// Fast Slew Rate
// Driver Strength: R0=260Ohm @3.3V, 150Ohm @1.8V, 240 Ohm for DDR, Acutal R = R0/6
// Max Speed : 200MHz
// Pull enabled
// Pull
// 100k ohm pull down resistor
#define FLEXSPI_DQS_SW_PAD_CTL_VAL                                                                  \
    (IOMUXC_SW_PAD_CTL_PAD_SRE(1) | IOMUXC_SW_PAD_CTL_PAD_DSE(6) | IOMUXC_SW_PAD_CTL_PAD_SPEED(3) | \
     IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(0) |   \
     IOMUXC_SW_PAD_CTL_PAD_HYS(1))

/*====================== FLEXSPI Secondary IOMUXC Definitions ===========================*/
#define SW_MUX_CTL_PAD_FLEXSPIA_SEC_SS0_B_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_15
#define SW_MUX_CTL_PAD_FLEXSPIA_SEC_SCLK_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_14
#define SW_MUX_CTL_PAD_FLEXSPIA_SEC_DATA0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_13
#define SW_MUX_CTL_PAD_FLEXSPIA_SEC_DATA1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_12
#define SW_MUX_CTL_PAD_FLEXSPIA_SEC_DATA2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_11
#define SW_MUX_CTL_PAD_FLEXSPIA_SEC_DATA3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_10
#define SW_MUX_CTL_PAD_FLEXSPIA_SEC_DQS_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_09

#define SW_PAD_CTL_PAD_FLEXSPIA_SEC_SS0_B_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_15
#define SW_PAD_CTL_PAD_FLEXSPIA_SEC_SCLK_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_14
#define SELECT_INPUT_FLEXSPIA_SEC_SCLK_IDX kIOMUXC_FLEXSPIA_SCK_SELECT_INPUT
#define SW_PAD_CTL_PAD_FLEXSPIA_SEC_DATA0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_13
#define SELECT_INPUT_FLEXSPIA_SEC_DATA0_IDX kIOMUXC_FLEXSPIA_DATA0_SELECT_INPUT
#define SW_PAD_CTL_PAD_FLEXSPIA_SEC_DATA1_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_12
#define SELECT_INPUT_FLEXSPIA_SEC_DATA1_IDX kIOMUXC_FLEXSPIA_DATA1_SELECT_INPUT
#define SW_PAD_CTL_PAD_FLEXSPIA_SEC_DATA2_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_11
#define SELECT_INPUT_FLEXSPIA_SEC_DATA2_IDX kIOMUXC_FLEXSPIA_DATA2_SELECT_INPUT
#define SW_PAD_CTL_PAD_FLEXSPIA_SEC_DATA3_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_10
#define SELECT_INPUT_FLEXSPIA_SEC_DATA3_IDX kIOMUXC_FLEXSPIA_DATA3_SELECT_INPUT
#define SW_PAD_CTL_PAD_FLEXSPIA_SEC_DQS_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B1_09
#define SELECT_INPUT_FLEXSPIA_SEC_DQS_IDX kIOMUXC_FLEXSPIA_DQS_SELECT_INPUT

#define FLEXSPIA_SEC_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(0)

/*====================== SEMC IOMUXC Definitions ===========================*/

#define SW_MUX_CTL_PAD_SEMC_DATA0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_00
#define SW_MUX_CTL_PAD_SEMC_DATA1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_01
#define SW_MUX_CTL_PAD_SEMC_DATA2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_02
#define SW_MUX_CTL_PAD_SEMC_DATA3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_03
#define SW_MUX_CTL_PAD_SEMC_DATA4_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_04
#define SW_MUX_CTL_PAD_SEMC_DATA5_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_05
#define SW_MUX_CTL_PAD_SEMC_DATA6_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_06
#define SW_MUX_CTL_PAD_SEMC_DATA7_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_07
#define SW_MUX_CTL_PAD_SEMC_DATA8_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_30
#define SW_MUX_CTL_PAD_SEMC_DATA9_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_31
#define SW_MUX_CTL_PAD_SEMC_DATA10_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_32
#define SW_MUX_CTL_PAD_SEMC_DATA11_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_33
#define SW_MUX_CTL_PAD_SEMC_DATA12_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_34
#define SW_MUX_CTL_PAD_SEMC_DATA13_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_35
#define SW_MUX_CTL_PAD_SEMC_DATA14_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_36
#define SW_MUX_CTL_PAD_SEMC_DATA15_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_37
#define SW_MUX_CTL_PAD_SEMC_ADDR0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_09
#define SW_MUX_CTL_PAD_SEMC_ADDR1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_10
#define SW_MUX_CTL_PAD_SEMC_ADDR2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_11
#define SW_MUX_CTL_PAD_SEMC_ADDR3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_12
#define SW_MUX_CTL_PAD_SEMC_ADDR4_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_13
#define SW_MUX_CTL_PAD_SEMC_ADDR5_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_14
#define SW_MUX_CTL_PAD_SEMC_ADDR6_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_15
#define SW_MUX_CTL_PAD_SEMC_ADDR7_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_16
#define SW_MUX_CTL_PAD_SEMC_ADDR8_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_17
#define SW_MUX_CTL_PAD_SEMC_ADDR9_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_18
#define SW_MUX_CTL_PAD_SEMC_ADDR10_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_23
#define SW_MUX_CTL_PAD_SEMC_ADDR11_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_19
#define SW_MUX_CTL_PAD_SEMC_ADDR12_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_20
#define SW_MUX_CTL_PAD_SEMC_BA0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_21
#define SW_MUX_CTL_PAD_SEMC_BA1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_22
#define SW_MUX_CTL_PAD_SEMC_DQS_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_39
#define SW_MUX_CTL_PAD_SEMC_RDY_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_40
#define SW_MUX_CTL_PAD_SEMC_CSX0_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_41
#define SW_MUX_CTL_PAD_SEMC_CSX1_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_00
#define SW_MUX_CTL_PAD_SEMC_CSX2_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_01
#define SW_MUX_CTL_PAD_SEMC_CSX3_IDX kIOMUXC_SW_MUX_CTL_PAD_GPIO_B0_02

#define SW_PAD_CTL_PAD_SEMC_DATA0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_00
#define SW_PAD_CTL_PAD_SEMC_DATA1_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_01
#define SW_PAD_CTL_PAD_SEMC_DATA2_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_02
#define SW_PAD_CTL_PAD_SEMC_DATA3_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_03
#define SW_PAD_CTL_PAD_SEMC_DATA4_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_04
#define SW_PAD_CTL_PAD_SEMC_DATA5_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_05
#define SW_PAD_CTL_PAD_SEMC_DATA6_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_06
#define SW_PAD_CTL_PAD_SEMC_DATA7_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_07
#define SW_PAD_CTL_PAD_SEMC_DATA8_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_30
#define SW_PAD_CTL_PAD_SEMC_DATA9_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_31
#define SW_PAD_CTL_PAD_SEMC_DATA10_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_32
#define SW_PAD_CTL_PAD_SEMC_DATA11_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_33
#define SW_PAD_CTL_PAD_SEMC_DATA12_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_34
#define SW_PAD_CTL_PAD_SEMC_DATA13_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_35
#define SW_PAD_CTL_PAD_SEMC_DATA14_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_36
#define SW_PAD_CTL_PAD_SEMC_DATA15_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_37
#define SW_PAD_CTL_PAD_SEMC_ADDR0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_09
#define SW_PAD_CTL_PAD_SEMC_ADDR1_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_10
#define SW_PAD_CTL_PAD_SEMC_ADDR2_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_11
#define SW_PAD_CTL_PAD_SEMC_ADDR3_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_12
#define SW_PAD_CTL_PAD_SEMC_ADDR4_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_13
#define SW_PAD_CTL_PAD_SEMC_ADDR5_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_14
#define SW_PAD_CTL_PAD_SEMC_ADDR6_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_15
#define SW_PAD_CTL_PAD_SEMC_ADDR7_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_16
#define SW_PAD_CTL_PAD_SEMC_ADDR8_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_17
#define SW_PAD_CTL_PAD_SEMC_ADDR9_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_18
#define SW_PAD_CTL_PAD_SEMC_ADDR10_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_23
#define SW_PAD_CTL_PAD_SEMC_ADDR11_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_19
#define SW_PAD_CTL_PAD_SEMC_ADDR12_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_20
#define SW_PAD_CTL_PAD_SEMC_BA0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_21
#define SW_PAD_CTL_PAD_SEMC_BA1_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_22
#define SW_PAD_CTL_PAD_SEMC_DQS_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_39
#define SW_PAD_CTL_PAD_SEMC_RDY_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_40
#define SW_PAD_CTL_PAD_SEMC_CSX0_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_41
#define SW_PAD_CTL_PAD_SEMC_CSX1_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_00
#define SW_PAD_CTL_PAD_SEMC_CSX2_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_01
#define SW_PAD_CTL_PAD_SEMC_CSX3_IDX kIOMUXC_SW_PAD_CTL_PAD_GPIO_B0_02

#define SEMC_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(0)
#define SEMC_CSX0_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(0)
#define SEMC_CSX123_MUX_VAL IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(6)

// Fast Slew Rate
// Driver Strength: R0=260Ohm @3.3V, 150Ohm @1.8V, 240 Ohm for DDR, Actual R = R0/6
// Max Speed : 200MHz
// Pull enabled
// Keeper
#define SEMC_SW_PAD_CTL_VAL                                                                         \
    (IOMUXC_SW_PAD_CTL_PAD_SRE(1) | IOMUXC_SW_PAD_CTL_PAD_DSE(6) | IOMUXC_SW_PAD_CTL_PAD_SPEED(3) | \
     IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(0) | IOMUXC_SW_PAD_CTL_PAD_PUS(0))

// Fast Slew Rate
// Driver Strength: R0=260Ohm @3.3V, 150Ohm @1.8V, 240 Ohm for DDR, Actual R = R0/6
// Max Speed : 200MHz
// Pull enabled
// Pull
// 22K Ohm Pull Up
#define SEMC_RDY_SW_PAD_CTL_VAL                                                                     \
    (IOMUXC_SW_PAD_CTL_PAD_SRE(1) | IOMUXC_SW_PAD_CTL_PAD_DSE(6) | IOMUXC_SW_PAD_CTL_PAD_SPEED(3) | \
     IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(3))

// Fast Slew Rate
// Driver Strength: R0=260Ohm @3.3V, 150Ohm @1.8V, 240 Ohm for DDR, Acutal R = R0/6
// Max Speed : 200MHz
// Pull enabled
// Pull
// 100k ohm pull down resistor
#define SEMC_DQS_SW_PAD_CTL_VAL                                                                     \
    (IOMUXC_SW_PAD_CTL_PAD_SRE(1) | IOMUXC_SW_PAD_CTL_PAD_DSE(6) | IOMUXC_SW_PAD_CTL_PAD_SPEED(3) | \
     IOMUXC_SW_PAD_CTL_PAD_PKE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(0) |   \
     IOMUXC_SW_PAD_CTL_PAD_HYS(1))

////////////////////////////////////////////////////////////////////////////////
// EOF
////////////////////////////////////////////////////////////////////////////////
