/***********************************************************************************************
* IMPORTANT. Read the following Freescale Software License Agreement (Agreement)             *
* completely. By selecting the I Accept button at the end of this page, you indicate         *
* that you accept the terms of this Agreement and you also acknowledge that you have the       *
* authority, on behalf of your company, to bind your company to such terms. You may then       *
* download or install the file.                                                                *
*                                                                                              *
* FREESCALE END-USER SOFTWARE LICENSE AGREEMENT                                                *
*                                                                                              *
* This is a license agreement between you (either as an individual or as an authorized         *
* representative acting on behalf of your employer) and Freescale Semiconductor,               *
* Inc. (Freescale). It concerns your rights to use the software provided to you in binary    *
* or source code form and any accompanying written materials (the Software). The Software    *
* may include any updates or error corrections or documentation relating to the Software       *
* provided to you by Freescale under this License. In consideration for Freescale allowing     *
* you to access the Software, you are agreeing to be bound by the terms of this Agreement.     *
* If you do not agree to all of the terms of this Agreement, do not download or install the    *
* Software. If you change your mind later, stop using the Software and delete all copies of    *
* the Software in your possession or control. Any copies of the Software that you have         *
* already distributed, where permitted, and do not destroy will continue to be governed by     *
* this Agreement. Your prior use will also continue to be governed by this Agreement.          *
*                                                                                              *
* 1. LICENSE GRANT. Freescale grants to you, free of charge, the non-exclusive,                *
* non-transferable, non-sublicensable right (1) to use the Software, (2) to reproduce the      *
* Software, (3) to prepare derivative works of the Software, and 4) to distribute the Software *
* and derivative works thereof in object (machine readable) form as part of a programmable     *
* processing unit (e.g. a microprocessor, microcontroller, or digital signal processor)        *
* supplied directly or indirectly from Freescale (Freescale System)                          *
*                                                                                              *
* You must notify Freescale, in writing, any time you create a derivative of the Software.     *
* Freescale owns all derivatives created from the Software, and derivatives are licensed       *
* to you under the same terms as the Software under this Agreement. Upon request, you must     *
* provide Freescale the source code of any derivative of the Software. If you violate any of   *
* the terms or restrictions of this Agreement, Freescale may immediately terminate this        *
* Agreement, and require that you stop using and delete all copies of the Software and any     *
* derivative in your possession or control. Any license granted above only extends to          *
* Freescale s intellectual property rights that would be necessarily infringed by the Software *
* as provided to you by Freescale and as used within the scope of the licenses granted. You    *
* must advise Freescale of any results obtained including any problems or suggested            *
* improvements thereof. Freescale retains the right to use such results and related            *
* information in any manner it deems appropriate.                                              *
*                                                                                              *
* 2. OTHER RESTRICTIONS. Subject to the license grant above, the following restrictions apply: *
*   a. Freescale reserves all rights not expressly granted herein.                             *
*   b. You may not rent, lease, sublicense, lend or encumber the Software, unless otherwise    *
*      expressly agreed to within this Agreement                                               *
*   c. You may not distribute, manufacture, have manufactured, sublicense or otherwise         *
*      reproduce the Software for purposes other than intended in this Agreement.              *
*   d. You may not remove or alter any proprietary legends, notices, or trademarks contained   *
*      in the Licensed Software,                                                               *
*   e. The terms and conditions of this Agreement will apply to any Software updates,          *
*      provided to you at Freescale s discretion, that replace and/or supplement the           *
*      original software, unless such update contains a separate license.                      *
*   f. You may not translate, reverse engineer, decompile, or disassemble the Software         *
*      provided to you solely in object code format (machine readable) except to the extent    *
*      applicable law specifically prohibits such restriction. You will prohibit your          *
*      sublicensees from translating, reverse engineering, decompiling, or disassembling the   *
*      Software except to the extent applicable law specifically prohibits such restriction.   *
*                                                                                              *
* 3. OPEN SOURCE. Any open source software included in the Software licensed herein is not     *
* licensed under the terms of this Agreement, but is instead licensed under the terms of       *
* applicable open source license(s), such as the BSD License, Apache License or the Lesser     *
* GNU General Public License. Your use of such open source software is subject to the terms    *
* of each applicable license. You must agree to the terms of each such applicable license,     *
* or you should not use the open source software.                                              *
*                                                                                              *
* 4. COPYRIGHT. The Software is licensed to you, not sold. Freescale owns the Software, and    *
* United States copyright laws and international treaty provisions protect the Software.       *
* Therefore, you must treat the Software like any other copyrighted material (e.g. a book or   *
* musical recording). You may not use or copy the Software for any other purpose than what is  *
* described in this Agreement. Except as expressly provided herein, Freescale does not grant   *
* to you any express or implied rights under any Freescale or third party patents,             *
* copyrights, trademarks, or trade secrets. Additionally, you must reproduce and apply any     *
* copyright or other proprietary rights notices included on or embedded in the Software to     *
* any copies made thereof, in whole or in part, if any. You may not remove any copyright       *
* notices of Freescale incorporated in the Software.                                           *
*                                                                                              *
* 5. TERM AND TERMINATION. The term of this Agreement shall commence on the date of            *
* installation or download and shall continue perpetually, unless earlier terminated in        *
* accordance with this Agreement. Freescale has the right to terminate this Agreement without  *
* notice and require that you stop using and delete all copies of the Software in your         *
* possession or control if you violate any of the terms or restrictions of this Agreement.     *
* Freescale may terminate this Agreement should any of the Software become, or in Freescale's  *
* reasonable opinion is likely to become, the subject of a claim of intellectual infringement  *
* or trade secret misappropriation. Upon termination, you must cease use of and destroy, the   *
* Software and confirm compliance in writing to Freescale. Upon termination, the license       *
* granted pursuant to this Agreement immediately terminates and the provisions of Sections 4   *
* through 18 will survive any termination of this Agreement.                                   *
*                                                                                              *
* 6. SUPPORT. Freescale is NOT obligated to provide any support, upgrades or new               *
* of the Software. If you wish, you may contact Freescale and report problems and provide      *
* suggestions regarding the Software. Freescale has no obligation whatsoever to respond in     *
* any way to such a problem report or suggestion. Freescale may make changes to the Software   *
* at any time, without any obligation to notify or provide updated versions of the Software    *
* to you.                                                                                      *
*                                                                                              *
* 7. NO WARRANTY. TO THE MAXIMUM EXTENT PERMITTED BY LAW, FREESCALE EXPRESSLY                  *
* DISCLAIMS ANY WARRANTY FOR THE SOFTWARE. THE SOFTWARE IS PROVIDED (AS IS), WITHOUT WARRANTY  *
* OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, THE IMPLIED           *
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT. YOU    *
* ASSUME THE ENTIRE RISK ARISING OUT OF THE USE OR PERFORMANCE OF THE SOFTWARE, OR ANY SYSTEMS *
* YOU DESIGN USING THE SOFTWARE (IF ANY). NOTHING IN THIS AGREEMENT MAY BE CONSTRUED AS A      *
* WARRANTY OR REPRESENTATION BY FREESCALE THAT THE SOFTWARE OR ANY DERIVATIVE WORK DEVELOPED   *
* WITH OR INCORPORATING THE SOFTWARE WILL BE FREE FROM INFRINGEMENT OF THE INTELLECTUAL        *
* PROPERTY RIGHTS OF THIRD PARTIES.                                                            *
*                                                                                              *
* 8. INDEMNITY. You agree to fully defend and indemnify Freescale from any and all             *
* claims, liabilities, and costs (including reasonable attorney s fees) related to (1) your    *
* use (including your sublicensee s use, if permitted) of the Software or (2) your violation   *
* of the terms and conditions of this Agreement.                                               *
*                                                                                              *
* 9. LIMITATION OF LIABILITY. IN NO EVENT WILL FREESCALE BE LIABLE, WHETHER IN                 *
* CONTRACT, TORT, OR OTHERWISE, FOR ANY INCIDENTAL, SPECIAL, INDIRECT, CONSEQUENTIAL OR        *
* PUNITIVE DAMAGES, INCLUDING, BUT NOT LIMITED TO, DAMAGES FOR ANY LOSS OF USE, LOSS OF TIME,  *
* INCONVENIENCE, COMMERCIAL LOSS, OR LOST PROFITS, SAVINGS, OR REVENUES TO THE FULL EXTENT     *
* SUCH MAY BE DISCLAIMED BY LAW EVEN IF INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH         *
* DAMAGES. FREESCALE S LIABILITY WILL IN ANY EVENT AND UNDER ANY THEORY OF RECOVERY BE         *
* LIMITED TO THE TOTAL AMOUNT RECEIVED BY FREESCALE UNDER THIS AGREEMENT.                      *
*                                                                                              *
* 10. COMPLIANCE WITH LAWS; EXPORT RESTRICTIONS. You must not resell, re-export, or            *
* provide, directly or indirectly, the licensed software or direct product thereof, in any     *
* form without obtaining appropriate export or re-export licenses from the United States       *
* Government and from the country from which the export or re-export is to occur. An export    *
* occurs when products, technology, or software is transferred from one country to another by  *
* any means, including physical shipments, FTP file transfers, E-mails, faxes, remote server   *
* access, conversations, and the like. An export also occurs when technology or software is    *
* transferred to a foreign national in the United States, or foreign national of the country   *
* in which the business activity is taking place. A foreign national is any person who is      *
* neither a citizen nor permanent resident of the United States, or the country in which the   *
* business activity is taking place. Furthermore, if an export/import license, permit or other *
* government required authority (collectively referred to as (government authorization)) is    *
* required to transfer technology, software, hardware or other Freescale property to non-      *
* Freescale party(ies) and is not approved, then Freescale is not obligated to transfer the    *
* Software under this Agreement until such (government authorization) is granted..             *
*                                                                                              *
* 11. GOVERNMENT RIGHTS. The Licensed Software is a (Commercial Item) as defined in 48         *
* C.F.R. 2.101, consisting of (Commercial Computer Software) and (Commercial Computer         *
* Software Documentation,) as such terms are used in 48 C.F.R.  12.212 or 48 C.F.R.           *
* 227.7202, as applicable and are only licensed to U.S. Government end users with the rights  *
* as are set forth herein..                                                                    *
*                                                                                              *
* 12. HIGH RISK ACTIVITIES. You acknowledge that the Software is not fault tolerant and        *
* is not designed, manufactured or intended by Freescale for incorporation into products       *
* intended for use or resale in on-line control equipment in hazardous, dangerous to life or   *
* potentially life-threatening environments requiring fail-safe performance, such as in the    *
* operation of nuclear facilities, aircraft navigation or communication systems, air traffic   *
* control, direct life support machines or weapons systems, in which the failure of products   *
* could lead directly to death, personal injury or severe physical or environmental damage     *
* (High Risk Activities). You specifically represent and warrant that you will not use the   *
* Software or any derivative work of the Software for High Risk Activities.                    *
*                                                                                              *
* 13. CHOICE OF LAW; VENUE; LIMITATIONS. You agree that the statutes and laws of the           *
* United States and the State of Texas, USA, without regard to conflicts of laws principles,   *
* will apply to all matters relating to this Agreement or the Software, and you agree that any *
* litigation will be subject to the exclusive jurisdiction of the state or federal courts in   *
* Texas, USA. You agree that regardless of any statute or law to the contrary, any claim or    *
* cause of action arising out of or related to this Agreement or the Software must be filed    *
* within one (1) year after such claim or cause of action arose or be forever barred.          *
*                                                                                              *
* 14. CONFIDENTIAL INFORMATION. You must treat the Software as confidential information        *
* and you agree to retain the Software in confidence perpetually, with respect to Software in  *
* source code form (human readable), or for a period of five (5) years from the date of        *
* termination of this Agreement, with respect to all other parts of the Software. During this  *
* period you may not disclose any part of the Software to anyone other than employees who have *
* a need to know of the Software and who have executed written agreements obligating them to   *
* protect such Licensed Software to at least the same degree of care as in this Agreement.     *
* You agree to use the same degree of care, but no less than a reasonable degree of care, with *
* the Software as you do with your own confidential information. You may disclose Software to  *
* the extent required by a court or under operation of law or order provided that you notify   *
* Freescale of such requirement prior to disclosure, which you only disclose information       *
* required, and that you allow Freescale the opportunity to object to such court or other      *
* legal body requiring such disclosure.                                                        *
*                                                                                              *
* 15. PRODUCT LABELING. You are not authorized to use any Freescale trademarks, brand          *
* names, or logos.                                                                             *
*                                                                                              *
* 16. ENTIRE AGREEMENT. This Agreement constitutes the entire agreement between you and        *
* Freescale regarding the subject matter of this Agreement, and supersedes all prior           *
* communications, negotiations, understandings, agreements or representations, either written  *
* or oral, if any. This Agreement may only be amended in written form, executed by you and     *
* Freescale.                                                                                   *
*                                                                                              *
* 17. SEVERABILITY. If any provision of this Agreement is held for any reason to be            *
* invalid or unenforceable, then the remaining provisions of this Agreement will be unimpaired *
* and, unless a modification or replacement of the invalid or unenforceable provision is       *
* further held to deprive you or Freescale of a material benefit, in which case the Agreement  *
* will immediately terminate, the invalid or unenforceable provision will be replaced with a   *
* provision that is valid and enforceable and that comes closest to the intention underlying   *
* the invalid or unenforceable provision.                                                      *
*                                                                                              *
* 18. NO WAIVER. The waiver by Freescale of any breach of any provision of this                *
* Agreement will not operate or be construed as a waiver of any other or a subsequent breach   *
* of the same or a different provision.                                                        *
***********************************************************************************************/

/*******************************************************************************
*
* file      IEC60730B_B_CM4_CM7_wdg.h
*
* author    B48632
* 
* version   3.0
*
* date      Nov-01-2018
* 
* brief     IEC60730 Class B Safety Routines Watchdog test for Cortex CM4, CM7 cores
*
*******************************************************************************/

#ifndef _IEC60730_B_WDG_H_
#define _IEC60730_B_WDG_H_


#ifndef __ASM__

/* Structure of WD_test variables */
/* must be placed in memory which is not touched by startup code,  which is only chagned by POR reset */
typedef struct {
  unsigned long counter;
  unsigned long resets;
  unsigned long wd_test_uncomplete_flag;
}volatile WD_Test_Str;


/*******************************************************************************
* Watchdog_test_configuration
*  
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the LPTMR which must be configured before the function call occurs. 
* Within the waiting endless loop, value from LPTMR is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup(WD_Test_Str* pWatchdogBackup);

/*******************************************************************************
* Watchdog_test_check
* 
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check
* param[in]    limit_high          precalculated limit value for LPTMR counter
* param[in]    limit_low           precalculated limit value for LPTMR counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup);

/*******************************************************************************
* Watchdog_test_configuration for MKE1xF
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the LPTMR which must be configured before the function call occurs. 
* Within the waiting endless loop, value from LPTMR is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup_ke
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup_ke(WD_Test_Str* pWatchdogBackup);

/*******************************************************************************
* Watchdog_test_check for MKE1xF
*
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check_ke
* param[in]    limit_high          precalculated limit value for LPTMR counter
* param[in]    limit_low           precalculated limit value for LPTMR counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check_ke(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup);

/*******************************************************************************
* Watchdog_test_configuration for MK32W
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the LPTMR which must be configured before the function call occurs. 
* Within the waiting endless loop, value from LPTMR is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup_k32w
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* param[in]    pWDOG  pointer to WDOG base address
* param[in]    pLPTMR  pointer to LPTMR base address
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup_k32w(WD_Test_Str* pWatchdogBackup, unsigned long* pWDOG, unsigned long* pLPTMR);

/*******************************************************************************
* Watchdog_test_check for MK32W
*
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check_k32w
* param[in]    limit_high          precalculated limit value for LPTMR counter
* param[in]    limit_low           precalculated limit value for LPTMR counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check_k32w(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup);

/*******************************************************************************
* Watchdog_test_configuration for I.MXrt
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the LPTMR which must be configured before the function call occurs. 
* Within the waiting endless loop, value from LPTMR is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup_RT
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup_RT(WD_Test_Str* pWatchdogBackup);

/*******************************************************************************
* Watchdog_test_check for I.MXrt
*
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check_RT
* param[in]    limit_high          precalculated limit value for LPTMR counter
* param[in]    limit_low           precalculated limit value for LPTMR counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check_RT(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup);


#endif /* __ASM__ */
	
#endif /* _IEC60730_B_CM4_CM7_WDG_H_ */
