
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


This example has been configured to use the 1XK M.2 module. To change which
module to use, replace WIFI_IW416_BOARD_MURATA_1XK_M2 in the app_config.h file
with one of the following and then rebuild the project:

    WIFI_IW416_BOARD_MURATA_1XK_M2     - To use the 1XK M.2 module
    WIFI_88W8801_BOARD_MURATA_2DS_M2   - To use the 2DS M.2 module
    WIFI_88W8987_BOARD_MURATA_1ZM_M2   - To use the 1ZM M.2 module

The NXP EVK needs an 'Murata uSD M.2 Adapter' but the iMXRT1062 Developer's Kit
has an M.2 connector (J38) so the adapter is not needed. Please ignore all mentions
of the 'Murata uSD M.2 Adapter' and the 'receptable cables' below.

More information about the M.2 Modules can be found here: https://www.embeddedartists.com/m2/.

In this version of the SDK for this version of the iMX RT1062 OEM board
Wi-Fi/Bluetooth is currently not working. This is being investigated and
a new version will be released as soon as this is fixed.

Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
Demo for showing how to use the Device Shadow library's API.

Before building the example application select Wi-Fi module macro in the app_config.h. (see #define WIFI_<SoC Name>_BOARD_<Module Name>).
For more information about Wi-Fi module connection see:
    readme_modules.txt
    Getting started guide on supported modules configuration:
    https://www.nxp.com/document/guide/getting-started-with-nxp-wi-fi-modules-using-i-mx-rt-platform:GS-WIFI-MODULES-IMXRT-PLATFORM



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Micro USB cable
- evkcmimxrt1060 board
- Personal Computer


Board settings
==============

Prepare the Demo
================
Before running the demo it is need to configure AWS IoT Console and update some of project files:

1.  Create AWS Account: https://console.aws.amazon.com/console/home

2.  Configure device in the AWS IoT Console base on this guide: https://docs.aws.amazon.com/iot/latest/developerguide/create-iot-resources.html

    Make note of example's "Thing name" and "REST API endpoint". These strings need to be set in the "aws_clientcredential.h".
    Example:
        #define clientcredentialMQTT_BROKER_ENDPOINT "abcdefgh123456.iot.us-west-2.amazonaws.com"
        #define clientcredentialIOT_THING_NAME "MyExample"

    Device certificate and private key needs to be opened in text editor and its content copied into the "aws_clientcredential_keys.h".
    Note: be sure to add " at the beginning of a line and \n"\ on every line break.
    Example:
        #define keyCLIENT_CERTIFICATE_PEM NULL

        Needs to be changed to:

        #define keyCLIENT_CERTIFICATE_PEM "-----BEGIN CERTIFICATE-----\n"\
        "MIIDWTCCAkGgAwIBAgIUfmv3zA+JULlMOxmz+upkAzhEkQ0wDQYJKoZIhvcNAQEL\n"\
        .
        .
        .
        "mepuT3lKmD0jZupsQ9vLQOA09rMjVMd0YPmI9ozvvWqLpjVvNTKVhsf/3slM\n"\
        "-----END CERTIFICATE-----\n"

    In the same way update "keyCLIENT_PRIVATE_KEY_PEM" with content of private key file.

    Files "aws_clientcredential.h" and "aws_clientcredential_keys.h" are located in project folder.

3.  This demo needs Wi-Fi network with internet access.
    Update these macros in "aws_clientcredential.h" based on your Wi-Fi network configuration:
        #define clientcredentialWIFI_SSID       "Paste Wi-Fi SSID here."
        #define clientcredentialWIFI_PASSWORD   "Paste Wi-Fi password here."

4.  Open example's project and build it.

5.  Connect a USB cable between the PC host and the OpenSDA port on the target board.

6.  Download the program to the target board with the CMSIS-DAP or J-Link debugger.

7.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

8.  Open a serial terminal on PC for serial device with these settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control

Running the demo
================
The log below shows the output of the demo in the terminal window. The log can be different based on your Wi-Fi network configuration.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.
.
.
6 13045 [MQTT] [INFO] Creating a TLS connection to a2zcot8a2tqh6c-ats.iot.us-east-2.amazonaws.com:8883.
7 14120 [MQTT] [INFO] (Network connection 2022b20c) TLS handshake successful.
8 14120 [MQTT] [INFO] (Network connection 2022b20c) Connection to a2zcot8a2tqh6c-ats.iot.us-east-2.amazonaws.com established.
9 14120 [MQTT] [INFO] Creating an MQTT connection to the broker.
10 14316 [MQTT] [INFO] MQTT connection established with the broker.
11 14316 [MQTT] [INFO] Successfully connected to MQTT broker.
12 14316 [SHADOW_APP] [INFO] MQTT Agent is connected. Initializing shadow update task.
13 14316 [SHADOW_APP] [INFO] Sending subscribe request to agent for shadow topics.
14 14317 [SHADOW_DEV] [INFO] MQTT Agent is connected. Initializing shadow device task.
15 14318 [SHADOW_DEV] [INFO] Sending subscribe request to agent for shadow topics.
16 14518 [SHADOW_APP] [INFO] Received subscribe ack for shadow update topics.
17 14668 [SHADOW_DEV] [INFO] Successfully subscribed to shadow update topics.
18 14668 [SHADOW_DEV] [INFO] Publishing to /get message using client token 14668.
19 14668 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/get.

20 14669 [SHADOW_DEV] [INFO] Successfully sent a publish message to /get topic.
21 14819 [MQTT] [INFO] Ack packet deserialized with result: MQTTSuccess.
22 14819 [MQTT] [INFO] State record updated. New state=MQTTPublishDone.
23 14869 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
24 14869 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
25 14870 [MQTT] [INFO] Ignoring GET accepted response without a delta field.
26 14871 [SHADOW_DEV] [INFO] Received an accepted response for shadow GET request. 
27 54518 [SHADOW_APP] [INFO] Publishing to /update with following client token 54518.
28 54518 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

29 54769 [MQTT] [INFO] Ack packet deserialized with result: MQTTSuccess.
30 54769 [MQTT] [INFO] State record updated. New state=MQTTPublishDone.
31 54819 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
32 54819 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
33 54819 [MQTT] [INFO] Received accepted response for update with token 54518. 
34 94820 [SHADOW_APP] [INFO] Publishing to /update with following client token 94820.
35 94820 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

36 95071 [MQTT] [INFO] Ack packet deserialized with result: MQTTSuccess.
37 95071 [MQTT] [INFO] State record updated. New state=MQTTPublishDone.
38 95121 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
39 95121 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
40 95121 [MQTT] [INFO] Received accepted response for update with token 94820. 
41 95172 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
42 95173 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
43 95173 [MQTT] [INFO] Received delta update with version 86.
44 95173 [MQTT] [INFO] Setting device state to 1.
45 95174 [SHADOW_DEV] [INFO] Publishing to /update with following client token 95173.
46 95174 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

47 95174 [SHADOW_DEV] [INFO] Successfully sent a publish message to /update topic.
48 95524 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
49 95524 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
50 95524 [MQTT] [INFO] Received accepted response for update with token 95173. 
51 95525 [SHADOW_DEV] [INFO] Successfully received a shadow update accepted message from cloud. 
52 135123 [SHADOW_APP] [INFO] Publishing to /update with following client token 135123.
53 135123 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

54 135424 [MQTT] [INFO] Ack packet deserialized with result: MQTTSuccess.
55 135424 [MQTT] [INFO] State record updated. New state=MQTTPublishDone.
56 135475 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
57 135475 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
58 135475 [MQTT] [INFO] Received accepted response for update with token 135123. 
59 135477 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
60 135477 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
61 135477 [MQTT] [INFO] Received delta update with version 88.
62 135477 [MQTT] [INFO] Setting device state to 0.
63 135518 [SHADOW_DEV] [INFO] Publishing to /update with following client token 135518.
64 135518 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

65 135519 [SHADOW_DEV] [INFO] Successfully sent a publish message to /update topic.
66 135819 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
67 135819 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
68 135820 [MQTT] [INFO] Received accepted response for update with token 135518. 
69 135820 [SHADOW_DEV] [INFO] Successfully received a shadow update accepted message from cloud. 
70 175477 [SHADOW_APP] [INFO] Publishing to /update with following client token 175477.
71 175477 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

72 175728 [MQTT] [INFO] Ack packet deserialized with result: MQTTSuccess.
73 175728 [MQTT] [INFO] State record updated. New state=MQTTPublishDone.
74 175828 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
75 175828 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
76 175828 [MQTT] [INFO] Received accepted response for update with token 175477. 
77 175830 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
78 175830 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
79 175830 [MQTT] [INFO] Received delta update with version 90.
80 175830 [MQTT] [INFO] Setting device state to 1.
81 175871 [SHADOW_DEV] [INFO] Publishing to /update with following client token 175871.
82 175871 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

83 175872 [SHADOW_DEV] [INFO] Successfully sent a publish message to /update topic.
84 176222 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
85 176223 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
86 176223 [MQTT] [INFO] Received accepted response for update with token 175871. 
87 176224 [SHADOW_DEV] [INFO] Successfully received a shadow update accepted message from cloud. 
88 215830 [SHADOW_APP] [INFO] Publishing to /update with following client token 215830.
89 215830 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.

90 216081 [MQTT] [INFO] Ack packet deserialized with result: MQTTSuccess.
91 216081 [MQTT] [INFO] State record updated. New state=MQTTPublishDone.
92 216131 [MQTT] [INFO] De-serialized incoming PUBLISH packet: DeserializerResult=MQTTSuccess.
93 216131 [MQTT] [INFO] State record updated. New state=MQTTPubAckSend.
94 216131 [MQTT] [INFO] Received delta update with version 92.
95 216131 [MQTT] [INFO] Setting device state to 0.
96 216132 [SHADOW_DEV] [INFO] Publishing to /update with following client token 216132.
97 216133 [MQTT] [INFO] Publishing message to $aws/things/aws_rpr_michal/shadow/update.
.
.
.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
