
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
This example demonstrates how to communicate with Azure IoT Hub through MQTT.

Prerequisites
Before running the example, need to set up a device in Azure IoT Hub, and write the device parameters in the example code.

Here, we demonstrate how to setup a device in Azure IoT Hub. If you are not familiar with Azure CLI, please refer to
the document for the details. (https://docs.microsoft.com/en-us/azure/iot-hub/)

Note that these steps assume you use the Azure IoT Hub for the first time.

1. Register an Azure account.

2. Install Azure CLI locally, or use Azure CLoud Shell.

3. Before using any CLI commands locally, you need to sign in:
     > az login

4. Add the Microsoft Azure IoT Extension for Azure CLI.
     > az extension add --name azure-iot

5: Create a new resource group which is a logical container into which Azure IoT Hub are deployed and managed.
   {MyResourceGroupName}: Name of the new resource group
   {MyResourceLocation}: Location, for example, westus. Select a location from: az account list-locations -o table.
     > az group create --name {MyResourceGroupName} --location {MyResourceLocation}

6: Create a new IoT Hub in the resource group.
   {MyResourceGroupName}: The name of the resource group you just created.
   {MyIoTHubName}: Name of the new IoT Hub. This name must be globally unique. If failed, please try another name.
     > az iot hub create --resource-group {MyResourceGroupName} --name {MyIoTHubName}

7: Create a new device identity in the Hub IoT.
   {MyIoTHubName}: Name of the IoT Hub just created
   {MyDeviceId}: ID of the new device
     > az iot hub device-identity create --hub-name {MyIoTHubName} --device-id {MyDeviceId}

8: Create a new device SAS token for the device {MyDeviceId}. Note that the token is only valid in 3600 seconds.
     > az iot hub generate-sas-token --hub-name {MyIoTHubName} --device-id {MyDeviceId}
   If you want to set a specified valid duration, please use the parameter, --duration {seconds}, to set the valid
   token duration in seconds.
   The command result is in the JSON format, like:
     {
        "sas": "{MySASToken}"
     }

9. Write the above device parameters into the source code, sample_azure_iot.c, in your project. Fill these three macros,
   HOST_NAME, DEVICE_ID, DEVICE_SAS.
     HOST_NAME: {MyIoTHubName}.azure-devices.net
     DEVICE_ID: {MyDeviceId}
     DEVICE_SAS: {MySASToken}
   For example:
     #define HOST_NAME "test-hub.azure-devices.net"
     #define DEVICE_ID "test-dev"
     #define DEVICE_SAS "SharedAccessSignature sr=test-hub.azure-devices.net%2Fdevices%2Ftest-dev&sig=57jVRiSOeoX9g4aI6iyP6tFzrjEdam5SpdNITeeUbVY%3D&se=1615181586"

10. Build the code and write it into the on-board Flash.


SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- Network cable RJ45 standard
- MIMXRT1060-EVKC board
- Personal Computer

Board settings
==============
No special settings are required.

Prepare the Demo
================
1.  Connect a USB cable between the host PC and the OpenSDA USB port on the target board.
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Insert Cable to Ethernet RJ45 port and connect it to a ethernet switch.
4.  Write the program to the flash of the target board.
5.  Press the reset button on your board to start the demo.

Running the demo
================
When the demo is running, the serial port will output, for example:

Start the azure_iot_mqtt example...
MAC address: 00:11:22:33:44:56
DHCP In Progress...
IP address: 10.193.20.67
Mask: 255.255.255.0
Gateway: 10.193.20.254
DNS Server address: 10.192.130.201
Connected to server
Subscribed to server
[Published] topic = devices/imxrt1050/messages/events/, message: {"temperature": 21}
[Published] topic = devices/imxrt1050/messages/events/, message: {"temperature": 22}
[Published] topic = devices/imxrt1050/messages/events/, message: {"temperature": 23}
[Published] topic = devices/imxrt1050/messages/events/, message: {"temperature": 24}

