/*
 * Copyright 2023 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Peripherals v11.0
processor: MIMXRT1062xxxxB
package_id: MIMXRT1062DVL6B
mcu_data: ksdk2_0
processor_version: 13.0.1
board: MIMXRT1060-EVKC
functionalGroups:
- name: BOARD_InitPeripherals
  UUID: 0947e71d-5d74-41f0-8fe0-aaf02832b2fe
  called_from_default_init: true
  selectedCore: core0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'system'
- type_id: 'system_54b53072540eeeb8f8e9343e71f28176'
- global_system_definitions:
  - user_definitions: ''
  - user_includes: ''
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'uart_cmsis_common'
- type_id: 'uart_cmsis_common_9cb8e302497aa696fdbb5a4fd622c2a8'
- global_USART_CMSIS_common:
  - quick_selection: 'default'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'gpio_adapter_common'
- type_id: 'gpio_adapter_common_57579b9ac814fe26bf95df0a384c36b6'
- global_gpio_adapter_common:
  - quick_selection: 'default'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "peripherals.h"

/***********************************************************************************************************************
 * BOARD_InitPeripherals functional group
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * LPUART_1 initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'LPUART_1'
- type: 'lpuart'
- mode: 'polling'
- custom_name_enabled: 'true'
- type_id: 'lpuart_bf01db7d964092f3cf860852cba17f7e'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'LPUART1'
- config_sets:
  - lpuartConfig_t:
    - lpuartConfig:
      - clockSource: 'LpuartClock'
      - lpuartSrcClkFreq: 'ClocksTool_DefaultInit'
      - baudRate_Bps: '115200'
      - parityMode: 'kLPUART_ParityDisabled'
      - dataBitsCount: 'kLPUART_EightDataBits'
      - isMsb: 'false'
      - stopBitCount: 'kLPUART_OneStopBit'
      - enableMatchAddress1: 'false'
      - matchAddress1: '0'
      - enableMatchAddress2: 'false'
      - matchAddress2: '0'
      - txFifoWatermark: '0'
      - rxFifoWatermark: '1'
      - enableRxRTS: 'false'
      - enableTxCTS: 'false'
      - txCtsSource: 'kLPUART_CtsSourcePin'
      - txCtsConfig: 'kLPUART_CtsSampleAtStart'
      - rxIdleType: 'kLPUART_IdleTypeStartBit'
      - rxIdleConfig: 'kLPUART_IdleCharacter1'
      - enableTx: 'true'
      - enableRx: 'true'
    - quick_selection: 'QuickSelection1'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const lpuart_config_t LPUART_1_config = {
  .baudRate_Bps = 115200UL,
  .parityMode = kLPUART_ParityDisabled,
  .dataBitsCount = kLPUART_EightDataBits,
  .isMsb = false,
  .stopBitCount = kLPUART_OneStopBit,
  .txFifoWatermark = 0U,
  .rxFifoWatermark = 1U,
  .enableRxRTS = false,
  .enableTxCTS = false,
  .txCtsSource = kLPUART_CtsSourcePin,
  .txCtsConfig = kLPUART_CtsSampleAtStart,
  .rxIdleType = kLPUART_IdleTypeStartBit,
  .rxIdleConfig = kLPUART_IdleCharacter1,
  .enableTx = true,
  .enableRx = true
};

static void LPUART_1_init(void) {
  LPUART_Init(LPUART_1_PERIPHERAL, &LPUART_1_config, LPUART_1_CLOCK_SOURCE);
}

/***********************************************************************************************************************
 * LPI2C_1 initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'LPI2C_1'
- type: 'lpi2c'
- mode: 'master'
- custom_name_enabled: 'true'
- type_id: 'lpi2c_6b71962515c3208facfccd030afebc98'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'LPI2C1'
- config_sets:
  - main:
    - clockSource: 'Lpi2cClock'
    - clockSourceFreq: 'ClocksTool_DefaultInit'
  - interrupt_vector: []
  - master:
    - mode: 'transfer'
    - config:
      - enableMaster: 'true'
      - enableDoze: 'true'
      - debugEnable: 'false'
      - ignoreAck: 'false'
      - pinConfig: 'kLPI2C_2PinOpenDrain'
      - baudRate_Hz: '100000'
      - busIdleTimeout_ns: '0'
      - pinLowTimeout_ns: '0'
      - sdaGlitchFilterWidth_ns: '0'
      - sclGlitchFilterWidth_ns: '0'
      - hostRequest:
        - enable: 'false'
        - source: 'kLPI2C_HostRequestExternalPin'
        - polarity: 'kLPI2C_HostRequestPinActiveHigh'
      - edmaRequestSources: ''
    - transfer:
      - blocking: 'false'
      - enable_custom_handle: 'false'
      - callback:
        - name: ''
        - userData: ''
      - flags: ''
      - slaveAddress: '0'
      - direction: 'kLPI2C_Write'
      - subaddress: '0'
      - subaddressSize: '1'
      - blocking_buffer: 'false'
      - enable_custom_buffer: 'false'
      - dataSize: '1'
    - quick_selection: 'qs_master_transfer'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const lpi2c_master_config_t LPI2C_1_masterConfig = {
  .enableMaster = true,
  .enableDoze = true,
  .debugEnable = false,
  .ignoreAck = false,
  .pinConfig = kLPI2C_2PinOpenDrain,
  .baudRate_Hz = 100000UL,
  .busIdleTimeout_ns = 0UL,
  .pinLowTimeout_ns = 0UL,
  .sdaGlitchFilterWidth_ns = 0U,
  .sclGlitchFilterWidth_ns = 0U,
  .hostRequest = {
    .enable = false,
    .source = kLPI2C_HostRequestExternalPin,
    .polarity = kLPI2C_HostRequestPinActiveHigh
  }
};
lpi2c_master_transfer_t LPI2C_1_masterTransfer = {
  .flags = kLPI2C_TransferDefaultFlag,
  .slaveAddress = 0,
  .direction = kLPI2C_Write,
  .subaddress = 0,
  .subaddressSize = 1,
  .data = LPI2C_1_masterBuffer,
  .dataSize = 1
};
lpi2c_master_handle_t LPI2C_1_masterHandle;
uint8_t LPI2C_1_masterBuffer[LPI2C_1_MASTER_BUFFER_SIZE];

static void LPI2C_1_init(void) {
  LPI2C_MasterInit(LPI2C_1_PERIPHERAL, &LPI2C_1_masterConfig, LPI2C_1_CLOCK_FREQ);
  LPI2C_MasterTransferCreateHandle(LPI2C_1_PERIPHERAL, &LPI2C_1_masterHandle, NULL, NULL);
}

/***********************************************************************************************************************
 * eLCDIF initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'eLCDIF'
- type: 'elcdif'
- mode: 'rgbMode'
- custom_name_enabled: 'true'
- type_id: 'elcdif_1c39bcb43ed1a24bc8980672c7378576'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'LCDIF'
- config_sets:
  - fsl_elcdif:
    - config:
      - panelWidthInt: '480'
      - panelHeightInt: '272'
      - hsw: '41'
      - hfp: '4'
      - hbp: '8'
      - vsw: '10'
      - vfp: '4'
      - vbp: '2'
      - frameRate: '60 Hz'
      - clockSource: 'LcdIfClock'
      - clockSourceFreq: 'ClocksTool_DefaultInit'
      - polarityFlags_st:
        - vSyncActive: 'kELCDIF_VsyncActiveLow'
        - hSyncActive: 'kELCDIF_HsyncActiveLow'
        - dataEnableActive: 'kELCDIF_DataEnableActiveHigh'
        - driveDataClkEdge: 'kELCDIF_DriveDataOnRisingClkEdge'
      - bufferName: 'defaultBuffer'
      - bufferAlign: '64'
      - pixelFormat: 'kELCDIF_PixelFormatRGB565'
      - dataBus: 'kELCDIF_DataBus16Bit'
      - enablePxpHandShake: 'false'
      - start: 'true'
    - isInterruptEnabled: 'true'
    - elcdifInterruptSources: 'kELCDIF_CurFrameDoneInterruptEnable kELCDIF_VsyncEdgeInterruptEnable kELCDIF_TxFifoUnderflowInterruptEnable'
    - interrupt:
      - IRQn: 'LCDIF_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
/* RGB mode configuration */
const elcdif_rgb_mode_config_t eLCDIF_rgbConfig = {
  .panelWidth = ELCDIF_PANEL_WIDTH,
  .panelHeight = ELCDIF_PANEL_HEIGHT,
  .hsw = 41U,
  .hfp = 4U,
  .hbp = 8U,
  .vsw = 10U,
  .vfp = 4U,
  .vbp = 2U,
  .polarityFlags = (kELCDIF_VsyncActiveLow | kELCDIF_HsyncActiveLow | kELCDIF_DataEnableActiveHigh | kELCDIF_DriveDataOnRisingClkEdge),
  .bufferAddr = (uint32_t) eLCDIF_Buffer[0],
  .pixelFormat = kELCDIF_PixelFormatRGB565,
  .dataBus = kELCDIF_DataBus16Bit
};
/* RGB buffer */
AT_NONCACHEABLE_SECTION_ALIGN(uint16_t eLCDIF_Buffer[2][ELCDIF_PANEL_HEIGHT][ELCDIF_PANEL_WIDTH], ELCDIF_RGB_BUFFER_ALIGN);

static void eLCDIF_init(void) {
  /* RGB mode initialization */
  ELCDIF_RgbModeInit(ELCDIF_PERIPHERAL, &eLCDIF_rgbConfig);
  /* Enable interrupts */
  ELCDIF_EnableInterrupts(ELCDIF_PERIPHERAL, (kELCDIF_CurFrameDoneInterruptEnable | kELCDIF_VsyncEdgeInterruptEnable | kELCDIF_TxFifoUnderflowInterruptEnable));
  /* Enable interrupt LCDIF_IRQn request in the NVIC. */
  EnableIRQ(ELCDIF_LCDIF_IRQN);
  /* RGB mode start */
  ELCDIF_RgbModeStart(ELCDIF_PERIPHERAL);
}

/***********************************************************************************************************************
 * GPIO_1 initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'GPIO_1'
- type: 'igpio'
- mode: 'GPIO'
- custom_name_enabled: 'true'
- type_id: 'igpio_b1c1fa279aa7069dca167502b8589cb7'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'GPIO1'
- config_sets:
  - fsl_gpio:
    - enable_irq_comb_0_15: 'false'
    - gpio_interrupt_comb_0_15:
      - IRQn: 'GPIO1_Combined_0_15_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_comb_16_31: 'false'
    - gpio_interrupt_comb_16_31:
      - IRQn: 'GPIO1_Combined_16_31_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int0: 'false'
    - gpio_interrupt_int0:
      - IRQn: 'GPIO1_INT0_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int1: 'false'
    - gpio_interrupt_int1:
      - IRQn: 'GPIO1_INT1_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int2: 'false'
    - gpio_interrupt_int2:
      - IRQn: 'GPIO1_INT2_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int3: 'false'
    - gpio_interrupt_int3:
      - IRQn: 'GPIO1_INT3_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int4: 'false'
    - gpio_interrupt_int4:
      - IRQn: 'GPIO1_INT4_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int5: 'false'
    - gpio_interrupt_int5:
      - IRQn: 'GPIO1_INT5_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int6: 'false'
    - gpio_interrupt_int6:
      - IRQn: 'GPIO1_INT6_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
    - enable_irq_int7: 'false'
    - gpio_interrupt_int7:
      - IRQn: 'GPIO1_INT7_IRQn'
      - enable_interrrupt: 'enabled'
      - enable_priority: 'false'
      - priority: '0'
      - enable_custom_name: 'false'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

static void GPIO_1_init(void) {
  /* Make sure, the clock gate for GPIO1 is enabled (e. g. in pin_mux.c) */
}

/***********************************************************************************************************************
 * NVIC initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'NVIC'
- type: 'nvic'
- mode: 'general'
- custom_name_enabled: 'false'
- type_id: 'nvic_57b5eef3774cc60acaede6f5b8bddc67'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'NVIC'
- config_sets:
  - nvic:
    - interrupt_table:
      - 0: []
    - interrupts: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/* Empty initialization function (commented out)
static void NVIC_init(void) {
} */

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/
void BOARD_InitPeripherals(void)
{
  /* Initialize components */
  LPUART_1_init();
  LPI2C_1_init();
  eLCDIF_init();
  GPIO_1_init();
}

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void)
{
  BOARD_InitPeripherals();
}
