
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
Hello World Virtual Com demonstrates the use of virtual com to print the "Hello World" string to the terminal.
Different with Hello World demo (a HW UART peripheral is used to transmit data), the demo transmits data based on
a serial port simulated by the USB device stack on target board side via USB peripheral.
The purpose of this demo is to demonstrate how to use virtual com and provide a simple project for debugging and further development. 

SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Two Micro USB cable
- MIMXRT1060-EVKC board
- Personal Computer

Board settings
==============
No special settings are required.

Prepare the Demo
================
1.  Connect a USB cable between the host PC and the OpenSDA USB port on the target board for downloading
    the program and supply power for the board, connect another USB cable between host PC and USB port
	on the target board.
2.  Download the program to the target board.
3.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.
4.  Open a serial terminal(like putty) to communicate with the board via virtual com.

Running the demo
================
The log below shows the output of this demo in the terminal window:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
hello world.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Terminal will echo back the received characters.
