/*
 * Copyright 2023 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Peripherals v12.0
processor: MIMXRT1062xxxxB
package_id: MIMXRT1062DVL6B
mcu_data: ksdk2_0
processor_version: 0.14.0
board: MIMXRT1060-EVKC
functionalGroups:
- name: BOARD_InitPeripherals
  UUID: 96c1cec6-3bd3-47a2-8301-f38e4b0dd25f
  called_from_default_init: true
  selectedCore: core0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'system'
- type_id: 'system_54b53072540eeeb8f8e9343e71f28176'
- global_system_definitions:
  - user_definitions: ''
  - user_includes: ''
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'uart_cmsis_common'
- type_id: 'uart_cmsis_common_9cb8e302497aa696fdbb5a4fd622c2a8'
- global_USART_CMSIS_common:
  - quick_selection: 'default'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'gpio_adapter_common'
- type_id: 'gpio_adapter_common_57579b9ac814fe26bf95df0a384c36b6'
- global_gpio_adapter_common:
  - quick_selection: 'default'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "peripherals.h"

/***********************************************************************************************************************
 * BOARD_InitPeripherals functional group
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * DEMO_eDMA initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'DEMO_eDMA'
- type: 'edma'
- mode: 'basic'
- custom_name_enabled: 'true'
- type_id: 'edma_46976c94302ab714c0d335f519487c8a'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'DMA0'
- config_sets:
  - fsl_edma:
    - common_settings:
      - enableMinorLoopMapping: 'true'
      - enableContinuousLinkMode: 'false'
      - enableHaltOnError: 'true'
      - ERCA: 'fixedPriority'
      - enableDebugMode: 'false'
    - dma_table:
      - 0: []
      - 1: []
    - edma_channels: []
    - errInterruptConfig:
      - enableErrInterrupt: 'false'
      - errorInterrupt:
        - IRQn: 'DMA_ERROR_IRQn'
        - enable_interrrupt: 'enabled'
        - enable_priority: 'false'
        - priority: '0'
        - enable_custom_name: 'false'
    - quick_selection: 'default'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const edma_config_t DEMO_eDMA_config = {
  .enableContinuousLinkMode = false,
  .enableHaltOnError = true,
  .enableRoundRobinArbitration = false,
  .enableDebugMode = false
};

static void DEMO_eDMA_init(void) {
  /* DMA0 minor loop mapping */
  EDMA_EnableMinorLoopMapping(DEMO_EDMA_DMA_BASEADDR, true);
}

/***********************************************************************************************************************
 * DEMO_SAI initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'DEMO_SAI'
- type: 'sai'
- mode: 'edma'
- custom_name_enabled: 'true'
- type_id: 'sai_d277a9f96e6a702cd0cbe3311dc8aff9'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'SAI1'
- config_sets:
  - fsl_sai:
    - usage: 'record_playback'
    - signal_config:
      - 0:
        - sourceTx: 'Tx'
        - sourceRx: 'Tx'
      - 1:
        - sourceTx: 'Tx'
        - sourceRx: 'Tx'
    - syncSwapI: []
    - bclkTxSetting: []
    - bclkRxSetting: []
    - syncTxSetting: []
    - syncRxSetting: []
    - whole:
      - tx_group:
        - sai_transceiver:
          - bitClock:
            - modeM: 'master'
            - bitClockSource: 'kSAI_BclkSourceMclkOption1'
            - bitClockSourceFreq: 'custom:24576000'
            - bclkPolarityM: 'kSAI_PolarityActiveLow'
            - bclkInputDelayM: 'false'
          - frameSync:
            - modeM: 'master'
            - frameSyncWidthM: '16'
            - frameSyncPolarityM: 'kSAI_PolarityActiveHigh'
            - frameSyncEarlyM: 'true'
            - frameSyncGenerateOnDemandM: 'false'
          - sampleRate_Hz: 'kSAI_SampleRate16KHz'
          - channelMask: 'kSAI_Channel0Mask'
          - serialData:
            - dataMode: 'kSAI_DataPinStateOutputZero'
            - differentFirstWord: 'false'
            - sameDataWordLengthM: 'kSAI_WordWidth16bits'
            - dataOrder: 'kSAI_DataMSB'
            - dataFirstBitShiftedM: '16'
            - dataWordNumM: '2'
            - dataMasked_config:
              - dataMasked_L:
                - 0: 'false'
                - 1: 'false'
                - 2: 'false'
                - 3: 'false'
                - 4: 'false'
                - 5: 'false'
                - 6: 'false'
                - 7: 'false'
                - 8: 'false'
                - 9: 'false'
                - 10: 'false'
                - 11: 'false'
                - 12: 'false'
                - 13: 'false'
                - 14: 'false'
                - 15: 'false'
              - dataMasked_H:
                - 0: 'false'
                - 1: 'false'
                - 2: 'false'
                - 3: 'false'
                - 4: 'false'
                - 5: 'false'
                - 6: 'false'
                - 7: 'false'
                - 8: 'false'
                - 9: 'false'
                - 10: 'false'
                - 11: 'false'
                - 12: 'false'
                - 13: 'false'
                - 14: 'false'
                - 15: 'false'
          - fifo:
            - fifoWatermarkM: '16'
            - fifoCombine: 'kSAI_FifoCombineDisabled'
            - fifoPacking: 'kSAI_FifoPackingDisabled'
            - fifoContinueOneError: 'true'
        - edma_group:
          - enable_edma_channel: 'true'
          - edma_channel:
            - uid: '1679905277336'
            - eDMAn: '0'
            - eDMA_source: 'kDmaRequestMuxSai1Tx'
            - enableTriggerPIT: 'false'
            - init_channel_priority: 'false'
            - edma_channel_Preemption:
              - enableChannelPreemption: 'false'
              - enablePreemptAbility: 'false'
              - channelPriority: '0'
            - enable_custom_name: 'true'
            - handle_custom_name: 'dmaTxHandle'
          - sai_edma_handle:
            - enable_custom_name: 'true'
            - handle_custom_name: 'txHandle'
            - placement:
              - section: 'quickAccess'
              - zeroInitialize: 'false'
              - align: '32'
            - init_callback: 'true'
            - callback_fcn: 'txCallback'
            - user_data: ''
      - rx_group:
        - sai_transceiver:
          - bitClock:
            - modeM: 'master'
            - bitClockSource: 'kSAI_BclkSourceBusclk'
            - bitClockSourceFreq: 'custom:0'
            - bclkPolarityM: 'kSAI_PolarityActiveLow'
            - bclkInputDelayM: 'false'
          - frameSync:
            - modeM: 'master'
            - frameSyncWidthM: '16'
            - frameSyncPolarityM: 'kSAI_PolarityActiveLow'
            - frameSyncEarlyM: 'true'
            - frameSyncGenerateOnDemandM: 'false'
          - sampleRate_Hz: 'kSAI_SampleRate16KHz'
          - channelMask: 'kSAI_Channel0Mask'
          - serialData:
            - dataMode: 'kSAI_DataPinStateTriState'
            - differentFirstWord: 'false'
            - sameDataWordLengthM: 'kSAI_WordWidth16bits'
            - dataOrder: 'kSAI_DataMSB'
            - dataFirstBitShiftedM: '16'
            - dataWordNumM: '2'
            - dataMasked_config:
              - dataMasked_L:
                - 0: 'false'
                - 1: 'false'
                - 2: 'false'
                - 3: 'false'
                - 4: 'false'
                - 5: 'false'
                - 6: 'false'
                - 7: 'false'
                - 8: 'false'
                - 9: 'false'
                - 10: 'false'
                - 11: 'false'
                - 12: 'false'
                - 13: 'false'
                - 14: 'false'
                - 15: 'false'
              - dataMasked_H:
                - 0: 'false'
                - 1: 'false'
                - 2: 'false'
                - 3: 'false'
                - 4: 'false'
                - 5: 'false'
                - 6: 'false'
                - 7: 'false'
                - 8: 'false'
                - 9: 'false'
                - 10: 'false'
                - 11: 'false'
                - 12: 'false'
                - 13: 'false'
                - 14: 'false'
                - 15: 'false'
          - fifo:
            - fifoWatermarkM: '16'
            - fifoCombine: 'kSAI_FifoCombineDisabled'
            - fifoPacking: 'kSAI_FifoPackingDisabled'
            - fifoContinueOneError: 'true'
        - edma_group:
          - enable_edma_channel: 'true'
          - edma_channel:
            - uid: '1679905277408'
            - eDMAn: '1'
            - eDMA_source: 'kDmaRequestMuxSai1Rx'
            - enableTriggerPIT: 'false'
            - init_channel_priority: 'false'
            - edma_channel_Preemption:
              - enableChannelPreemption: 'false'
              - enablePreemptAbility: 'false'
              - channelPriority: '0'
            - enable_custom_name: 'true'
            - handle_custom_name: 'dmaRxHandle'
          - sai_edma_handle:
            - enable_custom_name: 'true'
            - handle_custom_name: 'rxHandle'
            - placement:
              - section: 'quickAccess'
              - zeroInitialize: 'false'
              - align: '32'
            - init_callback: 'true'
            - callback_fcn: 'rxCallback'
            - user_data: ''
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
/* DEMO_SAI Tx configuration */
sai_transceiver_t DEMO_SAI_Tx_config = {
  .masterSlave = kSAI_Master,
  .bitClock = {
    .bclkSrcSwap = false,
    .bclkSource = kSAI_BclkSourceMclkOption1,
    .bclkPolarity = kSAI_PolarityActiveLow,
    .bclkInputDelay = false
  },
  .frameSync = {
    .frameSyncWidth = 16U,
    .frameSyncPolarity = kSAI_PolarityActiveHigh,
    .frameSyncEarly = true,
    .frameSyncGenerateOnDemand = false
  },
  .syncMode = kSAI_ModeAsync,
  .channelMask = kSAI_Channel0Mask,
  .startChannel = 0U,
  .endChannel = 0U,
  .channelNums = 1U,
  .serialData = {
    .dataMode = kSAI_DataPinStateOutputZero,
    .dataWord0Length = (uint8_t)kSAI_WordWidth16bits,
    .dataWordNLength = (uint8_t)kSAI_WordWidth16bits,
    .dataWordLength = (uint8_t)kSAI_WordWidth16bits,
    .dataOrder = kSAI_DataMSB,
    .dataFirstBitShifted = 16U,
    .dataWordNum = 2U,
    .dataMaskedWord = 0x0U
  },
  .fifo = {
    .fifoWatermark = 16U,
    .fifoCombine = kSAI_FifoCombineDisabled,
    .fifoPacking = kSAI_FifoPackingDisabled,
    .fifoContinueOneError = true
  }
};
/* DEMO_SAI Rx configuration */
sai_transceiver_t DEMO_SAI_Rx_config = {
  .masterSlave = kSAI_Master,
  .bitClock = {
    .bclkSrcSwap = false,
    .bclkSource = kSAI_BclkSourceMclkOption1,
    .bclkPolarity = kSAI_PolarityActiveLow,
    .bclkInputDelay = false
  },
  .frameSync = {
    .frameSyncWidth = 16U,
    .frameSyncPolarity = kSAI_PolarityActiveHigh,
    .frameSyncEarly = true,
    .frameSyncGenerateOnDemand = false
  },
  .syncMode = kSAI_ModeSync,
  .channelMask = kSAI_Channel0Mask,
  .startChannel = 0U,
  .endChannel = 0U,
  .channelNums = 1U,
  .serialData = {
    .dataMode = kSAI_DataPinStateTriState,
    .dataWord0Length = (uint8_t)kSAI_WordWidth16bits,
    .dataWordNLength = (uint8_t)kSAI_WordWidth16bits,
    .dataWordLength = (uint8_t)kSAI_WordWidth16bits,
    .dataOrder = kSAI_DataMSB,
    .dataFirstBitShifted = 16U,
    .dataWordNum = 2U,
    .dataMaskedWord = 0x0U
  },
  .fifo = {
    .fifoWatermark = 16U,
    .fifoCombine = kSAI_FifoCombineDisabled,
    .fifoPacking = kSAI_FifoPackingDisabled,
    .fifoContinueOneError = true
  }
};
edma_handle_t dmaTxHandle;
edma_handle_t dmaRxHandle;
AT_QUICKACCESS_SECTION_DATA(sai_edma_handle_t txHandle);
AT_QUICKACCESS_SECTION_DATA(sai_edma_handle_t rxHandle);

static void DEMO_SAI_init(void) {
  /* Set the source kDmaRequestMuxSai1Tx request in the DMAMUX */
  DMAMUX_SetSource(DEMO_SAI_TX_DMAMUX_BASEADDR, DEMO_SAI_TX_DMA_CHANNEL, DEMO_SAI_TX_DMA_REQUEST);
  /* Enable the channel 0 in the DMAMUX */
  DMAMUX_EnableChannel(DEMO_SAI_TX_DMAMUX_BASEADDR, DEMO_SAI_TX_DMA_CHANNEL);
  /* Set the source kDmaRequestMuxSai1Rx request in the DMAMUX */
  DMAMUX_SetSource(DEMO_SAI_RX_DMAMUX_BASEADDR, DEMO_SAI_RX_DMA_CHANNEL, DEMO_SAI_RX_DMA_REQUEST);
  /* Enable the channel 1 in the DMAMUX */
  DMAMUX_EnableChannel(DEMO_SAI_RX_DMAMUX_BASEADDR, DEMO_SAI_RX_DMA_CHANNEL);
  /* Create the eDMA dmaTxHandle handle */
  EDMA_CreateHandle(&dmaTxHandle, DEMO_SAI_TX_DMA_BASEADDR, DEMO_SAI_TX_DMA_CHANNEL);
  /* Create the eDMA dmaRxHandle handle */
  EDMA_CreateHandle(&dmaRxHandle, DEMO_SAI_RX_DMA_BASEADDR, DEMO_SAI_RX_DMA_CHANNEL);
  /* Initialize SAI clock gate */
  SAI_Init(DEMO_SAI_PERIPHERAL);
  /* Create the SAI Tx eDMA handle */
  SAI_TransferTxCreateHandleEDMA(DEMO_SAI_PERIPHERAL, &txHandle, txCallback, NULL, &dmaTxHandle);
  /* Create the SAI Rx eDMA handle */
  SAI_TransferRxCreateHandleEDMA(DEMO_SAI_PERIPHERAL, &rxHandle, rxCallback, NULL, &dmaRxHandle);
  /* Configures SAI Tx sub-module functionality */
  SAI_TransferTxSetConfigEDMA(DEMO_SAI_PERIPHERAL, &txHandle, &DEMO_SAI_Tx_config);
  /* Configures SAI Rx sub-module functionality */
  SAI_TransferRxSetConfigEDMA(DEMO_SAI_PERIPHERAL, &rxHandle, &DEMO_SAI_Rx_config);
  /* Set up SAI Tx bitclock rate by calculation of divider. */
  SAI_TxSetBitClockRate(DEMO_SAI_PERIPHERAL, DEMO_SAI_TX_BCLK_SOURCE_CLOCK_HZ, DEMO_SAI_TX_SAMPLE_RATE, DEMO_SAI_TX_WORD_WIDTH, DEMO_SAI_TX_WORDS_PER_FRAME);
  /* Set up SAI Rx bitclock rate by calculation of divider. */
  SAI_RxSetBitClockRate(DEMO_SAI_PERIPHERAL, DEMO_SAI_RX_BCLK_SOURCE_CLOCK_HZ, DEMO_SAI_RX_SAMPLE_RATE, DEMO_SAI_RX_WORD_WIDTH, DEMO_SAI_RX_WORDS_PER_FRAME);
}

/***********************************************************************************************************************
 * NVIC initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'NVIC'
- type: 'nvic'
- mode: 'general'
- custom_name_enabled: 'false'
- type_id: 'nvic_57b5eef3774cc60acaede6f5b8bddc67'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'NVIC'
- config_sets:
  - nvic:
    - interrupt_table: []
    - interrupts: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/* Empty initialization function (commented out)
static void NVIC_init(void) {
} */

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/
void BOARD_InitPeripherals(void)
{
  /* Global initialization */
  DMAMUX_Init(DEMO_EDMA_DMAMUX_BASEADDR);
  EDMA_Init(DEMO_EDMA_DMA_BASEADDR, &DEMO_eDMA_config);

  /* Initialize components */
  DEMO_eDMA_init();
  DEMO_SAI_init();
}

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void)
{
  BOARD_InitPeripherals();
}
