/*
 * Copyright 2023 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

#define BOARD_INITPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x080004U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */
#define BOARD_INITPINS_IOMUXC_GPR_GPR27_GPIO_MUX2_GPIO_SEL_MASK 0x90000000U /*!< GPIO2 and GPIO7 share same IO MUX function, GPIO_MUX2 selects one GPIO function: affected bits mask */

/* GPIO_AD_B0_13 (coord L14), UART1_RXD/J11[2] */
/* Routed pin properties */
#define BOARD_INITPINS_UART1_RXD_PERIPHERAL                              LPUART1   /*!< Peripheral name */
#define BOARD_INITPINS_UART1_RXD_SIGNAL                                       RX   /*!< Signal name */

/* GPIO_AD_B0_12 (coord K14), UART1_TXD/J13[2] */
/* Routed pin properties */
#define BOARD_INITPINS_UART1_TXD_PERIPHERAL                              LPUART1   /*!< Peripheral name */
#define BOARD_INITPINS_UART1_TXD_SIGNAL                                       TX   /*!< Signal name */

/* GPIO_B0_00 (coord D7), LCDIF_CLK/J49[A30] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_CLK_PERIPHERAL                                LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_CLK_SIGNAL                                lcdif_clk   /*!< Signal name */

/* GPIO_B0_04 (coord C8), LCDIF_D0/BT_CFG[0]/J49[A24] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D0_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D0_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D0_CHANNEL                                       0U   /*!< Signal channel */

/* GPIO_B0_05 (coord B8), LCDIF_D1/BT_CFG[1]/J49[A25] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D1_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D1_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D1_CHANNEL                                       1U   /*!< Signal channel */

/* GPIO_B0_06 (coord A8), LCDIF_D2/BT_CFG[2]/J49[A26] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D2_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D2_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D2_CHANNEL                                       2U   /*!< Signal channel */

/* GPIO_B0_07 (coord A9), LCDIF_D3/BT_CFG[3]/J49[A27] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D3_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D3_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D3_CHANNEL                                       3U   /*!< Signal channel */

/* GPIO_B0_08 (coord B9), LCDIF_D4/BT_CFG[4]/J49[A28] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D4_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D4_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D4_CHANNEL                                       4U   /*!< Signal channel */

/* GPIO_B0_09 (coord C9), LCDIF_D5/BT_CFG[5]/J49[A15] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D5_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D5_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D5_CHANNEL                                       5U   /*!< Signal channel */

/* GPIO_B0_10 (coord D9), LCDIF_D6/BT_CFG[6]/J49[A16] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D6_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D6_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D6_CHANNEL                                       6U   /*!< Signal channel */

/* GPIO_B0_11 (coord A10), LCDIF_D7/BT_CFG[7]/J49[A17] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D7_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D7_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D7_CHANNEL                                       7U   /*!< Signal channel */

/* GPIO_B0_12 (coord C10), LCDIF_D8/BT_CFG[8]/J49[A18] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D8_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D8_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D8_CHANNEL                                       8U   /*!< Signal channel */

/* GPIO_B0_13 (coord D10), LCDIF_D9/BT_CFG[9]/J49[A19] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D9_PERIPHERAL                                 LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D9_SIGNAL                                lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D9_CHANNEL                                       9U   /*!< Signal channel */

/* GPIO_B0_14 (coord E10), LCDIF_D10/BT_CFG[10]/J49[A20] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D10_PERIPHERAL                                LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D10_SIGNAL                               lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D10_CHANNEL                                     10U   /*!< Signal channel */

/* GPIO_B0_15 (coord E11), LCDIF_D11/BT_CFG[11]J49[A8] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D11_PERIPHERAL                                LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D11_SIGNAL                               lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D11_CHANNEL                                     11U   /*!< Signal channel */

/* GPIO_B1_00 (coord A11), LCDIF_D12/J49[A9] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D12_PERIPHERAL                                LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D12_SIGNAL                               lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D12_CHANNEL                                     12U   /*!< Signal channel */

/* GPIO_B1_01 (coord B11), LCDIF_D13/J49[A10] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D13_PERIPHERAL                                LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D13_SIGNAL                               lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D13_CHANNEL                                     13U   /*!< Signal channel */

/* GPIO_B1_02 (coord C11), LCDIF_D14/J49[A11] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D14_PERIPHERAL                                LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D14_SIGNAL                               lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D14_CHANNEL                                     14U   /*!< Signal channel */

/* GPIO_B1_03 (coord D11), LCDIF_D15/J49[A12] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_D15_PERIPHERAL                                LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_D15_SIGNAL                               lcdif_data   /*!< Signal name */
#define BOARD_INITPINS_LCDIF_D15_CHANNEL                                     15U   /*!< Signal channel */

/* GPIO_B0_01 (coord E7), LCDIF_ENABLE/J49[A34] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_ENABLE_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_ENABLE_SIGNAL                          lcdif_enable   /*!< Signal name */

/* GPIO_B0_02 (coord E8), LCDIF_HSYNC/J49[A32] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_HSYNC_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_HSYNC_SIGNAL                            lcdif_hsync   /*!< Signal name */

/* GPIO_B0_03 (coord D8), LCDIF_VSYNC/J49[A33] */
/* Routed pin properties */
#define BOARD_INITPINS_LCDIF_VSYNC_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITPINS_LCDIF_VSYNC_SIGNAL                            lcdif_vsync   /*!< Signal name */

/* GPIO_B1_15 (coord B14), USB_HOST_PWR/U28[A1]/BACKLIGHT_CTL/U14[4] */
/* Routed pin properties */
#define BOARD_INITPINS_BACKLIGHT_CTL_PERIPHERAL                            GPIO2   /*!< Peripheral name */
#define BOARD_INITPINS_BACKLIGHT_CTL_SIGNAL                              gpio_io   /*!< Signal name */
#define BOARD_INITPINS_BACKLIGHT_CTL_CHANNEL                                 31U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_BACKLIGHT_CTL_GPIO                                  GPIO2   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_BACKLIGHT_CTL_GPIO_PIN                                31U   /*!< GPIO pin number */
#define BOARD_INITPINS_BACKLIGHT_CTL_GPIO_PIN_MASK                   (1U << 31U)   /*!< GPIO pin mask */
#define BOARD_INITPINS_BACKLIGHT_CTL_PORT                                  GPIO2   /*!< PORT peripheral base pointer */
#define BOARD_INITPINS_BACKLIGHT_CTL_PIN                                     31U   /*!< PORT pin number */
#define BOARD_INITPINS_BACKLIGHT_CTL_PIN_MASK                        (1U << 31U)   /*!< PORT pin mask */

/* GPIO_AD_B1_03 (coord M12), SPDIF_IN/U15[4]/WL_RST#/J8[56]/SD_PWREN/Q5[1]/J16[8] */
/* Routed pin properties */
#define BOARD_INITPINS_SPDIF_IN_PERIPHERAL                                 GPIO1   /*!< Peripheral name */
#define BOARD_INITPINS_SPDIF_IN_SIGNAL                                   gpio_io   /*!< Signal name */
#define BOARD_INITPINS_SPDIF_IN_CHANNEL                                      19U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_SPDIF_IN_GPIO                                       GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_SPDIF_IN_GPIO_PIN                                     19U   /*!< GPIO pin number */
#define BOARD_INITPINS_SPDIF_IN_GPIO_PIN_MASK                        (1U << 19U)   /*!< GPIO pin mask */
#define BOARD_INITPINS_SPDIF_IN_PORT                                       GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_INITPINS_SPDIF_IN_PIN                                          19U   /*!< PORT pin number */
#define BOARD_INITPINS_SPDIF_IN_PIN_MASK                             (1U << 19U)   /*!< PORT pin mask */

/* GPIO_B1_12 (coord D13), SD_CD_SW/J22[9] */
/* Routed pin properties */
#define BOARD_INITPINS_SD_CD_SW_PERIPHERAL                                 GPIO2   /*!< Peripheral name */
#define BOARD_INITPINS_SD_CD_SW_SIGNAL                                   gpio_io   /*!< Signal name */
#define BOARD_INITPINS_SD_CD_SW_CHANNEL                                      28U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_SD_CD_SW_GPIO                                       GPIO2   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_SD_CD_SW_GPIO_PIN                                     28U   /*!< GPIO pin number */
#define BOARD_INITPINS_SD_CD_SW_GPIO_PIN_MASK                        (1U << 28U)   /*!< GPIO pin mask */
#define BOARD_INITPINS_SD_CD_SW_PORT                                       GPIO2   /*!< PORT peripheral base pointer */
#define BOARD_INITPINS_SD_CD_SW_PIN                                          28U   /*!< PORT pin number */
#define BOARD_INITPINS_SD_CD_SW_PIN_MASK                             (1U << 28U)   /*!< PORT pin mask */

/* GPIO_SD_B0_01 (coord J3), SD1_CLK/J22[5]/J17[3] */
/* Routed pin properties */
#define BOARD_INITPINS_SD1_CLK_PERIPHERAL                                 USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD1_CLK_SIGNAL                                  usdhc_clk   /*!< Signal name */

/* GPIO_SD_B0_00 (coord J4), SD1_CMD/J22[3]/J17[6] */
/* Routed pin properties */
#define BOARD_INITPINS_SD1_CMD_PERIPHERAL                                 USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD1_CMD_SIGNAL                                  usdhc_cmd   /*!< Signal name */

/* GPIO_SD_B0_02 (coord J1), SD1_D0/J22[7]/J17[4] */
/* Routed pin properties */
#define BOARD_INITPINS_SD1_D0_PERIPHERAL                                  USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD1_D0_SIGNAL                                  usdhc_data   /*!< Signal name */
#define BOARD_INITPINS_SD1_D0_CHANNEL                                         0U   /*!< Signal channel */

/* GPIO_SD_B0_03 (coord K1), SD1_D1/J22[8]/J17[5] */
/* Routed pin properties */
#define BOARD_INITPINS_SD1_D1_PERIPHERAL                                  USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD1_D1_SIGNAL                                  usdhc_data   /*!< Signal name */
#define BOARD_INITPINS_SD1_D1_CHANNEL                                         1U   /*!< Signal channel */

/* GPIO_SD_B0_04 (coord H2), SD1_D2/J22[1] */
/* Routed pin properties */
#define BOARD_INITPINS_SD1_D2_PERIPHERAL                                  USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD1_D2_SIGNAL                                  usdhc_data   /*!< Signal name */
#define BOARD_INITPINS_SD1_D2_CHANNEL                                         2U   /*!< Signal channel */

/* GPIO_SD_B0_05 (coord J2), SD1_D3/J22[2] */
/* Routed pin properties */
#define BOARD_INITPINS_SD1_D3_PERIPHERAL                                  USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD1_D3_SIGNAL                                  usdhc_data   /*!< Signal name */
#define BOARD_INITPINS_SD1_D3_CHANNEL                                         3U   /*!< Signal channel */

/* GPIO_B1_14 (coord C14), SD0_VSELECT */
/* Routed pin properties */
#define BOARD_INITPINS_SD0_VSELECT_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD0_VSELECT_SIGNAL                          usdhc_vselect   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
