
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
The flexcan_pingpang_buffer_transfer example shows how to use the FlexCAN queue feature to create
2 simulate FIFOs that can receive CAN/CANFD frames:

In this example, 2 boards are connected through CAN bus. Endpoint A(board A) send CAN/CANFD messages to
Endpoint B(board B) when user inputs the number of CAN messages to be sent in terminal. Endpoint B uses
two receiving queues to receive messages in turn, and prints the message content and the receiving queue
number to the terminal after any queue is full.

SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- MIMXRT1060-EVKC board
- Personal Computer

Board settings
==============
The example requires 2 sets of boards, each of them is mounted with the base board. A male-to-male CAN cable
is required to connect the CAN2 instance (J42) between the 2 base boards.

Prepare the Demo
================
1. Connect a USB cable between the PC host and the OpenSDA USB on the board.
2. Open a serial terminal on PC for OpenSDA serial device with these settings:
   - 115200 baud rate
   - 8 data bits
   - No parity
   - One stop bit
   - No flow control
3. Download the program to the target board.
4. Either press the reset button on your board or launch the debugger in your IDE to begin running
   the example.

Running the demo
================
After connecting the two boards, these instructions display on each terminal window.
One board must be chosen as node A and the other board as node B. (Note: Node B should start first)
Data is sent continuously between the node A and the node B.

~~~~~~~~~~~~~~~~~~~~~
Considering special errata 005829 feature, the 1st valid MB should be used as reserved one.
This message displays on the node A terminal:

********* FLEXCAN PingPong Buffer Example *********
    Message format: Standard (11 bit id)
    Node B Message buffer 1 to 4 used as Rx queue 1.
    Node B Message buffer 5 to 8 used as Rx queue 2.
    Node A Message buffer 8 used as Tx.
*********************************************

Please select local node as A or B:

Note: Node B should start first.
Node:A
Please input the number of CAN/CANFD messages to be send and end with enter.
100
Transmission done.

Please input the number of CAN/CANFD messages to be send and end with enter.

~~~~~~~~~~~~~~~~~~~~~

This message displays on the node B terminal:

********* FLEXCAN PingPong Buffer Example *********
    Message format: Standard (11 bit id)
    Node B Message buffer 1 to 4 used as Rx queue 1.
    Node B Message buffer 5 to 8 used as Rx queue 2.
    Node A Message buffer 8 used as Tx.
*********************************************

Please select local node as A or B:

Note: Node B should start first.
Node:B
Start to Wait data from Node A

Read Rx MB from Queue 1.
Rx MB ID: 0x321, Rx MB data: 0x0, Time stamp: 20971
Rx MB ID: 0x321, Rx MB data: 0x1, Time stamp: 56187
Rx MB ID: 0x321, Rx MB data: 0x2, Time stamp: 56867
Rx MB ID: 0x321, Rx MB data: 0x3, Time stamp: 57547
Read Rx MB from Queue 2.
Rx MB ID: 0x321, Rx MB data: 0x4, Time stamp: 56187
Rx MB ID: 0x321, Rx MB data: 0x5, Time stamp: 56867
Rx MB ID: 0x321, Rx MB data: 0x6, Time stamp: 57547
Rx MB ID: 0x321, Rx MB data: 0x7, Time stamp: 57547
Wait Node A to trigger the next 8 messages!

Read Rx MB from Queue 1.
Rx MB ID: 0x321, Rx MB data: 0x8, Time stamp: 61657
Rx MB ID: 0x321, Rx MB data: 0x9, Time stamp: 31304
Rx MB ID: 0x321, Rx MB data: 0xa, Time stamp: 31983
Rx MB ID: 0x321, Rx MB data: 0xb, Time stamp: 32662
Read Rx MB from Queue 2.
Rx MB ID: 0x321, Rx MB data: 0xc, Time stamp: 31304
Rx MB ID: 0x321, Rx MB data: 0xd, Time stamp: 31983
Rx MB ID: 0x321, Rx MB data: 0xe, Time stamp: 32662
Rx MB ID: 0x321, Rx MB data: 0xf, Time stamp: 32662
Wait Node A to trigger the next 8 messages!

.....
~~~~~~~~~~~~~~~~~~~~~
