
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


The SEMC/SDRAM example has been modified to use a better algorithm to
test the entire SDRAM (the original code only tests 4KB). To use the
old algorithm comment out the following line in semc_sdram.c:

#define USE_BETTER_TEST

The expected output when running the example is this:

SEMC SDRAM Example Start!
memTestDataBus(0x80000000) Succeed!
memTestAddressBus(0x80000000, len=33554432) Succeed!
memTestDevice(0x80000000, len=33554432) Succeed!
SEMC SDRAM Example End.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========

The sdramc example shows how to use SEMC controller driver to initialize the external SDRAM chip.



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- MIMXRT1060-EVKC board
- Personal Computer

Board settings
==============
No special settings are required.

Prepare the Demo
================
1.  Connect a USB cable between the host PC and the OpenSDA USB port on the target board.
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Download the program to the target board.
4.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
When the demo runs successfully, the log would be seen on the OpenSDA terminal like:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SEMC SDRAM Example Start!

 SEMC SDRAM Memory 32 bit Write Start, Start Address 0x80000000, Data Length 4096 !

 SEMC SDRAM Read 32 bit Data Start, Start Address 0x80000000, Data Length 4096 !

 SEMC SDRAM 32 bit Data Write and Read Compare Start!

 SEMC SDRAM 32 bit Data Write and Read Compare Succeed!

 SEMC SDRAM Memory 16 bit Write Start, Start Address 0x80000000, Data Length 4096 !

 SEMC SDRAM Read 16 bit Data Start, Start Address 0x80000000, Data Length 4096 !

 SEMC SDRAM 16 bit Data Write and Read Compare Start!

 SEMC SDRAM 16 bit Data Write and Read Compare Succeed!

 SEMC SDRAM Memory 8 bit Write Start, Start Address 0x80000000, Data Length 4096 !

 SEMC SDRAM Read 8 bit Data Start, Start Address 0x80000000, Data Length 4096 !

 SEMC SDRAM 8 bit Data Write and Read Compare Start!

 SEMC SDRAM 8 bit Data Write and Read Compare Succeed!

 SEMC SDRAM Example End.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Note:
Examples can't be downloaded again after dowmloading IAR flexspi_nor_debug/flexspi_nor_release target. Please erase flash by serial download mode(SW7:0001b). This issue will be fixed in later release.
