Overview
========
The lpi2c_probe example scans the I2C bus to find which adresses are in use
similar to how the i2cdetect tool works in Linux.

An XX in the table indicate that something responded on address XX.
An -- in the table indicate that nothing responded.

As of rev B1 of both iMXRT1062 OEM Board and iMX OEM Carrier Board the
following adresses are expected to be found:
0x1a - Audio Codec
0x20 - I2C GPIO Expander
0x38 - touch controller on the display
0x53 - I2C-E2PROM used to get MAC adress for the Ethernet PHY


Toolchain supported
===================
- IAR embedded Workbench  8.50.9
- Keil MDK  5.33
- GCC ARM Embedded  9.3.1
- MCUXpresso  11.3.1

Hardware requirements
=====================
- Micro USB cable
- iMXRT1062 Developer's Kit

Board settings
==============

Prepare the Demo
================
1. Connect a micro USB cable between the PC host and the J22 USB port on the board.
2.  Open a serial terminal with the following settings:
   - 115200 baud rate
   - 8 data bits
   - No parity
   - One stop bit
   - No flow control
3. Download the program to the target board.
4. Either press the reset button on your board or launch the debugger in your IDE to begin running the example.

Running the demo
================
When the example runs successfully, the following message is displayed in the terminal:

~~~~~~~~~~~~~~~~~~~~~
LPI2C probe example.
Probing I2C1
     0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f
00:          -- -- -- -- -- -- -- -- -- -- -- -- --
10: -- -- -- -- -- -- -- -- -- -- 1a -- -- -- -- --
20: 20 -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
30: -- -- -- -- -- -- -- -- 38 -- -- -- -- -- -- --
40: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
50: -- -- -- 53 -- -- -- -- -- -- -- -- -- -- -- --
60: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
70: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
DONE

End of LPI2C example .
~~~~~~~~~~~~~~~~~~~~~
