/*
 *  Copyright 2023 NXP
 *  All rights reserved.
 *
 *  SPDX-License-Identifier: BSD-3-Clause
 */
#define USB_HOST_CONFIG_EHCI (2U)
#define CONTROLLER_ID        kUSB_ControllerEhci0

/* Controller config
 * Supported controller list,
 * WIFI_IW416_BOARD_MURATA_1XK_M2
 * WIFI_88W8987_BOARD_MURATA_1ZM_M2
 * WIFI_IW612_BOARD_MURATA_2EL_M2
 *
 * If Embedded Artists Type 1XK(EAR00385 M2 only) is used, define macro WIFI_IW416_BOARD_MURATA_1XK_M2 below.
 * If Embedded Artists Type 1ZM(EAR00364 M2 only) is used, define macro WIFI_88W8987_BOARD_MURATA_1ZM_M2 below.
 * If Murata Type 2EL module (Rev-A1 M2 only) is used, define macro WIFI_IW612_BOARD_MURATA_2EL_M2 below.
 */

/* @TEST_ANCHOR */
#define WIFI_IW612_BOARD_MURATA_2EL_M2
/* @END_TEST_ANCHOR */
/*#define WIFI_IW416_BOARD_MURATA_1XK_M2*/
/*#define WIFI_88W8987_BOARD_MURATA_1ZM_M2*/
/*#define WIFI_IW612_BOARD_MURATA_2EL_M2*/

#if (defined(WIFI_IW416_BOARD_MURATA_1XK_M2) || defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2) || \
     defined(WIFI_IW612_BOARD_MURATA_2EL_M2))
#include "wifi_bt_module_config.h"
#include "wifi_config.h"
#else
#error The Wi-Fi module is unsupported
#endif

#define CONFIG_BT_RFCOMM                   1
#define CONFIG_BT_MAX_CONN                 3
#define CONFIG_BT_MAX_PAIRED               3
#define CONFIG_BT_RFCOMM_SESSION_MAX_COUNT 3
#define CONFIG_BT_RFCOMM_CLIENT_MAX_COUNT  5
#define CONFIG_BT_RFCOMM_SERVER_MAX_COUNT  5
#define CONFIG_BT_SETTINGS                 1
#define CONFIG_BT_KEYS_OVERWRITE_OLDEST    1


#if (defined(CONFIG_BT_SMP) && (CONFIG_BT_SMP > 0U))
    #define CONFIG_BT_RX_STACK_SIZE 2500
#else
    #define CONFIG_BT_RX_STACK_SIZE 1024
#endif

#define CONFIG_BT_BLE_DISABLE 1
#include "edgefast_bluetooth_config.h"
#include "edgefast_bluetooth_debug_config.h"
/* For convenience - sets WIFI_BOARD_NAME as string */
#if defined(WIFI_IW416_BOARD_MURATA_1XK_M2)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_M2"
#elif defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_MURATA_1ZM_M2"
#elif defined(WIFI_IW612_BOARD_MURATA_2EL_M2)
   #define WIFI_BOARD_NAME  "WIFI_IW612_BOARD_MURATA_2EL_M2"
#endif
