/*
 *  Copyright 2020-2021 NXP
 *  All rights reserved.
 *
 *  SPDX-License-Identifier: BSD-3-Clause
 */

#define USB_HOST_CONFIG_EHCI (2U)
#define CONTROLLER_ID        kUSB_ControllerEhci0

#define SERIAL_PORT_TYPE_BLE_WU            1
#define DEBUG_CONSOLE_TRANSMIT_BUFFER_LEN  8192
#define DEBUG_CONSOLE_TX_RELIABLE_ENABLE   0

#define CONTROLLER_INIT_ESCAPE          1

#define BUTTON_SHORT_PRESS_THRESHOLD    500U
#define BUTTON_LONG_PRESS_THRESHOLD     800U
#define FLASH_ADAPTER_SIZE              0x10000
#define CONFIG_BT_GATT_CLIENT           1
#define BUTTON_COUNT                    1
#define CONFIG_BT_CENTRAL               1
#define CONFIG_BT_OBSERVER              1
#define DEBUG_CONSOLE_RX_ENABLE         1
#define OSA_USED                        1
#define CONFIG_BT_MAX_CONN              16
#define CONFIG_BT_L2CAP_TX_BUF_COUNT    8
#define CONFIG_BT_DIS_MODEL             "Wireless UART Demo"
#define CONFIG_BT_PERIPHERAL            1
#define CONFIG_BT_DEVICE_NAME           "NXP_WU"
#define CONFIG_BT_SMP                   1
#define CONFIG_BT_SETTINGS              1
#define CONFIG_BT_HOST_CRYPTO           1
#define CONFIG_BT_KEYS_OVERWRITE_OLDEST 1
#define porting_errno                   1

#define CONFIG_WORK_QUEUE_TASK_STACK_SIZE 4096

#define CONFIG_BT_SNOOP 0

#define CONFIG_BT_MAX_PAIRED 16
/* Controller config
 * Supported controller list,
 * WIFI_IW416_BOARD_MURATA_1XK_M2
 * WIFI_88W8987_BOARD_MURATA_1ZM_M2
 * WIFI_IW61x_BOARD_MURATA_2EL_M2
 *
 * If Murata Type 1XK module (EAR00385 M2 only) is used, define macro WIFI_IW416_BOARD_MURATA_1XK_M2 below.
 * If Murata Type 1ZM module (EAR00364 M2 only) is used, define macro WIFI_88W8987_BOARD_MURATA_1ZM_M2 below.
 * If Murata Type 2EL module (Rev-A1 M2 only) is used, define macro WIFI_IW61x_BOARD_MURATA_2EL_M2 below.
 */

/* @TEST_ANCHOR */
#define WIFI_IW612_BOARD_MURATA_2EL_M2
/* @END_TEST_ANCHOR */
/*#define WIFI_IW416_BOARD_MURATA_1XK_M2*/
/*#define WIFI_88W8987_BOARD_MURATA_1ZM_M2*/
/*#define WIFI_IW61x_BOARD_MURATA_2EL_M2*/

#if (defined(WIFI_IW416_BOARD_MURATA_1XK_M2) || defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2) || \
     defined(WIFI_IW612_BOARD_MURATA_2EL_M2))
#include "wifi_bt_module_config.h"
#include "wifi_config.h"
#else
#error The transceiver module is unsupported
#endif

#include "edgefast_bluetooth_config.h"
/* For convenience - sets WIFI_BOARD_NAME as string */
#if defined(WIFI_IW416_BOARD_MURATA_1XK_M2)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_M2"
#elif defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_MURATA_1ZM_M2"
#elif defined(WIFI_IW61x_BOARD_MURATA_2EL_M2)
   #define WIFI_BOARD_NAME  "WIFI_IW61x_BOARD_MURATA_2EL_M2"
#endif
