
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


Some of the examples using Ethernet are as of SDK 2.15.000 configured
to use an ENET_INT (GPIO_AD_B0_10) as a LinkUp interrupt. That pin is
shared with the JTAG_TDO functionallity on the iMX OEM Carrier Board.

This has the following effect:
* Flashed targets (has 'flexspi' in the target name) can be downloaded
  to flash and executed from there by pressing RESET or power cycling
  the board. It is OK to have the debug dongle still attached to the
  board when executing as long as there is no active debug session.

* Debugging flashed targets (has 'flexspi' in the target name) is NOT
  possible as that requires a debugger which will use the JTAG_TDO pin.

* RAM targets (internal or external targets), i.e. all targets without
  'flexspi' in the name, are impossible to use. You have to use the
  debugger to download the program into RAM and to start it but you
  cannot have the debugger connected as it will mess with the LinkUp
  interrupt.

Note that this is only applicable to projects using that interrupt.

Some of the projects that DONT use LinkUp interrupt:
  driver_examples/txrx_transfer
  driver_examples/txrx_ptp1588_transfer

Some of the projects that DO use LinkUp interrupt:
  azure_rtos_examples/combine_usbx_netxduo_filex
  lwip_examples/lwip_dhcp


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========

This is the IPerf example to check your bandwidth using the network performance measurement IPerf application on a PC as a client or a server.
IPv4 is implemented. The UDP implementation is based on lwIP community experimental patches, therefore some issues could be experienced.
UDP sending rate is calculated from the system time, which has a resolution of 1 ms in lwIP. Therefore the actual sending rate could be
a little lower or higher due to sending a calculated (rounded) number of frames each one or more milliseconds. It can also result in higher jitter.
The desired UDP sending rate is determined by the IPERF_UDP_CLIENT_RATE definition. If you want to change the rate without the need to compile
the application with a new value of IPERF_UDP_CLIENT_RATE, you can run the application as a UDP server instead and control the sending rate
by using the tradeoff mode from the PC application and determining the rate there.
For client modes it assumes the PC application it connects to is running on the gateway.

The example has been tested with iperf 2.1.9, which is not compatible with iperf 2.0.5 used in earlier SDK releases.
Aside from the lack of reverse mode, which has been added in the version 2.1.0, the format of the settings sent
between a client and a server is not exactly the same. Therefore please use iperf 2.1.0 or later with this example.
Iperf 2.1.x can be downloaded from here: https://sourceforge.net/projects/iperf2/files/

To experiment with the receive throughput, try to increase the number of receive buffers.
The porting layer for NXP ethernet peripherals implements zero-copy on receive and the number of buffers
is determined by ENET_RXBUFF_NUM definition (or NETC_RXBUFF_NUM in case when NETC ethernet peripheral is used).
Increasing the PBUF_POOL_SIZE option will not help with receive throughput in this case.
Also increase the TCP receive window by changing TCP_WND definition in the file lwipopts.h or on command line.
Make sure that TCP_WND is not larger than (number of receive buffers / TCP_MSS).
Moving of frequently executed code to RAM may also help.
For RTOS applications, DEFAULT_THREAD_PRIO and TCPIP_THREAD_PRIO values can have effect on maximum throughput as well.


SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- Network cable RJ45 standard
- MIMXRT1060-EVKC board
- Personal Computer

Board settings
==============
No special settings are required.

Prepare the Demo
================
1.  Connect a USB cable between the PC host and the OpenSDA(or USB to Serial) USB port on the target board.
2.  Open a serial terminal on PC for OpenSDA serial(or USB to Serial) device with these settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Insert the Ethernet Cable into the target board's RJ45 port and connect it to your PC network adapter.
4.  Configure the host PC IP address to 192.168.0.100.
5.  Open a web browser.
6.  Download the program to the target board.
7.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
1. When the demo starts, the log would be seen on the terminal like:
        Initializing PHY...

        ************************************************
         IPERF example
        ************************************************
         IPv4 Address     : 192.168.0.102
         IPv4 Subnet mask : 255.255.255.0
         IPv4 Gateway     : 192.168.0.100
        ************************************************
        Please select one of the following modes to run IPERF with:

            0: TCP server mode (RX test)
            1: TCP client mode (TX only test)
            2: TCP client reverse mode (RX only test)
            3: TCP client dual mode (TX and RX in parallel)
            4: TCP client tradeoff mode (TX and RX sequentially)
            5: UDP server mode (RX test)
            6: UDP client mode (TX only test)
            7: UDP client reverse mode (RX only test)
            8: UDP client dual mode (TX and RX in parallel)
            9: UDP client tradeoff mode (TX and RX sequentially)

        Enter mode number:

2. Start the server (on the PC or on the board) first.
    If you want to run server on the board and client on the PC, enter the number of the desired server mode (TCP or UDP) into the terminal.
    If you want to run server on the PC and client on the board, start iperf application on the PC:
        For TCP: iperf.exe -s -p 5001 -i 1 -f k
        For UDP: iperf.exe -s -p 5001 -i 1 -f k -u
3. Start the client.
    If the PC is the client, start iperf application on the PC:
        For TCP: iperf.exe -c 192.168.0.102 -p 5001 -P 1 -i 1 -f k -t 10
        For UDP: iperf.exe -c 192.168.0.102 -p 5001 -P 1 -i 1 -f k -t 10 -u -b 100M
        Parameters like -d, -r, -R could be appended to the command for dual, tradeoff or reverse test modes.
        The iperf implementation in lwIP does not support all 2.1.x features, so it does not make
        sense to use some of the modes which require board cooperation, like --full-duplex.
    If the board is the client, enter the number of the desired client mode into the terminal.
4. When the test is finished, the output log of iperf.exe would be seen like below,
    where occurrences of the symbol "N" would be replaced by actual measured values.
    The log will vary depending on the selected mode:
        iperf.exe -c 192.168.0.102 -p 5001 -P 1 -i 1 -f k -t 10
        ------------------------------------------------------------
        Client connecting to 192.168.0.102, TCP port 5001
        TCP window size: 64.0 KByte (default)
        ------------------------------------------------------------
        [  1] local 192.168.0.100 port 51090 connected with 192.168.0.102 port 5001
        [ ID] Interval       Transfer     Bandwidth
        [  1] 0.00-1.00 sec  N KBytes     N Kbits/sec
        [  1] 1.00-2.00 sec  N KBytes     N Kbits/sec
        [  1] 2.00-3.00 sec  N KBytes     N Kbits/sec
        [  1] 3.00-4.00 sec  N KBytes     N Kbits/sec
        [  1] 4.00-5.00 sec  N KBytes     N Kbits/sec
        [  1] 5.00-6.00 sec  N KBytes     N Kbits/sec
        [  1] 6.00-7.00 sec  N KBytes     N Kbits/sec
        [  1] 7.00-8.00 sec  N KBytes     N Kbits/sec
        [  1] 8.00-9.00 sec  N KBytes     N Kbits/sec
        [  1] 9.00-10.00 sec  N KBytes     N Kbits/sec
        [  1] 0.00-10.11 sec  N KBytes     N Kbits/sec

5. Also, when the test is finished, the log would be seen on the terminal like below,
    where occurrences of the symbol "N" would be replaced by actual measured values.
    The log will vary depending on the selected mode:
        Enter mode number: 0
        Press SPACE to abort the test and return to main menu
        New TCP client (settings flags 0x40010078)

        -------------------------------------------------
         TCP_DONE_SERVER (RX)
         Local address : 192.168.0.102  Port 5001
         Remote address : 192.168.0.100  Port 51090
         Bytes Transferred N
         Duration (ms) N
         Bandwidth (kbitpsec) N

6. It is also possible to press the SPACE key when the test is running or finished.
    If it is pressed when test is in progress, the running test will be aborted
    and the main menu will appear. If the test is already finished, the main menu
    will appear directly. From the main menu, new test can be run.
