
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
This example demonstrates how to use the Simple Open EtherCAT Master (SOEM) Library to communicate with EhterCAT devices.

In this example there are three EhterCAT devices, one EtherCAT Coupler EK1100, one EtherCAT Terminal EL2008 (slave0),
and one EtherCAT Terminal EL1018 (slave1).

This example controls a stepper motor system using two outputs and one input remote IO:
  Outputs:
    -Pluse: The pulse signal with the period of 200us and the duty cycle of 50%.
    -Dir:  The direction signal.
  Inputs:
    -Limit signal: This signal comes from the Limit Switchs on the stepper motor system.
     The Dir signal changes once when one of the Limit Switchs has been touched.


SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- Network cable RJ45 standard
- MIMXRT1060-EVKC board
- One BECKHOFF EK1100 EtherCAT Coupler
- Personal Computer

Board settings
==============
No special settings are required.

Prepare the Demo
================
1.  Connect a USB cable between the host PC and the OpenSDA USB port on the target board.
2.  Power up the EtherCAT Coupler and connect it to the target board via an Ethernet Cable.
3.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
4.  Write the program to the flash of the target board.
5.  Press the reset button on your board to start the demo.

Running the demo
================
If the test passes, the led2 of slave0 lights up at 50% brightness.

If the stepper motor system is not setup properly, you can get information from
the console log and the led4 status of slave0.

When the demo is running, the serial port will output:


Start the soem_gpio_pulse FreeRTOS example...

ec_init on enet0 succeeded.

ec_config_init 0
3 slaves found and configured.

ec_config_map_group IOmap:80000089 group:0
 >Slave 1, configadr 1001, state 12
 >Slave 2, configadr 1002, state 12
 >Slave 3, configadr 1003, state 12
  SII Isize:0
  SII Osize:0
     ISIZE:0 0 OSIZE:0
  SM programming
  SII Isize:0
  SII Osize:8
    SM0 length 8
     ISIZE:0 0 OSIZE:8
  SM programming
    SM0 Type:3 StartAddr: f00 Flags:   90044
  SII Isize:8
    SM0 length 8
  SII Osize:0
     ISIZE:8 8 OSIZE:0
  SM programming
    SM0 Type:4 StartAddr:1000 Flags:   10000
  OUTPUT MAPPING
    FMMU 0
      SM0
    slave 2 Outputs 80000089 startbit 0
 =Slave 3, INPUT MAPPING
    FMMU 0
      SM0
    Inputs 8000008A startbit 0
IOmapSize 2
Slaves mapped, state to SAFE_OP.

oloop = 1, iloop = 1

segments : 1 : 2 0 0 0

Request operational state for all slaves

Calculated workcounter 3

Operational state reached for all slaves.

