
This SDK has been patched by Embedded Artists for the iMXRT1062 Developer's Kit.
The SDK was released on 2024-03-12 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1062xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Flash settings (double size, 16MB, compared to EVK, EVKB but same as EVKC)
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Modified pin muxing
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Adjusted the USB interface number for USB Host examples (it is different for host and device examples)
* Added a software_reset() function in board.c/.h to issue a JEDEC reset before NVIC_SystemReset()
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed the default display to RK043FN02H as it is the one mounted on the Developer's Kits
* Changed from the WM8962 codec that the EVKC uses to the WM8960 used by the Developer's Kits

This has been added:
* New WDOG examples that work
* I2C probe example
* Example to show the use of software_reset()

This has been removed:
* All projects for the EVK and EVKB - only keeping EVKC which is then patched
* The original WDOG and RTWDOG examples as those were not working

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1060.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work

Connectors:
* J22 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


This example has been configured to use the 1XK M.2 module. To change which
module to use, replace WIFI_IW416_BOARD_MURATA_1XK_M2 in the app_config.h file
with one of the following and then rebuild the project:

    WIFI_IW416_BOARD_MURATA_1XK_M2     - To use the 1XK M.2 module
    WIFI_88W8801_BOARD_MURATA_2DS_M2   - To use the 2DS M.2 module
    WIFI_88W8987_BOARD_MURATA_1ZM_M2   - To use the 1ZM M.2 module

The NXP EVK needs an 'Murata uSD M.2 Adapter' but the iMXRT1062 Developer's Kit
has an M.2 connector (J38) so the adapter is not needed. Please ignore all mentions
of the 'Murata uSD M.2 Adapter' and the 'receptable cables' below.

More information about the M.2 Modules can be found here: https://www.embeddedartists.com/m2/.

In this version of the SDK for this version of the iMX RT1062 OEM board
Wi-Fi/Bluetooth is currently not working. This is being investigated and
a new version will be released as soon as this is fixed.

Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
This demo implements a simple Wi-Fi station setup. The application will automatically scan local wireless networks at startup, then the user will 
be able to connect to one of the available networks and setup a ping task that will test the connection. 

Before building the example application select Wi-Fi module macro in the app_config.h. (see #define WIFI_<SoC Name>_BOARD_<Module Name>).
For more information about Wi-Fi module connection see:
    readme_modules.txt
    Getting started guide on supported modules configuration:
    https://www.nxp.com/document/guide/getting-started-with-nxp-wi-fi-modules-using-i-mx-rt-platform:GS-WIFI-MODULES-IMXRT-PLATFORM



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Micro USB cable
- evkcmimxrt1060 board
- Personal Computer
- One of the following WiFi modules:
- One of the following modules:
  - Embedded Artists 1XK M.2 Module (EAR00385) - direct M2 connection.
  - Embedded Artists 1ZM M.2 Module (EAR00364) - direct M2 connection.
  - Embedded Artists 2EL M.2 Module - direct M2 connection.
  - Embedded Artists 2DS M.2 Module (EAR00386) - direct M2 connection.

Board settings
==============

Jumper settings for RT1060-EVKC (enables external 5V supply):
remove  J40 5-6
connect J40 1-2
connect J45 with external power(controlled by SW6)

Murata Solution Board settings
Embedded Artists 1XK module datasheet: https://www.embeddedartists.com/doc/ds/1XK_M2_Datasheet.pdf
Embedded Artists 1ZM module datasheet: https://www.embeddedartists.com/doc/ds/1ZM_M2_Datasheet.pdf
Embedded Artists 2EL module datasheet: https://www.embeddedartists.com/doc/ds/2EL_M2_Datasheet.pdf
Embedded Artists 2DS module datasheet: https://www.embeddedartists.com/doc/ds/2DS_M2_Datasheet.pdf

RT1060-EVKC Board Rework For M2 Slot Enablement
A) Wi-Fi Rework:
	- Jumper Settings : Connect J109, connect J76 2-3
    - For 2DS M.2 Module: remove R2163
B) Wi-Fi Host Sleep Wakeup GPIO For 1XK/1ZM/2EL:
    - add 0Ohm resistor at position R252
    - 1XK:
        - Connect Fly-Wire between J33.1 and J108.5.
        - J108 is routed on M2.P44 which internally routed on GPIO[2] of Controller 1XK.
    - 1ZM:
        - Connect Fly-Wire between J33.1 and J108.2.
        - J108 is routed on M2.P40 which internally routed on GPIO[13] of Controller 1ZM.
    - 2EL:
        - No fly-wire connection required.
C) Wi-Fi Independent Reset OOB Trigger For 1XK/1ZM/2EL:
	- Connect Fly-Wire between J16.1 and J108.4.
	- J108 is routed on M2.P48 which internally routed on IR GPIO[15] of Controller 1XK/1ZM.
	- For 2EL-M2, No fly-wire connection required.
Prepare the Demo
================
1.  Connect a micro USB cable between the PC host and the CMSIS DAP USB port on the board
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Connect the Wi-Fi module.
4.  Download the program to the target board.
5.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.


Running the demo
================
1. When the demo starts, basic initialization proceeds - this might take several seconds.
2. After wifi is initialized, the application will try to scan nearby networks.
3. Once the scan is finished, the user will be prompted to enter SSID and password for one of the scanned networks to join.
4. After successfully joining the network, the user will be requested to specify a valid IPv4 address, which will be used for ping test.
