/*
 * Copyright 2020-2021 NXP
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 */


#ifndef _NXP_IOT_AGENT_CONFIG_CERTIFICATES_H_
#define _NXP_IOT_AGENT_CONFIG_CERTIFICATES_H_


#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_ECC_PROD                         \
    0x30, 0x82, 0x01, 0xcd, 0x30, 0x82, 0x01, 0x51, 0xa0, 0x03, 0x02, 0x01, \
    0x02, 0x02, 0x01, 0x01, 0x30, 0x0c, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, \
    0x3d, 0x04, 0x03, 0x03, 0x05, 0x00, 0x30, 0x3e, 0x31, 0x14, 0x30, 0x12, \
    0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x0b, 0x45, 0x64, 0x67, 0x65, 0x4c, \
    0x6f, 0x63, 0x6b, 0x32, 0x47, 0x6f, 0x31, 0x0c, 0x30, 0x0a, 0x06, 0x03, \
    0x55, 0x04, 0x0a, 0x0c, 0x03, 0x4e, 0x58, 0x50, 0x31, 0x18, 0x30, 0x16, \
    0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0f, 0x4e, 0x58, 0x50, 0x20, 0x52, \
    0x6f, 0x6f, 0x74, 0x43, 0x41, 0x76, 0x45, 0x33, 0x30, 0x30, 0x30, 0x22, \
    0x18, 0x0f, 0x32, 0x30, 0x32, 0x30, 0x30, 0x33, 0x32, 0x36, 0x31, 0x31, \
    0x35, 0x36, 0x30, 0x37, 0x5a, 0x18, 0x0f, 0x32, 0x30, 0x37, 0x32, 0x30, \
    0x33, 0x32, 0x36, 0x31, 0x31, 0x35, 0x36, 0x30, 0x37, 0x5a, 0x30, 0x3e, \
    0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x0b, 0x45, \
    0x64, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x32, 0x47, 0x6f, 0x31, 0x0c, \
    0x30, 0x0a, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x03, 0x4e, 0x58, 0x50, \
    0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0f, 0x4e, \
    0x58, 0x50, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x41, 0x76, 0x45, 0x33, \
    0x30, 0x30, 0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, \
    0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, \
    0x00, 0x04, 0xf6, 0x42, 0x7d, 0xfd, 0x0e, 0x76, 0x85, 0xa6, 0x92, 0x51, \
    0x78, 0x43, 0xb8, 0x97, 0x9e, 0x0b, 0x6d, 0x95, 0xed, 0x81, 0x18, 0x82, \
    0xc1, 0x39, 0xc6, 0xf0, 0x98, 0xb5, 0xb6, 0x26, 0xdd, 0x96, 0xdd, 0x2c, \
    0x1f, 0x7e, 0xaf, 0x3c, 0xa8, 0xf6, 0x4f, 0x46, 0x65, 0x1c, 0x40, 0xe3, \
    0x0c, 0xfe, 0x15, 0x93, 0xd8, 0xcc, 0x10, 0x58, 0x75, 0x21, 0xa9, 0x12, \
    0x45, 0xc2, 0x5b, 0x2d, 0x6b, 0x42, 0x27, 0xfe, 0x47, 0x09, 0xa9, 0xbe, \
    0x61, 0x05, 0x76, 0x57, 0x18, 0x8e, 0xe5, 0xf6, 0x47, 0xcf, 0x2f, 0x1a, \
    0x0b, 0x92, 0x43, 0x5d, 0xce, 0x99, 0x7f, 0x8f, 0xdb, 0x14, 0xd6, 0x96, \
    0xcb, 0x23, 0xa3, 0x1d, 0x30, 0x1b, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d, \
    0x13, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0b, 0x06, 0x03, \
    0x55, 0x1d, 0x0f, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x0c, 0x06, \
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x03, 0x05, 0x00, 0x03, \
    0x68, 0x00, 0x30, 0x65, 0x02, 0x31, 0x00, 0xe0, 0x12, 0x19, 0x9e, 0x99, \
    0xb2, 0x6c, 0x40, 0xbc, 0xcd, 0x0f, 0x8c, 0xda, 0x8d, 0x84, 0xfd, 0x69, \
    0xd2, 0x03, 0x8c, 0xd7, 0x9f, 0x21, 0x91, 0xde, 0xc6, 0x4f, 0xa0, 0x5e, \
    0xcd, 0xd0, 0xb1, 0x57, 0x09, 0x4b, 0x7f, 0xcc, 0x26, 0x20, 0x19, 0x4e, \
    0x40, 0x6b, 0x6e, 0x46, 0xa0, 0x5f, 0xe3, 0x02, 0x30, 0x77, 0x03, 0x43, \
    0x3e, 0x21, 0x88, 0x19, 0x6d, 0x07, 0xe4, 0xb1, 0x6d, 0xd7, 0xda, 0x40, \
    0xb1, 0xb4, 0xda, 0x08, 0x4d, 0xcb, 0xe2, 0x0a, 0x1b, 0x75, 0x1b, 0x5f, \
    0xfc, 0x4c, 0x08, 0x7f, 0x58, 0x35, 0x02, 0xb0, 0xb8, 0xf8, 0xf4, 0x3b, \
    0x98, 0x01, 0x7b, 0xbe, 0x8e, 0xee, 0x2f, 0xc0, 0x86 
#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_ECC_PROD_SIZE 465 
 
#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_RSA_PROD                         \
    0x30, 0x82, 0x05, 0x18, 0x30, 0x82, 0x03, 0x00, 0xa0, 0x03, 0x02, 0x01, \
    0x02, 0x02, 0x01, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, \
    0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x3e, 0x31, 0x14, 0x30, \
    0x12, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x0b, 0x45, 0x64, 0x67, 0x65, \
    0x4c, 0x6f, 0x63, 0x6b, 0x32, 0x47, 0x6f, 0x31, 0x0c, 0x30, 0x0a, 0x06, \
    0x03, 0x55, 0x04, 0x0a, 0x0c, 0x03, 0x4e, 0x58, 0x50, 0x31, 0x18, 0x30, \
    0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0f, 0x4e, 0x58, 0x50, 0x20, \
    0x52, 0x6f, 0x6f, 0x74, 0x43, 0x41, 0x76, 0x52, 0x34, 0x30, 0x30, 0x30, \
    0x22, 0x18, 0x0f, 0x32, 0x30, 0x32, 0x30, 0x30, 0x33, 0x32, 0x36, 0x31, \
    0x31, 0x35, 0x30, 0x35, 0x37, 0x5a, 0x18, 0x0f, 0x32, 0x30, 0x37, 0x32, \
    0x30, 0x33, 0x32, 0x36, 0x31, 0x31, 0x35, 0x30, 0x35, 0x37, 0x5a, 0x30, \
    0x3e, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x0b, \
    0x45, 0x64, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x32, 0x47, 0x6f, 0x31, \
    0x0c, 0x30, 0x0a, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x03, 0x4e, 0x58, \
    0x50, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0f, \
    0x4e, 0x58, 0x50, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x41, 0x76, 0x52, \
    0x34, 0x30, 0x30, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, \
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, \
    0x02, 0x0f, 0x00, 0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02, 0x01, 0x00, \
    0xb0, 0x8b, 0x0d, 0x5b, 0xc7, 0x88, 0x50, 0x3c, 0x02, 0xc7, 0x90, 0x92, \
    0xc1, 0xad, 0xac, 0x86, 0x64, 0xf5, 0x0c, 0xf8, 0x7e, 0x3d, 0x2c, 0x9e, \
    0xda, 0x08, 0xfa, 0x59, 0x54, 0xe6, 0x84, 0x1d, 0x88, 0x3b, 0x2c, 0x62, \
    0x61, 0x32, 0xd1, 0x17, 0x2b, 0x73, 0x25, 0x50, 0x9a, 0x77, 0xf2, 0xe7, \
    0x05, 0xe8, 0xcc, 0x05, 0xf7, 0x13, 0x93, 0x1d, 0x91, 0xd2, 0xa9, 0xd0, \
    0xa5, 0xf0, 0x25, 0xf7, 0x14, 0xdb, 0x3e, 0xb3, 0x23, 0xe2, 0x9c, 0xdb, \
    0x95, 0x02, 0x29, 0xd4, 0xc2, 0xa9, 0xa4, 0xd2, 0x1f, 0xf6, 0x20, 0xa6, \
    0x7d, 0x7c, 0xf7, 0x5b, 0x45, 0xda, 0x6f, 0x09, 0xb6, 0x54, 0xe5, 0xd0, \
    0x69, 0xae, 0xd1, 0x0b, 0xb6, 0x8e, 0xca, 0x63, 0x7d, 0x08, 0x72, 0x53, \
    0x07, 0xa2, 0xb7, 0x35, 0xe6, 0x1a, 0x78, 0x18, 0xbb, 0x09, 0x27, 0xdd, \
    0xcf, 0xe1, 0xb7, 0x0b, 0x64, 0xf3, 0xbb, 0xb9, 0x72, 0x22, 0xbc, 0xd8, \
    0x70, 0x5c, 0x22, 0xd0, 0x3f, 0x3f, 0x97, 0x2c, 0xcb, 0xf2, 0x97, 0xb3, \
    0x44, 0x0e, 0x50, 0x81, 0x1d, 0x58, 0x14, 0xa9, 0x24, 0x6d, 0xd7, 0xdf, \
    0x20, 0x96, 0x4c, 0x8b, 0x8c, 0x1b, 0x79, 0xcb, 0x26, 0x1d, 0x20, 0x52, \
    0x85, 0x4f, 0x01, 0x61, 0x8b, 0x03, 0x9d, 0x2f, 0x7f, 0x83, 0xb5, 0x90, \
    0x81, 0xb7, 0xde, 0x89, 0x04, 0x0f, 0xd2, 0xa1, 0xe2, 0xd3, 0x97, 0x17, \
    0xc9, 0xe3, 0x87, 0xff, 0xf1, 0x05, 0xdf, 0x3a, 0x1c, 0xc0, 0x9e, 0x5a, \
    0xdd, 0x6b, 0x61, 0xb5, 0xe8, 0x22, 0x4e, 0xfb, 0xe2, 0x9c, 0xcf, 0x47, \
    0x82, 0xad, 0x11, 0x4a, 0xf9, 0xa5, 0xc9, 0xc9, 0x7a, 0x23, 0x8c, 0x62, \
    0x4b, 0xaa, 0x7f, 0x4e, 0x93, 0xd1, 0x7b, 0x61, 0x5c, 0x4e, 0x06, 0x07, \
    0x9f, 0x79, 0x9f, 0x01, 0x47, 0xf0, 0x69, 0x93, 0xbd, 0x18, 0xa5, 0x3d, \
    0x97, 0x54, 0xb6, 0x0d, 0xbc, 0x05, 0x9a, 0xea, 0x5f, 0x7d, 0xa3, 0xa8, \
    0x53, 0x58, 0xa1, 0x00, 0x6e, 0x5d, 0xaa, 0xcc, 0xe0, 0x9a, 0xb4, 0x31, \
    0x58, 0x73, 0x54, 0x18, 0xac, 0x83, 0x51, 0xa4, 0x1a, 0x66, 0x8e, 0xd6, \
    0x80, 0x2a, 0x8f, 0x6f, 0xc7, 0xf7, 0x09, 0xac, 0x10, 0xca, 0x37, 0x37, \
    0x6b, 0x58, 0x8b, 0x50, 0xfe, 0x02, 0x54, 0x49, 0xb5, 0x30, 0xb1, 0x9b, \
    0x71, 0xb9, 0xe2, 0x51, 0x79, 0x39, 0x9f, 0x57, 0x2b, 0x19, 0x29, 0x88, \
    0xd8, 0x1b, 0x2c, 0x17, 0x45, 0x74, 0x28, 0x09, 0xa2, 0x8c, 0xc9, 0x2a, \
    0x81, 0x27, 0xae, 0x98, 0xc5, 0x05, 0x07, 0x70, 0x79, 0x5b, 0xc0, 0x25, \
    0x18, 0x1f, 0x06, 0x61, 0x84, 0xbc, 0x53, 0x0f, 0x69, 0x45, 0x29, 0xfc, \
    0x1a, 0x98, 0x74, 0x3f, 0xc3, 0x92, 0xb0, 0x1f, 0xaf, 0xe6, 0xbf, 0x6b, \
    0x1e, 0xa4, 0xfa, 0x89, 0xe8, 0x32, 0x33, 0xb7, 0x51, 0x5c, 0x16, 0xbf, \
    0xfa, 0x5c, 0x4d, 0x9f, 0xa0, 0x58, 0x3f, 0x0f, 0x46, 0x01, 0x96, 0x24, \
    0x34, 0xc9, 0xf2, 0xf7, 0xfc, 0xc2, 0xd6, 0xa7, 0x71, 0x61, 0xdd, 0xff, \
    0xee, 0xdd, 0x79, 0x72, 0xcd, 0xbb, 0xf2, 0x2f, 0x96, 0xbe, 0x75, 0xe4, \
    0x46, 0x88, 0xc4, 0xbd, 0x2a, 0x4b, 0xb3, 0x5e, 0x74, 0x76, 0xa4, 0xba, \
    0x57, 0x84, 0x3e, 0x5a, 0xda, 0x12, 0xa6, 0x18, 0x62, 0x79, 0x03, 0xf5, \
    0xa0, 0xc2, 0x93, 0xab, 0xab, 0xc6, 0xa4, 0x80, 0x33, 0x70, 0x6c, 0xe0, \
    0x05, 0x62, 0xf4, 0x1c, 0xc9, 0x13, 0x8b, 0x07, 0x5e, 0x87, 0x44, 0x40, \
    0xe0, 0xde, 0xf8, 0xdd, 0x1c, 0x70, 0xe3, 0x3a, 0x85, 0xcd, 0x0b, 0x06, \
    0xd1, 0x57, 0x30, 0x6c, 0x97, 0xa5, 0x0c, 0x4d, 0xdd, 0x7a, 0xfe, 0xca, \
    0x57, 0x1c, 0xd4, 0x4b, 0x05, 0x33, 0xe6, 0x70, 0xf1, 0xad, 0xa0, 0xaf, \
    0x23, 0x24, 0xc5, 0x85, 0x26, 0x10, 0x76, 0xc9, 0x02, 0x03, 0x01, 0x00, \
    0x01, 0xa3, 0x1d, 0x30, 0x1b, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d, 0x13, \
    0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0b, 0x06, 0x03, 0x55, \
    0x1d, 0x0f, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x0d, 0x06, 0x09, \
    0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, \
    0x82, 0x02, 0x01, 0x00, 0x68, 0x91, 0x70, 0xf5, 0x1f, 0x30, 0xde, 0x79, \
    0xbe, 0x6f, 0x03, 0xd4, 0xff, 0xb3, 0x09, 0xa3, 0xb2, 0x74, 0xd7, 0xff, \
    0x2b, 0x90, 0xea, 0x4e, 0x46, 0x09, 0x49, 0x53, 0x6b, 0x57, 0x2b, 0xd8, \
    0xff, 0x78, 0x2e, 0x2d, 0x33, 0xc7, 0xb9, 0x14, 0x2f, 0x4a, 0xc4, 0x20, \
    0x2e, 0x78, 0x34, 0x05, 0xea, 0x0c, 0x7d, 0xa6, 0xc2, 0x4a, 0xb7, 0x9f, \
    0x11, 0x6d, 0x0c, 0xaa, 0xe8, 0xf8, 0x5b, 0x96, 0xaa, 0x80, 0x43, 0x62, \
    0x4f, 0xf0, 0xa9, 0x3a, 0x47, 0xe5, 0x18, 0x43, 0xd5, 0x4a, 0x60, 0xcb, \
    0xe9, 0xa9, 0x86, 0x9b, 0x2b, 0xee, 0x58, 0xd4, 0xc8, 0xd7, 0x80, 0x17, \
    0x49, 0xd8, 0x35, 0x71, 0x58, 0xf7, 0x74, 0x1b, 0x39, 0x24, 0x84, 0xe8, \
    0x5e, 0x43, 0xf6, 0xcf, 0xc7, 0x76, 0x7d, 0x3b, 0x6b, 0x52, 0xa9, 0x0e, \
    0x47, 0xe0, 0xb6, 0x84, 0x71, 0x6f, 0xec, 0xf7, 0xc1, 0x31, 0xf5, 0x1a, \
    0xcb, 0x12, 0xf4, 0xd3, 0xfa, 0x0b, 0xc1, 0xb6, 0x2e, 0x6f, 0x33, 0x30, \
    0x28, 0xca, 0xc5, 0xd7, 0xe9, 0xf2, 0x3f, 0xf3, 0xdf, 0x12, 0x93, 0x63, \
    0x37, 0x63, 0x1c, 0x9b, 0x75, 0xeb, 0x56, 0xe3, 0x7c, 0xfe, 0x24, 0x35, \
    0xe8, 0xb3, 0xc2, 0x06, 0x28, 0x05, 0x27, 0xd9, 0xf8, 0x51, 0xa7, 0x15, \
    0xef, 0x6b, 0xc7, 0xc0, 0x4a, 0xc3, 0x04, 0x57, 0xb5, 0x90, 0xa3, 0xfa, \
    0x44, 0xb1, 0xdc, 0xe2, 0x52, 0x0b, 0x4b, 0xdb, 0xc5, 0x96, 0x7e, 0xdc, \
    0xf8, 0x63, 0x93, 0x77, 0xa6, 0x3c, 0xf3, 0x3d, 0xc2, 0x81, 0xd3, 0x01, \
    0x68, 0x3a, 0xd4, 0x82, 0xad, 0xfe, 0x48, 0x84, 0x91, 0xb1, 0x5f, 0xa5, \
    0x54, 0x4b, 0x0a, 0x81, 0xfa, 0xc7, 0xfe, 0x91, 0xee, 0xf9, 0xe0, 0xf1, \
    0xca, 0x5b, 0xb9, 0xfa, 0x29, 0x29, 0x34, 0xd1, 0xbd, 0xa8, 0x4a, 0x85, \
    0x27, 0x6e, 0xa4, 0x19, 0x4a, 0x58, 0x37, 0xed, 0x7d, 0x56, 0xf2, 0x80, \
    0x21, 0xa1, 0x0b, 0x7c, 0x20, 0x94, 0x8f, 0xbf, 0x1f, 0x21, 0xb9, 0x05, \
    0xd1, 0xd3, 0xbd, 0x14, 0xbe, 0x58, 0x74, 0xd9, 0x3e, 0xf8, 0xce, 0xea, \
    0x5f, 0x7f, 0xfd, 0x10, 0xe8, 0xa8, 0x41, 0xcf, 0x1b, 0xd4, 0x93, 0xba, \
    0x4c, 0x00, 0x93, 0xeb, 0x87, 0xe5, 0xd2, 0xb4, 0xf0, 0x9a, 0xc7, 0xc0, \
    0x92, 0x42, 0x4a, 0x56, 0xf1, 0xed, 0xb7, 0x5e, 0x94, 0xaa, 0x3a, 0x6a, \
    0xf6, 0xbb, 0x72, 0x97, 0x17, 0x54, 0xe6, 0x3a, 0x31, 0x56, 0x23, 0x90, \
    0x8a, 0xc7, 0x30, 0x43, 0xe6, 0x21, 0xee, 0xae, 0x25, 0xdf, 0x7e, 0x09, \
    0x68, 0x25, 0x14, 0xc0, 0xde, 0x72, 0x79, 0x84, 0x17, 0xbb, 0xca, 0x6e, \
    0xf3, 0x4f, 0x49, 0x0f, 0x4f, 0xf0, 0x80, 0xf4, 0xb6, 0x3f, 0x6e, 0xa4, \
    0xad, 0x9b, 0x87, 0x78, 0xab, 0xe4, 0x23, 0xb4, 0x0e, 0x9a, 0x61, 0x60, \
    0x5d, 0x9c, 0x9f, 0xcd, 0xeb, 0x4f, 0x0b, 0x1b, 0xf9, 0x42, 0xb2, 0xd3, \
    0x94, 0x89, 0x92, 0xe1, 0x45, 0xd5, 0x29, 0x88, 0x11, 0xfe, 0x81, 0x8c, \
    0x54, 0xd1, 0x07, 0x84, 0xf4, 0xac, 0x8c, 0xed, 0x7a, 0xcf, 0x77, 0x44, \
    0xb6, 0x88, 0x3a, 0xf1, 0xa5, 0x96, 0xd6, 0x1a, 0x35, 0xf4, 0xb4, 0x42, \
    0x52, 0x86, 0x57, 0x8c, 0x23, 0x50, 0x18, 0xd1, 0x88, 0xef, 0xfe, 0xe3, \
    0x7a, 0x73, 0xfc, 0xb9, 0xaa, 0x4d, 0x27, 0xb9, 0x4d, 0x56, 0x76, 0x28, \
    0xd9, 0xc3, 0x1f, 0x7a, 0xf2, 0xa2, 0xf4, 0x4e, 0x8e, 0xb8, 0xf1, 0x4b, \
    0x1d, 0x5f, 0x0d, 0xa2, 0x22, 0xd7, 0x47, 0x9a, 0xb9, 0x6b, 0x34, 0xa0, \
    0x2b, 0x80, 0x6f, 0x26, 0x66, 0xd2, 0x85, 0x23, 0x9b, 0x2e, 0xb1, 0x65, \
    0xdb, 0x7d, 0x72, 0x64, 0x32, 0xd0, 0xdd, 0x0b, 0x8e, 0xa5, 0x15, 0x65, \
    0xd1, 0xb8, 0x6d, 0x5a, 0xfb, 0x56, 0x14, 0x5f, 0x89, 0xa4, 0xfa, 0x1f
#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_RSA_PROD_SIZE 1308



// Used for NXP internal debugging when connecting to locally 
// running microservices or on the develop/test environments.
#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_ECC_SANDBOX                      \
	0x30, 0x82, 0x01, 0xd9, 0x30, 0x82, 0x01, 0x5f, 0xa0, 0x03, 0x02, 0x01, \
	0x02, 0x02, 0x01, 0x01, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, \
	0x3d, 0x04, 0x03, 0x02, 0x30, 0x44, 0x31, 0x0c, 0x30, 0x0a, 0x06, 0x03, \
	0x55, 0x04, 0x0a, 0x0c, 0x03, 0x4e, 0x58, 0x50, 0x31, 0x19, 0x30, 0x17, \
	0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x10, 0x45, 0x64, 0x67, 0x65, 0x6c, \
	0x6f, 0x63, 0x6b, 0x32, 0x47, 0x4f, 0x20, 0x54, 0x65, 0x73, 0x74, 0x31, \
	0x19, 0x30, 0x17, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x10, 0x54, 0x65, \
	0x73, 0x74, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x41, 0x76, 0x45, 0x33, \
	0x30, 0x30, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x30, 0x30, 0x33, 0x32, 0x30, \
	0x31, 0x35, 0x34, 0x37, 0x35, 0x32, 0x5a, 0x18, 0x0f, 0x32, 0x30, 0x36, \
	0x31, 0x30, 0x33, 0x31, 0x30, 0x31, 0x35, 0x34, 0x37, 0x35, 0x32, 0x5a, \
	0x30, 0x44, 0x31, 0x0c, 0x30, 0x0a, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, \
	0x03, 0x4e, 0x58, 0x50, 0x31, 0x19, 0x30, 0x17, 0x06, 0x03, 0x55, 0x04, \
	0x0b, 0x0c, 0x10, 0x45, 0x64, 0x67, 0x65, 0x6c, 0x6f, 0x63, 0x6b, 0x32, \
	0x47, 0x4f, 0x20, 0x54, 0x65, 0x73, 0x74, 0x31, 0x19, 0x30, 0x17, 0x06, \
	0x03, 0x55, 0x04, 0x03, 0x0c, 0x10, 0x54, 0x65, 0x73, 0x74, 0x20, 0x52, \
	0x6f, 0x6f, 0x74, 0x43, 0x41, 0x76, 0x45, 0x33, 0x30, 0x30, 0x30, 0x76, \
	0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, \
	0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0x33, 0x6d, \
	0x9b, 0x76, 0x65, 0xcf, 0xb2, 0xf0, 0xa9, 0xd2, 0xcc, 0x00, 0xd7, 0x40, \
	0x23, 0xa7, 0x2c, 0xf2, 0x51, 0x19, 0xdf, 0x88, 0xd8, 0x5f, 0x57, 0x39, \
	0xbf, 0xe2, 0x78, 0x91, 0x9c, 0x6e, 0xb2, 0x1d, 0xe1, 0x51, 0x31, 0xe7, \
	0x6d, 0x45, 0xa8, 0x53, 0xe8, 0x40, 0x78, 0x0a, 0x8f, 0x42, 0x6b, 0x38, \
	0x74, 0x01, 0xe6, 0xd9, 0x20, 0x99, 0x02, 0x28, 0x9a, 0x29, 0x56, 0x22, \
	0xd1, 0x5c, 0x9f, 0xde, 0xad, 0xa9, 0x17, 0xf7, 0x67, 0x96, 0xd9, 0xe8, \
	0x3c, 0xab, 0xe1, 0xe4, 0xfb, 0x8a, 0x89, 0xfd, 0x8e, 0x88, 0x30, 0x0d, \
	0x5a, 0xec, 0x7d, 0xe5, 0xe1, 0x84, 0x66, 0x2d, 0xe2, 0x56, 0xa3, 0x23, \
	0x30, 0x21, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, \
	0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0e, 0x06, 0x03, 0x55, \
	0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86, 0x30, \
	0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, \
	0x68, 0x00, 0x30, 0x65, 0x02, 0x30, 0x76, 0xc2, 0xd9, 0xb1, 0x29, 0xe5, \
	0x00, 0x43, 0xbd, 0xfd, 0xd7, 0x9f, 0xbf, 0x5a, 0x4d, 0xe9, 0x8c, 0xab, \
	0x11, 0xb7, 0x2e, 0xed, 0x18, 0xcb, 0xed, 0x32, 0xe1, 0x55, 0xc3, 0x37, \
	0xc7, 0xe5, 0xc0, 0x70, 0xce, 0x5e, 0x26, 0xb8, 0xcd, 0x7c, 0xb0, 0xf0, \
	0x62, 0x03, 0xf3, 0x0a, 0xed, 0x38, 0x02, 0x31, 0x00, 0x8e, 0x6a, 0x91, \
	0xf5, 0x26, 0x59, 0x26, 0x0c, 0x29, 0xb7, 0xcd, 0x1b, 0x50, 0xfe, 0xdd, \
	0x22, 0xa5, 0x59, 0xe5, 0x6d, 0x0b, 0x7e, 0xce, 0x87, 0x44, 0x4a, 0x8a, \
	0x2c, 0xef, 0xae, 0x58, 0x71, 0xdb, 0xa0, 0x6e, 0x59, 0x32, 0x66, 0x8e, \
	0x8d, 0x98, 0xb1, 0x70, 0x84, 0x45, 0xd2, 0xa6, 0xe2
#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_ECC_SANDBOX_SIZE 477



#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_RSA_SANDBOX                      \
	0x30, 0x82, 0x05, 0x28, 0x30, 0x82, 0x03, 0x10, 0xa0, 0x03, 0x02, 0x01, \
	0x02, 0x02, 0x01, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, \
	0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x44, 0x31, 0x0c, 0x30, \
	0x0a, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x03, 0x4e, 0x58, 0x50, 0x31, \
	0x19, 0x30, 0x17, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x10, 0x45, 0x64, \
	0x67, 0x65, 0x6c, 0x6f, 0x63, 0x6b, 0x32, 0x47, 0x4f, 0x20, 0x54, 0x65, \
	0x73, 0x74, 0x31, 0x19, 0x30, 0x17, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, \
	0x10, 0x54, 0x65, 0x73, 0x74, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x41, \
	0x76, 0x52, 0x34, 0x30, 0x30, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x30, 0x30, \
	0x33, 0x32, 0x30, 0x31, 0x35, 0x34, 0x38, 0x30, 0x32, 0x5a, 0x18, 0x0f, \
	0x32, 0x30, 0x36, 0x31, 0x30, 0x33, 0x31, 0x30, 0x31, 0x35, 0x34, 0x38, \
	0x30, 0x32, 0x5a, 0x30, 0x44, 0x31, 0x0c, 0x30, 0x0a, 0x06, 0x03, 0x55, \
	0x04, 0x0a, 0x0c, 0x03, 0x4e, 0x58, 0x50, 0x31, 0x19, 0x30, 0x17, 0x06, \
	0x03, 0x55, 0x04, 0x0b, 0x0c, 0x10, 0x45, 0x64, 0x67, 0x65, 0x6c, 0x6f, \
	0x63, 0x6b, 0x32, 0x47, 0x4f, 0x20, 0x54, 0x65, 0x73, 0x74, 0x31, 0x19, \
	0x30, 0x17, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x10, 0x54, 0x65, 0x73, \
	0x74, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x43, 0x41, 0x76, 0x52, 0x34, 0x30, \
	0x30, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, \
	0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0f, \
	0x00, 0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02, 0x01, 0x00, 0xd3, 0xc6, \
	0x91, 0xad, 0xd4, 0x58, 0x63, 0x2c, 0x59, 0xc2, 0xfb, 0x74, 0x67, 0xa0, \
	0x88, 0x67, 0x12, 0xfd, 0x55, 0x46, 0x80, 0xf3, 0xb4, 0x8a, 0xb1, 0x6b, \
	0xd4, 0x03, 0x29, 0xfa, 0x1b, 0xe5, 0x00, 0xa8, 0x8a, 0x61, 0x0b, 0xf9, \
	0xa2, 0x88, 0x1d, 0x60, 0x8c, 0xf0, 0xd4, 0xfe, 0x84, 0x68, 0x00, 0xb2, \
	0xda, 0x90, 0x4d, 0xea, 0x6b, 0x2d, 0x08, 0x5d, 0x56, 0xf9, 0xf7, 0xc6, \
	0xdd, 0xf9, 0xcd, 0xdd, 0x0f, 0x40, 0x31, 0x39, 0x47, 0x4a, 0xaf, 0x5a, \
	0x3e, 0x82, 0x33, 0x5e, 0xfa, 0x9c, 0x47, 0x0b, 0xb7, 0x5b, 0x2b, 0x83, \
	0x16, 0xa9, 0xf5, 0x3c, 0xcf, 0x94, 0xd6, 0xe8, 0x4b, 0xa6, 0x39, 0x4d, \
	0x0d, 0x61, 0xcf, 0xb4, 0x79, 0xa6, 0x06, 0x1c, 0xac, 0x70, 0xed, 0x99, \
	0xc5, 0xa0, 0x30, 0xeb, 0x77, 0xa8, 0x62, 0x52, 0xe6, 0xff, 0x88, 0x7a, \
	0x05, 0x86, 0x5a, 0x95, 0x84, 0xe7, 0xcb, 0x7b, 0xcd, 0xec, 0xf7, 0xca, \
	0x33, 0x7c, 0xfe, 0x4b, 0x44, 0x48, 0xf8, 0x55, 0xda, 0xe1, 0x33, 0x8d, \
	0x53, 0xae, 0x00, 0x07, 0x9e, 0x66, 0x99, 0x27, 0x80, 0xde, 0x2d, 0x49, \
	0xb4, 0xa8, 0xc2, 0xb2, 0x9c, 0xa6, 0x48, 0x1c, 0x13, 0x06, 0x23, 0x70, \
	0x9d, 0x90, 0x21, 0xa2, 0x32, 0xab, 0xa3, 0x61, 0x3e, 0x7f, 0x7b, 0xd3, \
	0x37, 0x26, 0xf8, 0x37, 0x17, 0x44, 0xb5, 0x54, 0xdf, 0x56, 0x5c, 0x3f, \
	0xef, 0x92, 0x37, 0x2d, 0x62, 0xe7, 0x8d, 0xcb, 0x65, 0x39, 0x4a, 0x4e, \
	0xd4, 0x92, 0x71, 0xb2, 0x73, 0xa5, 0x6e, 0x84, 0x67, 0x0d, 0x43, 0xf6, \
	0x36, 0x83, 0xd2, 0x08, 0xa6, 0xe6, 0xd3, 0x13, 0xef, 0xf6, 0x0d, 0x3f, \
	0xfb, 0xe1, 0x13, 0x65, 0x6d, 0xed, 0x56, 0x70, 0xb1, 0xc8, 0xf6, 0x10, \
	0xfb, 0x7d, 0x41, 0xf1, 0x2b, 0x7f, 0xc1, 0x5e, 0x04, 0x32, 0xe3, 0x9a, \
	0x0f, 0x95, 0x65, 0x82, 0x2d, 0x68, 0x8b, 0x29, 0xc4, 0x68, 0x6c, 0xcd, \
	0xe0, 0x9a, 0x1d, 0xb9, 0x83, 0x05, 0xc1, 0x7f, 0x22, 0x34, 0xee, 0xcd, \
	0xc9, 0x15, 0xa8, 0x35, 0x67, 0xf6, 0xa3, 0x6c, 0x34, 0x00, 0xb6, 0xc8, \
	0x98, 0x32, 0xfd, 0x3b, 0x3c, 0xe1, 0x23, 0xda, 0x15, 0x92, 0x30, 0x39, \
	0xb4, 0xfb, 0xe2, 0x54, 0x7e, 0xb5, 0x91, 0x00, 0x2e, 0xae, 0x20, 0x98, \
	0xcf, 0x1d, 0x8f, 0x61, 0xc1, 0x61, 0x00, 0xea, 0xe5, 0x68, 0x5e, 0xcd, \
	0x30, 0xc7, 0x40, 0xec, 0x2a, 0x40, 0x92, 0xe3, 0x8b, 0xd3, 0xfe, 0x76, \
	0x15, 0xf2, 0x20, 0xc2, 0x1f, 0xb2, 0xe4, 0xc5, 0x91, 0x6b, 0xc4, 0x5f, \
	0x98, 0x4d, 0xad, 0xd3, 0xae, 0xf7, 0x60, 0xb6, 0xdc, 0x0c, 0x35, 0x40, \
	0xf5, 0x2b, 0x5f, 0xf6, 0xe6, 0x5d, 0x87, 0xa4, 0xfe, 0xaa, 0x35, 0xa0, \
	0x22, 0x7c, 0x34, 0x60, 0x8c, 0x96, 0xc9, 0x8f, 0xa0, 0x1d, 0xf6, 0xfc, \
	0x6f, 0x7e, 0x30, 0x8f, 0x19, 0x15, 0x8e, 0xdc, 0xdc, 0xc6, 0xb4, 0x47, \
	0x97, 0x91, 0x65, 0x28, 0xfe, 0x7b, 0xf5, 0x47, 0xa0, 0xba, 0xe7, 0x58, \
	0x21, 0x37, 0x64, 0x2f, 0xfe, 0x53, 0x57, 0xd3, 0x16, 0x37, 0xb7, 0xeb, \
	0xc8, 0xff, 0x7e, 0x6c, 0x6a, 0x8f, 0x19, 0x66, 0x26, 0x61, 0xd8, 0xf9, \
	0xf6, 0xbc, 0x5e, 0xf5, 0xef, 0xfe, 0x2f, 0x1a, 0x0f, 0x67, 0x25, 0x2f, \
	0xaf, 0x7b, 0x18, 0x74, 0xa1, 0xad, 0x07, 0x5a, 0xd6, 0xd8, 0xf4, 0xa6, \
	0xe9, 0x71, 0x0d, 0xd0, 0xde, 0x9b, 0x2d, 0x93, 0xee, 0xbe, 0x18, 0x3c, \
	0x98, 0xc2, 0x3d, 0x6b, 0xa0, 0x5d, 0x02, 0xdd, 0x04, 0x70, 0x3f, 0x7c, \
	0x94, 0x20, 0xbd, 0x05, 0xba, 0xe2, 0xb9, 0xda, 0x28, 0xcf, 0x2d, 0xe2, \
	0xed, 0x9b, 0xdf, 0xe3, 0xb2, 0x5c, 0x0d, 0x9c, 0xeb, 0x18, 0x7c, 0x42, \
	0x34, 0xab, 0x38, 0xd4, 0x13, 0xb7, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, \
	0x23, 0x30, 0x21, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, \
	0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0e, 0x06, 0x03, \
	0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86, \
	0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, \
	0x0b, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0x47, 0x80, 0x71, 0xe4, \
	0x66, 0x2c, 0xf3, 0x5e, 0xf3, 0x1c, 0x07, 0x18, 0x16, 0xb5, 0x06, 0x29, \
	0x7c, 0xa0, 0xe1, 0x78, 0x61, 0xc4, 0x82, 0x6e, 0x60, 0xc3, 0xf2, 0xd0, \
	0x80, 0xbb, 0xf8, 0xed, 0xd7, 0x1b, 0x17, 0x98, 0xe2, 0xc4, 0xc4, 0x9f, \
	0x43, 0x7d, 0xd1, 0x30, 0x39, 0x9a, 0x63, 0x48, 0x5c, 0x2c, 0xa0, 0x5b, \
	0x88, 0x1f, 0x8c, 0xa8, 0xab, 0x91, 0x13, 0x76, 0xac, 0xd0, 0xde, 0x1f, \
	0x95, 0x3e, 0x2b, 0x50, 0xf3, 0x66, 0x5c, 0x27, 0x49, 0xb0, 0x00, 0xdb, \
	0x78, 0xd5, 0xff, 0xb1, 0xd7, 0x77, 0xe2, 0xdb, 0xbf, 0x10, 0x37, 0xfc, \
	0xfc, 0xe7, 0x47, 0x5d, 0x7e, 0x3b, 0x24, 0x2e, 0xc4, 0x48, 0x6d, 0x3d, \
	0xdd, 0xb5, 0xae, 0x3c, 0xc4, 0x53, 0xf7, 0x19, 0xd7, 0x2c, 0x57, 0x8c, \
	0xde, 0xc5, 0xe9, 0xe1, 0xf7, 0x6f, 0x3d, 0x3c, 0x38, 0xec, 0x40, 0xd1, \
	0xbd, 0x2c, 0x53, 0xfc, 0x73, 0x4c, 0x30, 0xd7, 0x3b, 0xbd, 0x37, 0x73, \
	0x0c, 0x18, 0xe8, 0x88, 0xda, 0x02, 0x84, 0x00, 0xc7, 0x55, 0x72, 0x32, \
	0xdf, 0x4f, 0x4f, 0x3e, 0x23, 0x03, 0x0c, 0xac, 0xaf, 0xa6, 0x95, 0x17, \
	0xd4, 0xad, 0xcb, 0xf3, 0x3b, 0xda, 0xf5, 0x19, 0x33, 0x71, 0xd3, 0x40, \
	0x3f, 0xcf, 0xe6, 0x0e, 0xb4, 0x63, 0x72, 0xb8, 0xec, 0x5c, 0xb9, 0x89, \
	0xd5, 0x1b, 0x13, 0x38, 0xad, 0xd1, 0x10, 0xf0, 0xf3, 0x7d, 0x97, 0xd0, \
	0xd4, 0x44, 0x5d, 0x34, 0xfe, 0xda, 0x12, 0x44, 0xe0, 0x00, 0x04, 0x4e, \
	0xf2, 0x3b, 0xa8, 0x29, 0x39, 0x59, 0xfa, 0xa4, 0x07, 0x13, 0x4c, 0x32, \
	0xa3, 0xa1, 0xee, 0xce, 0x49, 0x9c, 0xeb, 0x27, 0xa9, 0x48, 0x94, 0xa8, \
	0xdf, 0xae, 0xbc, 0x85, 0x09, 0xdc, 0x93, 0x32, 0xa3, 0xaf, 0x59, 0x34, \
	0xd0, 0xe1, 0x67, 0x04, 0x14, 0x01, 0xe7, 0x82, 0x68, 0x29, 0x14, 0xdb, \
	0xd3, 0xfb, 0xc6, 0xde, 0xe6, 0xba, 0x6b, 0x63, 0x1e, 0xee, 0x1e, 0xdf, \
	0x58, 0x81, 0xd8, 0xd9, 0xec, 0x0d, 0xc8, 0x4a, 0x10, 0x90, 0x4f, 0x4c, \
	0x46, 0xc9, 0x19, 0x62, 0x9a, 0x72, 0x1b, 0x03, 0xa3, 0x5f, 0x2a, 0x8a, \
	0xc2, 0xc9, 0xc9, 0x8f, 0xa9, 0x91, 0x72, 0x72, 0xe4, 0x5c, 0xbd, 0x8e, \
	0x5d, 0xde, 0x4c, 0x8a, 0x13, 0xf4, 0x76, 0xb1, 0xc6, 0xab, 0xbf, 0x2c, \
	0xa1, 0x62, 0x09, 0xf2, 0xc1, 0x37, 0x6a, 0xaa, 0x66, 0x3c, 0xaf, 0x51, \
	0xd3, 0xa7, 0x56, 0x12, 0x02, 0x80, 0xae, 0xb4, 0x6d, 0x77, 0x06, 0x44, \
	0xb1, 0xd6, 0x01, 0xa6, 0x5e, 0x44, 0x9d, 0x17, 0x17, 0xa4, 0xe4, 0x64, \
	0xb4, 0x5e, 0x2e, 0x88, 0x63, 0xf6, 0x50, 0xca, 0xa8, 0x7b, 0x94, 0x77, \
	0x74, 0xf0, 0xa4, 0x66, 0x24, 0x91, 0x30, 0x1c, 0x4b, 0x77, 0xe0, 0x52, \
	0x8b, 0xb0, 0x2f, 0x2b, 0x2c, 0x4a, 0xd5, 0xf9, 0xaa, 0xc0, 0x60, 0xa9, \
	0x79, 0xc9, 0x26, 0x30, 0xd2, 0x36, 0xca, 0xac, 0x0f, 0x13, 0xd7, 0x34, \
	0xcb, 0x9a, 0x85, 0xf3, 0x67, 0xb3, 0xe9, 0x71, 0x77, 0x7f, 0xa8, 0x7b, \
	0x7e, 0x62, 0x84, 0x93, 0xfc, 0xcf, 0x5d, 0x77, 0xd3, 0x6f, 0xa1, 0xc3, \
	0x43, 0x96, 0xae, 0xad, 0x72, 0x24, 0xf1, 0x0e, 0x6b, 0x2a, 0xc8, 0x73, \
	0xb7, 0x7c, 0xa1, 0xc8, 0x35, 0x88, 0xc1, 0xfd, 0xdc, 0x35, 0x30, 0x68, \
	0x64, 0x88, 0xda, 0x54, 0x2e, 0x70, 0x7a, 0x1f, 0xc2, 0x3a, 0x7b, 0x08, \
	0x0f, 0xe5, 0xb0, 0x25, 0xe6, 0x54, 0x26, 0x8e, 0xaf, 0xdc, 0xf7, 0x0a, \
	0xf3, 0x11, 0x56, 0xe1, 0x42, 0x0c, 0x19, 0x6f, 0xc6, 0x72, 0x74, 0x24, \
	0xd2, 0x33, 0x7c, 0x2d, 0xea, 0x86, 0x2c, 0xc1, 0xf1, 0xf4, 0xea, 0x11, \
	0xd4, 0xcc, 0x36, 0xc6, 0x05, 0x7c, 0xa8, 0x8b, 0xea, 0x03, 0x45, 0x0d, \
	0xfb, 0x92, 0x40, 0xe7
#define NXP_IOT_AGENT_TRUSTED_ROOT_CA_CERT_RSA_SANDBOX_SIZE 1324

#endif // #ifndef _NXP_IOT_AGENT_CONFIG_CERTIFICATES_H_
