/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _HDI_H_
#define _HDI_H_

/*! *********************************************************************************
 * Include
 ********************************************************************************** */

/*! *********************************************************************************
 * Public macros
 ********************************************************************************** */

/*! *********************************************************************************
 * Private macros
 ********************************************************************************** */

/*! *********************************************************************************
 * Private memory declarations
 ********************************************************************************** */

/*! *********************************************************************************
 * Private functions
 ********************************************************************************** */

/*! *********************************************************************************
 * Public type definitions
 ********************************************************************************** */
typedef enum
{
    radioModeBle_c      = 1,
    radioModeGenFsk_c   = 2,
    radioMode802p15p4_c = 3
} hdi_radio_mode_t;

/*! *********************************************************************************
 * Private type definitions
 ********************************************************************************** */

/*! *********************************************************************************
 * Public memory declarations
 ********************************************************************************** */

/*! *********************************************************************************
 * Public functions
 ********************************************************************************** */

void HDI_Init(void);
void HDI_SendChannelSwitchCmd(uint32_t channel);
void HDI_SendPowerSwitchCmd(uint32_t power);
void HDI_SendRadioConfigCmd(hdi_radio_mode_t mode);
void HDI_IpcInterface(void *buffer, uint32_t size);
#endif /* _HDI_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
