/*
 * Copyright 2020 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _IPC_H_
#define _IPC_H_

/*! *********************************************************************************
 * Include
 ********************************************************************************** */
#include "EmbeddedTypes.h"
#include "fsl_adapter_rpmsg.h"

/*! *********************************************************************************
 * Public definitions
 ********************************************************************************** */

/*! *********************************************************************************
 * Public type definitions
 ********************************************************************************** */
typedef void (*ipcTransportInterface_t)(void *data, uint32_t size);

/*! *********************************************************************************
 * Public memory declarations
 ********************************************************************************** */

/*! *********************************************************************************
 * Public functions
 ********************************************************************************** */
void Ipc_Init(hal_rpmsg_handle_t        ipcRpmsgHandle,
              const hal_rpmsg_config_t *ipcRpmsgConfig,
              ipcTransportInterface_t   interface);
int  Ipc_SendPacket(void *pPacket, uint16_t packetSize);

#endif /* _IPC_H_ */
