/*!
 * \file
 *
 * This file contains the SW implementation of the SHA1 algorithm.
 *
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * NXP Confidential Proprietary
 *
 * No part of this document must be reproduced in any form - including copied,
 * transcribed, printed or by any electronic means - without specific written
 * permission from NXP.
 *
 */

#include "CryptoLibSW.h"

/******************************************************************************
*******************************************************************************
* Private macros
*******************************************************************************
******************************************************************************/

/******************************************************************************
*******************************************************************************
* Private memory definitions
*******************************************************************************
******************************************************************************/
/* initial  */
static uint32_t mSecLib_random = 0xDEADBEEFu;

/******************************************************************************
*******************************************************************************
* Public function prototypes
*******************************************************************************
******************************************************************************/

/******************************************************************************
*******************************************************************************
* Public functions
*******************************************************************************
******************************************************************************/
uint32_t SecLib_set_rng_seed(uint32_t seed)
{
    uint32_t ret = 1u;
    if (seed != 0u)
    {
        mSecLib_random = seed;
        ret            = 0u;
    }

    return ret;
}

/*****************************************************************************/
uint32_t SecLib_get_random(void)
{
    mSecLib_random = (uint32_t)((((uint64_t)mSecLib_random * 279470273UL) % 4294967291UL) & 0xFFFFFFFFUL);
    return mSecLib_random;
}

/*****************************************************************************/
