macro(connfwk_get_all_targets_recursive targets dir)
    get_property(subdirectories DIRECTORY ${dir} PROPERTY SUBDIRECTORIES)
    foreach(subdir ${subdirectories})
        connfwk_get_all_targets_recursive(${targets} ${subdir})
    endforeach()

    get_property(current_targets DIRECTORY ${dir} PROPERTY BUILDSYSTEM_TARGETS)
    list(APPEND ${targets} ${current_targets})
endmacro()

function(connfwk_get_all_targets var)
    set(targets)
    connfwk_get_all_targets_recursive(targets ${CMAKE_CURRENT_SOURCE_DIR})
    set(${var} ${targets} PARENT_SCOPE)
endfunction()

function(connfwk_export_all_executables_to_bin)
    connfwk_get_all_targets(all_targets)
    foreach(target ${all_targets})
        connfwk_export_target_to_bin(${target})
    endforeach()
endfunction()

function(connfwk_export_all_executables_to_srec)
    connfwk_get_all_targets(all_targets)
    foreach(target ${all_targets})
        connfwk_export_target_to_srec(${target})
    endforeach()
endfunction()
