/**************************************************************************/
/*                                                                        */
/*       Copyright (c) Microsoft Corporation. All rights reserved.        */
/*                                                                        */
/*       This software is licensed under the Microsoft Software License   */
/*       Terms for Microsoft Azure RTOS. Full text of the license can be  */
/*       found in the LICENSE file at https://aka.ms/AzureRTOS_EULA       */
/*       and in the root directory of this software.                      */
/*                                                                        */
/**************************************************************************/

/* Version: 6.1 */

#include "nx_azure_iot_adu_agent.h"

/* Update manifest is meant for ADU devices to know what files are needed to be downloaded and installed.
   The update manifest is signed by ADU so devices can trust that the content wasnot altered during the 
   transmission.

   ADU will leverage two types of keys - Root Key(s) and Signing Key(s). Signing keys will be used to 
   digest sign the update manifest and root keys will be used to sign the signing keys.
   
   *Root key - used to sign signing public key; root public key is hardcoded in ADU devices.
   *Signing key - used to sign update manifest; signing public key signed with the master key is included in digest signature header.
*/

/* Root keys.  */

/* ADU.200702.R: root production key from 7/2/2020  */
const UCHAR adu_root_key_200702_r_kid[] = "ADU.200702.R";
const UCHAR adu_root_key_200702_r_n[] = {0x00, 0xd5, 0x42, 0x2e, 0xaf, 0x11, 0x54, 0xa3, 0x50, 0x65, 0x87, 0xa2, 0x4d, 0x5b, 0xba,
                                         0x1a, 0xfb, 0xa9, 0x32, 0xdf, 0xe9, 0x99, 0x5f, 0x05, 0x45, 0xc8, 0xaf, 0xbd, 0x35, 0x1d,
                                         0x89, 0xe8, 0x27, 0x27, 0x58, 0xa3, 0xa8, 0xee, 0xc5, 0xc5, 0x1e, 0x4f, 0xf7, 0x92, 0xa6,
                                         0x12, 0x06, 0x7d, 0x3d, 0x7d, 0xb0, 0x07, 0xf6, 0x2c, 0x7f, 0xde, 0x6d, 0x2a, 0xf5, 0xbc,
                                         0x49, 0xbc, 0x15, 0xef, 0xf0, 0x81, 0xcb, 0x3f, 0x88, 0x4f, 0x27, 0x1d, 0x88, 0x71, 0x28,
                                         0x60, 0x08, 0xb6, 0x19, 0xd2, 0xd2, 0x39, 0xd0, 0x05, 0x1f, 0x3c, 0x76, 0x86, 0x71, 0xbb,
                                         0x59, 0x58, 0xbc, 0xb1, 0x88, 0x7b, 0xab, 0x56, 0x28, 0xbf, 0x31, 0x73, 0x44, 0x32, 0x10,
                                         0xfd, 0x3d, 0xd3, 0x96, 0x5c, 0xff, 0x4e, 0x5c, 0xb3, 0x6b, 0xff, 0x8b, 0x84, 0x9b, 0x8b,
                                         0x80, 0xb8, 0x49, 0xd0, 0x7d, 0xfa, 0xd6, 0x40, 0x58, 0x76, 0x4d, 0xc0, 0x72, 0x27, 0x75,
                                         0xcb, 0x9a, 0x2f, 0x9b, 0xb4, 0x9f, 0x0f, 0x25, 0xf1, 0x1c, 0xc5, 0x1b, 0x0b, 0x5a, 0x30,
                                         0x7d, 0x2f, 0xb8, 0xef, 0xa7, 0x26, 0x58, 0x53, 0xaf, 0xd5, 0x1d, 0x55, 0x01, 0x51, 0x0d,
                                         0xe9, 0x1b, 0xa2, 0x0f, 0x3f, 0xd7, 0xe9, 0x1d, 0x20, 0x41, 0xa6, 0xe6, 0x14, 0x0a, 0xae,
                                         0xfe, 0xf2, 0x1c, 0x2a, 0xd6, 0xe4, 0x04, 0x7b, 0xf6, 0x14, 0x7e, 0xec, 0x0f, 0x97, 0x83,
                                         0xfa, 0x58, 0xfa, 0x81, 0x36, 0x21, 0xb9, 0xa3, 0x2b, 0xfa, 0xd9, 0x61, 0x0b, 0x1a, 0x94,
                                         0xf7, 0xc1, 0xbe, 0x7f, 0x40, 0x14, 0x4a, 0xc9, 0xfa, 0x35, 0x7f, 0xef, 0x66, 0x70, 0x00,
                                         0xb1, 0xfd, 0xdb, 0xd7, 0x61, 0x0d, 0x3b, 0x58, 0x74, 0x67, 0x94, 0x89, 0x75, 0x76, 0x96,
                                         0x7c, 0x91, 0x87, 0xd2, 0x8e, 0x11, 0x97, 0xee, 0x7b, 0x87, 0x6c, 0x9a, 0x2f, 0x45, 0xd8,
                                         0x65, 0x3f, 0x52, 0x70, 0x98, 0x2a, 0xcb, 0xc8, 0x04, 0x63, 0xf5, 0xc9, 0x47, 0xcf, 0x70,
                                         0xf4, 0xed, 0x64, 0xa7, 0x74, 0xa5, 0x23, 0x8f, 0xb6, 0xed, 0xf7, 0x1c, 0xd3, 0xb0, 0x1c,
                                         0x64, 0x57, 0x12, 0x5a, 0xa9, 0x81, 0x84, 0x1f, 0xa0, 0xe7, 0x50, 0x19, 0x96, 0xb4, 0x82,
                                         0xb1, 0xac, 0x48, 0xe3, 0xe1, 0x32, 0x82, 0xcb, 0x40, 0x1f, 0xac, 0xc4, 0x59, 0xbc, 0x10,
                                         0x34, 0x51, 0x82, 0xf9, 0x28, 0x8d, 0xa8, 0x1e, 0x9b, 0xf5, 0x79, 0x45, 0x75, 0xb2, 0xdc,
                                         0x9a, 0x11, 0x43, 0x08, 0xbe, 0x61, 0xcc, 0x9a, 0xc4, 0xcb, 0x77, 0x36, 0xff, 0x83, 0xdd,
                                         0xa8, 0x71, 0x4f, 0x51, 0x8e, 0x0e, 0x7b, 0x4d, 0xfa, 0x79, 0x98, 0x8d, 0xbe, 0xfc, 0x82,
                                         0x7e, 0x40, 0x48, 0xa9, 0x12, 0x01, 0xa8, 0xd9, 0x7e, 0xf3, 0xa5, 0x1b, 0xf1, 0xfb, 0x90,
                                         0x77, 0x3e, 0x40, 0x87, 0x18, 0xc9, 0xab, 0xd9, 0xf7, 0x79};
const UCHAR adu_root_key_200702_r_e[] = {0x01, 0x00, 0x01};


/* ADU.200702.R.T: root test key from 7/2/2020  */
const UCHAR adu_root_key_200702_r_t_kid[] = "ADU.200702.R.T";
const UCHAR adu_root_key_200702_r_t_n[] = {0x00, 0xb9, 0xc2, 0x80, 0x24, 0xc9, 0x2c, 0x91, 0x55, 0x4a, 0x8e, 0xd5, 0x4b, 0x15, 0xda,
                                           0xda, 0x31, 0x27, 0x74, 0x71, 0x36, 0xb6, 0x55, 0xc9, 0xdd, 0x92, 0x57, 0xb9, 0xe3, 0x4b,
                                           0x26, 0x83, 0x76, 0xb6, 0xbf, 0x88, 0x58, 0x5e, 0x81, 0xd6, 0x05, 0xa0, 0x34, 0xb6, 0x46,
                                           0x63, 0xe5, 0x53, 0x35, 0x7d, 0x64, 0x7e, 0x5d, 0xc8, 0xc7, 0x27, 0xd3, 0x51, 0x87, 0xbe,
                                           0x13, 0xce, 0xc1, 0xea, 0x3c, 0x93, 0x83, 0x5e, 0x7d, 0x3c, 0xe6, 0xd5, 0x86, 0x33, 0x03,
                                           0xb3, 0x50, 0x43, 0xe1, 0x39, 0x20, 0x33, 0x45, 0xa6, 0x3e, 0x14, 0x2a, 0xf6, 0xdd, 0x22,
                                           0x2a, 0x33, 0xa0, 0x07, 0x09, 0x83, 0xf1, 0xce, 0x22, 0x9b, 0xcf, 0xd9, 0x04, 0x70, 0x3e,
                                           0x9e, 0xd3, 0x8d, 0xd4, 0xc8, 0x24, 0x4c, 0xc8, 0xb7, 0xfc, 0x7d, 0x02, 0x77, 0x48, 0xeb,
                                           0xc1, 0x5c, 0x23, 0x68, 0x55, 0x29, 0x22, 0x43, 0xca, 0xf0, 0x70, 0x37, 0x87, 0x8c, 0x58,
                                           0x92, 0xce, 0x4f, 0xc1, 0x2f, 0x2d, 0x09, 0x19, 0x18, 0xdf, 0xcc, 0x96, 0x45, 0xf2, 0x5f,
                                           0xaa, 0xd4, 0xdf, 0x95, 0xaa, 0x9a, 0xb7, 0x56, 0xd3, 0xa6, 0x40, 0x9a, 0x61, 0x6e, 0x54,
                                           0x8b, 0xe9, 0xb0, 0xbd, 0x01, 0x1d, 0x46, 0x36, 0xbb, 0xda, 0x25, 0xb1, 0xe2, 0x49, 0xc8,
                                           0x9a, 0x16, 0xfb, 0xa2, 0xb9, 0xc9, 0xde, 0x54, 0x1b, 0xb7, 0x07, 0xa6, 0xd8, 0xd3, 0x01,
                                           0x22, 0x9f, 0x6d, 0x31, 0xfc, 0x2a, 0xe3, 0x4c, 0xd9, 0xa2, 0x58, 0x4b, 0x6e, 0x63, 0xfc,
                                           0xe8, 0x53, 0x12, 0x46, 0x2c, 0x64, 0x15, 0x1e, 0x4c, 0xc9, 0x45, 0x10, 0x10, 0xc1, 0xe1,
                                           0xf1, 0xc3, 0xf1, 0x43, 0x48, 0xc7, 0x77, 0x52, 0x18, 0x88, 0x35, 0x1b, 0x8d, 0xed, 0x06,
                                           0xf7, 0xaf, 0xf4, 0xbd, 0x1c, 0xfa, 0x05, 0x36, 0x46, 0x6f, 0x68, 0xe5, 0x15, 0x39, 0x57,
                                           0xbb, 0x59, 0x46, 0x34, 0x8c, 0x01, 0x48, 0xcd, 0x55, 0x04, 0x72, 0xad, 0x82, 0x4f, 0x1e,
                                           0x37, 0xa7, 0x45, 0xef, 0x68, 0xb7, 0x98, 0x13, 0x3f, 0x83, 0xb0, 0x6f, 0x91, 0x94, 0xf9,
                                           0x24, 0x4f, 0x68, 0xbe, 0xd7, 0x29, 0x04, 0x87, 0x0b, 0x49, 0x7e, 0xc2, 0x86, 0x0d, 0x32,
                                           0x0f, 0xe6, 0x63, 0xc3, 0xb2, 0x56, 0x64, 0x4d, 0x44, 0x9c, 0x81, 0x91, 0x51, 0x31, 0x3a,
                                           0x09, 0x77, 0x03, 0xad, 0x18, 0xa9, 0x00, 0xcc, 0x65, 0xd0, 0x3e, 0x5b, 0xed, 0x7f, 0x72,
                                           0x0b, 0xe3, 0xd7, 0xd4, 0x4c, 0xce, 0x2b, 0xf1, 0xda, 0x48, 0x73, 0xb1, 0x35, 0x37, 0x60,
                                           0xe3, 0xb7, 0xde, 0x3f, 0xfe, 0x47, 0x1d, 0x63, 0x57, 0xbc, 0x27, 0x17, 0xe0, 0x44, 0x7e,
                                           0xd1, 0xa2, 0x24, 0x02, 0x01, 0x31, 0xde, 0xa7, 0xaf, 0xa6, 0x41, 0x6e, 0x54, 0x2a, 0xaf,
                                           0xe8, 0x9c, 0x95, 0xb6, 0x6c, 0xda, 0x3b, 0x8b, 0xd1, 0x9b};
const UCHAR adu_root_key_200702_r_t_e[] = {0x01, 0x00, 0x01};

/* RSA Root key for verifying manifest.  */
const NX_AZURE_IOT_ADU_AGENT_RSA_ROOT_KEY _nx_azure_iot_adu_agent_rsa_root_key_list[] =
{
    {
        /* kid */
        adu_root_key_200702_r_kid,
        sizeof(adu_root_key_200702_r_kid) - 1,

        /* n */
        adu_root_key_200702_r_n,
        sizeof(adu_root_key_200702_r_n),

        /* e */
        adu_root_key_200702_r_e,
        sizeof(adu_root_key_200702_r_e),
    },
    {
        /* kid */
        adu_root_key_200702_r_t_kid,
        sizeof(adu_root_key_200702_r_t_kid) - 1,

        /* n */
        adu_root_key_200702_r_t_n,
        sizeof(adu_root_key_200702_r_t_n),

        /* e */
        adu_root_key_200702_r_t_e,
        sizeof(adu_root_key_200702_r_t_e),
    }
};

const UINT _nx_azure_iot_adu_agent_rsa_root_key_list_size = (sizeof(_nx_azure_iot_adu_agent_rsa_root_key_list) / sizeof(NX_AZURE_IOT_ADU_AGENT_RSA_ROOT_KEY));
