#ifndef _MAC_ADDR_H_
#define _MAC_ADDR_H_


/*!
 * @addtogroup mac_addr
 * @{
 */

/*******************************************************************************
 * API
 ******************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Attempts to read the MAC address from an EEPROM
 *
 * The passed address will only be updated if the EEPROM can be read.
 * 
 * @param addr   Six bytes to store the MAC address in
 */
void MAC_Read(uint8_t* addr);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _MAC_ADDR_H_ */

/*******************************************************************************
 * EOF
 ******************************************************************************/
