/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/* GPIO_AD_B0_12 (coord K14), UART1_TXD */
#define BOARD_INITDEBUG_UART_UART1_TXD_PERIPHERAL                        LPUART1   /*!< Device name: LPUART1 */
#define BOARD_INITDEBUG_UART_UART1_TXD_SIGNAL                                 TX   /*!< LPUART1 signal: TX */
#define BOARD_INITDEBUG_UART_UART1_TXD_PIN_NAME                    GPIO_AD_B0_12   /*!< Pin name */
#define BOARD_INITDEBUG_UART_UART1_TXD_LABEL                         "UART1_TXD"   /*!< Label */
#define BOARD_INITDEBUG_UART_UART1_TXD_NAME                          "UART1_TXD"   /*!< Identifier name */

/* GPIO_AD_B0_13 (coord L14), UART1_RXD */
#define BOARD_INITDEBUG_UART_UART1_RXD_PERIPHERAL                        LPUART1   /*!< Device name: LPUART1 */
#define BOARD_INITDEBUG_UART_UART1_RXD_SIGNAL                                 RX   /*!< LPUART1 signal: RX */
#define BOARD_INITDEBUG_UART_UART1_RXD_PIN_NAME                    GPIO_AD_B0_13   /*!< Pin name */
#define BOARD_INITDEBUG_UART_UART1_RXD_LABEL                         "UART1_RXD"   /*!< Label */
#define BOARD_INITDEBUG_UART_UART1_RXD_NAME                          "UART1_RXD"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitDEBUG_UART(void);

/* GPIO_EMC_09 (coord C2), SEMC_A0 */
#define BOARD_INITSDRAM_SEMC_A0_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A0_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A0_CHANNEL                                       0U   /*!< SEMC ADDR channel: 00 */
#define BOARD_INITSDRAM_SEMC_A0_PIN_NAME                             GPIO_EMC_09   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A0_LABEL                                  "SEMC_A0"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A0_NAME                                   "SEMC_A0"   /*!< Identifier name */

/* GPIO_EMC_10 (coord G1), SEMC_A1 */
#define BOARD_INITSDRAM_SEMC_A1_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A1_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A1_CHANNEL                                       1U   /*!< SEMC ADDR channel: 01 */
#define BOARD_INITSDRAM_SEMC_A1_PIN_NAME                             GPIO_EMC_10   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A1_LABEL                                  "SEMC_A1"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A1_NAME                                   "SEMC_A1"   /*!< Identifier name */

/* GPIO_EMC_11 (coord G3), SEMC_A2 */
#define BOARD_INITSDRAM_SEMC_A2_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A2_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A2_CHANNEL                                       2U   /*!< SEMC ADDR channel: 02 */
#define BOARD_INITSDRAM_SEMC_A2_PIN_NAME                             GPIO_EMC_11   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A2_LABEL                                  "SEMC_A2"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A2_NAME                                   "SEMC_A2"   /*!< Identifier name */

/* GPIO_EMC_12 (coord H1), SEMC_A3 */
#define BOARD_INITSDRAM_SEMC_A3_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A3_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A3_CHANNEL                                       3U   /*!< SEMC ADDR channel: 03 */
#define BOARD_INITSDRAM_SEMC_A3_PIN_NAME                             GPIO_EMC_12   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A3_LABEL                                  "SEMC_A3"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A3_NAME                                   "SEMC_A3"   /*!< Identifier name */

/* GPIO_EMC_13 (coord A6), SEMC_A4 */
#define BOARD_INITSDRAM_SEMC_A4_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A4_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A4_CHANNEL                                       4U   /*!< SEMC ADDR channel: 04 */
#define BOARD_INITSDRAM_SEMC_A4_PIN_NAME                             GPIO_EMC_13   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A4_LABEL                                  "SEMC_A4"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A4_NAME                                   "SEMC_A4"   /*!< Identifier name */

/* GPIO_EMC_14 (coord B6), SEMC_A5 */
#define BOARD_INITSDRAM_SEMC_A5_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A5_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A5_CHANNEL                                       5U   /*!< SEMC ADDR channel: 05 */
#define BOARD_INITSDRAM_SEMC_A5_PIN_NAME                             GPIO_EMC_14   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A5_LABEL                                  "SEMC_A5"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A5_NAME                                   "SEMC_A5"   /*!< Identifier name */

/* GPIO_EMC_15 (coord B1), SEMC_A6 */
#define BOARD_INITSDRAM_SEMC_A6_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A6_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A6_CHANNEL                                       6U   /*!< SEMC ADDR channel: 06 */
#define BOARD_INITSDRAM_SEMC_A6_PIN_NAME                             GPIO_EMC_15   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A6_LABEL                                  "SEMC_A6"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A6_NAME                                   "SEMC_A6"   /*!< Identifier name */

/* GPIO_EMC_16 (coord A5), SEMC_A7 */
#define BOARD_INITSDRAM_SEMC_A7_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A7_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A7_CHANNEL                                       7U   /*!< SEMC ADDR channel: 07 */
#define BOARD_INITSDRAM_SEMC_A7_PIN_NAME                             GPIO_EMC_16   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A7_LABEL                                  "SEMC_A7"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A7_NAME                                   "SEMC_A7"   /*!< Identifier name */

/* GPIO_EMC_17 (coord A4), SEMC_A8 */
#define BOARD_INITSDRAM_SEMC_A8_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A8_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A8_CHANNEL                                       8U   /*!< SEMC ADDR channel: 08 */
#define BOARD_INITSDRAM_SEMC_A8_PIN_NAME                             GPIO_EMC_17   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A8_LABEL                                  "SEMC_A8"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A8_NAME                                   "SEMC_A8"   /*!< Identifier name */

/* GPIO_EMC_18 (coord B2), SEMC_A9 */
#define BOARD_INITSDRAM_SEMC_A9_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A9_SIGNAL                                      ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A9_CHANNEL                                       9U   /*!< SEMC ADDR channel: 09 */
#define BOARD_INITSDRAM_SEMC_A9_PIN_NAME                             GPIO_EMC_18   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A9_LABEL                                  "SEMC_A9"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A9_NAME                                   "SEMC_A9"   /*!< Identifier name */

/* GPIO_EMC_23 (coord G2), SEMC_A10 */
#define BOARD_INITSDRAM_SEMC_A10_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A10_SIGNAL                                     ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A10_CHANNEL                                     10U   /*!< SEMC ADDR channel: 10 */
#define BOARD_INITSDRAM_SEMC_A10_PIN_NAME                            GPIO_EMC_23   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A10_LABEL                                "SEMC_A10"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A10_NAME                                 "SEMC_A10"   /*!< Identifier name */

/* GPIO_EMC_19 (coord B4), SEMC_A11 */
#define BOARD_INITSDRAM_SEMC_A11_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A11_SIGNAL                                     ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A11_CHANNEL                                     11U   /*!< SEMC ADDR channel: 11 */
#define BOARD_INITSDRAM_SEMC_A11_PIN_NAME                            GPIO_EMC_19   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A11_LABEL                                "SEMC_A11"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A11_NAME                                 "SEMC_A11"   /*!< Identifier name */

/* GPIO_EMC_20 (coord A3), SEMC_A12 */
#define BOARD_INITSDRAM_SEMC_A12_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_A12_SIGNAL                                     ADDR   /*!< SEMC signal: ADDR */
#define BOARD_INITSDRAM_SEMC_A12_CHANNEL                                     12U   /*!< SEMC ADDR channel: 12 */
#define BOARD_INITSDRAM_SEMC_A12_PIN_NAME                            GPIO_EMC_20   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_A12_LABEL                                "SEMC_A12"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_A12_NAME                                 "SEMC_A12"   /*!< Identifier name */

/* GPIO_EMC_21 (coord C1), SEMC_BA0 */
#define BOARD_INITSDRAM_SEMC_BA0_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_BA0_SIGNAL                                       BA   /*!< SEMC signal: BA */
#define BOARD_INITSDRAM_SEMC_BA0_CHANNEL                                      0U   /*!< SEMC BA channel: 0 */
#define BOARD_INITSDRAM_SEMC_BA0_PIN_NAME                            GPIO_EMC_21   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_BA0_LABEL                                "SEMC_BA0"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_BA0_NAME                                 "SEMC_BA0"   /*!< Identifier name */

/* GPIO_EMC_22 (coord F1), SEMC_BA1 */
#define BOARD_INITSDRAM_SEMC_BA1_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_BA1_SIGNAL                                       BA   /*!< SEMC signal: BA */
#define BOARD_INITSDRAM_SEMC_BA1_CHANNEL                                      1U   /*!< SEMC BA channel: 1 */
#define BOARD_INITSDRAM_SEMC_BA1_PIN_NAME                            GPIO_EMC_22   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_BA1_LABEL                                "SEMC_BA1"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_BA1_NAME                                 "SEMC_BA1"   /*!< Identifier name */

/* GPIO_EMC_24 (coord D3), SEMC_CAS */
#define BOARD_INITSDRAM_SEMC_CAS_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_CAS_SIGNAL                                 semc_cas   /*!< SEMC signal: semc_cas */
#define BOARD_INITSDRAM_SEMC_CAS_PIN_NAME                            GPIO_EMC_24   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_CAS_LABEL                                "SEMC_CAS"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_CAS_NAME                                 "SEMC_CAS"   /*!< Identifier name */

/* GPIO_EMC_27 (coord A2), SEMC_CKE */
#define BOARD_INITSDRAM_SEMC_CKE_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_CKE_SIGNAL                                 semc_cke   /*!< SEMC signal: semc_cke */
#define BOARD_INITSDRAM_SEMC_CKE_PIN_NAME                            GPIO_EMC_27   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_CKE_LABEL                                "SEMC_CKE"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_CKE_NAME                                 "SEMC_CKE"   /*!< Identifier name */

/* GPIO_EMC_26 (coord B3), SEMC_CLK */
#define BOARD_INITSDRAM_SEMC_CLK_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_CLK_SIGNAL                                 semc_clk   /*!< SEMC signal: semc_clk */
#define BOARD_INITSDRAM_SEMC_CLK_PIN_NAME                            GPIO_EMC_26   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_CLK_LABEL                                "SEMC_CLK"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_CLK_NAME                                 "SEMC_CLK"   /*!< Identifier name */

/* GPIO_EMC_00 (coord E3), SEMC_D0 */
#define BOARD_INITSDRAM_SEMC_D0_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D0_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D0_CHANNEL                                       0U   /*!< SEMC DATA channel: 00 */
#define BOARD_INITSDRAM_SEMC_D0_PIN_NAME                             GPIO_EMC_00   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D0_LABEL                                  "SEMC_D0"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D0_NAME                                   "SEMC_D0"   /*!< Identifier name */

/* GPIO_EMC_01 (coord F3), SEMC_D1 */
#define BOARD_INITSDRAM_SEMC_D1_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D1_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D1_CHANNEL                                       1U   /*!< SEMC DATA channel: 01 */
#define BOARD_INITSDRAM_SEMC_D1_PIN_NAME                             GPIO_EMC_01   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D1_LABEL                                  "SEMC_D1"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D1_NAME                                   "SEMC_D1"   /*!< Identifier name */

/* GPIO_EMC_02 (coord F4), SEMC_D2 */
#define BOARD_INITSDRAM_SEMC_D2_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D2_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D2_CHANNEL                                       2U   /*!< SEMC DATA channel: 02 */
#define BOARD_INITSDRAM_SEMC_D2_PIN_NAME                             GPIO_EMC_02   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D2_LABEL                                  "SEMC_D2"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D2_NAME                                   "SEMC_D2"   /*!< Identifier name */

/* GPIO_EMC_03 (coord G4), SEMC_D3 */
#define BOARD_INITSDRAM_SEMC_D3_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D3_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D3_CHANNEL                                       3U   /*!< SEMC DATA channel: 03 */
#define BOARD_INITSDRAM_SEMC_D3_PIN_NAME                             GPIO_EMC_03   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D3_LABEL                                  "SEMC_D3"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D3_NAME                                   "SEMC_D3"   /*!< Identifier name */

/* GPIO_EMC_04 (coord F2), SEMC_D4 */
#define BOARD_INITSDRAM_SEMC_D4_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D4_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D4_CHANNEL                                       4U   /*!< SEMC DATA channel: 04 */
#define BOARD_INITSDRAM_SEMC_D4_PIN_NAME                             GPIO_EMC_04   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D4_LABEL                                  "SEMC_D4"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D4_NAME                                   "SEMC_D4"   /*!< Identifier name */

/* GPIO_EMC_05 (coord G5), SEMC_D5 */
#define BOARD_INITSDRAM_SEMC_D5_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D5_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D5_CHANNEL                                       5U   /*!< SEMC DATA channel: 05 */
#define BOARD_INITSDRAM_SEMC_D5_PIN_NAME                             GPIO_EMC_05   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D5_LABEL                                  "SEMC_D5"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D5_NAME                                   "SEMC_D5"   /*!< Identifier name */

/* GPIO_EMC_06 (coord H5), SEMC_D6 */
#define BOARD_INITSDRAM_SEMC_D6_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D6_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D6_CHANNEL                                       6U   /*!< SEMC DATA channel: 06 */
#define BOARD_INITSDRAM_SEMC_D6_PIN_NAME                             GPIO_EMC_06   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D6_LABEL                                  "SEMC_D6"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D6_NAME                                   "SEMC_D6"   /*!< Identifier name */

/* GPIO_EMC_07 (coord H4), SEMC_D7 */
#define BOARD_INITSDRAM_SEMC_D7_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D7_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D7_CHANNEL                                       7U   /*!< SEMC DATA channel: 07 */
#define BOARD_INITSDRAM_SEMC_D7_PIN_NAME                             GPIO_EMC_07   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D7_LABEL                                  "SEMC_D7"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D7_NAME                                   "SEMC_D7"   /*!< Identifier name */

/* GPIO_EMC_30 (coord C6), SEMC_D8 */
#define BOARD_INITSDRAM_SEMC_D8_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D8_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D8_CHANNEL                                       8U   /*!< SEMC DATA channel: 08 */
#define BOARD_INITSDRAM_SEMC_D8_PIN_NAME                             GPIO_EMC_30   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D8_LABEL                                  "SEMC_D8"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D8_NAME                                   "SEMC_D8"   /*!< Identifier name */

/* GPIO_EMC_31 (coord C5), SEMC_D9 */
#define BOARD_INITSDRAM_SEMC_D9_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D9_SIGNAL                                      DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D9_CHANNEL                                       9U   /*!< SEMC DATA channel: 09 */
#define BOARD_INITSDRAM_SEMC_D9_PIN_NAME                             GPIO_EMC_31   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D9_LABEL                                  "SEMC_D9"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D9_NAME                                   "SEMC_D9"   /*!< Identifier name */

/* GPIO_EMC_32 (coord D5), SEMC_D10 */
#define BOARD_INITSDRAM_SEMC_D10_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D10_SIGNAL                                     DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D10_CHANNEL                                     10U   /*!< SEMC DATA channel: 10 */
#define BOARD_INITSDRAM_SEMC_D10_PIN_NAME                            GPIO_EMC_32   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D10_LABEL                                "SEMC_D10"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D10_NAME                                 "SEMC_D10"   /*!< Identifier name */

/* GPIO_EMC_33 (coord C4), SEMC_D11 */
#define BOARD_INITSDRAM_SEMC_D11_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D11_SIGNAL                                     DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D11_CHANNEL                                     11U   /*!< SEMC DATA channel: 11 */
#define BOARD_INITSDRAM_SEMC_D11_PIN_NAME                            GPIO_EMC_33   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D11_LABEL                                "SEMC_D11"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D11_NAME                                 "SEMC_D11"   /*!< Identifier name */

/* GPIO_EMC_34 (coord D4), SEMC_D12 */
#define BOARD_INITSDRAM_SEMC_D12_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D12_SIGNAL                                     DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D12_CHANNEL                                     12U   /*!< SEMC DATA channel: 12 */
#define BOARD_INITSDRAM_SEMC_D12_PIN_NAME                            GPIO_EMC_34   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D12_LABEL                                "SEMC_D12"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D12_NAME                                 "SEMC_D12"   /*!< Identifier name */

/* GPIO_EMC_35 (coord E5), SEMC_D13 */
#define BOARD_INITSDRAM_SEMC_D13_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D13_SIGNAL                                     DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D13_CHANNEL                                     13U   /*!< SEMC DATA channel: 13 */
#define BOARD_INITSDRAM_SEMC_D13_PIN_NAME                            GPIO_EMC_35   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D13_LABEL                                "SEMC_D13"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D13_NAME                                 "SEMC_D13"   /*!< Identifier name */

/* GPIO_EMC_36 (coord C3), SEMC_D14 */
#define BOARD_INITSDRAM_SEMC_D14_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D14_SIGNAL                                     DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D14_CHANNEL                                     14U   /*!< SEMC DATA channel: 14 */
#define BOARD_INITSDRAM_SEMC_D14_PIN_NAME                            GPIO_EMC_36   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D14_LABEL                                "SEMC_D14"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D14_NAME                                 "SEMC_D14"   /*!< Identifier name */

/* GPIO_EMC_37 (coord E4), SEMC_D15 */
#define BOARD_INITSDRAM_SEMC_D15_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_D15_SIGNAL                                     DATA   /*!< SEMC signal: DATA */
#define BOARD_INITSDRAM_SEMC_D15_CHANNEL                                     15U   /*!< SEMC DATA channel: 15 */
#define BOARD_INITSDRAM_SEMC_D15_PIN_NAME                            GPIO_EMC_37   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_D15_LABEL                                "SEMC_D15"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_D15_NAME                                 "SEMC_D15"   /*!< Identifier name */

/* GPIO_EMC_08 (coord H3), SEMC_DM0 */
#define BOARD_INITSDRAM_SEMC_DM0_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_DM0_SIGNAL                                       DM   /*!< SEMC signal: DM */
#define BOARD_INITSDRAM_SEMC_DM0_CHANNEL                                      0U   /*!< SEMC DM channel: 0 */
#define BOARD_INITSDRAM_SEMC_DM0_PIN_NAME                            GPIO_EMC_08   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_DM0_LABEL                                "SEMC_DM0"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_DM0_NAME                                 "SEMC_DM0"   /*!< Identifier name */

/* GPIO_EMC_38 (coord D6), SEMC_DM1 */
#define BOARD_INITSDRAM_SEMC_DM1_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_DM1_SIGNAL                                       DM   /*!< SEMC signal: DM */
#define BOARD_INITSDRAM_SEMC_DM1_CHANNEL                                      1U   /*!< SEMC DM channel: 1 */
#define BOARD_INITSDRAM_SEMC_DM1_PIN_NAME                            GPIO_EMC_38   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_DM1_LABEL                                "SEMC_DM1"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_DM1_NAME                                 "SEMC_DM1"   /*!< Identifier name */

/* GPIO_EMC_25 (coord D2), SEMC_RAS */
#define BOARD_INITSDRAM_SEMC_RAS_PERIPHERAL                                 SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_RAS_SIGNAL                                 semc_ras   /*!< SEMC signal: semc_ras */
#define BOARD_INITSDRAM_SEMC_RAS_PIN_NAME                            GPIO_EMC_25   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_RAS_LABEL                                "SEMC_RAS"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_RAS_NAME                                 "SEMC_RAS"   /*!< Identifier name */

/* GPIO_EMC_28 (coord D1), SEMC_WE */
#define BOARD_INITSDRAM_SEMC_WE_PERIPHERAL                                  SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_SEMC_WE_SIGNAL                                   semc_we   /*!< SEMC signal: semc_we */
#define BOARD_INITSDRAM_SEMC_WE_PIN_NAME                             GPIO_EMC_28   /*!< Pin name */
#define BOARD_INITSDRAM_SEMC_WE_LABEL                                  "SEMC_WE"   /*!< Label */
#define BOARD_INITSDRAM_SEMC_WE_NAME                                   "SEMC_WE"   /*!< Identifier name */

/* GPIO_EMC_41 (coord C7), ENET_MDIO */
#define BOARD_INITSDRAM_ENET_MDIO_PERIPHERAL                                SEMC   /*!< Device name: SEMC */
#define BOARD_INITSDRAM_ENET_MDIO_SIGNAL                                     CSX   /*!< SEMC signal: CSX */
#define BOARD_INITSDRAM_ENET_MDIO_CHANNEL                                     0U   /*!< SEMC CSX channel: 0 */
#define BOARD_INITSDRAM_ENET_MDIO_PIN_NAME                           GPIO_EMC_41   /*!< Pin name */
#define BOARD_INITSDRAM_ENET_MDIO_LABEL                              "ENET_MDIO"   /*!< Label */
#define BOARD_INITSDRAM_ENET_MDIO_NAME                               "ENET_MDIO"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitSDRAM(void);

/* GPIO_AD_B1_08 (coord H13), AUD_INT/CSI_D9//J35[13]/J22[4] */
#define BOARD_INITCSI_CSI_D9_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D9_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D9_CHANNEL                                          9U   /*!< CSI csi_data channel: 09 */
#define BOARD_INITCSI_CSI_D9_PIN_NAME                              GPIO_AD_B1_08   /*!< Pin name */
#define BOARD_INITCSI_CSI_D9_LABEL              "AUD_INT/CSI_D9//J35[13]/J22[4]"   /*!< Label */
#define BOARD_INITCSI_CSI_D9_NAME                                       "CSI_D9"   /*!< Identifier name */

/* GPIO_AD_B1_09 (coord M13), SAI1_MCLK/CSI_D8/J35[11] */
#define BOARD_INITCSI_CSI_D8_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D8_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D8_CHANNEL                                          8U   /*!< CSI csi_data channel: 08 */
#define BOARD_INITCSI_CSI_D8_PIN_NAME                              GPIO_AD_B1_09   /*!< Pin name */
#define BOARD_INITCSI_CSI_D8_LABEL                    "SAI1_MCLK/CSI_D8/J35[11]"   /*!< Label */
#define BOARD_INITCSI_CSI_D8_NAME                                       "CSI_D8"   /*!< Identifier name */

/* GPIO_AD_B1_10 (coord L13), SAI1_RX_SYNC/CSI_D7/J35[9]/J23[1] */
#define BOARD_INITCSI_CSI_D7_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D7_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D7_CHANNEL                                          7U   /*!< CSI csi_data channel: 07 */
#define BOARD_INITCSI_CSI_D7_PIN_NAME                              GPIO_AD_B1_10   /*!< Pin name */
#define BOARD_INITCSI_CSI_D7_LABEL           "SAI1_RX_SYNC/CSI_D7/J35[9]/J23[1]"   /*!< Label */
#define BOARD_INITCSI_CSI_D7_NAME                                       "CSI_D7"   /*!< Identifier name */

/* GPIO_AD_B1_11 (coord J13), SAI1_RX_BCLK/CSI_D6/J35[7]/J23[2] */
#define BOARD_INITCSI_CSI_D6_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D6_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D6_CHANNEL                                          6U   /*!< CSI csi_data channel: 06 */
#define BOARD_INITCSI_CSI_D6_PIN_NAME                              GPIO_AD_B1_11   /*!< Pin name */
#define BOARD_INITCSI_CSI_D6_LABEL           "SAI1_RX_BCLK/CSI_D6/J35[7]/J23[2]"   /*!< Label */
#define BOARD_INITCSI_CSI_D6_NAME                                       "CSI_D6"   /*!< Identifier name */

/* GPIO_AD_B1_12 (coord H12), SAI1_RXD/CSI_D5/J35[5]/U13[16] */
#define BOARD_INITCSI_CSI_D5_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D5_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D5_CHANNEL                                          5U   /*!< CSI csi_data channel: 05 */
#define BOARD_INITCSI_CSI_D5_PIN_NAME                              GPIO_AD_B1_12   /*!< Pin name */
#define BOARD_INITCSI_CSI_D5_LABEL              "SAI1_RXD/CSI_D5/J35[5]/U13[16]"   /*!< Label */
#define BOARD_INITCSI_CSI_D5_NAME                                       "CSI_D5"   /*!< Identifier name */

/* GPIO_AD_B1_13 (coord H11), SAI1_TXD/CSI_D4/J35[3]/U13[14] */
#define BOARD_INITCSI_CSI_D4_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D4_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D4_CHANNEL                                          4U   /*!< CSI csi_data channel: 04 */
#define BOARD_INITCSI_CSI_D4_PIN_NAME                              GPIO_AD_B1_13   /*!< Pin name */
#define BOARD_INITCSI_CSI_D4_LABEL              "SAI1_TXD/CSI_D4/J35[3]/U13[14]"   /*!< Label */
#define BOARD_INITCSI_CSI_D4_NAME                                       "CSI_D4"   /*!< Identifier name */

/* GPIO_AD_B1_15 (coord J14), SAI1_TX_SYNC/CSI_D2/J35[6]/U13[13] */
#define BOARD_INITCSI_CSI_D2_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D2_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D2_CHANNEL                                          2U   /*!< CSI csi_data channel: 02 */
#define BOARD_INITCSI_CSI_D2_PIN_NAME                              GPIO_AD_B1_15   /*!< Pin name */
#define BOARD_INITCSI_CSI_D2_LABEL          "SAI1_TX_SYNC/CSI_D2/J35[6]/U13[13]"   /*!< Label */
#define BOARD_INITCSI_CSI_D2_NAME                                       "CSI_D2"   /*!< Identifier name */

/* GPIO_AD_B1_14 (coord G12), SAI1_TX_BCLK/CSI_D3/J35[4]/U13[12] */
#define BOARD_INITCSI_CSI_D3_PERIPHERAL                                      CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_D3_SIGNAL                                     csi_data   /*!< CSI signal: csi_data */
#define BOARD_INITCSI_CSI_D3_CHANNEL                                          3U   /*!< CSI csi_data channel: 03 */
#define BOARD_INITCSI_CSI_D3_PIN_NAME                              GPIO_AD_B1_14   /*!< Pin name */
#define BOARD_INITCSI_CSI_D3_LABEL          "SAI1_TX_BCLK/CSI_D3/J35[4]/U13[12]"   /*!< Label */
#define BOARD_INITCSI_CSI_D3_NAME                                       "CSI_D3"   /*!< Identifier name */

/* GPIO_AD_B1_04 (coord L12), CSI_PIXCLK/J35[8]/J23[3] */
#define BOARD_INITCSI_CSI_PIXCLK_PERIPHERAL                                  CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_PIXCLK_SIGNAL                               csi_pixclk   /*!< CSI signal: csi_pixclk */
#define BOARD_INITCSI_CSI_PIXCLK_PIN_NAME                          GPIO_AD_B1_04   /*!< Pin name */
#define BOARD_INITCSI_CSI_PIXCLK_LABEL                "CSI_PIXCLK/J35[8]/J23[3]"   /*!< Label */
#define BOARD_INITCSI_CSI_PIXCLK_NAME                               "CSI_PIXCLK"   /*!< Identifier name */

/* GPIO_AD_B1_05 (coord K12), CSI_MCLK/J35[12]/J23[4] */
#define BOARD_INITCSI_CSI_MCLK_PERIPHERAL                                    CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_MCLK_SIGNAL                                   csi_mclk   /*!< CSI signal: csi_mclk */
#define BOARD_INITCSI_CSI_MCLK_PIN_NAME                            GPIO_AD_B1_05   /*!< Pin name */
#define BOARD_INITCSI_CSI_MCLK_LABEL                   "CSI_MCLK/J35[12]/J23[4]"   /*!< Label */
#define BOARD_INITCSI_CSI_MCLK_NAME                                   "CSI_MCLK"   /*!< Identifier name */

/* GPIO_AD_B1_06 (coord J12), CSI_VSYNC/J35[18]/J22[2]/UART_TX */
#define BOARD_INITCSI_CSI_VSYNC_PERIPHERAL                                   CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_VSYNC_SIGNAL                                 csi_vsync   /*!< CSI signal: csi_vsync */
#define BOARD_INITCSI_CSI_VSYNC_PIN_NAME                           GPIO_AD_B1_06   /*!< Pin name */
#define BOARD_INITCSI_CSI_VSYNC_LABEL         "CSI_VSYNC/J35[18]/J22[2]/UART_TX"   /*!< Label */
#define BOARD_INITCSI_CSI_VSYNC_NAME                                 "CSI_VSYNC"   /*!< Identifier name */

/* GPIO_AD_B1_07 (coord K10), CSI_HSYNC/J35[16]/J22[1]/UART_RX */
#define BOARD_INITCSI_CSI_HSYNC_PERIPHERAL                                   CSI   /*!< Device name: CSI */
#define BOARD_INITCSI_CSI_HSYNC_SIGNAL                                 csi_hsync   /*!< CSI signal: csi_hsync */
#define BOARD_INITCSI_CSI_HSYNC_PIN_NAME                           GPIO_AD_B1_07   /*!< Pin name */
#define BOARD_INITCSI_CSI_HSYNC_LABEL         "CSI_HSYNC/J35[16]/J22[1]/UART_RX"   /*!< Label */
#define BOARD_INITCSI_CSI_HSYNC_NAME                                 "CSI_HSYNC"   /*!< Identifier name */

/* GPIO_AD_B1_00 (coord J11), I2C1_SCL/CSI_I2C_SCL/J35[20]/J23[6]/U13[17]/U32[4] */
#define BOARD_INITCSI_CSI_I2C_SCL_PERIPHERAL                              LPI2C1   /*!< Device name: LPI2C1 */
#define BOARD_INITCSI_CSI_I2C_SCL_SIGNAL                                     SCL   /*!< LPI2C1 signal: SCL */
#define BOARD_INITCSI_CSI_I2C_SCL_PIN_NAME                         GPIO_AD_B1_00   /*!< Pin name */
#define BOARD_INITCSI_CSI_I2C_SCL_LABEL "I2C1_SCL/CSI_I2C_SCL/J35[20]/J23[6]/U13[17]/U32[4]" /*!< Label */
#define BOARD_INITCSI_CSI_I2C_SCL_NAME                             "CSI_I2C_SCL"   /*!< Identifier name */

/* GPIO_AD_B1_01 (coord K11), I2C1_SDA/CSI_I2C_SDA/J35[22]/J23[5]/U13[18]/U32[6] */
#define BOARD_INITCSI_CSI_I2C_SDA_PERIPHERAL                              LPI2C1   /*!< Device name: LPI2C1 */
#define BOARD_INITCSI_CSI_I2C_SDA_SIGNAL                                     SDA   /*!< LPI2C1 signal: SDA */
#define BOARD_INITCSI_CSI_I2C_SDA_PIN_NAME                         GPIO_AD_B1_01   /*!< Pin name */
#define BOARD_INITCSI_CSI_I2C_SDA_LABEL "I2C1_SDA/CSI_I2C_SDA/J35[22]/J23[5]/U13[18]/U32[6]" /*!< Label */
#define BOARD_INITCSI_CSI_I2C_SDA_NAME                             "CSI_I2C_SDA"   /*!< Identifier name */

/* GPIO_AD_B0_04 (coord F11), CSI_PWDN/J35[17]/BOOT_MODE[0] */
#define BOARD_INITCSI_CSI_PWDN_GPIO                                        GPIO1   /*!< GPIO device name: GPIO1 */
#define BOARD_INITCSI_CSI_PWDN_PORT                                        GPIO1   /*!< PORT device name: GPIO1 */
#define BOARD_INITCSI_CSI_PWDN_GPIO_PIN                                       4U   /*!< GPIO1 pin index: 4 */
#define BOARD_INITCSI_CSI_PWDN_PIN_NAME                            GPIO_AD_B0_04   /*!< Pin name */
#define BOARD_INITCSI_CSI_PWDN_LABEL             "CSI_PWDN/J35[17]/BOOT_MODE[0]"   /*!< Label */
#define BOARD_INITCSI_CSI_PWDN_NAME                                   "CSI_PWDN"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitCSI(void);

/* GPIO_B0_04 (coord C8), LCDIF_D0/BT_CFG[0] */
#define BOARD_INITLCD_LCDIF_D0_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D0_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D0_CHANNEL                                        0U   /*!< LCDIF lcdif_data channel: 00 */
#define BOARD_INITLCD_LCDIF_D0_PIN_NAME                               GPIO_B0_04   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D0_LABEL                        "LCDIF_D0/BT_CFG[0]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D0_NAME                                   "LCDIF_D0"   /*!< Identifier name */

/* GPIO_B0_05 (coord B8), LCDIF_D1/BT_CFG[1] */
#define BOARD_INITLCD_LCDIF_D1_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D1_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D1_CHANNEL                                        1U   /*!< LCDIF lcdif_data channel: 01 */
#define BOARD_INITLCD_LCDIF_D1_PIN_NAME                               GPIO_B0_05   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D1_LABEL                        "LCDIF_D1/BT_CFG[1]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D1_NAME                                   "LCDIF_D1"   /*!< Identifier name */

/* GPIO_B0_06 (coord A8), LCDIF_D2/BT_CFG[2] */
#define BOARD_INITLCD_LCDIF_D2_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D2_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D2_CHANNEL                                        2U   /*!< LCDIF lcdif_data channel: 02 */
#define BOARD_INITLCD_LCDIF_D2_PIN_NAME                               GPIO_B0_06   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D2_LABEL                        "LCDIF_D2/BT_CFG[2]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D2_NAME                                   "LCDIF_D2"   /*!< Identifier name */

/* GPIO_B0_00 (coord D7), LCDIF_CLK */
#define BOARD_INITLCD_LCDIF_CLK_PERIPHERAL                                 LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_CLK_SIGNAL                                 lcdif_clk   /*!< LCDIF signal: lcdif_clk */
#define BOARD_INITLCD_LCDIF_CLK_PIN_NAME                              GPIO_B0_00   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_CLK_LABEL                                "LCDIF_CLK"   /*!< Label */
#define BOARD_INITLCD_LCDIF_CLK_NAME                                 "LCDIF_CLK"   /*!< Identifier name */

/* GPIO_B0_07 (coord A9), LCDIF_D3/BT_CFG[3] */
#define BOARD_INITLCD_LCDIF_D3_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D3_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D3_CHANNEL                                        3U   /*!< LCDIF lcdif_data channel: 03 */
#define BOARD_INITLCD_LCDIF_D3_PIN_NAME                               GPIO_B0_07   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D3_LABEL                        "LCDIF_D3/BT_CFG[3]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D3_NAME                                   "LCDIF_D3"   /*!< Identifier name */

/* GPIO_B0_08 (coord B9), LCDIF_D4/BT_CFG[4] */
#define BOARD_INITLCD_LCDIF_D4_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D4_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D4_CHANNEL                                        4U   /*!< LCDIF lcdif_data channel: 04 */
#define BOARD_INITLCD_LCDIF_D4_PIN_NAME                               GPIO_B0_08   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D4_LABEL                        "LCDIF_D4/BT_CFG[4]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D4_NAME                                   "LCDIF_D4"   /*!< Identifier name */

/* GPIO_B0_09 (coord C9), LCDIF_D5/BT_CFG[5] */
#define BOARD_INITLCD_LCDIF_D5_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D5_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D5_CHANNEL                                        5U   /*!< LCDIF lcdif_data channel: 05 */
#define BOARD_INITLCD_LCDIF_D5_PIN_NAME                               GPIO_B0_09   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D5_LABEL                        "LCDIF_D5/BT_CFG[5]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D5_NAME                                   "LCDIF_D5"   /*!< Identifier name */

/* GPIO_B0_10 (coord D9), LCDIF_D6/BT_CFG[6] */
#define BOARD_INITLCD_LCDIF_D6_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D6_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D6_CHANNEL                                        6U   /*!< LCDIF lcdif_data channel: 06 */
#define BOARD_INITLCD_LCDIF_D6_PIN_NAME                               GPIO_B0_10   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D6_LABEL                        "LCDIF_D6/BT_CFG[6]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D6_NAME                                   "LCDIF_D6"   /*!< Identifier name */

/* GPIO_B0_11 (coord A10), LCDIF_D7/BT_CFG[7] */
#define BOARD_INITLCD_LCDIF_D7_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D7_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D7_CHANNEL                                        7U   /*!< LCDIF lcdif_data channel: 07 */
#define BOARD_INITLCD_LCDIF_D7_PIN_NAME                               GPIO_B0_11   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D7_LABEL                        "LCDIF_D7/BT_CFG[7]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D7_NAME                                   "LCDIF_D7"   /*!< Identifier name */

/* GPIO_B0_12 (coord C10), LCDIF_D8/BT_CFG[8] */
#define BOARD_INITLCD_LCDIF_D8_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D8_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D8_CHANNEL                                        8U   /*!< LCDIF lcdif_data channel: 08 */
#define BOARD_INITLCD_LCDIF_D8_PIN_NAME                               GPIO_B0_12   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D8_LABEL                        "LCDIF_D8/BT_CFG[8]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D8_NAME                                   "LCDIF_D8"   /*!< Identifier name */

/* GPIO_B0_13 (coord D10), LCDIF_D9/BT_CFG[9] */
#define BOARD_INITLCD_LCDIF_D9_PERIPHERAL                                  LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D9_SIGNAL                                 lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D9_CHANNEL                                        9U   /*!< LCDIF lcdif_data channel: 09 */
#define BOARD_INITLCD_LCDIF_D9_PIN_NAME                               GPIO_B0_13   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D9_LABEL                        "LCDIF_D9/BT_CFG[9]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D9_NAME                                   "LCDIF_D9"   /*!< Identifier name */

/* GPIO_B0_14 (coord E10), LCDIF_D10/BT_CFG[10] */
#define BOARD_INITLCD_LCDIF_D10_PERIPHERAL                                 LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D10_SIGNAL                                lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D10_CHANNEL                                      10U   /*!< LCDIF lcdif_data channel: 10 */
#define BOARD_INITLCD_LCDIF_D10_PIN_NAME                              GPIO_B0_14   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D10_LABEL                     "LCDIF_D10/BT_CFG[10]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D10_NAME                                 "LCDIF_D10"   /*!< Identifier name */

/* GPIO_B0_15 (coord E11), LCDIF_D11/BT_CFG[11] */
#define BOARD_INITLCD_LCDIF_D11_PERIPHERAL                                 LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D11_SIGNAL                                lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D11_CHANNEL                                      11U   /*!< LCDIF lcdif_data channel: 11 */
#define BOARD_INITLCD_LCDIF_D11_PIN_NAME                              GPIO_B0_15   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D11_LABEL                     "LCDIF_D11/BT_CFG[11]"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D11_NAME                                 "LCDIF_D11"   /*!< Identifier name */

/* GPIO_B1_00 (coord A11), LCDIF_D12 */
#define BOARD_INITLCD_LCDIF_D12_PERIPHERAL                                 LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D12_SIGNAL                                lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D12_CHANNEL                                      12U   /*!< LCDIF lcdif_data channel: 12 */
#define BOARD_INITLCD_LCDIF_D12_PIN_NAME                              GPIO_B1_00   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D12_LABEL                                "LCDIF_D12"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D12_NAME                                 "LCDIF_D12"   /*!< Identifier name */

/* GPIO_B1_01 (coord B11), LCDIF_D13 */
#define BOARD_INITLCD_LCDIF_D13_PERIPHERAL                                 LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D13_SIGNAL                                lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D13_CHANNEL                                      13U   /*!< LCDIF lcdif_data channel: 13 */
#define BOARD_INITLCD_LCDIF_D13_PIN_NAME                              GPIO_B1_01   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D13_LABEL                                "LCDIF_D13"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D13_NAME                                 "LCDIF_D13"   /*!< Identifier name */

/* GPIO_B1_02 (coord C11), LCDIF_D14 */
#define BOARD_INITLCD_LCDIF_D14_PERIPHERAL                                 LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D14_SIGNAL                                lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D14_CHANNEL                                      14U   /*!< LCDIF lcdif_data channel: 14 */
#define BOARD_INITLCD_LCDIF_D14_PIN_NAME                              GPIO_B1_02   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D14_LABEL                                "LCDIF_D14"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D14_NAME                                 "LCDIF_D14"   /*!< Identifier name */

/* GPIO_B1_03 (coord D11), LCDIF_D15 */
#define BOARD_INITLCD_LCDIF_D15_PERIPHERAL                                 LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_D15_SIGNAL                                lcdif_data   /*!< LCDIF signal: lcdif_data */
#define BOARD_INITLCD_LCDIF_D15_CHANNEL                                      15U   /*!< LCDIF lcdif_data channel: 15 */
#define BOARD_INITLCD_LCDIF_D15_PIN_NAME                              GPIO_B1_03   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_D15_LABEL                                "LCDIF_D15"   /*!< Label */
#define BOARD_INITLCD_LCDIF_D15_NAME                                 "LCDIF_D15"   /*!< Identifier name */

/* GPIO_B0_01 (coord E7), LCDIF_ENABLE */
#define BOARD_INITLCD_LCDIF_ENABLE_PERIPHERAL                              LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_ENABLE_SIGNAL                           lcdif_enable   /*!< LCDIF signal: lcdif_enable */
#define BOARD_INITLCD_LCDIF_ENABLE_PIN_NAME                           GPIO_B0_01   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_ENABLE_LABEL                          "LCDIF_ENABLE"   /*!< Label */
#define BOARD_INITLCD_LCDIF_ENABLE_NAME                           "LCDIF_ENABLE"   /*!< Identifier name */

/* GPIO_B0_02 (coord E8), LCDIF_HSYNC */
#define BOARD_INITLCD_LCDIF_HSYNC_PERIPHERAL                               LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_HSYNC_SIGNAL                             lcdif_hsync   /*!< LCDIF signal: lcdif_hsync */
#define BOARD_INITLCD_LCDIF_HSYNC_PIN_NAME                            GPIO_B0_02   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_HSYNC_LABEL                            "LCDIF_HSYNC"   /*!< Label */
#define BOARD_INITLCD_LCDIF_HSYNC_NAME                             "LCDIF_HSYNC"   /*!< Identifier name */

/* GPIO_B0_03 (coord D8), LCDIF_VSYNC */
#define BOARD_INITLCD_LCDIF_VSYNC_PERIPHERAL                               LCDIF   /*!< Device name: LCDIF */
#define BOARD_INITLCD_LCDIF_VSYNC_SIGNAL                             lcdif_vsync   /*!< LCDIF signal: lcdif_vsync */
#define BOARD_INITLCD_LCDIF_VSYNC_PIN_NAME                            GPIO_B0_03   /*!< Pin name */
#define BOARD_INITLCD_LCDIF_VSYNC_LABEL                            "LCDIF_VSYNC"   /*!< Label */
#define BOARD_INITLCD_LCDIF_VSYNC_NAME                             "LCDIF_VSYNC"   /*!< Identifier name */

/* GPIO_B1_15 (coord B14), USB_HOST_PWR/BACKLIGHT_CTL */
#define BOARD_INITLCD_BACKLIGHT_CTL_GPIO                                   GPIO2   /*!< GPIO device name: GPIO2 */
#define BOARD_INITLCD_BACKLIGHT_CTL_PORT                                   GPIO2   /*!< PORT device name: GPIO2 */
#define BOARD_INITLCD_BACKLIGHT_CTL_GPIO_PIN                                 31U   /*!< GPIO2 pin index: 31 */
#define BOARD_INITLCD_BACKLIGHT_CTL_PIN_NAME                          GPIO_B1_15   /*!< Pin name */
#define BOARD_INITLCD_BACKLIGHT_CTL_LABEL           "USB_HOST_PWR/BACKLIGHT_CTL"   /*!< Label */
#define BOARD_INITLCD_BACKLIGHT_CTL_NAME                         "BACKLIGHT_CTL"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitLCD(void);

/* GPIO_AD_B0_14 (coord H14), CAN2_TX/U12[1] */
#define BOARD_INITCAN_CAN2_TX_PERIPHERAL                                    CAN2   /*!< Device name: CAN2 */
#define BOARD_INITCAN_CAN2_TX_SIGNAL                                          TX   /*!< CAN2 signal: TX */
#define BOARD_INITCAN_CAN2_TX_PIN_NAME                             GPIO_AD_B0_14   /*!< Pin name */
#define BOARD_INITCAN_CAN2_TX_LABEL                             "CAN2_TX/U12[1]"   /*!< Label */
#define BOARD_INITCAN_CAN2_TX_NAME                                     "CAN2_TX"   /*!< Identifier name */

/* GPIO_AD_B0_15 (coord L10), CAN2_RX/U12[4] */
#define BOARD_INITCAN_CAN2_RX_PERIPHERAL                                    CAN2   /*!< Device name: CAN2 */
#define BOARD_INITCAN_CAN2_RX_SIGNAL                                          RX   /*!< CAN2 signal: RX */
#define BOARD_INITCAN_CAN2_RX_PIN_NAME                             GPIO_AD_B0_15   /*!< Pin name */
#define BOARD_INITCAN_CAN2_RX_LABEL                             "CAN2_RX/U12[4]"   /*!< Label */
#define BOARD_INITCAN_CAN2_RX_NAME                                     "CAN2_RX"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitCAN(void);

/* GPIO_EMC_40 (coord A7), ENET_MDC */
#define BOARD_INITENET_ENET_MDC_PERIPHERAL                                  ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_MDC_SIGNAL                                  enet_mdc   /*!< ENET signal: enet_mdc */
#define BOARD_INITENET_ENET_MDC_PIN_NAME                             GPIO_EMC_40   /*!< Pin name */
#define BOARD_INITENET_ENET_MDC_LABEL                                 "ENET_MDC"   /*!< Label */
#define BOARD_INITENET_ENET_MDC_NAME                                  "ENET_MDC"   /*!< Identifier name */

/* GPIO_EMC_41 (coord C7), ENET_MDIO */
#define BOARD_INITENET_ENET_MDIO_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_MDIO_SIGNAL                                enet_mdio   /*!< ENET signal: enet_mdio */
#define BOARD_INITENET_ENET_MDIO_PIN_NAME                            GPIO_EMC_41   /*!< Pin name */
#define BOARD_INITENET_ENET_MDIO_LABEL                               "ENET_MDIO"   /*!< Label */
#define BOARD_INITENET_ENET_MDIO_NAME                                "ENET_MDIO"   /*!< Identifier name */

/* GPIO_B1_10 (coord B13), ENET_TX_CLK */
#define BOARD_INITENET_ENET_TX_CLK_PERIPHERAL                               ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_TX_CLK_SIGNAL                           enet_ref_clk   /*!< ENET signal: enet_ref_clk */
#define BOARD_INITENET_ENET_TX_CLK_PIN_NAME                           GPIO_B1_10   /*!< Pin name */
#define BOARD_INITENET_ENET_TX_CLK_LABEL                           "ENET_TX_CLK"   /*!< Label */
#define BOARD_INITENET_ENET_TX_CLK_NAME                            "ENET_TX_CLK"   /*!< Identifier name */

/* GPIO_B1_04 (coord E12), ENET_RXD0 */
#define BOARD_INITENET_ENET_RXD0_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_RXD0_SIGNAL                             enet_rx_data   /*!< ENET signal: enet_rx_data */
#define BOARD_INITENET_ENET_RXD0_CHANNEL                                      0U   /*!< ENET enet_rx_data channel: 0 */
#define BOARD_INITENET_ENET_RXD0_PIN_NAME                             GPIO_B1_04   /*!< Pin name */
#define BOARD_INITENET_ENET_RXD0_LABEL                               "ENET_RXD0"   /*!< Label */
#define BOARD_INITENET_ENET_RXD0_NAME                                "ENET_RXD0"   /*!< Identifier name */

/* GPIO_B1_05 (coord D12), ENET_RXD1 */
#define BOARD_INITENET_ENET_RXD1_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_RXD1_SIGNAL                             enet_rx_data   /*!< ENET signal: enet_rx_data */
#define BOARD_INITENET_ENET_RXD1_CHANNEL                                      1U   /*!< ENET enet_rx_data channel: 1 */
#define BOARD_INITENET_ENET_RXD1_PIN_NAME                             GPIO_B1_05   /*!< Pin name */
#define BOARD_INITENET_ENET_RXD1_LABEL                               "ENET_RXD1"   /*!< Label */
#define BOARD_INITENET_ENET_RXD1_NAME                                "ENET_RXD1"   /*!< Identifier name */

/* GPIO_B1_06 (coord C12), ENET_CRS_DV */
#define BOARD_INITENET_ENET_CRS_DV_PERIPHERAL                               ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_CRS_DV_SIGNAL                             enet_rx_en   /*!< ENET signal: enet_rx_en */
#define BOARD_INITENET_ENET_CRS_DV_PIN_NAME                           GPIO_B1_06   /*!< Pin name */
#define BOARD_INITENET_ENET_CRS_DV_LABEL                           "ENET_CRS_DV"   /*!< Label */
#define BOARD_INITENET_ENET_CRS_DV_NAME                            "ENET_CRS_DV"   /*!< Identifier name */

/* GPIO_B1_11 (coord C13), ENET_RXER */
#define BOARD_INITENET_ENET_RXER_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_RXER_SIGNAL                               enet_rx_er   /*!< ENET signal: enet_rx_er */
#define BOARD_INITENET_ENET_RXER_PIN_NAME                             GPIO_B1_11   /*!< Pin name */
#define BOARD_INITENET_ENET_RXER_LABEL                               "ENET_RXER"   /*!< Label */
#define BOARD_INITENET_ENET_RXER_NAME                                "ENET_RXER"   /*!< Identifier name */

/* GPIO_B1_07 (coord B12), ENET_TXD0 */
#define BOARD_INITENET_ENET_TXD0_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_TXD0_SIGNAL                             enet_tx_data   /*!< ENET signal: enet_tx_data */
#define BOARD_INITENET_ENET_TXD0_CHANNEL                                      0U   /*!< ENET enet_tx_data channel: 0 */
#define BOARD_INITENET_ENET_TXD0_PIN_NAME                             GPIO_B1_07   /*!< Pin name */
#define BOARD_INITENET_ENET_TXD0_LABEL                               "ENET_TXD0"   /*!< Label */
#define BOARD_INITENET_ENET_TXD0_NAME                                "ENET_TXD0"   /*!< Identifier name */

/* GPIO_B1_08 (coord A12), ENET_TXD1 */
#define BOARD_INITENET_ENET_TXD1_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_TXD1_SIGNAL                             enet_tx_data   /*!< ENET signal: enet_tx_data */
#define BOARD_INITENET_ENET_TXD1_CHANNEL                                      1U   /*!< ENET enet_tx_data channel: 1 */
#define BOARD_INITENET_ENET_TXD1_PIN_NAME                             GPIO_B1_08   /*!< Pin name */
#define BOARD_INITENET_ENET_TXD1_LABEL                               "ENET_TXD1"   /*!< Label */
#define BOARD_INITENET_ENET_TXD1_NAME                                "ENET_TXD1"   /*!< Identifier name */

/* GPIO_B1_09 (coord A13), ENET_TXEN */
#define BOARD_INITENET_ENET_TXEN_PERIPHERAL                                 ENET   /*!< Device name: ENET */
#define BOARD_INITENET_ENET_TXEN_SIGNAL                               enet_tx_en   /*!< ENET signal: enet_tx_en */
#define BOARD_INITENET_ENET_TXEN_PIN_NAME                             GPIO_B1_09   /*!< Pin name */
#define BOARD_INITENET_ENET_TXEN_LABEL                               "ENET_TXEN"   /*!< Label */
#define BOARD_INITENET_ENET_TXEN_NAME                                "ENET_TXEN"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitENET(void);

/* GPIO_SD_B0_05 (coord J2), SD1_D3 */
#define BOARD_INITUSDHC_SD1_D3_PERIPHERAL                                 USDHC1   /*!< Device name: USDHC1 */
#define BOARD_INITUSDHC_SD1_D3_SIGNAL                                 usdhc_data   /*!< USDHC1 signal: usdhc_data */
#define BOARD_INITUSDHC_SD1_D3_CHANNEL                                        3U   /*!< USDHC1 usdhc_data channel: 3 */
#define BOARD_INITUSDHC_SD1_D3_PIN_NAME                            GPIO_SD_B0_05   /*!< Pin name */
#define BOARD_INITUSDHC_SD1_D3_LABEL                                    "SD1_D3"   /*!< Label */
#define BOARD_INITUSDHC_SD1_D3_NAME                                     "SD1_D3"   /*!< Identifier name */

/* GPIO_SD_B0_04 (coord H2), SD1_D2 */
#define BOARD_INITUSDHC_SD1_D2_PERIPHERAL                                 USDHC1   /*!< Device name: USDHC1 */
#define BOARD_INITUSDHC_SD1_D2_SIGNAL                                 usdhc_data   /*!< USDHC1 signal: usdhc_data */
#define BOARD_INITUSDHC_SD1_D2_CHANNEL                                        2U   /*!< USDHC1 usdhc_data channel: 2 */
#define BOARD_INITUSDHC_SD1_D2_PIN_NAME                            GPIO_SD_B0_04   /*!< Pin name */
#define BOARD_INITUSDHC_SD1_D2_LABEL                                    "SD1_D2"   /*!< Label */
#define BOARD_INITUSDHC_SD1_D2_NAME                                     "SD1_D2"   /*!< Identifier name */

/* GPIO_SD_B0_03 (coord K1), SD1_D1/J24[5]/SPI_MISO */
#define BOARD_INITUSDHC_SD1_D1_PERIPHERAL                                 USDHC1   /*!< Device name: USDHC1 */
#define BOARD_INITUSDHC_SD1_D1_SIGNAL                                 usdhc_data   /*!< USDHC1 signal: usdhc_data */
#define BOARD_INITUSDHC_SD1_D1_CHANNEL                                        1U   /*!< USDHC1 usdhc_data channel: 1 */
#define BOARD_INITUSDHC_SD1_D1_PIN_NAME                            GPIO_SD_B0_03   /*!< Pin name */
#define BOARD_INITUSDHC_SD1_D1_LABEL                    "SD1_D1/J24[5]/SPI_MISO"   /*!< Label */
#define BOARD_INITUSDHC_SD1_D1_NAME                                     "SD1_D1"   /*!< Identifier name */

/* GPIO_SD_B0_02 (coord J1), SD1_D0/J24[4]/SPI_MOSI/PWM */
#define BOARD_INITUSDHC_SD1_D0_PERIPHERAL                                 USDHC1   /*!< Device name: USDHC1 */
#define BOARD_INITUSDHC_SD1_D0_SIGNAL                                 usdhc_data   /*!< USDHC1 signal: usdhc_data */
#define BOARD_INITUSDHC_SD1_D0_CHANNEL                                        0U   /*!< USDHC1 usdhc_data channel: 0 */
#define BOARD_INITUSDHC_SD1_D0_PIN_NAME                            GPIO_SD_B0_02   /*!< Pin name */
#define BOARD_INITUSDHC_SD1_D0_LABEL                "SD1_D0/J24[4]/SPI_MOSI/PWM"   /*!< Label */
#define BOARD_INITUSDHC_SD1_D0_NAME                                     "SD1_D0"   /*!< Identifier name */

/* GPIO_SD_B0_00 (coord J4), SD1_CMD/J24[6] */
#define BOARD_INITUSDHC_SD1_CMD_PERIPHERAL                                USDHC1   /*!< Device name: USDHC1 */
#define BOARD_INITUSDHC_SD1_CMD_SIGNAL                                 usdhc_cmd   /*!< USDHC1 signal: usdhc_cmd */
#define BOARD_INITUSDHC_SD1_CMD_PIN_NAME                           GPIO_SD_B0_00   /*!< Pin name */
#define BOARD_INITUSDHC_SD1_CMD_LABEL                           "SD1_CMD/J24[6]"   /*!< Label */
#define BOARD_INITUSDHC_SD1_CMD_NAME                                   "SD1_CMD"   /*!< Identifier name */

/* GPIO_SD_B0_01 (coord J3), SD1_CLK/J24[3] */
#define BOARD_INITUSDHC_SD1_CLK_PERIPHERAL                                USDHC1   /*!< Device name: USDHC1 */
#define BOARD_INITUSDHC_SD1_CLK_SIGNAL                                 usdhc_clk   /*!< USDHC1 signal: usdhc_clk */
#define BOARD_INITUSDHC_SD1_CLK_PIN_NAME                           GPIO_SD_B0_01   /*!< Pin name */
#define BOARD_INITUSDHC_SD1_CLK_LABEL                           "SD1_CLK/J24[3]"   /*!< Label */
#define BOARD_INITUSDHC_SD1_CLK_NAME                                   "SD1_CLK"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitUSDHC(void);

/* GPIO_SD_B1_07 (coord L4), FlexSPI_CLK */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_PERIPHERAL                      FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_SIGNAL                   FLEXSPI_A_SCLK   /*!< FLEXSPI signal: FLEXSPI_A_SCLK */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_PIN_NAME                  GPIO_SD_B1_07   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_LABEL                     "FlexSPI_CLK"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_NAME                      "FlexSPI_CLK"   /*!< Identifier name */

/* GPIO_SD_B1_10 (coord P4), FlexSPI_D2_A */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_A_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_A_SIGNAL                 FLEXSPI_A_DATA2   /*!< FLEXSPI signal: FLEXSPI_A_DATA2 */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_A_PIN_NAME                 GPIO_SD_B1_10   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_A_LABEL                   "FlexSPI_D2_A"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_A_NAME                    "FlexSPI_D2_A"   /*!< Identifier name */

/* GPIO_SD_B1_08 (coord P3), FlexSPI_D0_A */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_A_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_A_SIGNAL                 FLEXSPI_A_DATA0   /*!< FLEXSPI signal: FLEXSPI_A_DATA0 */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_A_PIN_NAME                 GPIO_SD_B1_08   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_A_LABEL                   "FlexSPI_D0_A"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_A_NAME                    "FlexSPI_D0_A"   /*!< Identifier name */

/* GPIO_SD_B1_09 (coord N4), FlexSPI_D1_A */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_A_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_A_SIGNAL                 FLEXSPI_A_DATA1   /*!< FLEXSPI signal: FLEXSPI_A_DATA1 */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_A_PIN_NAME                 GPIO_SD_B1_09   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_A_LABEL                   "FlexSPI_D1_A"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_A_NAME                    "FlexSPI_D1_A"   /*!< Identifier name */

/* GPIO_SD_B1_00 (coord L5), FlexSPI_D3_B */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_B_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_B_SIGNAL                 FLEXSPI_B_DATA3   /*!< FLEXSPI signal: FLEXSPI_B_DATA3 */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_B_PIN_NAME                 GPIO_SD_B1_00   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_B_LABEL                   "FlexSPI_D3_B"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_B_NAME                    "FlexSPI_D3_B"   /*!< Identifier name */

/* GPIO_SD_B1_01 (coord M5), FlexSPI_D2_B */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_B_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_B_SIGNAL                 FLEXSPI_B_DATA2   /*!< FLEXSPI signal: FLEXSPI_B_DATA2 */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_B_PIN_NAME                 GPIO_SD_B1_01   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_B_LABEL                   "FlexSPI_D2_B"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D2_B_NAME                    "FlexSPI_D2_B"   /*!< Identifier name */

/* GPIO_SD_B1_02 (coord M3), FlexSPI_D1_B */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_B_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_B_SIGNAL                 FLEXSPI_B_DATA1   /*!< FLEXSPI signal: FLEXSPI_B_DATA1 */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_B_PIN_NAME                 GPIO_SD_B1_02   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_B_LABEL                   "FlexSPI_D1_B"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D1_B_NAME                    "FlexSPI_D1_B"   /*!< Identifier name */

/* GPIO_SD_B1_03 (coord M4), FlexSPI_D0_B */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_B_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_B_SIGNAL                 FLEXSPI_B_DATA0   /*!< FLEXSPI signal: FLEXSPI_B_DATA0 */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_B_PIN_NAME                 GPIO_SD_B1_03   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_B_LABEL                   "FlexSPI_D0_B"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D0_B_NAME                    "FlexSPI_D0_B"   /*!< Identifier name */

/* GPIO_SD_B1_04 (coord P2), FlexSPI_CLK_B */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_B_PERIPHERAL                    FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_B_SIGNAL                 FLEXSPI_B_SCLK   /*!< FLEXSPI signal: FLEXSPI_B_SCLK */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_B_PIN_NAME                GPIO_SD_B1_04   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_B_LABEL                 "FlexSPI_CLK_B"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_CLK_B_NAME                  "FlexSPI_CLK_B"   /*!< Identifier name */

/* GPIO_SD_B1_06 (coord L3), FlexSPI_SS0 */
#define BOARD_INITHYPERFLASH_FlexSPI_SS0_PERIPHERAL                      FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_SS0_SIGNAL                  FLEXSPI_A_SS0_B   /*!< FLEXSPI signal: FLEXSPI_A_SS0_B */
#define BOARD_INITHYPERFLASH_FlexSPI_SS0_PIN_NAME                  GPIO_SD_B1_06   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_SS0_LABEL                     "FlexSPI_SS0"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_SS0_NAME                      "FlexSPI_SS0"   /*!< Identifier name */

/* GPIO_SD_B1_11 (coord P5), FlexSPI_D3_A */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_A_PERIPHERAL                     FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_A_SIGNAL                 FLEXSPI_A_DATA3   /*!< FLEXSPI signal: FLEXSPI_A_DATA3 */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_A_PIN_NAME                 GPIO_SD_B1_11   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_A_LABEL                   "FlexSPI_D3_A"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_D3_A_NAME                    "FlexSPI_D3_A"   /*!< Identifier name */

/* GPIO_SD_B1_05 (coord N3), FlexSPI_DQS */
#define BOARD_INITHYPERFLASH_FlexSPI_DQS_PERIPHERAL                      FLEXSPI   /*!< Device name: FLEXSPI */
#define BOARD_INITHYPERFLASH_FlexSPI_DQS_SIGNAL                    FLEXSPI_A_DQS   /*!< FLEXSPI signal: FLEXSPI_A_DQS */
#define BOARD_INITHYPERFLASH_FlexSPI_DQS_PIN_NAME                  GPIO_SD_B1_05   /*!< Pin name */
#define BOARD_INITHYPERFLASH_FlexSPI_DQS_LABEL                     "FlexSPI_DQS"   /*!< Label */
#define BOARD_INITHYPERFLASH_FlexSPI_DQS_NAME                      "FlexSPI_DQS"   /*!< Identifier name */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitHyperFlash(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
