/* Copyright 2018-2019 Google LLC
 *
 * This is part of the Google Cloud IoT Device SDK for Embedded C.
 * It is licensed under the BSD 3-Clause license; you may not use this file
 * except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *  https://opensource.org/licenses/BSD-3-Clause
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "iotc_RootCA_list.h"

/* generated by create_buffer.py from a PEM file. Example:
 * ./create_buffer.py --file_name res/trusted_RootCA_certs/roots.pem
 *    --array_name iotc_RootCA_list --out_path src/libiotc/tls/certs
 * --no-pretend
 *
 * The buffer is terminated with '\n' for consistency with POSIX filesystem
 * reads
 */
const unsigned char iotc_RootCA_list[IOTC_ROOTCA_LIST_BYTE_LENGTH] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43,
    0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x42, 0x78, 0x54, 0x43, 0x43,
    0x41, 0x57, 0x75, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x4e,
    0x41, 0x66, 0x44, 0x33, 0x6e, 0x56, 0x6e, 0x64, 0x62, 0x6c, 0x44, 0x33,
    0x51, 0x6e, 0x4e, 0x78, 0x55, 0x44, 0x41, 0x4b, 0x42, 0x67, 0x67, 0x71,
    0x68, 0x6b, 0x6a, 0x4f, 0x50, 0x51, 0x51, 0x44, 0x41, 0x6a, 0x42, 0x45,
    0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x0a, 0x56, 0x51, 0x51,
    0x47, 0x45, 0x77, 0x4a, 0x56, 0x55, 0x7a, 0x45, 0x69, 0x4d, 0x43, 0x41,
    0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x68, 0x4d, 0x5a, 0x52, 0x32, 0x39,
    0x76, 0x5a, 0x32, 0x78, 0x6c, 0x49, 0x46, 0x52, 0x79, 0x64, 0x58, 0x4e,
    0x30, 0x49, 0x46, 0x4e, 0x6c, 0x63, 0x6e, 0x5a, 0x70, 0x59, 0x32, 0x56,
    0x7a, 0x49, 0x45, 0x78, 0x4d, 0x51, 0x7a, 0x45, 0x52, 0x4d, 0x41, 0x38,
    0x47, 0x0a, 0x41, 0x31, 0x55, 0x45, 0x41, 0x78, 0x4d, 0x49, 0x52, 0x31,
    0x52, 0x54, 0x49, 0x45, 0x78, 0x55, 0x55, 0x31, 0x49, 0x77, 0x48, 0x68,
    0x63, 0x4e, 0x4d, 0x54, 0x67, 0x78, 0x4d, 0x54, 0x41, 0x78, 0x4d, 0x44,
    0x41, 0x77, 0x4d, 0x44, 0x51, 0x79, 0x57, 0x68, 0x63, 0x4e, 0x4e, 0x44,
    0x49, 0x78, 0x4d, 0x54, 0x41, 0x78, 0x4d, 0x44, 0x41, 0x77, 0x4d, 0x44,
    0x51, 0x79, 0x57, 0x6a, 0x42, 0x45, 0x0a, 0x4d, 0x51, 0x73, 0x77, 0x43,
    0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x45, 0x77, 0x4a, 0x56, 0x55,
    0x7a, 0x45, 0x69, 0x4d, 0x43, 0x41, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43,
    0x68, 0x4d, 0x5a, 0x52, 0x32, 0x39, 0x76, 0x5a, 0x32, 0x78, 0x6c, 0x49,
    0x46, 0x52, 0x79, 0x64, 0x58, 0x4e, 0x30, 0x49, 0x46, 0x4e, 0x6c, 0x63,
    0x6e, 0x5a, 0x70, 0x59, 0x32, 0x56, 0x7a, 0x49, 0x45, 0x78, 0x4d, 0x0a,
    0x51, 0x7a, 0x45, 0x52, 0x4d, 0x41, 0x38, 0x47, 0x41, 0x31, 0x55, 0x45,
    0x41, 0x78, 0x4d, 0x49, 0x52, 0x31, 0x52, 0x54, 0x49, 0x45, 0x78, 0x55,
    0x55, 0x31, 0x49, 0x77, 0x57, 0x54, 0x41, 0x54, 0x42, 0x67, 0x63, 0x71,
    0x68, 0x6b, 0x6a, 0x4f, 0x50, 0x51, 0x49, 0x42, 0x42, 0x67, 0x67, 0x71,
    0x68, 0x6b, 0x6a, 0x4f, 0x50, 0x51, 0x4d, 0x42, 0x42, 0x77, 0x4e, 0x43,
    0x41, 0x41, 0x54, 0x4e, 0x0a, 0x38, 0x59, 0x79, 0x4f, 0x32, 0x75, 0x2b,
    0x79, 0x43, 0x51, 0x6f, 0x5a, 0x64, 0x77, 0x41, 0x6b, 0x55, 0x4e, 0x76,
    0x35, 0x63, 0x33, 0x64, 0x6f, 0x6b, 0x66, 0x55, 0x4c, 0x66, 0x72, 0x41,
    0x36, 0x51, 0x4a, 0x67, 0x46, 0x56, 0x32, 0x58, 0x4d, 0x75, 0x45, 0x4e,
    0x74, 0x51, 0x5a, 0x49, 0x47, 0x35, 0x48, 0x55, 0x4f, 0x53, 0x36, 0x6a,
    0x46, 0x6e, 0x38, 0x66, 0x30, 0x79, 0x53, 0x6c, 0x56, 0x0a, 0x65, 0x4f,
    0x52, 0x43, 0x78, 0x71, 0x46, 0x79, 0x6a, 0x44, 0x4a, 0x79, 0x52, 0x6e,
    0x38, 0x36, 0x64, 0x2b, 0x49, 0x6b, 0x6f, 0x30, 0x49, 0x77, 0x51, 0x44,
    0x41, 0x4f, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x51, 0x38, 0x42, 0x41, 0x66,
    0x38, 0x45, 0x42, 0x41, 0x4d, 0x43, 0x41, 0x59, 0x59, 0x77, 0x44, 0x77,
    0x59, 0x44, 0x56, 0x52, 0x30, 0x54, 0x41, 0x51, 0x48, 0x2f, 0x42, 0x41,
    0x55, 0x77, 0x0a, 0x41, 0x77, 0x45, 0x42, 0x2f, 0x7a, 0x41, 0x64, 0x42,
    0x67, 0x4e, 0x56, 0x48, 0x51, 0x34, 0x45, 0x46, 0x67, 0x51, 0x55, 0x50,
    0x76, 0x37, 0x2f, 0x7a, 0x46, 0x4c, 0x72, 0x76, 0x7a, 0x51, 0x2b, 0x50,
    0x66, 0x4e, 0x41, 0x30, 0x4f, 0x51, 0x6c, 0x73, 0x56, 0x2b, 0x34, 0x75,
    0x31, 0x49, 0x77, 0x43, 0x67, 0x59, 0x49, 0x4b, 0x6f, 0x5a, 0x49, 0x7a,
    0x6a, 0x30, 0x45, 0x41, 0x77, 0x49, 0x44, 0x0a, 0x53, 0x41, 0x41, 0x77,
    0x52, 0x51, 0x49, 0x68, 0x41, 0x50, 0x4b, 0x75, 0x66, 0x2f, 0x56, 0x74,
    0x42, 0x48, 0x71, 0x47, 0x77, 0x33, 0x54, 0x55, 0x77, 0x55, 0x49, 0x71,
    0x37, 0x54, 0x66, 0x61, 0x45, 0x78, 0x70, 0x33, 0x62, 0x48, 0x37, 0x62,
    0x6a, 0x43, 0x42, 0x6d, 0x56, 0x58, 0x4a, 0x75, 0x70, 0x54, 0x39, 0x46,
    0x41, 0x69, 0x42, 0x72, 0x30, 0x53, 0x6d, 0x43, 0x74, 0x73, 0x75, 0x6b,
    0x0a, 0x6d, 0x69, 0x47, 0x67, 0x70, 0x61, 0x6a, 0x6a, 0x66, 0x2f, 0x67,
    0x46, 0x69, 0x67, 0x47, 0x4d, 0x33, 0x34, 0x46, 0x39, 0x30, 0x32, 0x31,
    0x62, 0x43, 0x57, 0x73, 0x31, 0x4d, 0x62, 0x4c, 0x30, 0x53, 0x41, 0x3d,
    0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x43,
    0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47,
    0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41,
    0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x42,
    0x34, 0x54, 0x43, 0x43, 0x41, 0x59, 0x65, 0x67, 0x41, 0x77, 0x49, 0x42,
    0x41, 0x67, 0x49, 0x52, 0x4b, 0x6a, 0x69, 0x6b, 0x48, 0x4a, 0x59, 0x4b,
    0x42, 0x4e, 0x35, 0x43, 0x73, 0x69, 0x69, 0x6c, 0x43, 0x2b, 0x67, 0x30,
    0x6d, 0x41, 0x49, 0x77, 0x43, 0x67, 0x59, 0x49, 0x4b, 0x6f, 0x5a, 0x49,
    0x7a, 0x6a, 0x30, 0x45, 0x41, 0x77, 0x49, 0x77, 0x55, 0x44, 0x45, 0x6b,
    0x0a, 0x4d, 0x43, 0x49, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x78, 0x4d,
    0x62, 0x52, 0x32, 0x78, 0x76, 0x59, 0x6d, 0x46, 0x73, 0x55, 0x32, 0x6c,
    0x6e, 0x62, 0x69, 0x42, 0x46, 0x51, 0x30, 0x4d, 0x67, 0x55, 0x6d, 0x39,
    0x76, 0x64, 0x43, 0x42, 0x44, 0x51, 0x53, 0x41, 0x74, 0x49, 0x46, 0x49,
    0x30, 0x4d, 0x52, 0x4d, 0x77, 0x45, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51,
    0x4b, 0x45, 0x77, 0x70, 0x48, 0x0a, 0x62, 0x47, 0x39, 0x69, 0x59, 0x57,
    0x78, 0x54, 0x61, 0x57, 0x64, 0x75, 0x4d, 0x52, 0x4d, 0x77, 0x45, 0x51,
    0x59, 0x44, 0x56, 0x51, 0x51, 0x44, 0x45, 0x77, 0x70, 0x48, 0x62, 0x47,
    0x39, 0x69, 0x59, 0x57, 0x78, 0x54, 0x61, 0x57, 0x64, 0x75, 0x4d, 0x42,
    0x34, 0x58, 0x44, 0x54, 0x45, 0x79, 0x4d, 0x54, 0x45, 0x78, 0x4d, 0x7a,
    0x41, 0x77, 0x4d, 0x44, 0x41, 0x77, 0x4d, 0x46, 0x6f, 0x58, 0x0a, 0x44,
    0x54, 0x4d, 0x34, 0x4d, 0x44, 0x45, 0x78, 0x4f, 0x54, 0x41, 0x7a, 0x4d,
    0x54, 0x51, 0x77, 0x4e, 0x31, 0x6f, 0x77, 0x55, 0x44, 0x45, 0x6b, 0x4d,
    0x43, 0x49, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x78, 0x4d, 0x62, 0x52,
    0x32, 0x78, 0x76, 0x59, 0x6d, 0x46, 0x73, 0x55, 0x32, 0x6c, 0x6e, 0x62,
    0x69, 0x42, 0x46, 0x51, 0x30, 0x4d, 0x67, 0x55, 0x6d, 0x39, 0x76, 0x64,
    0x43, 0x42, 0x44, 0x0a, 0x51, 0x53, 0x41, 0x74, 0x49, 0x46, 0x49, 0x30,
    0x4d, 0x52, 0x4d, 0x77, 0x45, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4b,
    0x45, 0x77, 0x70, 0x48, 0x62, 0x47, 0x39, 0x69, 0x59, 0x57, 0x78, 0x54,
    0x61, 0x57, 0x64, 0x75, 0x4d, 0x52, 0x4d, 0x77, 0x45, 0x51, 0x59, 0x44,
    0x56, 0x51, 0x51, 0x44, 0x45, 0x77, 0x70, 0x48, 0x62, 0x47, 0x39, 0x69,
    0x59, 0x57, 0x78, 0x54, 0x61, 0x57, 0x64, 0x75, 0x0a, 0x4d, 0x46, 0x6b,
    0x77, 0x45, 0x77, 0x59, 0x48, 0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30,
    0x43, 0x41, 0x51, 0x59, 0x49, 0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30,
    0x44, 0x41, 0x51, 0x63, 0x44, 0x51, 0x67, 0x41, 0x45, 0x75, 0x4d, 0x5a,
    0x35, 0x30, 0x34, 0x39, 0x73, 0x4a, 0x51, 0x36, 0x66, 0x4c, 0x6a, 0x6b,
    0x5a, 0x48, 0x41, 0x4f, 0x6b, 0x72, 0x70, 0x72, 0x6c, 0x4f, 0x51, 0x63,
    0x4a, 0x0a, 0x46, 0x73, 0x70, 0x6a, 0x73, 0x62, 0x6d, 0x47, 0x2b, 0x49,
    0x70, 0x58, 0x77, 0x56, 0x66, 0x4f, 0x51, 0x76, 0x70, 0x7a, 0x6f, 0x66,
    0x64, 0x6c, 0x51, 0x76, 0x38, 0x65, 0x77, 0x51, 0x43, 0x79, 0x62, 0x6e,
    0x4d, 0x4f, 0x2f, 0x38, 0x63, 0x68, 0x35, 0x52, 0x69, 0x6b, 0x71, 0x74,
    0x6c, 0x78, 0x50, 0x36, 0x6a, 0x55, 0x75, 0x63, 0x36, 0x4d, 0x48, 0x61,
    0x4e, 0x43, 0x4d, 0x45, 0x41, 0x77, 0x0a, 0x44, 0x67, 0x59, 0x44, 0x56,
    0x52, 0x30, 0x50, 0x41, 0x51, 0x48, 0x2f, 0x42, 0x41, 0x51, 0x44, 0x41,
    0x67, 0x45, 0x47, 0x4d, 0x41, 0x38, 0x47, 0x41, 0x31, 0x55, 0x64, 0x45,
    0x77, 0x45, 0x42, 0x2f, 0x77, 0x51, 0x46, 0x4d, 0x41, 0x4d, 0x42, 0x41,
    0x66, 0x38, 0x77, 0x48, 0x51, 0x59, 0x44, 0x56, 0x52, 0x30, 0x4f, 0x42,
    0x42, 0x59, 0x45, 0x46, 0x46, 0x53, 0x77, 0x65, 0x36, 0x31, 0x46, 0x0a,
    0x75, 0x4f, 0x4a, 0x41, 0x66, 0x2f, 0x73, 0x4b, 0x62, 0x76, 0x75, 0x2b,
    0x4d, 0x38, 0x6b, 0x38, 0x6f, 0x34, 0x54, 0x56, 0x4d, 0x41, 0x6f, 0x47,
    0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39, 0x42, 0x41, 0x4d, 0x43,
    0x41, 0x30, 0x67, 0x41, 0x4d, 0x45, 0x55, 0x43, 0x49, 0x51, 0x44, 0x63,
    0x6b, 0x71, 0x47, 0x67, 0x45, 0x36, 0x62, 0x50, 0x41, 0x37, 0x44, 0x6d,
    0x78, 0x43, 0x47, 0x58, 0x0a, 0x6b, 0x50, 0x6f, 0x55, 0x56, 0x79, 0x30,
    0x44, 0x37, 0x4f, 0x34, 0x38, 0x30, 0x32, 0x37, 0x4b, 0x71, 0x47, 0x78,
    0x32, 0x76, 0x4b, 0x4c, 0x65, 0x75, 0x77, 0x49, 0x67, 0x4a, 0x36, 0x69,
    0x46, 0x4a, 0x7a, 0x57, 0x62, 0x56, 0x73, 0x61, 0x6a, 0x38, 0x6b, 0x66,
    0x53, 0x74, 0x32, 0x34, 0x62, 0x41, 0x67, 0x41, 0x58, 0x71, 0x6d, 0x65,
    0x6d, 0x46, 0x5a, 0x48, 0x65, 0x2b, 0x70, 0x54, 0x73, 0x0a, 0x65, 0x77,
    0x76, 0x34, 0x6e, 0x34, 0x51, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
    0x45, 0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43,
    0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x00};

#ifdef __cplusplus
}
#endif
