/***********************************************************************************************
* IMPORTANT. Read the following Freescale Software License Agreement (Agreement)             *
* completely. By selecting the I Accept button at the end of this page, you indicate         *
* that you accept the terms of this Agreement and you also acknowledge that you have the       *
* authority, on behalf of your company, to bind your company to such terms. You may then       *
* download or install the file.                                                                *
*                                                                                              *
* FREESCALE END-USER SOFTWARE LICENSE AGREEMENT                                                *
*                                                                                              *
* This is a license agreement between you (either as an individual or as an authorized         *
* representative acting on behalf of your employer) and Freescale Semiconductor,               *
* Inc. (Freescale). It concerns your rights to use the software provided to you in binary    *
* or source code form and any accompanying written materials (the Software). The Software    *
* may include any updates or error corrections or documentation relating to the Software       *
* provided to you by Freescale under this License. In consideration for Freescale allowing     *
* you to access the Software, you are agreeing to be bound by the terms of this Agreement.     *
* If you do not agree to all of the terms of this Agreement, do not download or install the    *
* Software. If you change your mind later, stop using the Software and delete all copies of    *
* the Software in your possession or control. Any copies of the Software that you have         *
* already distributed, where permitted, and do not destroy will continue to be governed by     *
* this Agreement. Your prior use will also continue to be governed by this Agreement.          *
*                                                                                              *
* 1. LICENSE GRANT. Freescale grants to you, free of charge, the non-exclusive,                *
* non-transferable, non-sublicensable right (1) to use the Software, (2) to reproduce the      *
* Software, (3) to prepare derivative works of the Software, and 4) to distribute the Software *
* and derivative works thereof in object (machine readable) form as part of a programmable     *
* processing unit (e.g. a microprocessor, microcontroller, or digital signal processor)        *
* supplied directly or indirectly from Freescale (Freescale System)                          *
*                                                                                              *
* You must notify Freescale, in writing, any time you create a derivative of the Software.     *
* Freescale owns all derivatives created from the Software, and derivatives are licensed       *
* to you under the same terms as the Software under this Agreement. Upon request, you must     *
* provide Freescale the source code of any derivative of the Software. If you violate any of   *
* the terms or restrictions of this Agreement, Freescale may immediately terminate this        *
* Agreement, and require that you stop using and delete all copies of the Software and any     *
* derivative in your possession or control. Any license granted above only extends to          *
* Freescale s intellectual property rights that would be necessarily infringed by the Software *
* as provided to you by Freescale and as used within the scope of the licenses granted. You    *
* must advise Freescale of any results obtained including any problems or suggested            *
* improvements thereof. Freescale retains the right to use such results and related            *
* information in any manner it deems appropriate.                                              *
*                                                                                              *
* 2. OTHER RESTRICTIONS. Subject to the license grant above, the following restrictions apply: *
*   a. Freescale reserves all rights not expressly granted herein.                             *
*   b. You may not rent, lease, sublicense, lend or encumber the Software, unless otherwise    *
*      expressly agreed to within this Agreement                                               *
*   c. You may not distribute, manufacture, have manufactured, sublicense or otherwise         *
*      reproduce the Software for purposes other than intended in this Agreement.              *
*   d. You may not remove or alter any proprietary legends, notices, or trademarks contained   *
*      in the Licensed Software,                                                               *
*   e. The terms and conditions of this Agreement will apply to any Software updates,          *
*      provided to you at Freescale s discretion, that replace and/or supplement the           *
*      original software, unless such update contains a separate license.                      *
*   f. You may not translate, reverse engineer, decompile, or disassemble the Software         *
*      provided to you solely in object code format (machine readable) except to the extent    *
*      applicable law specifically prohibits such restriction. You will prohibit your          *
*      sublicensees from translating, reverse engineering, decompiling, or disassembling the   *
*      Software except to the extent applicable law specifically prohibits such restriction.   *
*                                                                                              *
* 3. OPEN SOURCE. Any open source software included in the Software licensed herein is not     *
* licensed under the terms of this Agreement, but is instead licensed under the terms of       *
* applicable open source license(s), such as the BSD License, Apache License or the Lesser     *
* GNU General Public License. Your use of such open source software is subject to the terms    *
* of each applicable license. You must agree to the terms of each such applicable license,     *
* or you should not use the open source software.                                              *
*                                                                                              *
* 4. COPYRIGHT. The Software is licensed to you, not sold. Freescale owns the Software, and    *
* United States copyright laws and international treaty provisions protect the Software.       *
* Therefore, you must treat the Software like any other copyrighted material (e.g. a book or   *
* musical recording). You may not use or copy the Software for any other purpose than what is  *
* described in this Agreement. Except as expressly provided herein, Freescale does not grant   *
* to you any express or implied rights under any Freescale or third party patents,             *
* copyrights, trademarks, or trade secrets. Additionally, you must reproduce and apply any     *
* copyright or other proprietary rights notices included on or embedded in the Software to     *
* any copies made thereof, in whole or in part, if any. You may not remove any copyright       *
* notices of Freescale incorporated in the Software.                                           *
*                                                                                              *
* 5. TERM AND TERMINATION. The term of this Agreement shall commence on the date of            *
* installation or download and shall continue perpetually, unless earlier terminated in        *
* accordance with this Agreement. Freescale has the right to terminate this Agreement without  *
* notice and require that you stop using and delete all copies of the Software in your         *
* possession or control if you violate any of the terms or restrictions of this Agreement.     *
* Freescale may terminate this Agreement should any of the Software become, or in Freescale's  *
* reasonable opinion is likely to become, the subject of a claim of intellectual infringement  *
* or trade secret misappropriation. Upon termination, you must cease use of and destroy, the   *
* Software and confirm compliance in writing to Freescale. Upon termination, the license       *
* granted pursuant to this Agreement immediately terminates and the provisions of Sections 4   *
* through 18 will survive any termination of this Agreement.                                   *
*                                                                                              *
* 6. SUPPORT. Freescale is NOT obligated to provide any support, upgrades or new               *
* of the Software. If you wish, you may contact Freescale and report problems and provide      *
* suggestions regarding the Software. Freescale has no obligation whatsoever to respond in     *
* any way to such a problem report or suggestion. Freescale may make changes to the Software   *
* at any time, without any obligation to notify or provide updated versions of the Software    *
* to you.                                                                                      *
*                                                                                              *
* 7. NO WARRANTY. TO THE MAXIMUM EXTENT PERMITTED BY LAW, FREESCALE EXPRESSLY                  *
* DISCLAIMS ANY WARRANTY FOR THE SOFTWARE. THE SOFTWARE IS PROVIDED (AS IS), WITHOUT WARRANTY  *
* OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, THE IMPLIED           *
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT. YOU    *
* ASSUME THE ENTIRE RISK ARISING OUT OF THE USE OR PERFORMANCE OF THE SOFTWARE, OR ANY SYSTEMS *
* YOU DESIGN USING THE SOFTWARE (IF ANY). NOTHING IN THIS AGREEMENT MAY BE CONSTRUED AS A      *
* WARRANTY OR REPRESENTATION BY FREESCALE THAT THE SOFTWARE OR ANY DERIVATIVE WORK DEVELOPED   *
* WITH OR INCORPORATING THE SOFTWARE WILL BE FREE FROM INFRINGEMENT OF THE INTELLECTUAL        *
* PROPERTY RIGHTS OF THIRD PARTIES.                                                            *
*                                                                                              *
* 8. INDEMNITY. You agree to fully defend and indemnify Freescale from any and all             *
* claims, liabilities, and costs (including reasonable attorney s fees) related to (1) your    *
* use (including your sublicensee s use, if permitted) of the Software or (2) your violation   *
* of the terms and conditions of this Agreement.                                               *
*                                                                                              *
* 9. LIMITATION OF LIABILITY. IN NO EVENT WILL FREESCALE BE LIABLE, WHETHER IN                 *
* CONTRACT, TORT, OR OTHERWISE, FOR ANY INCIDENTAL, SPECIAL, INDIRECT, CONSEQUENTIAL OR        *
* PUNITIVE DAMAGES, INCLUDING, BUT NOT LIMITED TO, DAMAGES FOR ANY LOSS OF USE, LOSS OF TIME,  *
* INCONVENIENCE, COMMERCIAL LOSS, OR LOST PROFITS, SAVINGS, OR REVENUES TO THE FULL EXTENT     *
* SUCH MAY BE DISCLAIMED BY LAW EVEN IF INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH         *
* DAMAGES. FREESCALE S LIABILITY WILL IN ANY EVENT AND UNDER ANY THEORY OF RECOVERY BE         *
* LIMITED TO THE TOTAL AMOUNT RECEIVED BY FREESCALE UNDER THIS AGREEMENT.                      *
*                                                                                              *
* 10. COMPLIANCE WITH LAWS; EXPORT RESTRICTIONS. You must not resell, re-export, or            *
* provide, directly or indirectly, the licensed software or direct product thereof, in any     *
* form without obtaining appropriate export or re-export licenses from the United States       *
* Government and from the country from which the export or re-export is to occur. An export    *
* occurs when products, technology, or software is transferred from one country to another by  *
* any means, including physical shipments, FTP file transfers, E-mails, faxes, remote server   *
* access, conversations, and the like. An export also occurs when technology or software is    *
* transferred to a foreign national in the United States, or foreign national of the country   *
* in which the business activity is taking place. A foreign national is any person who is      *
* neither a citizen nor permanent resident of the United States, or the country in which the   *
* business activity is taking place. Furthermore, if an export/import license, permit or other *
* government required authority (collectively referred to as (government authorization)) is    *
* required to transfer technology, software, hardware or other Freescale property to non-      *
* Freescale party(ies) and is not approved, then Freescale is not obligated to transfer the    *
* Software under this Agreement until such (government authorization) is granted..             *
*                                                                                              *
* 11. GOVERNMENT RIGHTS. The Licensed Software is a (Commercial Item) as defined in 48         *
* C.F.R. 2.101, consisting of (Commercial Computer Software) and (Commercial Computer         *
* Software Documentation,) as such terms are used in 48 C.F.R.  12.212 or 48 C.F.R.           *
* 227.7202, as applicable and are only licensed to U.S. Government end users with the rights  *
* as are set forth herein..                                                                    *
*                                                                                              *
* 12. HIGH RISK ACTIVITIES. You acknowledge that the Software is not fault tolerant and        *
* is not designed, manufactured or intended by Freescale for incorporation into products       *
* intended for use or resale in on-line control equipment in hazardous, dangerous to life or   *
* potentially life-threatening environments requiring fail-safe performance, such as in the    *
* operation of nuclear facilities, aircraft navigation or communication systems, air traffic   *
* control, direct life support machines or weapons systems, in which the failure of products   *
* could lead directly to death, personal injury or severe physical or environmental damage     *
* (High Risk Activities). You specifically represent and warrant that you will not use the   *
* Software or any derivative work of the Software for High Risk Activities.                    *
*                                                                                              *
* 13. CHOICE OF LAW; VENUE; LIMITATIONS. You agree that the statutes and laws of the           *
* United States and the State of Texas, USA, without regard to conflicts of laws principles,   *
* will apply to all matters relating to this Agreement or the Software, and you agree that any *
* litigation will be subject to the exclusive jurisdiction of the state or federal courts in   *
* Texas, USA. You agree that regardless of any statute or law to the contrary, any claim or    *
* cause of action arising out of or related to this Agreement or the Software must be filed    *
* within one (1) year after such claim or cause of action arose or be forever barred.          *
*                                                                                              *
* 14. CONFIDENTIAL INFORMATION. You must treat the Software as confidential information        *
* and you agree to retain the Software in confidence perpetually, with respect to Software in  *
* source code form (human readable), or for a period of five (5) years from the date of        *
* termination of this Agreement, with respect to all other parts of the Software. During this  *
* period you may not disclose any part of the Software to anyone other than employees who have *
* a need to know of the Software and who have executed written agreements obligating them to   *
* protect such Licensed Software to at least the same degree of care as in this Agreement.     *
* You agree to use the same degree of care, but no less than a reasonable degree of care, with *
* the Software as you do with your own confidential information. You may disclose Software to  *
* the extent required by a court or under operation of law or order provided that you notify   *
* Freescale of such requirement prior to disclosure, which you only disclose information       *
* required, and that you allow Freescale the opportunity to object to such court or other      *
* legal body requiring such disclosure.                                                        *
*                                                                                              *
* 15. PRODUCT LABELING. You are not authorized to use any Freescale trademarks, brand          *
* names, or logos.                                                                             *
*                                                                                              *
* 16. ENTIRE AGREEMENT. This Agreement constitutes the entire agreement between you and        *
* Freescale regarding the subject matter of this Agreement, and supersedes all prior           *
* communications, negotiations, understandings, agreements or representations, either written  *
* or oral, if any. This Agreement may only be amended in written form, executed by you and     *
* Freescale.                                                                                   *
*                                                                                              *
* 17. SEVERABILITY. If any provision of this Agreement is held for any reason to be            *
* invalid or unenforceable, then the remaining provisions of this Agreement will be unimpaired *
* and, unless a modification or replacement of the invalid or unenforceable provision is       *
* further held to deprive you or Freescale of a material benefit, in which case the Agreement  *
* will immediately terminate, the invalid or unenforceable provision will be replaced with a   *
* provision that is valid and enforceable and that comes closest to the intention underlying   *
* the invalid or unenforceable provision.                                                      *
*                                                                                              *
* 18. NO WAIVER. The waiver by Freescale of any breach of any provision of this                *
* Agreement will not operate or be construed as a waiver of any other or a subsequent breach   *
* of the same or a different provision.                                                        *
***********************************************************************************************/

/***********************************************************************************************
*
* @file      IEC60730_B_CM4_CM7_wdg.c
*
* @author    B48632
* 
* @version   3.0
*
* @date      Nov-01-2018
* 
* @brief     IEC60730 Class B Safety Watchdog test for Cortex CM4, CM7 cores
*`
************************************************************************************************

***********************************************************************************************/

#include "IEC60730_B_CM4_CM7_wdg.h"


/* WATCHDOG */
/* WATCHDOG_Register_Accessor_Macros */
typedef struct  
{
   unsigned short STCTRLH;                           /* Watchdog Status and Control Register High, offset: 0x0 */
   unsigned short STCTRLL;                           /* Watchdog Status and Control Register Low, offset: 0x2 */
   unsigned short TOVALH;                            /* Watchdog Time-out Value Register High, offset: 0x4 */
   unsigned short TOVALL;                            /* Watchdog Time-out Value Register Low, offset: 0x6 */
   unsigned short WINH;                              /* Watchdog Window Register High, offset: 0x8 */
   unsigned short WINL;                              /* Watchdog Window Register Low, offset: 0xA */
   unsigned short REFRESH;                           /* Watchdog Refresh register, offset: 0xC */
   unsigned short UNLOCK;                            /* Watchdog Unlock register, offset: 0xE */
   unsigned short TMROUTH;                           /* Watchdog Timer Output Register High, offset: 0x10 */
   unsigned short TMROUTL;                           /* Watchdog Timer Output Register Low, offset: 0x12 */
   unsigned short RSTCNT;                            /* Watchdog Reset Count register, offset: 0x14 */
   unsigned short PRESC;                             /* Watchdog Prescaler register, offset: 0x16 */
} Watchdog_Struct;


#define Watchdog_BASE     (0x40052000)
#define WATCHDOG_REG      ((Watchdog_Struct   *)  Watchdog_BASE)

/* STCTRLH Bit Fields */
#define WATCHDOG_STCTRLH_WDOGEN_MSK                 0x1
#define WATCHDOG_STCTRLH_CLKSRC_MSK                 0x2
#define WATCHDOG_STCTRLH_IRQRSTEN_MSK               0x4
#define WATCHDOG_STCTRLH_WINEN_MSK                  0x8
#define WATCHDOG_STCTRLH_ALLOWUPDATE_MSK            0x10
#define WATCHDOG_STCTRLH_DBGEN_MSK                  0x20
#define WATCHDOG_STCTRLH_STOPEN_MSK                 0x40
#define WATCHDOG_STCTRLH_WAITEN_MSK                 0x80
#define WATCHDOG_STCTRLH_TESTWDOG_MSK               0x400
#define WATCHDOG_STCTRLH_TESTSEL_MSK                0x800
#define WATCHDOG_STCTRLH_BYTESEL_MSK                0x3000
#define WATCHDOG_STCTRLH_BYTESEL_SHIFT               12
#define WATCHDOG_STCTRLH_BYTESEL(x)                  (((unsigned short)(((unsigned short)(x))<<WATCHDOG_STCTRLH_BYTESEL_SHIFT))&WATCHDOG_STCTRLH_BYTESEL_MSK)
#define WATCHDOG_STCTRLH_DISTESTWDOG_MSK            0x4000
/* STCTRLL Bit Fields */
#define WATCHDOG_STCTRLL_INTFLG_MSK                 0x8000
/* PRESC Bit Fields */
#define WATCHDOG_PRESC_PRESCVAL_MSK                 0x700
#define WATCHDOG_PRESC_PRESCVAL_SHIFT                8
#define WATCHDOG_PRESC_PRESCVAL(x)                   (((unsigned short)(((unsigned short)(x))<<WATCHDOG_PRESC_PRESCVAL_SHIFT))&WATCHDOG_PRESC_PRESCVAL_MSK)


/* LPTMR */
/* LPTMR_Register_Accessor_Macros */

#define LPTMR_BASE     (0x40040000)
#define LPTMR_REG      ((LPTMR_Str   *)  LPTMR_BASE)

volatile typedef struct {
  unsigned long CSR;         /* Low Power Timer Control Status Register, offset: 0x0 */
  unsigned long PSR;         /* Low Power Timer Prescale Register, offset: 0x4 */
  unsigned long CMR;         /* Low Power Timer Compare Register, offset: 0x8 */
  unsigned long CNR;         /* Low Power Timer Counter Register, offset: 0xC */
} LPTMR_Str;

#define LPTMR_CSR_TIE_MSK                     0x40
#define LPTMR_CSR_TCF_MSK                     0x80
#define LPTMR_CSR_TEN_MSK                     0x1


/* RCM */
/* RCM_Register_Accessor_Macros */
#define RCM_BASE     (0x4007F000)
#define RCM_REG      ((RCM_Str   *)  RCM_BASE)

volatile typedef struct {
  unsigned char SRS0;
} RCM_Str;

#define RCM_SRS0_WDOG_MSK                     0x20
#define RCM_SRS0_POR_MSK                      0x80


/* WATCHDOG KE */
/* WATCHDOG_Register_Accessor_Macros */
typedef struct  
{
  unsigned long CS;          /* Watchdog Control and Status Register, offset: 0x0 */
  unsigned long CNT;         /* Watchdog Counter Register, offset: 0x4 */
  unsigned long TOVAL;       /* Watchdog Timeout Value Register, offset: 0x8 */
  unsigned long WIN;         /* Watchdog Window Register, offset: 0xC */   
} Watchdog_Ke_Struct;


#define WATCHDOG_KE_REG      ((Watchdog_Ke_Struct   *)  Watchdog_BASE)


#define Watchdog_K32w_BASE   (0x4002A000u)
#define WATCHDOG_K32W_REG    ((Watchdog_Ke_Struct   *)  Watchdog_K32w_BASE)

#define WATCHDOG_KE_CS_STOP_MSK              0x1
#define WATCHDOG_KE_CS_WAIT_MSK              0x2
#define WATCHDOG_KE_CS_DBG_MSK               0x4
#define WATCHDOG_KE_CS_TST_MSK               0x18
#define WATCHDOG_KE_CS_TST_SHIFT             3
#define WATCHDOG_KE_CS_TST(x)                (((unsigned long)(((unsigned long)(x)) << WATCHDOG_KE_CS_TST_SHIFT)) & WATCHDOG_KE_CS_TST_MSK)
#define WATCHDOG_KE_CS_UPDATE_MSK            0x20
#define WATCHDOG_KE_CS_INT_MSK               0x40
#define WATCHDOG_KE_CS_EN_MSK                0x80
#define WATCHDOG_KE_CS_CLK_MSK               0x18
#define WATCHDOG_KE_CS_CLK_SHIFT             8
#define WATCHDOG_KE_CS_CLK(x)                (((unsigned long)(((unsigned long)(x)) << WATCHDOG_KE_CS_CLK_SHIFT)) & WATCHDOG_KE_CS_CLK_MSK)
#define WATCHDOG_KE_CS_RCS_MSK               0x400
#define WATCHDOG_KE_CS_ULK_MSK               0x800
#define WATCHDOG_KE_CS_PRES_MSK              0x1000
#define WATCHDOG_KE_CS_CMD32EN_MSK           0x2000
#define WATCHDOG_KE_CS_FLG_MSK               0x4000
#define WATCHDOG_KE_CS_WIN_MSK               0x8000

/* RCM KE*/
/* RCM_Register_Accessor_Macros */
#define RCM_KE_REG      ((RCM_KE_Str   *)  RCM_BASE)

volatile typedef struct {
  unsigned long empty0;
  unsigned long empty1;
  unsigned long SRS;
} RCM_KE_Str;

#define RCM_KE_SRS_WDOG_MSK                     0x20
#define RCM_KE_SRS_POR_MSK                      0x80


/* MSMC0 */
/* MSMC0_Register_Accessor_Macros */
#define MSMC0_BASE     (0x40020000)
#define MSMC0_REG  ((MSMC0_Str  *) MSMC0_BASE) 

volatile typedef struct {
  unsigned long empty0[8];
  unsigned long SRS;  
} MSMC0_Str;  

#define MSMC_SRS_WAKEUP_MSK                      0x1U
#define MSMC_SRS_POR_MSK                         0x2U
#define MSMC_SRS_LVD_MSK                         0x4U
#define MSMC_SRS_HVD_MSK                         0x8U
#define MSMC_SRS_WARM_MSK                        0x10U
#define MSMC_SRS_FATAL_MSK                       0x20U
#define MSMC_SRS_CORE_MSK                        0x80U
#define MSMC_SRS_PIN_MSK                         0x100U
#define MSMC_SRS_MDM_MSK                         0x200U
#define MSMC_SRS_RSTACK_MSK                      0x400U
#define MSMC_SRS_STOPACK_MSK                     0x800U
#define MSMC_SRS_SCG_MSK                         0x1000U
#define MSMC_SRS_WDOG_MSK                        0x2000U
#define MSMC_SRS_SW_MSK                          0x4000U
#define MSMC_SRS_LOCKUP_MSK                      0x8000U
#define MSMC_SRS_CORE0_MSK                       0x10000U
#define MSMC_SRS_CORE1_MSK                       0x20000U
#define MSMC_SRS_JTAG_MSK                        0x10000000U

/* iMXRT */
/* Structure type to access the low power timer (GPT).  */
typedef struct {
  unsigned long CR;                              /* GPT Control Register, offset: 0x0 */
  unsigned long PR;                              /* GPT Prescaler Register, offset: 0x4 */
  unsigned long SR;                              /* GPT Status Register, offset: 0x8 */
  unsigned long IR;                              /* GPT Interrupt Register, offset: 0xC */
  unsigned long OCR[3];                          /* GPT Output Compare Register 1..GPT Output Compare Register 3, array offset: 0x10, array step: 0x4 */
  unsigned long ICR[2];                          /* GPT Input Capture Register 1..GPT Input Capture Register 2, array offset: 0x1C, array step: 0x4 */
  unsigned long CNT;                             /* GPT Counter Register, offset: 0x24 */
} GPT_Str;
#define GPT1_BASE     (0x401EC000U)
#define GPT1_REG      ((GPT_Str   *)  GPT1_BASE)

/* RTWDOG_Register_Accessor_Macros */
typedef struct  
{
  unsigned long CS;    /* Watchdog Control and Status Register, offset: 0x0 */
  unsigned long CNT;   /* Watchdog Counter Register, offset: 0x4 */
  unsigned long TOVAL; /* Watchdog Timeout Value Register, offset: 0x8 */
  unsigned long WIN;   /* Watchdog Window Register, offset: 0xC */
} Watchdog_Struct_RT;

#define Watchdog_BASE_RT (0x400BC000U)
#define WATCHDOG_REG_RT  ((Watchdog_Struct_RT *) Watchdog_BASE_RT)

/* SRC */
/* SRC_Register_Accessor_Macros */
#define SRC_BASE (0x400F8000u)
#define SRC_REG  ((SRC_Str *)SRC_BASE)

/** SRC - Register Layout Typedef */
volatile typedef struct {
  unsigned long SCR;             /**< SRC Control Register, offset: 0x0 */
  unsigned long SBMR1;           /**< SRC Boot Mode Register 1, offset: 0x4 */
  long SRSR;                     /**< SRC Reset Status Register, offset: 0x8 */
  unsigned char RESERVED_0[16];
  unsigned long SBMR2;          /**< SRC Boot Mode Register 2, offset: 0x1C */
  unsigned long GPR[10];        /**< SRC General Purpose Register 1..SRC General Purpose Register 10, array offset: 0x20, array step: 0x4 */
} SRC_Str;

#define SRC_SRSR_IPP_RESET_B_MSK  0x1U
#define SRC_SRSR_WDOG3_RST_B_MSK  0x80U

/*******************************************************************************
* Watchdog_test_configuration
*  
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the LPTMR which must be configured before the function call occurs. 
* Within the waiting endless loop, value from LPTMR is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup(WD_Test_Str* pWatchdogBackup)
{
    pWatchdogBackup->resets=0;                    /* clear the number of WD resets */
    pWatchdogBackup->wd_test_uncomplete_flag =0;  /* clear the wd_test_uncomplete flag */
  
    WATCHDOG_REG->REFRESH = 0xA602;               /* refresh sequence */
    WATCHDOG_REG->REFRESH = 0xB480;  
      
    LPTMR_REG->CSR |= LPTMR_CSR_TEN_MSK;          /* start of LPTMR */
    
    while(1)                                      /* wait for WD reset */
    {    
      LPTMR_REG->CNR = 0;                         /* write any value to synchronize the counter value */
      pWatchdogBackup->counter = LPTMR_REG->CNR;  /* store the actual value from LPTMR */      
    }
}

/*******************************************************************************
* Watchdog_test_check
* 
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check
* param[in]    limit_high          precalculated limit value for LPTMR counter
* param[in]    limit_low           precalculated limit value for LPTMR counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup)
{   
  unsigned long error_flag = 0;
    
  if ((RCM_REG->SRS0 & RCM_SRS0_WDOG_MSK) == RCM_SRS0_WDOG_MSK) /* if WD reset has occured */
  {
     pWatchdogBackup->resets +=1; /* increment the number of WD resets */ 
    /* check if the watchdog resets the system too many times */
    if (pWatchdogBackup->resets >= resets_limit) 
    {
      pWatchdogBackup->resets = resets_limit; /* to avoid overflow of reset counter */
      error_flag = 1;   /* set the error flag */   
    }
    /* check if the timeout from watchdog test corresponds to value of independent timer */
    if ((pWatchdogBackup->counter > limit_high)||(pWatchdogBackup->counter < limit_low))
    {
      error_flag = 1;   /* set the error flag */
    }    
  }
  else 
  {
    pWatchdogBackup->wd_test_uncomplete_flag = 1;              /* set the flag to 1 */
    error_flag = 1;   /* set the error flag */
  }
  /* if endless loop is enabled and some error has occured, wait in loop */  
  if (error_flag && endless_loop_enable) 
  {
    while(1)
    {
      __asm("nop"); 
    }
  }
}

/*******************************************************************************
* Watchdog_test_configuration for MKE1xF
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the LPTMR which must be configured before the function call occurs. 
* Within the waiting endless loop, value from LPTMR is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup_ke
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup_ke(WD_Test_Str* pWatchdogBackup)
{
    pWatchdogBackup->resets=0;                    /* clear the number of WD resets */
    pWatchdogBackup->wd_test_uncomplete_flag =0;  /* clear the wd_test_uncomplete flag */
  
    WATCHDOG_KE_REG->CNT = 0xB480A602;            /* refresh sequence */
      
    LPTMR_REG->CSR |= LPTMR_CSR_TEN_MSK;          /* start of LPTMR */
    
    while(1)                                      /* wait for WD reset */
    {    
      LPTMR_REG->CNR = 0;                         /* write any value to synchronize the counter value */
      pWatchdogBackup->counter = LPTMR_REG->CNR;  /* store the actual value from LPTMR */      
    }
}

/*******************************************************************************
* Watchdog_test_check for MKE1xF
*
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check_ke
* param[in]    limit_high          precalculated limit value for LPTMR counter
* param[in]    limit_low           precalculated limit value for LPTMR counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check_ke(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup)
{   
  unsigned long error_flag = 0;
    
  if ((RCM_KE_REG->SRS & RCM_KE_SRS_WDOG_MSK) == RCM_KE_SRS_WDOG_MSK) /* if WD reset has occured */
  {
     pWatchdogBackup->resets +=1; /* increment the number of WD resets */ 
    /* check if the watchdog resets the system too many times */
    if (pWatchdogBackup->resets >= resets_limit) 
    {
      pWatchdogBackup->resets = resets_limit; /* to avoid overflow of reset counter */
      error_flag = 1;   /* set the error flag */   
    }
    /* check if the timeout from watchdog test corresponds to value of independent timer */
    if ((pWatchdogBackup->counter > limit_high)||(pWatchdogBackup->counter < limit_low))
    {
      error_flag = 1;   /* set the error flag */
    }    
  }
  else 
  {
    pWatchdogBackup->wd_test_uncomplete_flag = 1;              /* set the flag to 1 */
    error_flag = 1;   /* set the error flag */
  }
  /* if endless loop is enabled and some error has occured, wait in loop */  
  if (error_flag && endless_loop_enable) 
  {
    while(1)
    {
      __asm("nop"); 
    }
  }
}

/*******************************************************************************
* Watchdog_test_configuration for MK32W
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the LPTMR which must be configured before the function call occurs. 
* Within the waiting endless loop, value from LPTMR is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup_k32w
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* param[in]    pWDOG  pointer to WDOG base address
* param[in]    pLPTMR  pointer to LPTMR base address
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup_k32w(WD_Test_Str* pWatchdogBackup, unsigned long* pWDOG, unsigned long* pLPTMR)
{
    volatile Watchdog_Ke_Struct* pWdg = (Watchdog_Ke_Struct*)pWDOG;
    volatile LPTMR_Str* pTmr = (LPTMR_Str*)pLPTMR;
    pWatchdogBackup->resets=0;                    /* clear the number of WD resets */
    pWatchdogBackup->wd_test_uncomplete_flag =0;  /* clear the wd_test_uncomplete flag */
  
    pWdg->CNT = 0xB480A602;            /* refresh sequence */
      
    pTmr->CSR |= LPTMR_CSR_TEN_MSK;          /* start of LPTMR */
    
    while(1)                                      /* wait for WD reset */
    {    
      pTmr->CNR = 0;                         /* write any value to synchronize the counter value */
      pWatchdogBackup->counter = pTmr->CNR;  /* store the actual value from LPTMR */      
    }
}

/*******************************************************************************
* Watchdog_test_check for MK32W
*
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check_k32w
* param[in]    limit_high          precalculated limit value for LPTMR counter
* param[in]    limit_low           precalculated limit value for LPTMR counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check_k32w(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup)
{   
  unsigned long error_flag = 0;
    
  if ((MSMC0_REG->SRS & MSMC_SRS_WDOG_MSK) == MSMC_SRS_WDOG_MSK) /* if WD reset has occured */
  {
     pWatchdogBackup->resets +=1; /* increment the number of WD resets */ 
    /* check if the watchdog resets the system too many times */
    if (pWatchdogBackup->resets >= resets_limit) 
    {
      pWatchdogBackup->resets = resets_limit; /* to avoid overflow of reset counter */
      error_flag = 1;   /* set the error flag */   
    }
    /* check if the timeout from watchdog test corresponds to value of independent timer */
    if ((pWatchdogBackup->counter > limit_high)||(pWatchdogBackup->counter < limit_low))
    {
      error_flag = 1;   /* set the error flag */
    }    
  }
  else 
  {
    pWatchdogBackup->wd_test_uncomplete_flag = 1;              /* set the flag to 1 */
    error_flag = 1;   /* set the error flag */
  }
  
  /* if endless loop is enabled and some error has occured, wait in loop */  
  if (error_flag && endless_loop_enable) 
  {
    while(1)
    {
      __asm("nop"); 
    }
  }
}

/*******************************************************************************
* Watchdog_test_configuration for RT 
*  
* This function should be called only once after POR reset. - each calling of this function causes a wd reset
* Function clears the WD resets counter to 0. No WD settings are changed here.  
* It starts the GPT which must be configured before the function call occurs. 
* Within the waiting endless loop, value from GPT is periodically stored to reserved area in RAM
* 
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_setup_RT
* param[in]    pWatchdogBackup  pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_setup_RT(WD_Test_Str* pWatchdogBackup)
{
    pWatchdogBackup->resets = 0;                  /* Clear the number of WD resets */
    pWatchdogBackup->wd_test_uncomplete_flag = 0; /* Clear the wd_test_uncomplete flag */
  
    WATCHDOG_REG_RT->CNT = 0xB480A602; /* Refresh sequence */   
    
    GPT1_REG->OCR[0] = 0xFFFFFFFF; /* Change "compare" value, this cause RESET of CNT to zero */
    
    while(1)                                       /* Wait for WD reset */
    {    
        pWatchdogBackup->counter = GPT1_REG->CNT;  /* Store value from GPT */
    }
}
/*******************************************************************************
* Watchdog_test_check_RT
* 
* function should be called after every WD reset, its calling should be handled by conditional execution in application
* if the source of reset is WD, function increments the wd_reset counter
* if the reset counter has overflowed, function will wait in endless loop if it is enabled
* if the source of reset is WD, function next check the timeout value, if it is not in range, function will wait in endless loop if it is enabled
*
* if the source of reset isn't WD or POR, function will sets the wd_test_uncomplete_flag and will wait in endless loop if it is enabled
*******************************************************************************/
/********************************************************************************************************* 
* brief        IEC60730B_CM4_CM7_watchdog_test_check_RT
* param[in]    limit_high          precalculated limit value for GPT counter
* param[in]    limit_low           precalculated limit value for GPT counter
* param[in]    resets_limit        limit value for WD resets
* param[in]    endless_loop_enable enable, or disable endless loop within the function
* param[in]    pWatchdogBackup     pointer to structure with WD_test variables
* return       void
**********************************************************************************************************/ 
void IEC60730B_CM4_CM7_watchdog_test_check_RT(unsigned long limit_high, unsigned long limit_low, unsigned long resets_limit, unsigned long endless_loop_enable, WD_Test_Str* pWatchdogBackup)
{   
    unsigned long error_flag = 0;
    if (SRC_SRSR_WDOG3_RST_B_MSK == (SRC_REG->SRSR & SRC_SRSR_WDOG3_RST_B_MSK)) /* If WD reset has occured */
    {
        /* Clear wdog3_rst_b bit */
        SRC_REG->SRSR = SRC_SRSR_WDOG3_RST_B_MSK;
      
        pWatchdogBackup->resets +=1; /* Increment the number of WD resets */ 
        /* Check if the watchdog resets the system too many times */
        if (pWatchdogBackup->resets >= resets_limit) 
        {
            pWatchdogBackup->resets = resets_limit; /* To avoid overflow of reset counter */
            error_flag = 1;   /* Set the error flag */   
        }
        
        /* Check if the timeout from watchdog test corresponds to value of independent timer */
        if ((pWatchdogBackup->counter > limit_high) || (pWatchdogBackup->counter < limit_low))
        {
            error_flag = 1;   /* Set the error flag */
        }    
    }
    else 
    {     
        pWatchdogBackup->wd_test_uncomplete_flag = 1; /* Set the flag to 1 */
        error_flag = 1;   /* Set the error flag */
    }
    
    /* If endless loop is enabled and some error has occured, wait in loop */  
    if (error_flag && endless_loop_enable) 
    {
        while(1)
        {
            __asm("nop"); 
        }
    }
}
