/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Peripherals v5.0
processor: MIMXRT1062xxxxA
package_id: MIMXRT1062DVL6A
mcu_data: ksdk2_0
processor_version: 5.0.2
board: MIMXRT1060-EVKB
functionalGroups:
- name: BOARD_InitPeripherals
  called_from_default_init: true
  selectedCore: core0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'system'
- type_id: 'system_54b53072540eeeb8f8e9343e71f28176'
- global_system_definitions: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "peripherals.h"

/***********************************************************************************************************************
 * BOARD_InitPeripherals functional group
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * ACCEL_I2C initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'ACCEL_I2C'
- type: 'lpi2c'
- mode: 'master'
- type_id: 'lpi2c_db68d4f4f06a22e25ab51fe9bd6db4d2'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'LPI2C1'
- config_sets:
  - main:
    - clockSource: 'Lpi2cClock'
    - clockSourceFreq: 'BOARD_BootClockRUN'
    - interrupt:
      - IRQn: 'LPI2C1_IRQn'
      - enable_priority: 'false'
      - enable_custom_name: 'false'
    - quick_selection: 'qs_interrupt'
  - master:
    - mode: 'transfer'
    - config:
      - enableMaster: 'true'
      - enableDoze: 'true'
      - debugEnable: 'false'
      - ignoreAck: 'false'
      - pinConfig: 'kLPI2C_2PinOpenDrain'
      - baudRate_Hz: '100000'
      - busIdleTimeout_ns: '0'
      - pinLowTimeout_ns: '0'
      - sdaGlitchFilterWidth_ns: '0'
      - sclGlitchFilterWidth_ns: '0'
      - hostRequest:
        - enable: 'false'
        - source: 'kLPI2C_HostRequestExternalPin'
        - polarity: 'kLPI2C_HostRequestPinActiveHigh'
    - transfer:
      - blocking: 'false'
      - flags: ''
      - slaveAddress: '0'
      - direction: 'kLPI2C_Write'
      - subaddress: '0'
      - subaddressSize: '1'
      - dataSize: '1'
      - callback:
        - name: ''
        - userData: ''
    - quick_selection: 'qs_master_transfer'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const lpi2c_master_config_t ACCEL_I2C_masterConfig = {
    .enableMaster            = true,
    .enableDoze              = true,
    .debugEnable             = false,
    .ignoreAck               = false,
    .pinConfig               = kLPI2C_2PinOpenDrain,
    .baudRate_Hz             = 100000,
    .busIdleTimeout_ns       = 0,
    .pinLowTimeout_ns        = 0,
    .sdaGlitchFilterWidth_ns = 0,
    .sclGlitchFilterWidth_ns = 0,
    .hostRequest             = {
        .enable = false, .source = kLPI2C_HostRequestExternalPin, .polarity = kLPI2C_HostRequestPinActiveHigh}};
lpi2c_master_transfer_t ACCEL_I2C_masterTransfer = {.flags          = kLPI2C_TransferDefaultFlag,
                                                    .slaveAddress   = 0,
                                                    .direction      = kLPI2C_Write,
                                                    .subaddress     = 0,
                                                    .subaddressSize = 1,
                                                    .data           = ACCEL_I2C_masterBuffer,
                                                    .dataSize       = 1};
lpi2c_master_handle_t ACCEL_I2C_masterHandle;
uint8_t ACCEL_I2C_masterBuffer[ACCEL_I2C_MASTER_BUFFER_SIZE];

void ACCEL_I2C_init(void)
{
    LPI2C_MasterInit(ACCEL_I2C_PERIPHERAL, &ACCEL_I2C_masterConfig, ACCEL_I2C_CLOCK_FREQ);
    LPI2C_MasterTransferCreateHandle(ACCEL_I2C_PERIPHERAL, &ACCEL_I2C_masterHandle, NULL, NULL);
}

/***********************************************************************************************************************
 * TIMER initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'TIMER'
- type: 'qtmr'
- mode: 'general'
- type_id: 'qtmr_460dd7aa3f3371843c2548acd54252b0'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'TMR3'
- config_sets:
  - fsl_qtmr:
    - clockSource: 'BusInterfaceClock'
    - clockSourceFreq: 'BOARD_BootClockRUN'
    - qtmr_channels:
      - 0:
        - channel_prefix_id: 'Channel_0'
        - channel: 'kQTMR_Channel_0'
        - primarySource: 'kQTMR_ClockDivide_128'
        - secondarySource: 'kQTMR_Counter0InputPin'
        - countingMode: 'kQTMR_PriSrcRiseEdge'
        - enableMasterMode: 'false'
        - enableExternalForce: 'false'
        - faultFilterCount: '3'
        - faultFilterPeriod: '0'
        - debugMode: 'kQTMR_RunNormalInDebug'
        - timerModeInit: 'pwmOutput'
        - pwmMode:
          - freq_value_str: '23'
          - dutyCyclePercent: '50'
          - outputPolarity: 'false'
        - dmaIntMode: 'interrupt'
        - interrupts: 'kQTMR_Compare1InterruptEnable kQTMR_Compare2InterruptEnable'
    - interruptVector:
      - enable_irq: 'true'
      - interrupt:
        - IRQn: 'TMR3_IRQn'
        - enable_priority: 'false'
        - enable_custom_name: 'true'
        - handler_custom_name: 'TIMER_IRQ_HANDLER'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const qtmr_config_t TIMER_Channel_0_config = {.primarySource       = kQTMR_ClockDivide_128,
                                              .secondarySource     = kQTMR_Counter0InputPin,
                                              .enableMasterMode    = false,
                                              .enableExternalForce = false,
                                              .faultFilterCount    = 0,
                                              .faultFilterPeriod   = 0,
                                              .debugMode           = kQTMR_RunNormalInDebug};

void TIMER_init(void)
{
    /* Quad timer channel Channel_0 peripheral initialization */
    QTMR_Init(TIMER_PERIPHERAL, TIMER_CHANNEL_0_CHANNEL, &TIMER_Channel_0_config);
    /* Setup the PWM mode of the timer channel */
    QTMR_SetupPwm(TIMER_PERIPHERAL, TIMER_CHANNEL_0_CHANNEL, 50956UL, 50U, false, TIMER_CHANNEL_0_CLOCK_SOURCE);
    /* Enable interrupt requests of the timer channel */
    QTMR_EnableInterrupts(TIMER_PERIPHERAL, TIMER_CHANNEL_0_CHANNEL,
                          kQTMR_Compare1InterruptEnable | kQTMR_Compare2InterruptEnable);
    /* Enable interrupt TMR3_IRQn request in the NVIC */
    EnableIRQ(TIMER_IRQN);
    /* Start the timer - select the timer counting mode */
    QTMR_StartTimer(TIMER_PERIPHERAL, TIMER_CHANNEL_0_CHANNEL, kQTMR_PriSrcRiseEdge);
}

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/
void BOARD_InitPeripherals(void)
{
    /* Initialize components */
    ACCEL_I2C_init();
    TIMER_init();
}

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void)
{
    BOARD_InitPeripherals();
}
