/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PERIPHERALS_H_
#define _PERIPHERALS_H_

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "fsl_common.h"
#include "fsl_clock.h"
#include "fsl_lpi2c.h"
#include "fsl_qtmr.h"

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/
/* Definitions for BOARD_InitPeripherals functional group */
/* BOARD_InitPeripherals defines for LPI2C1 */
/* Definition of peripheral ID */
#define ACCEL_I2C_PERIPHERAL LPI2C1
/* Definition of clock source */
#define ACCEL_I2C_CLOCK_FREQ 60000000UL
/* Transfer buffer size */
#define ACCEL_I2C_MASTER_BUFFER_SIZE 1
/* Definition of peripheral ID */
#define TIMER_PERIPHERAL TMR3
/* Definition of the timer channel Channel_0. */
#define TIMER_CHANNEL_0_CHANNEL kQTMR_Channel_0
/* Definition of the timer channel Channel_0 clock source frequency. */
#define TIMER_CHANNEL_0_CLOCK_SOURCE 1172000UL
/* TIMER interrupt vector ID (number). */
#define TIMER_IRQN TMR3_IRQn
/* TIMER interrupt handler identifier. */
#define TIMER_IRQ_HANDLER TMR3_IRQHandler

/***********************************************************************************************************************
 * Global variables
 **********************************************************************************************************************/
extern const lpi2c_master_config_t ACCEL_I2C_masterConfig;
extern lpi2c_master_transfer_t ACCEL_I2C_masterTransfer;
extern uint8_t ACCEL_I2C_masterBuffer[ACCEL_I2C_MASTER_BUFFER_SIZE];
extern lpi2c_master_handle_t ACCEL_I2C_masterHandle;
extern const qtmr_config_t TIMER_Channel_0_config;

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/
void BOARD_InitPeripherals(void);

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void);

#if defined(__cplusplus)
}
#endif

#endif /* _PERIPHERALS_H_ */
