/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _MUSIC_H_
#define _MUSIC_H_

#include "fsl_common.h"

#if defined(__GNUC__) /* GNU Compiler */
#ifndef __ALIGN_END
#define __ALIGN_END __attribute__((aligned(4)))
#endif
#ifndef __ALIGN_BEGIN
#define __ALIGN_BEGIN
#endif
#else
#ifndef __ALIGN_END
#define __ALIGN_END
#endif
#ifndef __ALIGN_BEGIN
#if defined(__CC_ARM) || defined(__ARMCC_VERSION) /* ARM Compiler */
#define __ALIGN_BEGIN __attribute__((aligned(4)))
#elif defined(__ICCARM__) /* IAR Compiler */
#define __ALIGN_BEGIN
#endif
#endif
#endif

#if defined(__ICCARM__)
#pragma data_alignment = 4
#endif
__ALIGN_BEGIN int a __ALIGN_END;

#define MUSIC_LEN (190000U)

#if defined DEMO_AUDIO_DATA_PUT_INTO_SECTION
DEMO_AUDIO_DATA_PUT_INTO_SECTION(uint8_t music[], 4U) =
#else
#if defined FSL_FEATURE_SOC_MMDC_COUNT && FSL_FEATURE_SOC_MMDC_COUNT
AT_NONCACHEABLE_SECTION_ALIGN_INIT(uint8_t music[], 4) =
#else
__ALIGN_BEGIN const uint16_t music[] __ALIGN_END =
#endif
#endif
    {
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,
        0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d,
        0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000,
        0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118,
        0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d,
        0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642,
        0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121,
        0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214,
        0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126,
        0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000,
        0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be,
        0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214,
        0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121,
        0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642,
        0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
        0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda,
        0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec,
        0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5,
        0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e,
        0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be,
        0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118,
        0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000,
        0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,
        0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc,
        0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82,
        0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3,
        0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d,
        0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,
        0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04,
        0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d,
        0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d,
        0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000,
        0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3,
        0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc,
        0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000,
        0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126,
        0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118,
        0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be,
        0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x2121, 0x2121, 0x2121, 0x2121, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x7642, 0x7642, 0x7642, 0x7642, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff,
        0x7fff, 0x7fff, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642,
        0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec,
        0x4dec, 0x4dec, 0x4000, 0x4000, 0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121,
        0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf,
        0xdedf, 0xdedf, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214,
        0xa57e, 0xa57e, 0xa57e, 0xa57e, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be,
        0x89be, 0x89be, 0x845d, 0x845d, 0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000,
        0x8118, 0x8118, 0x8118, 0x8118, 0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126,
        0x9126, 0x9126, 0x9a73, 0x9a73, 0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214,
        0xc000, 0xc000, 0xc000, 0xc000, 0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b,
        0xef4b, 0xef4b, 0x0,    0x0,    0x0,    0x0,    0x10b5, 0x10b5, 0x10b5, 0x10b5, 0x2121, 0x2121, 0x2121, 0x2121,
        0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x4000, 0x4000, 0x4000, 0x4000, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x5a82, 0x5a82,
        0x5a82, 0x5a82, 0x658d, 0x658d, 0x658d, 0x658d, 0x6eda, 0x6eda, 0x6eda, 0x6eda, 0x7642, 0x7642, 0x7642, 0x7642,
        0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ee8, 0x7ee8, 0x7ee8, 0x7ee8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7ee8, 0x7ee8,
        0x7ee8, 0x7ee8, 0x7ba3, 0x7ba3, 0x7ba3, 0x7ba3, 0x7642, 0x7642, 0x7642, 0x7642, 0x6eda, 0x6eda, 0x6eda, 0x6eda,
        0x658d, 0x658d, 0x658d, 0x658d, 0x5a82, 0x5a82, 0x5a82, 0x5a82, 0x4dec, 0x4dec, 0x4dec, 0x4dec, 0x4000, 0x4000,
        0x4000, 0x4000, 0x30fc, 0x30fc, 0x30fc, 0x30fc, 0x2121, 0x2121, 0x2121, 0x2121, 0x10b5, 0x10b5, 0x10b5, 0x10b5,
        0x0,    0x0,    0x0,    0x0,    0xef4b, 0xef4b, 0xef4b, 0xef4b, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xcf04, 0xcf04,
        0xcf04, 0xcf04, 0xc000, 0xc000, 0xc000, 0xc000, 0xb214, 0xb214, 0xb214, 0xb214, 0xa57e, 0xa57e, 0xa57e, 0xa57e,
        0x9a73, 0x9a73, 0x9a73, 0x9a73, 0x9126, 0x9126, 0x9126, 0x9126, 0x89be, 0x89be, 0x89be, 0x89be, 0x845d, 0x845d,
        0x845d, 0x845d, 0x8118, 0x8118, 0x8118, 0x8118, 0x8000, 0x8000, 0x8000, 0x8000, 0x8118, 0x8118, 0x8118, 0x8118,
        0x845d, 0x845d, 0x845d, 0x845d, 0x89be, 0x89be, 0x89be, 0x89be, 0x9126, 0x9126, 0x9126, 0x9126, 0x9a73, 0x9a73,
        0x9a73, 0x9a73, 0xa57e, 0xa57e, 0xa57e, 0xa57e, 0xb214, 0xb214, 0xb214, 0xb214, 0xc000, 0xc000, 0xc000, 0xc000,
        0xcf04, 0xcf04, 0xcf04, 0xcf04, 0xdedf, 0xdedf, 0xdedf, 0xdedf, 0xef4b, 0xef4b, 0xef4b, 0xef4b,

};

#endif
