/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_debug_console.h"
#include "board.h"

#include "fsl_wdog.h"

#include "pin_mux.h"
#include "clock_config.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define DEMO_WDOG_BASE       WDOG1

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/

void reset_now(void)
{
    wdog_config_t config;
	/*
	 * wdogConfig->enableWdog = true;
	 * wdogConfig->workMode.enableWait = true;
	 * wdogConfig->workMode.enableStop = false;
	 * wdogConfig->workMode.enableDebug = false;
	 * wdogConfig->enableInterrupt = false;
	 * wdogConfig->enablePowerdown = false;
	 * wdogConfig->resetExtension = false;
	 * wdogConfig->timeoutValue = 0xFFU;
	 * wdogConfig->interruptTimeValue = 0x04u;
	 */
	WDOG_GetDefaultConfig(&config);
	config.timeoutValue = 0x0U; /* Timeout value is (0x0 + 1)/2 = 0.5 sec. */
	config.enableTimeOutAssert = true;
	WDOG_Init(DEMO_WDOG_BASE, &config);
	SDK_DelayAtLeastUs(600*1000, SystemCoreClock);
}

/*!
 * @brief Main function
 */
int main(void)
{
    uint16_t resetFlag = 0U;
    BOARD_ConfigMPU();
    BOARD_InitWDOGPins();
    BOARD_BootClockRUN();
    BOARD_InitDebugConsole();

    PRINTF("\r\n******** System Start ********\r\n");
    PRINTF("System reset by:");

    resetFlag = WDOG_GetStatusFlags(DEMO_WDOG_BASE);

    switch (resetFlag & (kWDOG_PowerOnResetFlag | kWDOG_TimeoutResetFlag | kWDOG_SoftwareResetFlag))
    {
        case kWDOG_PowerOnResetFlag:
            PRINTF(" Power On Reset!\r\n");
            break;
        case kWDOG_TimeoutResetFlag:
            PRINTF(" Time Out Reset!\r\n");
            break;
        case kWDOG_SoftwareResetFlag:
            PRINTF(" Software Reset!\r\n");
            break;
        default:
            PRINTF(" Error status!\r\n");
            break;
    }

	PRINTF("\r\n- Testing reset_now()\r\n");
	reset_now();
	PRINTF("\r\n- Should never end up here\r\n");

	while (1)
	{
	}
}
