/*
 * Copyright 2020-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

#define BOARD_INITPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x080220U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */
#define BOARD_INITPINS_IOMUXC_GPR_GPR27_GPIO_MUX2_GPIO_SEL_MASK 0x10000000U /*!< GPIO2 and GPIO7 share same IO MUX function, GPIO_MUX2 selects one GPIO function: affected bits mask */

/* GPIO_AD_B0_09 (coord F14), LED */
/* Routed pin properties */
#define BOARD_INITPINS_LED_PERIPHERAL                                      GPIO1   /*!< Peripheral name */
#define BOARD_INITPINS_LED_SIGNAL                                        gpio_io   /*!< Signal name */
#define BOARD_INITPINS_LED_CHANNEL                                            9U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_LED_GPIO                                            GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_LED_GPIO_PIN                                           9U   /*!< GPIO pin number */
#define BOARD_INITPINS_LED_GPIO_PIN_MASK                              (1U << 9U)   /*!< GPIO pin mask */

/* GPIO_AD_B0_05 (coord G14), CAN_STBY/BOOT_MODE[1]/Flash_RST/U12[8] */
/* Routed pin properties */
#define BOARD_INITPINS_CAN_STBY_PERIPHERAL                                 GPIO1   /*!< Peripheral name */
#define BOARD_INITPINS_CAN_STBY_SIGNAL                                   gpio_io   /*!< Signal name */
#define BOARD_INITPINS_CAN_STBY_CHANNEL                                       5U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_CAN_STBY_GPIO                                       GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_CAN_STBY_GPIO_PIN                                      5U   /*!< GPIO pin number */
#define BOARD_INITPINS_CAN_STBY_GPIO_PIN_MASK                         (1U << 5U)   /*!< GPIO pin mask */

/* GPIO_AD_B0_12 (coord K14), UART1_TXD */
/* Routed pin properties */
#define BOARD_INITPINS_UART1_TXD_PERIPHERAL                              LPUART1   /*!< Peripheral name */
#define BOARD_INITPINS_UART1_TXD_SIGNAL                                       TX   /*!< Signal name */

/* GPIO_AD_B0_13 (coord L14), UART1_RXD */
/* Routed pin properties */
#define BOARD_INITPINS_UART1_RXD_PERIPHERAL                              LPUART1   /*!< Peripheral name */
#define BOARD_INITPINS_UART1_RXD_SIGNAL                                       RX   /*!< Signal name */

/* GPIO_AD_B1_03 (coord M12), SPDIF_IN/J22[8] */
/* Routed pin properties */
#define BOARD_INITPINS_SPDIF_IN_PERIPHERAL                                 GPIO1   /*!< Peripheral name */
#define BOARD_INITPINS_SPDIF_IN_SIGNAL                                   gpio_io   /*!< Signal name */
#define BOARD_INITPINS_SPDIF_IN_CHANNEL                                      19U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_SPDIF_IN_GPIO                                       GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_SPDIF_IN_GPIO_PIN                                     19U   /*!< GPIO pin number */
#define BOARD_INITPINS_SPDIF_IN_GPIO_PIN_MASK                        (1U << 19U)   /*!< GPIO pin mask */

/* GPIO_B1_12 (coord D13), SD_CD_SW */
/* Routed pin properties */
#define BOARD_INITPINS_SD_CD_SW_PERIPHERAL                                 GPIO2   /*!< Peripheral name */
#define BOARD_INITPINS_SD_CD_SW_SIGNAL                                   gpio_io   /*!< Signal name */
#define BOARD_INITPINS_SD_CD_SW_CHANNEL                                      28U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_SD_CD_SW_GPIO                                       GPIO2   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_SD_CD_SW_GPIO_PIN                                     28U   /*!< GPIO pin number */
#define BOARD_INITPINS_SD_CD_SW_GPIO_PIN_MASK                        (1U << 28U)   /*!< GPIO pin mask */

/* GPIO_B1_14 (coord C14), SD0_VSELECT */
/* Routed pin properties */
#define BOARD_INITPINS_SD0_VSELECT_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITPINS_SD0_VSELECT_SIGNAL                          usdhc_vselect   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/* GPIO_SD_B0_00 (coord J4), SD1_CMD/J24[6] */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_CMD_PERIPHERAL                            USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_CMD_SIGNAL                             usdhc_cmd   /*!< Signal name */

/* GPIO_SD_B0_01 (coord J3), SD1_CLK/J24[3] */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_CLK_PERIPHERAL                            USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_CLK_SIGNAL                             usdhc_clk   /*!< Signal name */

/* GPIO_SD_B0_02 (coord J1), SD1_D0/J24[4]/SPI_MOSI/PWM */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D0_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D0_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D0_CHANNEL                                    0U   /*!< Signal channel */

/* GPIO_SD_B0_03 (coord K1), SD1_D1/J24[5]/SPI_MISO */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D1_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D1_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D1_CHANNEL                                    1U   /*!< Signal channel */

/* GPIO_SD_B0_04 (coord H2), SD1_D2 */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D2_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D2_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D2_CHANNEL                                    2U   /*!< Signal channel */

/* GPIO_SD_B0_05 (coord J2), SD1_D3 */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D3_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D3_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D3_CHANNEL                                    3U   /*!< Signal channel */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitUSDHCPins(void);

/* GPIO_AD_B1_06 (coord J12), CSI_VSYNC/J46[18]/BT_UART_TXD/U9[4]/I2C3_SCL/J24[3]/J23[13]/J16[2] */
/* Routed pin properties */
#define BOARD_INITARDUINOUARTPINS_CSI_VSYNC_PERIPHERAL                   LPUART3   /*!< Peripheral name */
#define BOARD_INITARDUINOUARTPINS_CSI_VSYNC_SIGNAL                            TX   /*!< Signal name */

/* GPIO_AD_B1_05 (coord K12), CSI_MCLK/J46[12]/WL_DEV_WAKE/U9[10]/J33[4] */
/* Routed pin properties */
#define BOARD_INITARDUINOUARTPINS_CSI_MCLK_PERIPHERAL                    LPUART3   /*!< Peripheral name */
#define BOARD_INITARDUINOUARTPINS_CSI_MCLK_SIGNAL                          RTS_B   /*!< Signal name */

/* GPIO_AD_B1_04 (coord L12), CSI_PIXCLK/J46[8]/BT_DEV_WAKE/U9[9]/J33[3] */
/* Routed pin properties */
#define BOARD_INITARDUINOUARTPINS_CSI_PIXCLK_PERIPHERAL                  LPUART3   /*!< Peripheral name */
#define BOARD_INITARDUINOUARTPINS_CSI_PIXCLK_SIGNAL                        CTS_B   /*!< Signal name */

/* GPIO_AD_B1_07 (coord K10), CSI_HSYNC/J46[16]/BT_UART_RXD/U10[20]/I2C3_SDA/J24[5]/J23[15]/J16[1] */
/* Routed pin properties */
#define BOARD_INITARDUINOUARTPINS_CSI_HSYNC_PERIPHERAL                   LPUART3   /*!< Peripheral name */
#define BOARD_INITARDUINOUARTPINS_CSI_HSYNC_SIGNAL                            RX   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitArduinoUARTPins(void);

#define BOARD_INITPINSM2_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x01080000U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */

/* GPIO_AD_B1_03 (coord M12), SPDIF_IN/U15[4]/WL_RST#/J8[56]/SD_PWREN/Q5[1]/J16[8] */
/* Routed pin properties */
#define BOARD_INITPINSM2_WL_RST_PERIPHERAL                                 GPIO1   /*!< Peripheral name */
#define BOARD_INITPINSM2_WL_RST_SIGNAL                                   gpio_io   /*!< Signal name */
#define BOARD_INITPINSM2_WL_RST_CHANNEL                                      19U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINSM2_WL_RST_GPIO                                       GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINSM2_WL_RST_GPIO_PIN                                     19U   /*!< GPIO pin number */
#define BOARD_INITPINSM2_WL_RST_GPIO_PIN_MASK                        (1U << 19U)   /*!< GPIO pin mask */
#define BOARD_INITPINSM2_WL_RST_PORT                                       GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_INITPINSM2_WL_RST_PIN                                          19U   /*!< PORT pin number */
#define BOARD_INITPINSM2_WL_RST_PIN_MASK                             (1U << 19U)   /*!< PORT pin mask */

/* GPIO_AD_B1_08 (coord H13), AUD_INT/J34[5]/U25[15]/WIFI_RST_B/U9[3]/CSI_D9/J46[13]/J16[4] */
/* Routed pin properties */
#define BOARD_INITPINSM2_SDIO_RST_PERIPHERAL                               GPIO1   /*!< Peripheral name */
#define BOARD_INITPINSM2_SDIO_RST_SIGNAL                                 gpio_io   /*!< Signal name */
#define BOARD_INITPINSM2_SDIO_RST_CHANNEL                                    24U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINSM2_SDIO_RST_GPIO                                     GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINSM2_SDIO_RST_GPIO_PIN                                   24U   /*!< GPIO pin number */
#define BOARD_INITPINSM2_SDIO_RST_GPIO_PIN_MASK                      (1U << 24U)   /*!< GPIO pin mask */
#define BOARD_INITPINSM2_SDIO_RST_PORT                                     GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_INITPINSM2_SDIO_RST_PIN                                        24U   /*!< PORT pin number */
#define BOARD_INITPINSM2_SDIO_RST_PIN_MASK                           (1U << 24U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPinsM2(void);

#define BOARD_DEINITARDUINOUARTPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0xF00000U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */

/* GPIO_AD_B1_04 (coord L12), CSI_PIXCLK/J46[8]/BT_DEV_WAKE/U9[9]/J33[3] */
/* Routed pin properties */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_PERIPHERAL                  GPIO1   /*!< Peripheral name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_SIGNAL                    gpio_io   /*!< Signal name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_CHANNEL                       20U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_GPIO                        GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_GPIO_PIN                      20U   /*!< GPIO pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_GPIO_PIN_MASK         (1U << 20U)   /*!< GPIO pin mask */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_PORT                        GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_PIN                           20U   /*!< PORT pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_PIXCLK_PIN_MASK              (1U << 20U)   /*!< PORT pin mask */

/* GPIO_AD_B1_05 (coord K12), CSI_MCLK/J46[12]/WL_DEV_WAKE/U9[10]/J33[4] */
/* Routed pin properties */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_PERIPHERAL                    GPIO1   /*!< Peripheral name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_SIGNAL                      gpio_io   /*!< Signal name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_CHANNEL                         21U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_GPIO                          GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_GPIO_PIN                        21U   /*!< GPIO pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_GPIO_PIN_MASK           (1U << 21U)   /*!< GPIO pin mask */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_PORT                          GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_PIN                             21U   /*!< PORT pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_MCLK_PIN_MASK                (1U << 21U)   /*!< PORT pin mask */

/* GPIO_AD_B1_06 (coord J12), CSI_VSYNC/J46[18]/BT_UART_TXD/U9[4]/I2C3_SCL/J24[3]/J23[13]/J16[2] */
/* Routed pin properties */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_PERIPHERAL                   GPIO1   /*!< Peripheral name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_SIGNAL                     gpio_io   /*!< Signal name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_CHANNEL                        22U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_GPIO                         GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_GPIO_PIN                       22U   /*!< GPIO pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_GPIO_PIN_MASK          (1U << 22U)   /*!< GPIO pin mask */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_PORT                         GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_PIN                            22U   /*!< PORT pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_VSYNC_PIN_MASK               (1U << 22U)   /*!< PORT pin mask */

/* GPIO_AD_B1_07 (coord K10), CSI_HSYNC/J46[16]/BT_UART_RXD/U10[20]/I2C3_SDA/J24[5]/J23[15]/J16[1] */
/* Routed pin properties */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_PERIPHERAL                   GPIO1   /*!< Peripheral name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_SIGNAL                     gpio_io   /*!< Signal name */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_CHANNEL                        23U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_GPIO                         GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_GPIO_PIN                       23U   /*!< GPIO pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_GPIO_PIN_MASK          (1U << 23U)   /*!< GPIO pin mask */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_PORT                         GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_PIN                            23U   /*!< PORT pin number */
#define BOARD_DEINITARDUINOUARTPINS_CSI_HSYNC_PIN_MASK               (1U << 23U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_DeinitArduinoUARTPins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
