/*
 *  Copyright 2020-2021 NXP
 *  All rights reserved.
 *
 *  SPDX-License-Identifier: BSD-3-Clause
 */

#define USB_HOST_CONFIG_EHCI (2U)
#define CONTROLLER_ID        kUSB_ControllerEhci0

/* Controller config
 * Supported controller list,
 * WIFI_IW416_BOARD_AW_AM510MA
 * WIFI_88W8987_BOARD_AW_CM358MA
 * WIFI_IW416_BOARD_AW_AM510_USD
 * WIFI_88W8987_BOARD_AW_CM358_USD
 * WIFI_IW416_BOARD_MURATA_1XK_USD
 * WIFI_IW416_BOARD_MURATA_1XK_M2
 * WIFI_88W8987_BOARD_MURATA_1ZM_USD
 * WIFI_88W8987_BOARD_MURATA_1ZM_M2
 *
 * If aw am510 ma is used, define macro WIFI_IW416_BOARD_AW_AM510MA below.
 * If aw cm358 ma is used, define macro WIFI_88W8987_BOARD_AW_CM358MA below.
 * If aw am510 uSD is used, define macro WIFI_IW416_BOARD_AW_AM510_USD below.
 * If aw cm358 uSD is used, define macro WIFI_88W8987_BOARD_AW_CM358_USD below.
 * If Embedded Artists Type 1XK with uSD-M2 adapter is used, define macro WIFI_IW416_BOARD_MURATA_1XK_USD below.
 * If Embedded Artists Type 1XK (EAR00385 M2 only) is used, define macro WIFI_IW416_BOARD_MURATA_1XK_M2 below.
 * If Embedded Artists Type 1ZM with uSD-M2 adapter is used, define macro WIFI_88W8987_BOARD_MURATA_1ZM_USD below.
 * If Embedded Artists Type 1ZM (EAR00364 M2 only) is used, define macro WIFI_88W8987_BOARD_MURATA_1ZM_M2 below.
 */

/* @TEST_ANCHOR */
#define WIFI_IW416_BOARD_MURATA_1XK_M2
/* @END_TEST_ANCHOR */
/*#define WIFI_IW416_BOARD_AW_AM510_USD*/
/*#define WIFI_88W8987_BOARD_AW_CM358_USD*/
/*#define WIFI_IW416_BOARD_AW_AM510MA*/
/*#define WIFI_88W8987_BOARD_AW_CM358MA*/
/*#define WIFI_IW416_BOARD_MURATA_1XK_USD*/
/*#define WIFI_IW416_BOARD_MURATA_1XK_M2*/
/*#define WIFI_88W8987_BOARD_MURATA_1ZM_USD*/
/*#define WIFI_88W8987_BOARD_MURATA_1ZM_M2*/

#if (defined(WIFI_IW416_BOARD_MURATA_1XK_USD) || defined(WIFI_88W8987_BOARD_MURATA_1ZM_USD))
#define SDMMCHOST_OPERATION_VOLTAGE_3V3
#define SD_TIMING_MAX kSD_TimingSDR25HighSpeedMode
#endif

#if defined(WIFI_IW416_BOARD_AW_AM510MA) || defined(WIFI_88W8987_BOARD_AW_CM358MA) ||      \
    defined(WIFI_IW416_BOARD_AW_AM510_USD) || defined(WIFI_88W8987_BOARD_AW_CM358_USD) ||  \
    defined(WIFI_IW416_BOARD_MURATA_1XK_USD) || defined(WIFI_IW416_BOARD_MURATA_1XK_M2) || \
    defined(WIFI_88W8987_BOARD_MURATA_1ZM_USD) || defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2)
#include "bt_module_config.h"
#include "wifi_config.h"
#else
#error The Wi-Fi module is unsupported
#endif

#if defined(SDMMCHOST_OPERATION_VOLTAGE_3V3)
#elif defined(SDMMCHOST_OPERATION_VOLTAGE_1V8)
#undef SDMMCHOST_OPERATION_VOLTAGE_1V8
#define SDMMCHOST_OPERATION_VOLTAGE_3V3
#endif

#define CONFIG_BT_RFCOMM                1
#define CONFIG_BT_HFP_AG                1
#define CONFIG_BT_DEBUG                 0
#define CONFIG_BT_DEBUG_HCI_CORE        0
#define CONFIG_BT_DEBUG_CONN            0
#define CONFIG_BT_DEBUG_GATT            0
#define CONFIG_BT_DEBUG_ATT             0
#define CONFIG_BT_DEBUG_SMP             0
#define CONFIG_BT_DEBUG_KEYS            0
#define CONFIG_BT_DEBUG_L2CAP           0
#define CONFIG_BT_DEBUG_SERVICE         0
#define CONFIG_BT_DEBUG_HFP_AG          0
#define CONFIG_BT_SETTINGS              1
#define CONFIG_BT_KEYS_OVERWRITE_OLDEST 1

#include "edgefast_bluetooth_config.h"

/* For convenience - sets WIFI_BOARD_NAME as string */
#if defined(WIFI_IW416_BOARD_AW_AM510MA)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_AW_AM510MA"
#elif defined(WIFI_88W8987_BOARD_AW_CM358MA)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_AW_CM358MA"
#elif defined(WIFI_IW416_BOARD_AW_AM510_USD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_AW_AM510_USD"
#elif defined(WIFI_88W8987_BOARD_AW_CM358_USD)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_AW_CM358_USD"
#elif defined(WIFI_IW416_BOARD_MURATA_1XK_USD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_USD"
#elif defined(WIFI_IW416_BOARD_MURATA_1XK_M2)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_M2"
#elif defined(WIFI_88W8987_BOARD_MURATA_1ZM_USD)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_MURATA_1ZM_USD"
#elif defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_MURATA_1ZM_M2"
#endif
