/*
 * Copyright 2021-2022 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "wifi_bt_config.h"
#include "pin_mux.h"
#include "fsl_gpio.h"
#include "pca6416.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#ifdef WIFI_BT_USE_USD_INTERFACE
  /* The iMXRT1062 Developers Kit does not have support for the uSD connector
     for Wi-Fi so make sure to prevent selection of a module that use it. */
  #error "uSD interface is not supported on this board"
#endif

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/

void BOARD_WIFI_BT_Enable(bool enable)
{
    if (enable)
    {
        /* Enable module */
#ifdef WIFI_BT_USE_M2_INTERFACE

        // Control WL_REG_ON.
        // Connected to both pins 23 and 56 on the M.2 connector.
        PCA6416_SetPins(PCA_WL_REG_ON_3V3);

        // Control BT_REG_ON.
        // Connected to pin 54 on the M.2 connector
        PCA6416_SetPins(PCA_BT_REG_ON_3V3);

#elif defined(WIFI_BT_USE_USD_INTERFACE)

        /* Enable power supply for SD */
        BOARD_SDMMC_SD_POWER_RESET_GPIO_BASE->GDIR &= ~(1UL << BOARD_SDMMC_SD_POWER_RESET_GPIO_PIN);

#endif /* WIFI_BT_USE_M2_INTERFACE */

        vTaskDelay(pdMS_TO_TICKS(100));
    }
    else
    {
        /* Disable module */
#ifdef WIFI_BT_USE_M2_INTERFACE

        // Control WL_REG_ON.
        // Connected to both pins 23 and 56 on the M.2 connector.
        PCA6416_ClearPins(PCA_WL_REG_ON_3V3);

        // Control BT_REG_ON.
        // Connected to pin 54 on the M.2 connector
        PCA6416_ClearPins(PCA_BT_REG_ON_3V3);

#elif defined(WIFI_BT_USE_USD_INTERFACE)

        /* Disable power supply for SD */
        BOARD_SDMMC_SD_POWER_RESET_GPIO_BASE->GDIR |= (1UL << BOARD_SDMMC_SD_POWER_RESET_GPIO_PIN);

#endif /* WIFI_BT_USE_M2_INTERFACE */

        vTaskDelay(pdMS_TO_TICKS(100));
    }
}

void BOARD_WIFI_BT_Config(void *card, sdio_int_t cardInt)
{
    BOARD_SDIO_Config(card, NULL, BOARD_SDMMC_SDIO_HOST_IRQ_PRIORITY, cardInt);
    ((sdio_card_t *)card)->usrParam.pwr = NULL;

#ifdef WIFI_BT_USE_M2_INTERFACE
    ((sdio_card_t *)card)->usrParam.pwr = NULL;
    BOARD_InitPinsM2();
#endif

    BOARD_WIFI_BT_Enable(false);
}
