/*
 * Copyright 2018 ,2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/* GPIO_AD_B0_12 (coord K14), UART1_TXD/J13[2] */
/* Routed pin properties */
#define BOARD_INITDEBUG_UARTPINS_UART1_TXD_PERIPHERAL                    LPUART1   /*!< Peripheral name */
#define BOARD_INITDEBUG_UARTPINS_UART1_TXD_SIGNAL                             TX   /*!< Signal name */

/* GPIO_AD_B0_13 (coord L14), UART1_RXD/J11[2] */
/* Routed pin properties */
#define BOARD_INITDEBUG_UARTPINS_UART1_RXD_PERIPHERAL                    LPUART1   /*!< Peripheral name */
#define BOARD_INITDEBUG_UARTPINS_UART1_RXD_SIGNAL                             RX   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitDEBUG_UARTPins(void);

/* GPIO_EMC_09 (coord C2), SEMC_A0/U16[H7] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A0_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A0_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A0_CHANNEL                                   0U   /*!< Signal channel */

/* GPIO_EMC_10 (coord G1), SEMC_A1/U16[H8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A1_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A1_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A1_CHANNEL                                   1U   /*!< Signal channel */

/* GPIO_EMC_11 (coord G3), SEMC_A2/U16[J8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A2_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A2_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A2_CHANNEL                                   2U   /*!< Signal channel */

/* GPIO_EMC_12 (coord H1), SEMC_A3/U16[J7] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A3_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A3_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A3_CHANNEL                                   3U   /*!< Signal channel */

/* GPIO_EMC_13 (coord A6), SEMC_A4/U16[J3] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A4_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A4_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A4_CHANNEL                                   4U   /*!< Signal channel */

/* GPIO_EMC_14 (coord B6), SEMC_A5/U16[J2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A5_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A5_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A5_CHANNEL                                   5U   /*!< Signal channel */

/* GPIO_EMC_15 (coord B1), SEMC_A6/U16[H3] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A6_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A6_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A6_CHANNEL                                   6U   /*!< Signal channel */

/* GPIO_EMC_16 (coord A5), SEMC_A7/U6[H2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A7_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A7_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A7_CHANNEL                                   7U   /*!< Signal channel */

/* GPIO_EMC_17 (coord A4), SEMC_A8/U16[H1] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A8_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A8_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A8_CHANNEL                                   8U   /*!< Signal channel */

/* GPIO_EMC_18 (coord B2), SEMC_A9/U16[G3] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A9_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A9_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A9_CHANNEL                                   9U   /*!< Signal channel */

/* GPIO_EMC_23 (coord G2), SEMC_A10/U16[H9] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A10_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A10_SIGNAL                                 ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A10_CHANNEL                                 10U   /*!< Signal channel */

/* GPIO_EMC_19 (coord B4), SEMC_A11/U6[G2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A11_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A11_SIGNAL                                 ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A11_CHANNEL                                 11U   /*!< Signal channel */

/* GPIO_EMC_20 (coord A3), SEMC_A12/U16[G1] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A12_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A12_SIGNAL                                 ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A12_CHANNEL                                 12U   /*!< Signal channel */

/* GPIO_EMC_21 (coord C1), SEMC_BA0/U16[G7] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_BA0_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_BA0_SIGNAL                                   BA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_BA0_CHANNEL                                  0U   /*!< Signal channel */

/* GPIO_EMC_22 (coord F1), SEMC_BA1/U16[G8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_BA1_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_BA1_SIGNAL                                   BA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_BA1_CHANNEL                                  1U   /*!< Signal channel */

/* GPIO_EMC_24 (coord D3), SEMC_CAS/U16[F7] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_CAS_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_CAS_SIGNAL                             semc_cas   /*!< Signal name */

/* GPIO_EMC_27 (coord A2), SEMC_CKE/U16[F3] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_CKE_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_CKE_SIGNAL                             semc_cke   /*!< Signal name */

/* GPIO_EMC_26 (coord B3), SEMC_CLK/U16[F2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_CLK_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_CLK_SIGNAL                             semc_clk   /*!< Signal name */

/* GPIO_EMC_41 (coord C7), ENET_MDIO/U18[11] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_ENET_MDIO_PERIPHERAL                            SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_ENET_MDIO_SIGNAL                                 CSX   /*!< Signal name */
#define BOARD_INITSDRAMPINS_ENET_MDIO_CHANNEL                                 0U   /*!< Signal channel */

/* GPIO_EMC_00 (coord E3), SEMC_D0/U16[A8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D0_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D0_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D0_CHANNEL                                   0U   /*!< Signal channel */

/* GPIO_EMC_01 (coord F3), SEMC_D1/U16[B9] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D1_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D1_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D1_CHANNEL                                   1U   /*!< Signal channel */

/* GPIO_EMC_02 (coord F4), SEMC_D2/U16[B8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D2_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D2_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D2_CHANNEL                                   2U   /*!< Signal channel */

/* GPIO_EMC_03 (coord G4), SEMC_D3/U16[C9] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D3_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D3_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D3_CHANNEL                                   3U   /*!< Signal channel */

/* GPIO_EMC_04 (coord F2), SEMC_D4/U16[C8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D4_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D4_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D4_CHANNEL                                   4U   /*!< Signal channel */

/* GPIO_EMC_05 (coord G5), SEMC_D5/U16[D9] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D5_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D5_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D5_CHANNEL                                   5U   /*!< Signal channel */

/* GPIO_EMC_06 (coord H5), SEMC_D6/U16[D8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D6_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D6_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D6_CHANNEL                                   6U   /*!< Signal channel */

/* GPIO_EMC_07 (coord H4), SEMC_D7/U16[E9] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D7_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D7_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D7_CHANNEL                                   7U   /*!< Signal channel */

/* GPIO_EMC_30 (coord C6), SEMC_D8/U16[E1] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D8_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D8_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D8_CHANNEL                                   8U   /*!< Signal channel */

/* GPIO_EMC_31 (coord C5), SEMC_D9/U16[D2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D9_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D9_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D9_CHANNEL                                   9U   /*!< Signal channel */

/* GPIO_EMC_32 (coord D5), SEMC_D10/U16[D1] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D10_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D10_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D10_CHANNEL                                 10U   /*!< Signal channel */

/* GPIO_EMC_33 (coord C4), SEMC_D11/U16[C2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D11_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D11_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D11_CHANNEL                                 11U   /*!< Signal channel */

/* GPIO_EMC_34 (coord D4), SEMC_D12/U16[C1] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D12_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D12_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D12_CHANNEL                                 12U   /*!< Signal channel */

/* GPIO_EMC_35 (coord E5), SEMC_D13/U16[B2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D13_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D13_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D13_CHANNEL                                 13U   /*!< Signal channel */

/* GPIO_EMC_36 (coord C3), SEMC_D14/U16[B1] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D14_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D14_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D14_CHANNEL                                 14U   /*!< Signal channel */

/* GPIO_EMC_37 (coord E4), SEMC_D15/U16[A2] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D15_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D15_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D15_CHANNEL                                 15U   /*!< Signal channel */

/* GPIO_EMC_08 (coord H3), SEMC_DM0/U16[E8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_DM0_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_DM0_SIGNAL                                   DM   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_DM0_CHANNEL                                  0U   /*!< Signal channel */

/* GPIO_EMC_38 (coord D6), SEMC_DM1/U16[F1] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_DM1_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_DM1_SIGNAL                                   DM   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_DM1_CHANNEL                                  1U   /*!< Signal channel */

/* GPIO_EMC_25 (coord D2), SEMC_RAS/U16[F8] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_RAS_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_RAS_SIGNAL                             semc_ras   /*!< Signal name */

/* GPIO_EMC_28 (coord D1), SEMC_WE/U16[F9] */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_WE_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_WE_SIGNAL                               semc_we   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitSDRAMPins(void);

#define BOARD_INITCSIPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x040000U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */

/* GPIO_AD_B1_08 (coord H13), AUD_INT/J34[5]/U25[15]/WIFI_RST_B/U9[3]/CSI_D9/J46[13]/J16[4] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D9_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D9_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D9_CHANNEL                                      9U   /*!< Signal channel */

/* GPIO_AD_B1_09 (coord M13), SAI1_MCLK/U25[11]/DC_I2S1_MCLK/J23[1]/CSI_D8/J46[11] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D8_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D8_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D8_CHANNEL                                      8U   /*!< Signal channel */

/* GPIO_AD_B1_10 (coord L13), SAI1_RX_SYNC/J23[9]/CSI_D7/J46[9]/J33[1] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D7_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D7_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D7_CHANNEL                                      7U   /*!< Signal channel */

/* GPIO_AD_B1_11 (coord J13), DC_I2S1_RX_BCLK/J23[5]/CSI_D6/J46[7]/J33[2] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D6_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D6_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D6_CHANNEL                                      6U   /*!< Signal channel */

/* GPIO_AD_B1_12 (coord H12), SAI1_RXD/J41[1]/DC_I2S1_RX_D0/J23[11]/BT_PCM_RXD/U10[18]/CSI_D5/J46[5] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D5_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D5_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D5_CHANNEL                                      5U   /*!< Signal channel */

/* GPIO_AD_B1_13 (coord H11), SAI1_TXD/J37[1]/DC_I2S1_TX_D0/J23[17]/BT_PCM_TXD/U9[6]/CSI_D4/J46[3] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D4_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D4_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D4_CHANNEL                                      4U   /*!< Signal channel */

/* GPIO_AD_B1_14 (coord G12), SAI1_TX_BCLK/J35[1]/DC_I2S1_TX_BCLK/U23[23]/BT_PCM_BCLK/U9[7]/U10[17]/CSI_D3/J46[4] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D3_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D3_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D3_CHANNEL                                      3U   /*!< Signal channel */

/* GPIO_AD_B1_15 (coord J14), SAI1_TX_SYNC/J36[1]/DC_I2S1_TX_SYNC/U23[16]/BT_PCM_SYNC/U9[8]/U10[16]/CSI_D2/J46[6] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D2_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D2_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D2_CHANNEL                                      2U   /*!< Signal channel */

/* GPIO_AD_B1_04 (coord L12), CSI_PIXCLK/J46[8]/BT_DEV_WAKE/U9[9]/J33[3] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_PIXCLK_PERIPHERAL                              CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_PIXCLK_SIGNAL                           csi_pixclk   /*!< Signal name */

/* GPIO_AD_B1_05 (coord K12), CSI_MCLK/J46[12]/WL_DEV_WAKE/U9[10]/J33[4] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_MCLK_PERIPHERAL                                CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_MCLK_SIGNAL                               csi_mclk   /*!< Signal name */

/* GPIO_AD_B1_06 (coord J12), CSI_VSYNC/J46[18]/BT_UART_TXD/U9[4]/I2C3_SCL/J24[3]/J23[13]/J16[2] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_VSYNC_PERIPHERAL                               CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_VSYNC_SIGNAL                             csi_vsync   /*!< Signal name */

/* GPIO_AD_B1_07 (coord K10), CSI_HSYNC/J46[16]/BT_UART_RXD/U10[20]/I2C3_SDA/J24[5]/J23[15]/J16[1] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_HSYNC_PERIPHERAL                               CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_HSYNC_SIGNAL                             csi_hsync   /*!< Signal name */

/* GPIO_AD_B1_02 (coord L11), SPDIF_OUT/J18[2]/BT_RST#/J8[54]/CSI_PWDN/PWDN/J46[17]/J16[7] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_PWDN_PERIPHERAL                              GPIO1   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_PWDN_SIGNAL                                gpio_io   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_PWDN_CHANNEL                                   18U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITCSIPINS_CSI_PWDN_GPIO                                    GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITCSIPINS_CSI_PWDN_GPIO_PIN                                  18U   /*!< GPIO pin number */
#define BOARD_INITCSIPINS_CSI_PWDN_GPIO_PIN_MASK                     (1U << 18U)   /*!< GPIO pin mask */
#define BOARD_INITCSIPINS_CSI_PWDN_PORT                                    GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_INITCSIPINS_CSI_PWDN_PIN                                       18U   /*!< PORT pin number */
#define BOARD_INITCSIPINS_CSI_PWDN_PIN_MASK                          (1U << 18U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitCSIPins(void);

#define BOARD_INITLCDPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x04U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */
#define BOARD_INITLCDPINS_IOMUXC_GPR_GPR27_GPIO_MUX2_GPIO_SEL_MASK 0x80000000U /*!< GPIO2 and GPIO7 share same IO MUX function, GPIO_MUX2 selects one GPIO function: affected bits mask */

/* GPIO_B0_00 (coord D7), LCDIF_CLK/J49[A30] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_CLK_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_CLK_SIGNAL                             lcdif_clk   /*!< Signal name */

/* GPIO_B0_01 (coord E7), LCDIF_ENABLE/J49[A34] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_ENABLE_PERIPHERAL                          LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_ENABLE_SIGNAL                       lcdif_enable   /*!< Signal name */

/* GPIO_B0_02 (coord E8), LCDIF_HSYNC/J49[A32] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_HSYNC_PERIPHERAL                           LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_HSYNC_SIGNAL                         lcdif_hsync   /*!< Signal name */

/* GPIO_B0_03 (coord D8), LCDIF_VSYNC/J49[A33] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_VSYNC_PERIPHERAL                           LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_VSYNC_SIGNAL                         lcdif_vsync   /*!< Signal name */

/* GPIO_B0_04 (coord C8), LCDIF_D0/BT_CFG[0]/J49[A24] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D0_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D0_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D0_CHANNEL                                    0U   /*!< Signal channel */

/* GPIO_B0_05 (coord B8), LCDIF_D1/BT_CFG[1]/J49[A25] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D1_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D1_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D1_CHANNEL                                    1U   /*!< Signal channel */

/* GPIO_B0_06 (coord A8), LCDIF_D2/BT_CFG[2]/J49[A26] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D2_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D2_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D2_CHANNEL                                    2U   /*!< Signal channel */

/* GPIO_B0_07 (coord A9), LCDIF_D3/BT_CFG[3]/J49[A27] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D3_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D3_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D3_CHANNEL                                    3U   /*!< Signal channel */

/* GPIO_B0_08 (coord B9), LCDIF_D4/BT_CFG[4]/J49[A28] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D4_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D4_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D4_CHANNEL                                    4U   /*!< Signal channel */

/* GPIO_B0_09 (coord C9), LCDIF_D5/BT_CFG[5]/J49[A15] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D5_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D5_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D5_CHANNEL                                    5U   /*!< Signal channel */

/* GPIO_B0_10 (coord D9), LCDIF_D6/BT_CFG[6]/J49[A16] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D6_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D6_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D6_CHANNEL                                    6U   /*!< Signal channel */

/* GPIO_B0_11 (coord A10), LCDIF_D7/BT_CFG[7]/J49[A17] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D7_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D7_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D7_CHANNEL                                    7U   /*!< Signal channel */

/* GPIO_B0_12 (coord C10), LCDIF_D8/BT_CFG[8]/J49[A18] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D8_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D8_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D8_CHANNEL                                    8U   /*!< Signal channel */

/* GPIO_B0_13 (coord D10), LCDIF_D9/BT_CFG[9]/J49[A19] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D9_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D9_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D9_CHANNEL                                    9U   /*!< Signal channel */

/* GPIO_B0_14 (coord E10), LCDIF_D10/BT_CFG[10]/J49[A20] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D10_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D10_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D10_CHANNEL                                  10U   /*!< Signal channel */

/* GPIO_B0_15 (coord E11), LCDIF_D11/BT_CFG[11]J49[A8] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D11_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D11_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D11_CHANNEL                                  11U   /*!< Signal channel */

/* GPIO_B1_00 (coord A11), LCDIF_D12/J49[A9] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D12_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D12_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D12_CHANNEL                                  12U   /*!< Signal channel */

/* GPIO_B1_01 (coord B11), LCDIF_D13/J49[A10] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D13_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D13_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D13_CHANNEL                                  13U   /*!< Signal channel */

/* GPIO_B1_02 (coord C11), LCDIF_D14/J49[A11] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D14_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D14_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D14_CHANNEL                                  14U   /*!< Signal channel */

/* GPIO_B1_03 (coord D11), LCDIF_D15/J49[A12] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D15_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D15_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D15_CHANNEL                                  15U   /*!< Signal channel */

/* GPIO_B1_15 (coord B14), USB_HOST_PWR/U28[A1]/BACKLIGHT_CTL/U14[4] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PERIPHERAL                         GPIO2   /*!< Peripheral name */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_SIGNAL                           gpio_io   /*!< Signal name */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_CHANNEL                              31U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_GPIO                               GPIO2   /*!< GPIO peripheral base pointer */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_GPIO_PIN                             31U   /*!< GPIO pin number */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_GPIO_PIN_MASK                (1U << 31U)   /*!< GPIO pin mask */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PORT                               GPIO2   /*!< PORT peripheral base pointer */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PIN                                  31U   /*!< PORT pin number */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PIN_MASK                     (1U << 31U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitLCDPins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
