/*********************************************************************
 *                SEGGER Microcontroller GmbH & Co. KG                *
 *        Solutions for real time microcontroller applications        *
 *                           www.segger.com                           *
 **********************************************************************
 *                                                                    *
 * C-file generated by                                                *
 *                                                                    *
 *        Bitmap Converter for emWin V5.38c.                          *
 *        Compiled Dec 14 2016, 11:34:30                              *
 *                                                                    *
 *        (c) 1998 - 2016 Segger Microcontroller GmbH & Co. KG        *
 *                                                                    *
 **********************************************************************
 *                                                                    *
 * Source file: NXP_110x44                                            *
 * Dimensions:  110 * 44                                              *
 * NumColors:   256                                                   *
 *                                                                    *
 **********************************************************************
 */

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
#define GUI_CONST_STORAGE const
#endif

extern GUI_CONST_STORAGE GUI_BITMAP bmNXP_110x44;

/*********************************************************************
 *
 *       Palette
 *
 *  Description
 *    The following are the entries of the palette table.
 *    The entries are stored as a 32-bit values of which 24 bits are
 *    actually used according to the following bit mask: 0xBBGGRR
 *
 *    The lower   8 bits represent the Red   component.
 *    The middle  8 bits represent the Green component.
 *    The highest 8 bits represent the Blue  component.
 */
static GUI_CONST_STORAGE GUI_COLOR _ColorsNXP_110x44[] = {
#if (GUI_USE_ARGB == 0)
    0x00623600, 0x0010B4E8, 0x0020D1C9, 0x00D9AE8B, 0x003C957C, 0x003E828E, 0x00643000, 0x00643400, 0x00663100,
    0x00623400, 0x0016AAD5, 0x00DEAF8B, 0x003C838F, 0x0078928D, 0x00E2B08C, 0x00609A7E, 0x0020D3CC, 0x00643200,
    0x000EB5EA, 0x0019A5CE, 0x00457855, 0x002A8A9A, 0x0026C3B7, 0x0026C4B8, 0x002CB6A5, 0x00408565, 0x000EB6ED,
    0x0017A8D2, 0x005F3400, 0x00603500, 0x00467C5B, 0x002592AA, 0x002AB9AA, 0x001FD4CE, 0x00486E68, 0x00408D72,
    0x00407C82, 0x00613600, 0x00DCB18E, 0x003D947A, 0x00DAAF8C, 0x00DDB290, 0x005C3200, 0x00623200, 0x003F828D,
    0x002A8A9C, 0x0040808A, 0x0024C8BE, 0x00DBB08D, 0x0011B1E2, 0x000DB8F1, 0x00387574, 0x003E9379, 0x00C69B75,
    0x003A9981, 0x00298C9E, 0x0035A08A, 0x0032A996, 0x0018AAD6, 0x001ED8D3, 0x00E2AF8C, 0x00663200, 0x00603A05,
    0x00673C06, 0x005A4215, 0x0058441A, 0x006C410B, 0x0051502F, 0x0046604C, 0x00436556, 0x0094693A, 0x00AA7F54,
    0x003E8B6E, 0x0039967D, 0x0061977A, 0x00B1865D, 0x00B58A61, 0x00BA8F67, 0x00BE8F65, 0x00BF946C, 0x00CBA07B,
    0x00399D85, 0x003C8491, 0x0035A48E, 0x0030AC99, 0x001E9DBE, 0x002F91AA, 0x002C94AE, 0x00269ABA, 0x002CB7A8,
    0x007B9089, 0x0027C2B5, 0x0028C0B3, 0x0026C5BA, 0x0019A6D0, 0x0015ADDA, 0x000DB8EF, 0x001ED7D1, 0x0024CAC0,
    0x0022CEC5, 0x0020D4CD, 0x00D5AA86, 0x00D7AC88, 0x00592E00, 0x005B3000, 0x005E3300, 0x005F3B07, 0x005F3B08,
    0x005E3D0B, 0x005C3F10, 0x00652F00, 0x00682A00, 0x00613300, 0x00633801, 0x00643902, 0x00603B07, 0x005E400C,
    0x005B4112, 0x005C4011, 0x005A4917, 0x00594A19, 0x006E430E, 0x00724713, 0x00724714, 0x00764B17, 0x00764B18,
    0x00784D1A, 0x007B501D, 0x00544C27, 0x00514F2D, 0x00565122, 0x00565324, 0x00545628, 0x004E5335, 0x004E5538,
    0x00525C30, 0x00515D32, 0x00515E33, 0x007E5321, 0x007F5421, 0x004D673F, 0x00506136, 0x00506138, 0x003A736F,
    0x00397472, 0x0036797A, 0x00357B7F, 0x004A6E48, 0x00446454, 0x00426658, 0x00477552, 0x00467B5A, 0x00466E69,
    0x00727B68, 0x00835827, 0x00875C2B, 0x008B602F, 0x009A6F41, 0x009B7042, 0x009D7246, 0x00A4794D, 0x00A4794E,
    0x00A67B50, 0x00A87D53, 0x003F886A, 0x003B9176, 0x003A9479, 0x0061805D, 0x00438160, 0x00418363, 0x00408769,
    0x00418D71, 0x00609073, 0x0060997E, 0x00AD8258, 0x00B78C63, 0x00B78C64, 0x00BE936C, 0x00CA9F7A, 0x00CDA27D,
    0x00D3A47E, 0x00D6A57F, 0x003C7B80, 0x003C7D84, 0x00417C81, 0x003F818D, 0x00369D86, 0x003C9880, 0x002E8591,
    0x002C8898, 0x003B8391, 0x003A8695, 0x00398798, 0x00368A9C, 0x0038899A, 0x0034A38D, 0x0036A28C, 0x0038A08B,
    0x002FAF9D, 0x0035A490, 0x0030AB98, 0x0031AD9C, 0x002EB19F, 0x001F9CBD, 0x00298DA0, 0x00358DA0, 0x002790A7,
    0x003190A6, 0x002A97B4, 0x002998B4, 0x00219AB8, 0x00209CBB, 0x002EB1A0, 0x002FB2A1, 0x002BBAAC, 0x0029BCAE,
    0x002ABCAE, 0x0030B0A0, 0x0040818C, 0x00768A80, 0x0057AC96, 0x0055B19B, 0x006D9DA0, 0x006AA2A6, 0x0027C3B8,
    0x0025C5BA, 0x0025C7BC, 0x001D9FC2, 0x00229EC1, 0x001CA0C3, 0x001CA1C5, 0x001DA2C6, 0x001AA3C9, 0x001FA2C9,
    0x001AA4CA, 0x001CA3CC, 0x001CA6CF, 0x0019A8D3, 0x0015ABD8, 0x0013AFDE, 0x0015ACDC, 0x0021A0C4, 0x0014B0E0,
    0x0011B2E6, 0x0010B4E7, 0x0010B3E8, 0x001FD3CB, 0x0023CBC1, 0x0023CDC3, 0x00D1A682, 0x00D6AB88, 0x00D8AD8A,
    0x00DAAF8B, 0x00D9AE8C, 0x00DFB08B, 0x00E2AF8B
#else
    0xFF003662, 0xFFE8B410, 0xFFC9D120, 0xFF8BAED9, 0xFF7C953C, 0xFF8E823E, 0xFF003064, 0xFF003464, 0xFF003166,
    0xFF003462, 0xFFD5AA16, 0xFF8BAFDE, 0xFF8F833C, 0xFF8D9278, 0xFF8CB0E2, 0xFF7E9A60, 0xFFCCD320, 0xFF003264,
    0xFFEAB50E, 0xFFCEA519, 0xFF557845, 0xFF9A8A2A, 0xFFB7C326, 0xFFB8C426, 0xFFA5B62C, 0xFF658540, 0xFFEDB60E,
    0xFFD2A817, 0xFF00345F, 0xFF003560, 0xFF5B7C46, 0xFFAA9225, 0xFFAAB92A, 0xFFCED41F, 0xFF686E48, 0xFF728D40,
    0xFF827C40, 0xFF003661, 0xFF8EB1DC, 0xFF7A943D, 0xFF8CAFDA, 0xFF90B2DD, 0xFF00325C, 0xFF003262, 0xFF8D823F,
    0xFF9C8A2A, 0xFF8A8040, 0xFFBEC824, 0xFF8DB0DB, 0xFFE2B111, 0xFFF1B80D, 0xFF747538, 0xFF79933E, 0xFF759BC6,
    0xFF81993A, 0xFF9E8C29, 0xFF8AA035, 0xFF96A932, 0xFFD6AA18, 0xFFD3D81E, 0xFF8CAFE2, 0xFF003266, 0xFF053A60,
    0xFF063C67, 0xFF15425A, 0xFF1A4458, 0xFF0B416C, 0xFF2F5051, 0xFF4C6046, 0xFF566543, 0xFF3A6994, 0xFF547FAA,
    0xFF6E8B3E, 0xFF7D9639, 0xFF7A9761, 0xFF5D86B1, 0xFF618AB5, 0xFF678FBA, 0xFF658FBE, 0xFF6C94BF, 0xFF7BA0CB,
    0xFF859D39, 0xFF91843C, 0xFF8EA435, 0xFF99AC30, 0xFFBE9D1E, 0xFFAA912F, 0xFFAE942C, 0xFFBA9A26, 0xFFA8B72C,
    0xFF89907B, 0xFFB5C227, 0xFFB3C028, 0xFFBAC526, 0xFFD0A619, 0xFFDAAD15, 0xFFEFB80D, 0xFFD1D71E, 0xFFC0CA24,
    0xFFC5CE22, 0xFFCDD420, 0xFF86AAD5, 0xFF88ACD7, 0xFF002E59, 0xFF00305B, 0xFF00335E, 0xFF073B5F, 0xFF083B5F,
    0xFF0B3D5E, 0xFF103F5C, 0xFF002F65, 0xFF002A68, 0xFF003361, 0xFF013863, 0xFF023964, 0xFF073B60, 0xFF0C405E,
    0xFF12415B, 0xFF11405C, 0xFF17495A, 0xFF194A59, 0xFF0E436E, 0xFF134772, 0xFF144772, 0xFF174B76, 0xFF184B76,
    0xFF1A4D78, 0xFF1D507B, 0xFF274C54, 0xFF2D4F51, 0xFF225156, 0xFF245356, 0xFF285654, 0xFF35534E, 0xFF38554E,
    0xFF305C52, 0xFF325D51, 0xFF335E51, 0xFF21537E, 0xFF21547F, 0xFF3F674D, 0xFF366150, 0xFF386150, 0xFF6F733A,
    0xFF727439, 0xFF7A7936, 0xFF7F7B35, 0xFF486E4A, 0xFF546444, 0xFF586642, 0xFF527547, 0xFF5A7B46, 0xFF696E46,
    0xFF687B72, 0xFF275883, 0xFF2B5C87, 0xFF2F608B, 0xFF416F9A, 0xFF42709B, 0xFF46729D, 0xFF4D79A4, 0xFF4E79A4,
    0xFF507BA6, 0xFF537DA8, 0xFF6A883F, 0xFF76913B, 0xFF79943A, 0xFF5D8061, 0xFF608143, 0xFF638341, 0xFF698740,
    0xFF718D41, 0xFF739060, 0xFF7E9960, 0xFF5882AD, 0xFF638CB7, 0xFF648CB7, 0xFF6C93BE, 0xFF7A9FCA, 0xFF7DA2CD,
    0xFF7EA4D3, 0xFF7FA5D6, 0xFF807B3C, 0xFF847D3C, 0xFF817C41, 0xFF8D813F, 0xFF869D36, 0xFF80983C, 0xFF91852E,
    0xFF98882C, 0xFF91833B, 0xFF95863A, 0xFF988739, 0xFF9C8A36, 0xFF9A8938, 0xFF8DA334, 0xFF8CA236, 0xFF8BA038,
    0xFF9DAF2F, 0xFF90A435, 0xFF98AB30, 0xFF9CAD31, 0xFF9FB12E, 0xFFBD9C1F, 0xFFA08D29, 0xFFA08D35, 0xFFA79027,
    0xFFA69031, 0xFFB4972A, 0xFFB49829, 0xFFB89A21, 0xFFBB9C20, 0xFFA0B12E, 0xFFA1B22F, 0xFFACBA2B, 0xFFAEBC29,
    0xFFAEBC2A, 0xFFA0B030, 0xFF8C8140, 0xFF808A76, 0xFF96AC57, 0xFF9BB155, 0xFFA09D6D, 0xFFA6A26A, 0xFFB8C327,
    0xFFBAC525, 0xFFBCC725, 0xFFC29F1D, 0xFFC19E22, 0xFFC3A01C, 0xFFC5A11C, 0xFFC6A21D, 0xFFC9A31A, 0xFFC9A21F,
    0xFFCAA41A, 0xFFCCA31C, 0xFFCFA61C, 0xFFD3A819, 0xFFD8AB15, 0xFFDEAF13, 0xFFDCAC15, 0xFFC4A021, 0xFFE0B014,
    0xFFE6B211, 0xFFE7B410, 0xFFE8B310, 0xFFCBD31F, 0xFFC1CB23, 0xFFC3CD23, 0xFF82A6D1, 0xFF88ABD6, 0xFF8AADD8,
    0xFF8BAFDA, 0xFF8CAED9, 0xFF8BB0DF, 0xFF8BAFE2
#endif

};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalNXP_110x44 = {256, // Number of entries
                                                          0,   // No transparency
                                                          &_ColorsNXP_110x44[0]};

static GUI_CONST_STORAGE unsigned char _acNXP_110x44[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x70,
    0x2A, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x2A,
    0x09, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x11, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x08, 0x11, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0xE5, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
    0x1B, 0x1B, 0xE8, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x25, 0xB7, 0xB8, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0xDB, 0xB4, 0xB2, 0x1D, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB3, 0xB5, 0xAC, 0x23, 0x23, 0x23,
    0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0xAB, 0xC4, 0x17, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
    0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0xD7, 0xD4, 0xBA, 0xA9, 0x88, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xCB,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE7,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x28, 0xA0, 0x1D, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xAE, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0xBB, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x21, 0x21, 0x49, 0x77, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xBD, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5E, 0x58, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x30, 0x7A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x7F, 0x29, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x27, 0xD6, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x21, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x90, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x12, 0xBF, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x4F, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x50,
    0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xC5, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x10, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x3A, 0x2E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B,
    0x03, 0x03, 0x26, 0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x9E, 0x30, 0x03, 0x03, 0x0E, 0x0F,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x27, 0x2F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x10,
    0xA6, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x13, 0x01, 0x12, 0x56, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0xFA,
    0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xFB, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0xC9, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x61, 0x83, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x31, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01,
    0x01, 0x31, 0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x4B, 0x69, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x2A, 0x4D, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xBB, 0x10,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x53, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B,
    0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x12, 0xE4, 0xB9,
    0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x26, 0x8B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9B,
    0x29, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x34, 0x5C, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x55, 0x11, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x12, 0xC2, 0x05, 0x05, 0x05, 0x05,
    0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x50, 0x00, 0x00, 0x00, 0x00, 0x72, 0xFA, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x53, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x64, 0x8C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x3A, 0xDA, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x9D, 0x25, 0x00, 0x1C, 0x47, 0x28, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x62, 0x02, 0x02, 0x02, 0x02, 0xE1, 0xA8, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0xA5, 0x18, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0xA4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x33, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x57, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0xFD, 0x42, 0x00, 0x7E, 0x30, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0xD9,
    0x10, 0x02, 0x02, 0x02, 0x02, 0x20, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x06, 0x82, 0x2F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x38, 0x07, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01,
    0x01, 0x01, 0x01, 0xF5, 0x52, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xB1, 0x67,
    0x35, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x36, 0xF6, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x8D, 0x21, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xC6, 0x11, 0x00, 0x00, 0x00, 0x00, 0x08,
    0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0xE9, 0xDA, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x26, 0x4C, 0x26, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x34, 0xE0, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x20, 0x08, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x21, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31,
    0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xCD, 0x05, 0x0C,
    0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x0E, 0x0F, 0x04, 0x04, 0x39, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x2F, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x59, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x73, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF0, 0x2C, 0x0C, 0x0D, 0x0B, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04,
    0xF8, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x2F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x59, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37,
    0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xD0, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x18, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x62, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x59, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x76, 0x31, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xBC, 0x07, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xBE, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x51, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x61, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x59, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x86, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x8F, 0x07, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x5E, 0x5A, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x3C, 0x4A, 0x5D, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x20, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0x21, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x59, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x45, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x60, 0x94, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xDF,
    0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF,
    0xDD, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0xCA, 0x11, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x15, 0x07, 0x00, 0x07, 0x33, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12,
    0x43, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xDE, 0xFE, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3C, 0xDC, 0x10, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x20, 0x6F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x6E, 0x3E, 0xC3, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x38,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07,
    0x00, 0x00, 0x11, 0x37, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xEF, 0x6D, 0x00, 0x13,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xEB, 0x5A, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3C, 0x4A, 0x16, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x63, 0x17, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
    0xE2, 0x3B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xAA, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x00, 0x5E, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x36, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x21, 0x8E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x6B, 0xEE, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD3, 0xEA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A,
    0x57, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x0E, 0x0F, 0x04, 0xD5, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x21, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x2C, 0x0C, 0x0D, 0x0B,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F,
    0x04, 0x04, 0xF7, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xC1, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x28, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0xC7, 0x10,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x21, 0x78, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0xF1, 0xDA, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x29,
    0xA3, 0x29, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x34, 0x5C, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x10, 0x48, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x07, 0x92, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0xF3, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4C, 0x68, 0x4F, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0xBB, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x10, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
    0xCE, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x56, 0x05, 0x05, 0x05,
    0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x66, 0x3F, 0x00, 0x7B, 0xFC, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0xC9, 0x10, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x3B, 0x49, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE3, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xED, 0x2E, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x26, 0x46, 0x25, 0x00, 0x1D, 0xA1, 0x28, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04,
    0x04, 0x04, 0x04, 0x27, 0x2F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x64, 0x21, 0x63, 0xC8, 0x84, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xC0, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x35, 0x1D, 0x00, 0x00, 0x00, 0x00, 0xF9, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04,
    0xC5, 0x10, 0x02, 0x02, 0x02, 0x5B, 0x96, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x93, 0x87, 0x74, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0xF4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x12, 0x58, 0x2C, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x29, 0x7D, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x8A, 0x29, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x27, 0xD8, 0x02, 0x02,
    0x02, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
    0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF2, 0x2C, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x47, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x4B,
    0x03, 0x03, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x02, 0x02, 0x18, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x95, 0x60, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0xCF, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
    0x0D, 0x0B, 0x03, 0x03, 0x03, 0x65, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x66, 0x03, 0x03, 0x03,
    0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x39, 0x10, 0x02, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x2D, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
    0x91, 0x1A, 0x01, 0x01, 0x01, 0x01, 0xEC, 0x2E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03,
    0x29, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x46, 0x30, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x27, 0x5D, 0x02, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x37, 0x12, 0x01,
    0x01, 0x12, 0x52, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0xB0, 0x1C, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x35, 0x03, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x51, 0x10, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x07, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE6, 0x01, 0x12, 0xD1, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x03, 0x03, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7C, 0x29, 0x03, 0x0E, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x27, 0x59,
    0x59, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x5F, 0x5F, 0x2C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x0C, 0x0D, 0x0B, 0x28, 0x9F, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1D, 0xA2, 0x28, 0x0E, 0xAD, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xCC, 0x1F, 0x1F, 0x1F, 0x1F,
    0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0xB6, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x98, 0x99,
    0x4E, 0xAF, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x4D, 0x4E,
    0xA7, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x97, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x1C, 0x1C, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x09, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

GUI_CONST_STORAGE GUI_BITMAP bmNXP_110x44 = {110,             // xSize
                                             44,              // ySize
                                             110,             // BytesPerLine
                                             8,               // BitsPerPixel
                                             _acNXP_110x44,   // Pointer to picture data (indices)
                                             &_PalNXP_110x44, // Pointer to palette
                                             NULL};

/*************************** End of file ****************************/
