/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _USB_DEVICE_DESCRIPTOR_H_
#define _USB_DEVICE_DESCRIPTOR_H_ 1

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define USB_DEVICE_SPECIFIC_BCD_VERSION (0x0200)
#define USB_DEVICE_DEMO_BCD_VERSION     (0x0101U)

#define USB_DEVICE_VID (0x1FC9U)
#define USB_DEVICE_PID (0x0095U)

/* Communication  Class Codes */
#define CDC_COMM_CLASS (0x02)
/* Data  Class Codes */
#define CDC_DATA_CLASS (0x0A)

/* Communication Class SubClass Codes */
#define USB_CDC_DIRECT_LINE_CONTROL_MODEL         (0x01)
#define USB_CDC_ABSTRACT_CONTROL_MODEL            (0x02)
#define USB_CDC_TELEPHONE_CONTROL_MODEL           (0x03)
#define USB_CDC_MULTI_CHANNEL_CONTROL_MODEL       (0x04)
#define USB_CDC_CAPI_CONTROL_MOPDEL               (0x05)
#define USB_CDC_ETHERNET_NETWORKING_CONTROL_MODEL (0x06)
#define USB_CDC_ATM_NETWORKING_CONTROL_MODEL      (0x07)
#define USB_CDC_WIRELESS_HANDSET_CONTROL_MODEL    (0x08)
#define USB_CDC_DEVICE_MANAGEMENT                 (0x09)
#define USB_CDC_MOBILE_DIRECT_LINE_MODEL          (0x0A)
#define USB_CDC_OBEX                              (0x0B)
#define USB_CDC_ETHERNET_EMULATION_MODEL          (0x0C)

/* Communication Class Protocol Codes */
#define USB_CDC_NO_CLASS_SPECIFIC_PROTOCOL  (0x00) /*also for Data Class Protocol Code */
#define USB_CDC_AT_250_PROTOCOL             (0x01)
#define USB_CDC_AT_PCCA_101_PROTOCOL        (0x02)
#define USB_CDC_AT_PCCA_101_ANNEX_O         (0x03)
#define USB_CDC_AT_GSM_7_07                 (0x04)
#define USB_CDC_AT_3GPP_27_007              (0x05)
#define USB_CDC_AT_TIA_CDMA                 (0x06)
#define USB_CDC_ETHERNET_EMULATION_PROTOCOL (0x07)
#define USB_CDC_EXTERNAL_PROTOCOL           (0xFE)
#define USB_CDC_VENDOR_SPECIFIC             (0xFF) /*also for Data Class Protocol Code */

/* Data Class Protocol Codes */
#define USB_CDC_PYHSICAL_INTERFACE_PROTOCOL (0x30)
#define USB_CDC_HDLC_PROTOCOL               (0x31)
#define USB_CDC_TRANSPARENT_PROTOCOL        (0x32)
#define USB_CDC_MANAGEMENT_PROTOCOL         (0x50)
#define USB_CDC_DATA_LINK_Q931_PROTOCOL     (0x51)
#define USB_CDC_DATA_LINK_Q921_PROTOCOL     (0x52)
#define USB_CDC_DATA_COMPRESSION_V42BIS     (0x90)
#define USB_CDC_EURO_ISDN_PROTOCOL          (0x91)
#define USB_CDC_RATE_ADAPTION_ISDN_V24      (0x92)
#define USB_CDC_CAPI_COMMANDS               (0x93)
#define USB_CDC_HOST_BASED_DRIVER           (0xFD)
#define USB_CDC_UNIT_FUNCTIONAL             (0xFE)

/* Descriptor SubType in Communications Class Functional Descriptors */
#define USB_CDC_HEADER_FUNC_DESC              (0x00)
#define USB_CDC_CALL_MANAGEMENT_FUNC_DESC     (0x01)
#define USB_CDC_ABSTRACT_CONTROL_FUNC_DESC    (0x02)
#define USB_CDC_DIRECT_LINE_FUNC_DESC         (0x03)
#define USB_CDC_TELEPHONE_RINGER_FUNC_DESC    (0x04)
#define USB_CDC_TELEPHONE_REPORT_FUNC_DESC    (0x05)
#define USB_CDC_UNION_FUNC_DESC               (0x06)
#define USB_CDC_COUNTRY_SELECT_FUNC_DESC      (0x07)
#define USB_CDC_TELEPHONE_MODES_FUNC_DESC     (0x08)
#define USB_CDC_TERMINAL_FUNC_DESC            (0x09)
#define USB_CDC_NETWORK_CHANNEL_FUNC_DESC     (0x0A)
#define USB_CDC_PROTOCOL_UNIT_FUNC_DESC       (0x0B)
#define USB_CDC_EXTENSION_UNIT_FUNC_DESC      (0x0C)
#define USB_CDC_MULTI_CHANNEL_FUNC_DESC       (0x0D)
#define USB_CDC_CAPI_CONTROL_FUNC_DESC        (0x0E)
#define USB_CDC_ETHERNET_NETWORKING_FUNC_DESC (0x0F)
#define USB_CDC_ATM_NETWORKING_FUNC_DESC      (0x10)
#define USB_CDC_WIRELESS_CONTROL_FUNC_DESC    (0x11)
#define USB_CDC_MOBILE_DIRECT_LINE_FUNC_DESC  (0x12)
#define USB_CDC_MDLM_DETAIL_FUNC_DESC         (0x13)
#define USB_CDC_DEVICE_MANAGEMENT_FUNC_DESC   (0x14)
#define USB_CDC_OBEX_FUNC_DESC                (0x15)
#define USB_CDC_COMMAND_SET_FUNC_DESC         (0x16)
#define USB_CDC_COMMAND_SET_DETAIL_FUNC_DESC  (0x17)
#define USB_CDC_TELEPHONE_CONTROL_FUNC_DESC   (0x18)
#define USB_CDC_OBEX_SERVICE_ID_FUNC_DESC     (0x19)

/* usb descriptor length */
#define USB_DESCRIPTOR_LENGTH_CONFIGURATION_ALL (sizeof(g_UsbDeviceConfigurationDescriptor))
#define USB_DESCRIPTOR_LENGTH_CDC_HEADER_FUNC   (5)
#define USB_DESCRIPTOR_LENGTH_CDC_CALL_MANAG    (5)
#define USB_DESCRIPTOR_LENGTH_CDC_ABSTRACT      (4)
#define USB_DESCRIPTOR_LENGTH_CDC_UNION_FUNC    (5)

/* Configuration, interface and endpoint. */
#define USB_DEVICE_CONFIGURATION_COUNT (1)
#define USB_DEVICE_STRING_COUNT        (3)
#define USB_DEVICE_LANGUAGE_COUNT      (1)

#define USB_CDC_VNIC_CONFIGURE_INDEX (1)

#define USB_CDC_VNIC_ENDPOINT_CIC_COUNT             (1)
#define USB_CDC_VNIC_ENDPOINT_DIC_COUNT             (2)
#define USB_CDC_VNIC_INTERRUPT_IN_ENDPOINT          (1)
#define USB_CDC_VNIC_BULK_IN_ENDPOINT               (2)
#define USB_CDC_VNIC_BULK_OUT_ENDPOINT              (3)
#define USB_CDC_VNIC_INTERFACE_COUNT                (2)
#define USB_CDC_VNIC_COMM_INTERFACE_INDEX           (0)
#define USB_CDC_VNIC_DATA_INTERFACE_INDEX           (1)
#define USB_CDC_VNIC_COMM_INTERFACE_ALTERNATE_COUNT (1)
#define USB_CDC_VNIC_DATA_INTERFACE_ALTERNATE_COUNT (1)
#define USB_CDC_VNIC_COMM_INTERFACE_ALTERNATE_0     (0)
#define USB_CDC_VNIC_DATA_INTERFACE_ALTERNATE_0     (0)

/* Packet size. */
#define HS_CDC_VNIC_INTERRUPT_IN_PACKET_SIZE (16)
#define FS_CDC_VNIC_INTERRUPT_IN_PACKET_SIZE (16)
#define HS_CDC_VNIC_INTERRUPT_IN_INTERVAL    (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VNIC_INTERRUPT_IN_INTERVAL    (0x0A)
#define HS_CDC_VNIC_BULK_IN_PACKET_SIZE      (512)
#define FS_CDC_VNIC_BULK_IN_PACKET_SIZE      (64)
#define HS_CDC_VNIC_BULK_OUT_PACKET_SIZE     (512)
#define FS_CDC_VNIC_BULK_OUT_PACKET_SIZE     (64)

/* String descriptor length. */
#define USB_DESCRIPTOR_LENGTH_STRING0 (sizeof(g_UsbDeviceString0))
#define USB_DESCRIPTOR_LENGTH_STRING1 (sizeof(g_UsbDeviceString1))
#define USB_DESCRIPTOR_LENGTH_STRING2 (sizeof(g_UsbDeviceString2))

#define USB_DESCRIPTOR_TYPE_CDC_CS_INTERFACE (0x24)
#define USB_DESCRIPTOR_TYPE_CDC_CS_ENDPOINT  (0x25)

/* There is no need to install the INF by changing the class code, subclass code
 * and protocol code as the following:
 * #define USB_CDC_IFACE_DESCRIPTOR_VNIC_CIC_CLASS    (0xEF)
 * #define USB_CDC_IFACE_DESCRIPTOR_VNIC_CIC_SUBCLASS (0x04)
 * #define USB_CDC_IFACE_DESCRIPTOR_VNIC_CIC_PROTOCOL (0x01)
 * Note that the above change is only applied for descriptor, please do not change the codes of class driver.
 * This is not verified under all conditions, so please be cautious to change.
 */
#define USB_DEVICE_CLASS    (0x02)
#define USB_DEVICE_SUBCLASS (0x00)
#define USB_DEVICE_PROTOCOL (0x00)

#define USB_DEVICE_MAX_POWER (0x32)

#define USB_CDC_VNIC_CIC_CLASS    (CDC_COMM_CLASS)
#define USB_CDC_VNIC_CIC_SUBCLASS (USB_CDC_ABSTRACT_CONTROL_MODEL)
#define USB_CDC_VNIC_CIC_PROTOCOL (USB_CDC_NO_CLASS_SPECIFIC_PROTOCOL)

#define USB_CDC_VNIC_DIC_CLASS    (CDC_DATA_CLASS)
#define USB_CDC_VNIC_DIC_SUBCLASS (0x00)
#define USB_CDC_VNIC_DIC_PROTOCOL (USB_CDC_NO_CLASS_SPECIFIC_PROTOCOL)

/*******************************************************************************
 * API
 ******************************************************************************/
/*!
 * @brief USB device callback function.
 *
 * This function handles the usb device specific requests.
 *
 * @param handle          The USB device handle.
 * @param event           The USB device event type.
 * @param param           The parameter of the device specific request.
 *
 * @return A USB error code or kStatus_USB_Success.
 */
extern usb_status_t USB_DeviceCallback(usb_device_handle handle, uint32_t event, void *param);
/*!
 * @brief USB device set speed function.
 *
 * This function sets the speed of the USB device.
 *
 * Due to the difference of HS and FS descriptors, the device descriptors and configurations need to be updated to match
 * current speed.
 * As the default, the device descriptors and configurations are configured by using FS parameters for both EHCI and
 * KHCI.
 * When the EHCI is enabled, the application needs to call this function to update device by using current speed.
 * The updated information includes endpoint max packet size, endpoint interval, etc.
 *
 * @param handle The USB device handle.
 * @param speed Speed type. USB_SPEED_HIGH/USB_SPEED_FULL/USB_SPEED_LOW.
 *
 * @return A USB error code or kStatus_USB_Success.
 */
extern usb_status_t USB_DeviceSetSpeed(usb_device_handle handle, uint8_t speed);
#endif /* _USB_DEVICE_DESCRIPTOR_H_ */
