/*
 *
 * Copyright 2019 NXP
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef SSS_AUTH_SE050_OEF_20191211_1809_
#define SSS_AUTH_SE050_OEF_20191211_1809_

/* ************************************************************************** */
/* Includes                                                                   */
/* ************************************************************************** */

/* ************************************************************************** */
/* Defines                                                                    */
/* ************************************************************************** */

/* clang-format off */



/* See https://www.nxp.com/docs/en/application-note/AN12436.pdf */

// Variant           ==> OEF ID
// SE050A1           ==> A204
// SE050A2           ==> A205
// SE050B1           ==> A202
// SE050B2           ==> A203
// SE050C1           ==> A200
// SE050C2           ==> A201
// Development Board ==> A1F4 (DEVKIT)

//SE051C             ==>0xA8FA
//SE051A             ==>0xA920
//SE050E              ==>0xA921
//SE051W(Fira)       ==>0xA739
//A5000 gen          ==>0xA736
//SE050F2            ==>0xA92A



// SE050A1
#define SSS_AUTH_SE050A1_KEY_ENC \
    {0x34, 0xae, 0x09, 0x67, 0xe3, 0x29, 0xe9, 0x51, 0x8e, 0x72, 0x65, 0xd5, 0xad, 0xcc, 0x01, 0xc2 }
#define SSS_AUTH_SE050A1_KEY_MAC \
    {0x52, 0xb2, 0x53, 0xca, 0xdf, 0x47, 0x2b, 0xdb, 0x3d, 0x0f, 0xb3, 0x8e, 0x09, 0x77, 0x00, 0x99 }
#define SSS_AUTH_SE050A1_KEY_DEK \
    {0xac, 0xc9, 0x14, 0x31, 0xfe, 0x26, 0x81, 0x1b, 0x5e, 0xcb, 0xc8, 0x45, 0x62, 0x0d, 0x83, 0x44 }

// SE050A2
#define SSS_AUTH_SE050A2_KEY_ENC \
    {0x46, 0xa9, 0xc4, 0x8c, 0x34, 0xef, 0xe3, 0x44, 0xa5, 0x22, 0xe6, 0x67, 0x44, 0xf8, 0x99, 0x6a }
#define SSS_AUTH_SE050A2_KEY_MAC \
    {0x12, 0x03, 0xff, 0x61, 0xdf, 0xbc, 0x9c, 0x86, 0x19, 0x6a, 0x22, 0x74, 0xae, 0xf4, 0xed, 0x28 }
#define SSS_AUTH_SE050A2_KEY_DEK \
    {0xf7, 0x56, 0x1c, 0x6f, 0x48, 0x33, 0x61, 0x19, 0xee, 0x39, 0x43, 0x9a, 0xab, 0x34, 0x09, 0x8e }

// SE050B1
#define SSS_AUTH_SE050B1_KEY_ENC \
    {0xd4, 0x99, 0xbc, 0x90, 0xde, 0xa5, 0x42, 0xcf, 0x78, 0xd2, 0x5e, 0x13, 0xd6, 0x4c, 0xbb, 0x1f }
#define SSS_AUTH_SE050B1_KEY_MAC \
    {0x08, 0x15, 0x55, 0x96, 0x43, 0xfb, 0x79, 0xeb, 0x85, 0x01, 0xa0, 0xdc, 0x83, 0x3d, 0x90, 0x1f }
#define SSS_AUTH_SE050B1_KEY_DEK \
    {0xbe, 0x7d, 0xdf, 0xb4, 0x06, 0xe8, 0x1a, 0xe4, 0xe9, 0x66, 0x5a, 0x9f, 0xed, 0x64, 0x26, 0x7c }

// SE050B2
#define SSS_AUTH_SE050B2_KEY_ENC \
    {0x5f, 0xa4, 0x3d, 0x82, 0x02, 0xd2, 0x5e, 0x9a, 0x85, 0xb1, 0xfe, 0x7e, 0x2d, 0x26, 0x47, 0x8d }
#define SSS_AUTH_SE050B2_KEY_MAC \
    {0x10, 0x5c, 0xea, 0x22, 0x19, 0xf5, 0x2b, 0xd1, 0x67, 0xa0, 0x74, 0x63, 0xc6, 0x93, 0x79, 0xc3 }
#define SSS_AUTH_SE050B2_KEY_DEK \
    {0xd7, 0x02, 0x81, 0x57, 0xf2, 0xad, 0x37, 0x2c, 0x74, 0xbe, 0x96, 0x9b, 0xcc, 0x39, 0x06, 0x27 }

// SE050C1
#define SSS_AUTH_SE050C1_KEY_ENC \
    {0x85, 0x2b, 0x59, 0x62, 0xe9, 0xcc, 0xe5, 0xd0, 0xbe, 0x74, 0x6b, 0x83, 0x3b, 0xcc, 0x62, 0x87 }
#define SSS_AUTH_SE050C1_KEY_MAC \
    {0xdb, 0x0a, 0xa3, 0x19, 0xa4, 0x08, 0x69, 0x6c, 0x8e, 0x10, 0x7a, 0xb4, 0xe3, 0xc2, 0x6b, 0x47 }
#define SSS_AUTH_SE050C1_KEY_DEK \
    {0x4c, 0x2f, 0x75, 0xc6, 0xa2, 0x78, 0xa4, 0xae, 0xe5, 0xc9, 0xaf, 0x7c, 0x50, 0xee, 0xa8, 0x0c }

// SE050C2
#define SSS_AUTH_SE050C2_KEY_ENC \
    {0xbd, 0x1d, 0xe2, 0x0a, 0x81, 0xea, 0xb2, 0xbf, 0x3b, 0x70, 0x9a, 0x9d, 0x69, 0xa3, 0x12, 0x54 }
#define SSS_AUTH_SE050C2_KEY_MAC \
    {0x9a, 0x76, 0x1b, 0x8d, 0xba, 0x6b, 0xed, 0xf2, 0x27, 0x41, 0xe4, 0x5d, 0x8d, 0x42, 0x36, 0xf5 }
#define SSS_AUTH_SE050C2_KEY_DEK \
    {0x9b, 0x99, 0x3b, 0x60, 0x0f, 0x1c, 0x64, 0xf5, 0xad, 0xc0, 0x63, 0x19, 0x2a, 0x96, 0xc9, 0x47 }

// SE050_DEVKIT
#define SSS_AUTH_SE050_DEVKIT_KEY_ENC \
    {0x35, 0xc2, 0x56, 0x45, 0x89, 0x58, 0xa3, 0x4f, 0x61, 0x36, 0x15, 0x5f, 0x82, 0x09, 0xd6, 0xcd }
#define SSS_AUTH_SE050_DEVKIT_KEY_MAC \
    {0xaf, 0x17, 0x7d, 0x5d, 0xbd, 0xf7, 0xc0, 0xd5, 0xc1, 0x0a, 0x05, 0xb9, 0xf1, 0x60, 0x7f, 0x78 }
#define SSS_AUTH_SE050_DEVKIT_KEY_DEK \
    {0xa1, 0xbc, 0x84, 0x38, 0xbf, 0x77, 0x93, 0x5b, 0x36, 0x1a, 0x44, 0x25, 0xfe, 0x79, 0xfa, 0x29 }

// SE051A2 
#define SSS_AUTH_SE051A2_KEY_ENC \
    { 0x84, 0x0a, 0x5d, 0x51, 0x79, 0x55, 0x11, 0xc9, 0xce, 0xf0, 0xc9, 0x6f, 0xd2, 0xcb, 0xf0, 0x41 }
#define SSS_AUTH_SE051A2_KEY_MAC \
    { 0x64, 0x6b, 0xc2, 0xb8, 0xc3, 0xa4, 0xd9, 0xc1, 0xfa, 0x8d, 0x71, 0x16, 0xbe, 0x04, 0xfd, 0xfe }
#define SSS_AUTH_SE051A2_KEY_DEK \
    { 0x03, 0xe6, 0x69, 0x9a, 0xca, 0x94, 0x26, 0xd9, 0xc3, 0x89, 0x22, 0xf8, 0x91, 0x4c, 0xe5, 0xf7 }

// SE051C2 
#define SSS_AUTH_SE051C2_KEY_ENC \
    { 0x88, 0xdb, 0xcd, 0x65, 0x82, 0x0d, 0x2a, 0xa0, 0x6f, 0xfa, 0xb9, 0x2a, 0xa8, 0xe7, 0x93, 0x64 }
#define SSS_AUTH_SE051C2_KEY_MAC \
    { 0xa8, 0x64, 0x4e, 0x2a, 0x04, 0xd9, 0xe9, 0xc8, 0xc0, 0xea, 0x60, 0x86, 0x68, 0x29, 0x99, 0xe5 }
#define SSS_AUTH_SE051C2_KEY_DEK \
    { 0x8a, 0x38, 0x72, 0x38, 0x99, 0x88, 0x18, 0x44, 0xe2, 0xc1, 0x51, 0x3d, 0xac, 0xd9, 0xf8, 0x0d }

// SE050F2
#define SSS_AUTH_SE050F2_KEY_ENC \
    { 0x91, 0x88, 0xda, 0x8c, 0xf3, 0x69, 0xcf, 0xa9, 0xa0, 0x08, 0x91, 0x62, 0x7b, 0x65, 0x34, 0x5a }
#define SSS_AUTH_SE050F2_KEY_MAC \
    { 0xcb, 0x20, 0xf8, 0x09, 0xc7, 0xa0, 0x39, 0x32, 0xbc, 0x20, 0x3b, 0x0a, 0x01, 0x81, 0x6c, 0x81 }
#define SSS_AUTH_SE050F2_KEY_DEK \
    { 0x27, 0x8e, 0x61, 0x9d, 0x83, 0x51, 0x8e, 0x14, 0xc6, 0xf1, 0xe4, 0xfa, 0x96, 0x8b, 0xe5, 0x1c }


//SE051C             ==>0xA8FA
#define SSS_AUTH_SE051C_0005A8FA_KEY_ENC \
    { 0xbf, 0xc2, 0xdb, 0xe1, 0x82, 0x8e, 0x03, 0x5d, 0x3e, 0x7f, 0xa3, 0x6b, 0x90, 0x2a, 0x05, 0xc6 }
#define SSS_AUTH_SE051C_0005A8FA_KEY_MAC \
    { 0xbe, 0xf8, 0x5b, 0xd7, 0xba, 0x04, 0x97, 0xd6, 0x28, 0x78, 0x1c, 0xe4, 0x7b, 0x18, 0x8c, 0x96 }
#define SSS_AUTH_SE051C_0005A8FA_KEY_DEK \
    { 0xd8, 0x73, 0xf3, 0x16, 0xbe, 0x29, 0x7f, 0x2f, 0xc9, 0xc0, 0xe4, 0x5f, 0x54, 0x71, 0x06, 0x99 }

//SE051A             ==>0xA920
#define SSS_AUTH_SE051A_0001A920_KEY_ENC \
    { 0x88, 0xea, 0x9f, 0xa6, 0x86, 0xf3, 0xcf, 0x2f, 0xfc, 0xaf, 0x4b, 0x1c, 0xba, 0x93, 0xe4, 0x42 }
#define SSS_AUTH_SE051A_0001A920_KEY_MAC \
    { 0x4f, 0x16, 0x3f, 0x59, 0xf0, 0x74, 0x31, 0xf4, 0x3e, 0xe2, 0xee, 0x18, 0x34, 0xa5, 0x23, 0x34 }
#define SSS_AUTH_SE051A_0001A920_KEY_DEK \
    { 0xd4, 0x76, 0xcf, 0x47, 0xaa, 0x27, 0xb5, 0x4a, 0xb3, 0xdb, 0xeb, 0xe7, 0x65, 0x6d, 0x67, 0x70 }


//SE050E              ==>0xA921
#define SSS_AUTH_SE050E_0001A921_KEY_ENC \
    { 0xd2, 0xdb, 0x63, 0xe7, 0xa0, 0xa5, 0xae, 0xd7, 0x2a, 0x64, 0x60, 0xc4, 0xdf, 0xdc, 0xaf, 0x64 }
#define SSS_AUTH_SE050E_0001A921_KEY_MAC \
    { 0x73, 0x8d, 0x5b, 0x79, 0x8e, 0xd2, 0x41, 0xb0, 0xb2, 0x47, 0x68, 0x51, 0x4b, 0xfb, 0xa9, 0x5b }
#define SSS_AUTH_SE050E_0001A921_KEY_DEK \
    { 0x67, 0x02, 0xda, 0xc3, 0x09, 0x42, 0xb2, 0xc8, 0x5e, 0x7f, 0x47, 0xb4, 0x2c, 0xed, 0x4e, 0x7f }

//SE051W(Fira)       ==>0xA739
#define SSS_AUTH_SE051W_0004A739_KEY_ENC \
    { 0x18, 0xb3, 0xb4, 0xe3, 0x40, 0xc0, 0x80, 0xd9, 0x9b, 0xeb, 0xb8, 0xb8, 0x64, 0x4b, 0x8c, 0x52 }
#define SSS_AUTH_SE051W_0004A739_KEY_MAC \
    { 0x3d, 0x0c, 0xfa, 0xc8, 0x7b, 0x96, 0x7c, 0x00, 0xe3, 0x3b, 0xa4, 0x96, 0x61, 0x38, 0x38, 0xa2 }
#define SSS_AUTH_SE051W_0004A739_KEY_DEK \
    { 0x68, 0x06, 0x83, 0xf9, 0x4e, 0x6b, 0xcb, 0x94, 0x73, 0xec, 0xc1, 0x56, 0x7a, 0x1b, 0xd1, 0x09 }

//A5000 gen          ==>0xA736
#define SSS_AUTH_A5000_0004A736_KEY_ENC \
    { 0xc9, 0x11, 0x85, 0x00, 0xb5, 0xff, 0xa1, 0x43, 0x3a, 0x50, 0x22, 0x6f, 0x48, 0x9a, 0x0a, 0xa5 }
#define SSS_AUTH_A5000_0004A736_KEY_MAC \
    { 0x29, 0xd2, 0xfe, 0x28, 0xf7, 0xfe, 0xeb, 0x15, 0x30, 0x68, 0xbe, 0x38, 0x1f, 0x61, 0xbc, 0x01 }
#define SSS_AUTH_A5000_0004A736_KEY_DEK \
    { 0x61, 0x24, 0xd3, 0x84, 0x02, 0x11, 0x80, 0x60, 0xed, 0x91, 0x03, 0x60, 0xfc, 0x5a, 0x42, 0x78 }

//SE050F2            ==>0xA92A
#define SSS_AUTH_SE050F2_0001A92A_KEY_ENC \
    { 0xb5, 0x0e, 0x1f, 0x12, 0xb8, 0x1f, 0xe5, 0x3b, 0x6c, 0x3b, 0x53, 0x87, 0x91, 0x2a, 0x1a, 0x5a }
#define SSS_AUTH_SE050F2_0001A92A_KEY_MAC \
    { 0x71, 0x93, 0x69, 0x59, 0xd3, 0x7f, 0x2b, 0x22, 0xc5, 0xa0, 0xc3, 0x49, 0x19, 0xa2, 0xbc, 0x1f }
#define SSS_AUTH_SE050F2_0001A92A_KEY_DEK \
    { 0x86, 0x95, 0x93, 0x23, 0x98, 0x54, 0xdc, 0x0d, 0x86, 0x99, 0x00, 0x50, 0x0c, 0xa7, 0x9c, 0x15 }



/* clang-format on */

/* ************************************************************************** */
/* Structures and Typedefs                                                    */
/* ************************************************************************** */

/* ************************************************************************** */
/* Global Variables                                                           */
/* ************************************************************************** */

/* ************************************************************************** */
/* Functions                                                                  */
/* ************************************************************************** */

#endif /* SSS_AUTH_SE050_OEF_20191211_1809_  */