/*
 * Copyright 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitADC(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitENC(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitLPUART(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPWM(void);

#define BOARD_MISC_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x0200U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */

/* GPIO_AD_B0_09 (coord F14), UserLed */
/* Routed pin properties */
#define BOARD_MISC_UserLed_PERIPHERAL                                      GPIO1   /*!< Peripheral name */
#define BOARD_MISC_UserLed_SIGNAL                                        gpio_io   /*!< Signal name */
#define BOARD_MISC_UserLed_CHANNEL                                            9U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_MISC_UserLed_GPIO                                            GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_MISC_UserLed_GPIO_PIN                                           9U   /*!< GPIO pin number */
#define BOARD_MISC_UserLed_GPIO_PIN_MASK                              (1U << 9U)   /*!< GPIO pin mask */
#define BOARD_MISC_UserLed_PORT                                            GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_MISC_UserLed_PIN                                                9U   /*!< PORT pin number */
#define BOARD_MISC_UserLed_PIN_MASK                                   (1U << 9U)   /*!< PORT pin mask */

/* WAKEUP (coord L6), SW8 */
/* Routed pin properties */
#define BOARD_MISC_SW8_PERIPHERAL                                          GPIO5   /*!< Peripheral name */
#define BOARD_MISC_SW8_SIGNAL                                            gpio_io   /*!< Signal name */
#define BOARD_MISC_SW8_CHANNEL                                                0U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_MISC_SW8_GPIO                                                GPIO5   /*!< GPIO peripheral base pointer */
#define BOARD_MISC_SW8_GPIO_PIN                                               0U   /*!< GPIO pin number */
#define BOARD_MISC_SW8_GPIO_PIN_MASK                                  (1U << 0U)   /*!< GPIO pin mask */
#define BOARD_MISC_SW8_PORT                                                GPIO5   /*!< PORT peripheral base pointer */
#define BOARD_MISC_SW8_PIN                                                    0U   /*!< PORT pin number */
#define BOARD_MISC_SW8_PIN_MASK                                       (1U << 0U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_Misc(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitCMP(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
