/*
 * Copyright 2021 Embedded Artists AB
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/


/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/* Aliases to deal with all the different example setups without having to
   patch every example in the SDK.*/
void BOARD_InitPins(void);
void BOARD_InitEnetPins(void);
void BOARD_InitCSIPins(void);
void BOARD_InitI2C1Pins(void);
void BOARD_I2C_ConfigurePins(void);
void BOARD_InitParallelRGBPins(void);

/* Functions needed to setup interfaces that conflicts with the default
   setupt, i.e. pins have different functions. ENET2 conflicts with display
   pins, Semc (i.e. SDRAM) can only be called under certain circumstances
   and the Wi-Fi pins conflict with the uSD card pins. */
void BOARD_InitEnet2Pins(void);
void BOARD_InitSemcPins(void);
void BOARD_InitWiFiPins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
