/*******************************************************************************
* Copyright (c) 2018-2020 Cadence Design Systems, Inc.
* 
* Permission is hereby granted, free of charge, to any person obtaining
* a copy of this software and associated documentation files (the
* "Software"), to use this Software with Cadence processor cores only and 
* not with any other processors and platforms, subject to
* the following conditions:
* 
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************/

#define FIX_INV_Q31(x)  (unsigned int)(((unsigned int)1<<31)/((float)x))

/* 1/num in Q31 format for num = 0 - 256 */
const unsigned int inv_256_tbl[257] = {
    0,
    FIX_INV_Q31(  1), FIX_INV_Q31(  2), FIX_INV_Q31(  3), FIX_INV_Q31(  4),
    FIX_INV_Q31(  5), FIX_INV_Q31(  6), FIX_INV_Q31(  7), FIX_INV_Q31(  8),
    FIX_INV_Q31(  9), FIX_INV_Q31( 10), FIX_INV_Q31( 11), FIX_INV_Q31( 12),
    FIX_INV_Q31( 13), FIX_INV_Q31( 14), FIX_INV_Q31( 15), FIX_INV_Q31( 16),
    FIX_INV_Q31( 17), FIX_INV_Q31( 18), FIX_INV_Q31( 19), FIX_INV_Q31( 20),
    FIX_INV_Q31( 21), FIX_INV_Q31( 22), FIX_INV_Q31( 23), FIX_INV_Q31( 24),
    FIX_INV_Q31( 25), FIX_INV_Q31( 26), FIX_INV_Q31( 27), FIX_INV_Q31( 28),
    FIX_INV_Q31( 29), FIX_INV_Q31( 30), FIX_INV_Q31( 31), FIX_INV_Q31( 32),
    FIX_INV_Q31( 33), FIX_INV_Q31( 34), FIX_INV_Q31( 35), FIX_INV_Q31( 36),
    FIX_INV_Q31( 37), FIX_INV_Q31( 38), FIX_INV_Q31( 39), FIX_INV_Q31( 40),
    FIX_INV_Q31( 41), FIX_INV_Q31( 42), FIX_INV_Q31( 43), FIX_INV_Q31( 44),
    FIX_INV_Q31( 45), FIX_INV_Q31( 46), FIX_INV_Q31( 47), FIX_INV_Q31( 48),
    FIX_INV_Q31( 49), FIX_INV_Q31( 50), FIX_INV_Q31( 51), FIX_INV_Q31( 52),
    FIX_INV_Q31( 53), FIX_INV_Q31( 54), FIX_INV_Q31( 55), FIX_INV_Q31( 56),
    FIX_INV_Q31( 57), FIX_INV_Q31( 58), FIX_INV_Q31( 59), FIX_INV_Q31( 60),
    FIX_INV_Q31( 61), FIX_INV_Q31( 62), FIX_INV_Q31( 63), FIX_INV_Q31( 64),
    FIX_INV_Q31( 65), FIX_INV_Q31( 66), FIX_INV_Q31( 67), FIX_INV_Q31( 68),
    FIX_INV_Q31( 69), FIX_INV_Q31( 70), FIX_INV_Q31( 71), FIX_INV_Q31( 72),
    FIX_INV_Q31( 73), FIX_INV_Q31( 74), FIX_INV_Q31( 75), FIX_INV_Q31( 76),
    FIX_INV_Q31( 77), FIX_INV_Q31( 78), FIX_INV_Q31( 79), FIX_INV_Q31( 80),
    FIX_INV_Q31( 81), FIX_INV_Q31( 82), FIX_INV_Q31( 83), FIX_INV_Q31( 84),
    FIX_INV_Q31( 85), FIX_INV_Q31( 86), FIX_INV_Q31( 87), FIX_INV_Q31( 88),
    FIX_INV_Q31( 89), FIX_INV_Q31( 90), FIX_INV_Q31( 91), FIX_INV_Q31( 92),
    FIX_INV_Q31( 93), FIX_INV_Q31( 94), FIX_INV_Q31( 95), FIX_INV_Q31( 96),
    FIX_INV_Q31( 97), FIX_INV_Q31( 98), FIX_INV_Q31( 99), FIX_INV_Q31(100),
    FIX_INV_Q31(101), FIX_INV_Q31(102), FIX_INV_Q31(103), FIX_INV_Q31(104),
    FIX_INV_Q31(105), FIX_INV_Q31(106), FIX_INV_Q31(107), FIX_INV_Q31(108),
    FIX_INV_Q31(109), FIX_INV_Q31(110), FIX_INV_Q31(111), FIX_INV_Q31(112),
    FIX_INV_Q31(113), FIX_INV_Q31(114), FIX_INV_Q31(115), FIX_INV_Q31(116),
    FIX_INV_Q31(117), FIX_INV_Q31(118), FIX_INV_Q31(119), FIX_INV_Q31(120),
    FIX_INV_Q31(121), FIX_INV_Q31(122), FIX_INV_Q31(123), FIX_INV_Q31(124),
    FIX_INV_Q31(125), FIX_INV_Q31(126), FIX_INV_Q31(127), FIX_INV_Q31(128),
    FIX_INV_Q31(129), FIX_INV_Q31(130), FIX_INV_Q31(131), FIX_INV_Q31(132),
    FIX_INV_Q31(133), FIX_INV_Q31(134), FIX_INV_Q31(135), FIX_INV_Q31(136),
    FIX_INV_Q31(137), FIX_INV_Q31(138), FIX_INV_Q31(139), FIX_INV_Q31(140),
    FIX_INV_Q31(141), FIX_INV_Q31(142), FIX_INV_Q31(143), FIX_INV_Q31(144),
    FIX_INV_Q31(145), FIX_INV_Q31(146), FIX_INV_Q31(147), FIX_INV_Q31(148),
    FIX_INV_Q31(149), FIX_INV_Q31(150), FIX_INV_Q31(151), FIX_INV_Q31(152),
    FIX_INV_Q31(153), FIX_INV_Q31(154), FIX_INV_Q31(155), FIX_INV_Q31(156),
    FIX_INV_Q31(157), FIX_INV_Q31(158), FIX_INV_Q31(159), FIX_INV_Q31(160),
    FIX_INV_Q31(161), FIX_INV_Q31(162), FIX_INV_Q31(163), FIX_INV_Q31(164),
    FIX_INV_Q31(165), FIX_INV_Q31(166), FIX_INV_Q31(167), FIX_INV_Q31(168),
    FIX_INV_Q31(169), FIX_INV_Q31(170), FIX_INV_Q31(171), FIX_INV_Q31(172),
    FIX_INV_Q31(173), FIX_INV_Q31(174), FIX_INV_Q31(175), FIX_INV_Q31(176),
    FIX_INV_Q31(177), FIX_INV_Q31(178), FIX_INV_Q31(179), FIX_INV_Q31(180),
    FIX_INV_Q31(181), FIX_INV_Q31(182), FIX_INV_Q31(183), FIX_INV_Q31(184),
    FIX_INV_Q31(185), FIX_INV_Q31(186), FIX_INV_Q31(187), FIX_INV_Q31(188),
    FIX_INV_Q31(189), FIX_INV_Q31(190), FIX_INV_Q31(191), FIX_INV_Q31(192),
    FIX_INV_Q31(193), FIX_INV_Q31(194), FIX_INV_Q31(195), FIX_INV_Q31(196),
    FIX_INV_Q31(197), FIX_INV_Q31(198), FIX_INV_Q31(199), FIX_INV_Q31(200),
    FIX_INV_Q31(201), FIX_INV_Q31(202), FIX_INV_Q31(203), FIX_INV_Q31(204),
    FIX_INV_Q31(205), FIX_INV_Q31(206), FIX_INV_Q31(207), FIX_INV_Q31(208),
    FIX_INV_Q31(209), FIX_INV_Q31(210), FIX_INV_Q31(211), FIX_INV_Q31(212),
    FIX_INV_Q31(213), FIX_INV_Q31(214), FIX_INV_Q31(215), FIX_INV_Q31(216),
    FIX_INV_Q31(217), FIX_INV_Q31(218), FIX_INV_Q31(219), FIX_INV_Q31(220),
    FIX_INV_Q31(221), FIX_INV_Q31(222), FIX_INV_Q31(223), FIX_INV_Q31(224),
    FIX_INV_Q31(225), FIX_INV_Q31(226), FIX_INV_Q31(227), FIX_INV_Q31(228),
    FIX_INV_Q31(229), FIX_INV_Q31(230), FIX_INV_Q31(231), FIX_INV_Q31(232),
    FIX_INV_Q31(233), FIX_INV_Q31(234), FIX_INV_Q31(235), FIX_INV_Q31(236),
    FIX_INV_Q31(237), FIX_INV_Q31(238), FIX_INV_Q31(239), FIX_INV_Q31(240),
    FIX_INV_Q31(241), FIX_INV_Q31(242), FIX_INV_Q31(243), FIX_INV_Q31(244),
    FIX_INV_Q31(245), FIX_INV_Q31(246), FIX_INV_Q31(247), FIX_INV_Q31(248),
    FIX_INV_Q31(249), FIX_INV_Q31(250), FIX_INV_Q31(251), FIX_INV_Q31(252),
    FIX_INV_Q31(253), FIX_INV_Q31(254), FIX_INV_Q31(255), FIX_INV_Q31(256)
};
