/*
 * coreMQTT v1.1.0
 * Copyright (C) 2020 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file get_time_stub.c
 * @brief A stub to mock the retrieval of current time.
 */

#include "core_mqtt.h"
#include "get_time_stub.h"

uint32_t GetCurrentTimeStub( void )
{
    /* There are loops in the MQTT library that rely on the timestamp being
     * reasonable in order to complete. Returning an unbounded timestamp does
     * not add value to the proofs as the MQTT library uses the timestamp for
     * only arithmetic operations. In C arithmetic operations on unsigned
     * integers are guaranteed to reliably wrap around with no adverse side
     * effects. If the time returned was unbounded, the loops could be unwound
     * a large number of times making the proof execution very long. */
    static uint32_t globalEntryTime = 0;

    return ++globalEntryTime;
}
