/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "wifi_bt_config.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#ifdef WIFI_BT_USE_M2_INTERFACE
  /* The iMXRT1064 Developers Kit does not have support for the M.2 connector
     so make sure to prevent selection of a module that use it. */
  #error "M.2 interface is not supported on this board"
#endif

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/

void BOARD_WIFI_BT_Enable(bool enable)
{
    if (enable)
    {
        /* Enable module */
#ifdef WIFI_BT_USE_USD_INTERFACE

        /* Enable power supply for SD */
        GPIO_PinWrite(BOARD_SDMMC_SD_POWER_RESET_GPIO_BASE, BOARD_SDMMC_SD_POWER_RESET_GPIO_PIN, 1);

        /* Control WL_REG_ON. To use this make sure J9 pin 3 on the uSD-M2 Adapter is
           connected to J32 pin 2 (INT) on the uCOM Carrier Board with a cable.*/
        GPIO_PinWrite(GPIO3, 2, 1);

#elif defined(WIFI_BT_USE_ONBOARD_MODULE)

        /* For onboard Wi-Fi chip, pull RF_EN high */
        GPIO_PinWrite(GPIO1, 8, 1);

#endif /* WIFI_BT_USE_USD_INTERFACE */
    }
    else
    {
        /* Disable module */
#ifdef WIFI_BT_USE_USD_INTERFACE

        /* Disable power supply for SD */
        GPIO_PinWrite(BOARD_SDMMC_SD_POWER_RESET_GPIO_BASE, BOARD_SDMMC_SD_POWER_RESET_GPIO_PIN, 0);

        /* Control WL_REG_ON. To use this make sure J9 pin 3 on the uSD-M2 Adapter is
           connected to J32 pin 2 (INT) on the uCOM Carrier Board with a cable.*/
        GPIO_PinWrite(GPIO3, 2, 0);

#elif defined(WIFI_BT_USE_ONBOARD_MODULE)

        /* For onboard Wi-Fi chip, pull RF_EN low */
        GPIO_PinWrite(GPIO1, 8, 0);

#endif /* WIFI_BT_USE_USD_INTERFACE */
    }

    vTaskDelay(pdMS_TO_TICKS(100));
}

void BOARD_WIFI_BT_Config(void *card, sdio_int_t cardInt)
{
    BOARD_SDIO_Config(card, NULL, BOARD_SDMMC_SDIO_HOST_IRQ_PRIORITY, cardInt);
    BOARD_WIFI_BT_Enable(false);
}
