# Submitting Patches

Development on mcuboot primarily takes place in github, at:
https://github.com/mcu-tools/mcuboot

Changes should be submitted via github pull requests.  Each commit
should have a Signed-off-by line for the author (and the committer, if
that is different).  It is not necessary (or possible) to get a
Signed-off-by from Github itself, even though some commits may be
generated by that tool.

The Signed-off-by line should be at the end of the commit text, in the
last blank-line-separated section.  There can be multiple lines in
this section (the format being roughly like RFC-2822).  Currently
supported trailer lines are:

    Signed-off-by: Developer Name <devname@example.com>

which indicates that the signer agrees to the Developer Certificate of
Origin below, and

    JIRA: MCUB-1234

which associates this commit with a particular JIRA ticket.  You can
put more than one JIRA ticket, by separating them with a comma and a
space.  JIRA is quite flexible about where the indicators go, but
putting them in a trailer with a common format will make them easier
to find later.

# Developer Certificate of Origin

```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
1 Letterman Drive
Suite D4700
San Francisco, CA, 94129

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.


Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```
