
This SDK has been patched by Embedded Artists for the iMXRT1064 Developer's Kit.
The SDK was released on 2024-03-25 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1064xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Correction of the VDD_SOC_IN voltage.
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using a display have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed reset pin for SD card examples

This has been added:
* LWIP projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AWS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AzureRTOS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* I2C probe example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1064.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work


Connectors:
* J29 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


All CAN-related examples use either
* FLEXCAN2 on GPIO_AD_B0_14 and GPIO_AD_B0_15 or
* FLEXCAN3 on GPIO_AD_B0_14 and GPIO_AD_B0_15
So it is the same physical pins regardless of bus selection.

The uCOM Carrier Board rev C has two onboard CAN trancievers.
The examples only use one bus so it is up to personal
preference which of the two transcievers to use (channel A
or channel B).

The uCOM Carrier Boards older than rev C (rev PB2, PB3 and B)
have no CAN trancievers. However, using for example the
Adafruit CAN Pal (https://www.adafruit.com/product/5708)
makes it possible to run the CAN bus examples in the SDK.

On uCOM Carrier Board rev PB2 or PB3:

    J15-37 connects to TX on the Adafruit board
    J15-38 connects to RX on the Adafruit board
    J31-7  connects to VCC on the Adafruit board
    J31-8  connects to GND on the Adafruit board

On uCOM Carrier Board rev B:

    J15-29 connects to TX on the Adafruit board
    J15-30 connects to RX on the Adafruit board
    J31-7  connects to VCC on the Adafruit board
    J31-8  connects to GND on the Adafruit board

On uCOM Carrier Board rev C:

    Using CAN channel A:
        JP51-2 connects to JP48-1 for TX
        JP51-1 connects to JP48-2 for RX

        CAN-A_H is available on JP49-1
        CAN-A_L is available on JP49-2
        GND     is available on JP49-3

    Using CAN channel B:
        JP51-2 connects to JP48-4 for TX
        JP51-1 connects to JP48-5 for RX

        CAN-B_H is available on JP50-1
        CAN-B_L is available on JP50-2
        GND     is available on JP50-3


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
The mco_slave/mcofd_slave example implements a minimal CANopen CiA 401 generic I/O device.
It produces a cyclic heartbeat message (703h) and waits to be detected by a 
CANopen Manager. It replies to (SDO) requests received by the manager.

NOTE: For more details, please see the User's Manual for the
EmSA CANopen (FD) Libraries for NXP SDKs.


Implementation Description
Node-ID: 0x03, Baudrate: 500kbps

Messages produced (by CAN ID):
0x083 - Emergency and emergency reset
0x583 - SDO responses to requests
0x703 - Heartbeat (default 1000ms)
In operatinal state:
0x183 - TPDO1 - Total of 4 input Bytes
    [6000h,1] Digital in byte 1: counter of digital data received
    [6000h,2] Digital in byte 2: counter of analog data received
    [6000h,3] Digital in byte 3: copy/echo of [6200h,3] Digital out byte 3
    [6000h,4] Digital in byte 4: copy/echo of [6200h,4] Digital out byte 4
0x283 - TPDO2 - Two 16-bit analog inputs.
    [6401h,1] Analog out word16 1: timer with hi byte seconds and lo byte quarter seconds
    [6401h,2] Analog out word16 2: copy/echo of [6411h,2] Analog out word16 2

Messages consumed (by CAN ID):
0x000 - NMT Master command message
0x701 - HBCon - Heartbeat consumer node 1 (after configiration through manager)
In operatinal state:
0x203 - RPDO1 - Four bytes of digital outputs. 
0x303 - RPDO2 - Two 16-bit analog outputs.

User can use a CAN monitor (USB CAN analysis) to probe the CAN frame transfered.
- CANL in CAN USB analysis connected with CANL in two board by shunt-wound method.
- CANH in CAN USB analysis connected with CANH in two board by shunt-wound method.
- (optinal) GND in CAN USB analysis connected with GND in two board by shunt-wound method.

SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Two mini/micro USB cables
- Two EVKB-IMXRT1064 boards with J11 pin header connector populated
- CAN cabling with pin header female connectors 
- Personal Computer

Board settings
==============
The example requires 2 sets of boards, each of them with the J11 header pin connector populated.
Using dupont wires, connect all 3 pins of both boards with each other.
Pin 1 to pin 1 (CAN_Hi), pin 2 to pin 2 (GND) and pin 3 to pin 3 (CAN_Lo).

Prepare the Demo
================
1. Connect a USB cable between the PC host and the OpenSDA USB on the board.
2. Open a serial terminal on PC for OpenSDA serial device with these settings:
   - 115200 baud rate
   - 8 data bits
   - No parity
   - One stop bit
   - No flow control
3. Download the mco_slave program to one target board.
4. Download the mco_manager program to the other target board.

Running the demo
================
1. First press the reset button on the board with the mco_slave example
2. Second press the reset button on the board with the mco_manager example

~~~~~~~~~~~~~~~~~~~~~
The terminal connected to the mco_manager example displays similar like that:

Starting CANopen FD Library manager example
Provided by EmSA - www.em-sa.com/nxp

CANopen FD Library Event - Reset Communication, nominal bitrate 500kbps, data bitrate 2000kbps, node id 1
CANopen FD Library Event - NMT Change: 0x 0 boot 
CANopen FD Library Event - NMT Change: 0x 5 operational 
CANopen FD Manager Event - Node Status Change: 3, 0x 0 booted 
CANopen FD Manager Event - Node Status Change: 3, 0x81 emergency over / reset 
CANopen FD Manager Event - Node Status Change: 3, 0xA0 scan complete
 [1000,01]:   F0191 [1018,01]:AF0002DC [1018,02]:C0DE0020
CANopen FD Manager Event - Node Status Change: 3, 0x 5 operational 
CANopen FD Manager Event - Node Status Change: 3, 0x90 heartbeat monitoring active 
CANopen FD Manager USDO Client Complete: node 3
 [1008,00]:CANopenLibNXPSDK CiA401-B/F Example
 

The terminal connected to the mco_slave example displays similar like that:

Starting CANopen FD Library slave example
Provided by EmSA - www.em-sa.com/nxp

CANopen FD Library Event - Reset Communication, nominal bitrate 500kbps, data bitrate 2000kbps, node id 3
CANopen FD Library Event - NMT Change: 0x 0 boot
CANopen FD Library Event - NMT Change: 0x7F pre-operational
CANopen FD Library Event - NMT Change: 0x7F pre-operational
CANopen FD Library Event - NMT Change: 0x 5 operational
~~~~~~~~~~~~~~~~~~~~~
