Overview
========
The lpi2c_probe example scans the I2C bus to find which adresses are in use
similar to how the i2cdetect tool works in Linux.

An XX in the table indicate that something responded on address XX.
An -- in the table indicate that nothing responded.

As of rev A of both iMXRT1064 uCOM Board and uCOM Carrier Board the
following addresses are expected to be found:

I2C-A, 0x38 - touch controller on the display (if connected)
I2C-A, 0x52 - I2C-E2PROM used to get MAC adress for the Ethernet PHY (on adapter board)
I2C-A, 0x53 - I2C-E2PROM used to get MAC adress for the Ethernet PHY (on uCOM board)
I2C-A, 0x61 - I2C PWM GPIO Expander, PCA9530
I2C-B, 0x21 - I2C GPIO Expander, PCA6416


Toolchain supported
===================
- IAR embedded Workbench  9.10.2
- Keil MDK  5.34
- GCC ARM Embedded  10.2.1
- MCUXpresso  11.4.0

Hardware requirements
=====================
- Micro USB cable
- iMXRT1064 uCOM Developer's Kit

Board settings
==============

Prepare the Demo
================
1. Connect a micro USB cable between the PC host and the J29 USB port on the board.
2.  Open a serial terminal with the following settings:
   - 115200 baud rate
   - 8 data bits
   - No parity
   - One stop bit
   - No flow control
3. Download the program to the target board.
4. Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
When the example runs successfully, the following message is displayed in the terminal:

~~~~~~~~~~~~~~~~~~~~~
LPI2C probe example.

Probing I2C-A (I2C1)
     0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f
00:          -- -- -- -- -- -- -- -- -- -- -- -- --
10: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
20: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
30: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
40: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
50: -- -- -- 53 -- -- -- -- -- -- -- -- -- -- -- --
60: -- 61 -- -- -- -- -- -- -- -- -- -- -- -- -- --
70: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

Probing I2C-B (I2C2)
     0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f
00:          -- -- -- -- -- -- -- -- -- -- -- -- --
10: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
20: -- 21 -- -- -- -- -- -- -- -- -- -- -- -- -- --
30: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
40: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
50: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
60: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
70: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
DONE

End of LPI2C example .
~~~~~~~~~~~~~~~~~~~~~
