
This SDK has been patched by Embedded Artists for the iMXRT1064 Developer's Kit.
The SDK was released on 2024-03-25 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1064xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Correction of the VDD_SOC_IN voltage.
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using a display have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed reset pin for SD card examples

This has been added:
* LWIP projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AWS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AzureRTOS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* I2C probe example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1064.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work


Connectors:
* J29 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
THIS PROJECT IS NOT DIRECTLY COMPATIBLE WITH THE HARDWARE AND WILL NOT WORK.

The CSI interface needed for camera support is not available on the iMXRT1064 uCOM connector
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
Demonstrates inference for models compiled using the GLOW AOT tool and uses
a camera to generate data for inferencing.

The network used in this is based on the CIFAR-10 example in Caffe2 [1] & [2].

[1] https://github.com/caffe2/tutorials/blob/master/CIFAR10_Part1.ipynb
[2] https://github.com/caffe2/tutorials/blob/master/CIFAR10_Part2.ipynb


The neural network consists of 3 convolution layers interspersed by
ReLU activation and max pooling layers, followed by a fully-connected layer
at the end. The input to the network is a 32x32 pixel color image extracted 
from camera data, which will be classified into one of the 10 output classes.

This project does not include the pre-trained model or the training script
since Caffe2 framework is deprecated and lately has become part of PyTorch.
This project example only includes the bundle (binary) generated after running
the Glow AOT tool and is intended to be used as-is. The Glow bundle is the same as the
"glow_cifar10" MCUXpresso SDK example in the SDK. See that project's readme.txt
 for more details on model generation. 

 If you want a step-by-step example of running the Glow AOT tool for a given model 
 take a look at the LeNet MNIST Glow example and the Glow Getting Started Lab:
 https://community.nxp.com/t5/eIQ-Machine-Learning-Software/eIQ-Glow-Lab-for-i-MX-RT/ta-p/1123119


Toolchains supported
- MCUXpresso IDE
- IAR Embedded Workbench for ARM
- Keil uVision MDK
- ArmGCC - GNU Tools ARM Embedded



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- EVK-MIMXRT1064 board
- FRMD-STBC-AGM01
- Personal computer

Board settings
==============
Plug FRMD-STBC-AGM01 kit to arduino connector (J22, J23, J24, J25).
Put jumper J5 to 3-2 position.

Prepare the Demo
================
1. Connect a USB cable between the host PC and the OpenSDA USB port on the target board. 
2. Open a serial terminal with the following settings:
   - 115200 baud rate
   - 8 data bits
   - No parity
   - One stop bit
   - No flow control
3. Download the program to the target board.
4. Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
Use the LCD screen to point the camera at images of airplanes, ships, deer, frogs, cars, and other 
images that can be categorized by CIFAR10. Some images will work better than others, and a few example
images have been provided in the PDF in the /doc folder. For best results, the flashing selection rectangle should 
be centered on the image and nearly (but not completely) fill up the whole rectangle. The camera should be stabilized with your finger
or by some other means to prevent shaking. Also ensure the camera lens has been focused as described in the instructions
when connecting the camera and LCD 
(https://community.nxp.com/t5/i-MX-RT-Knowledge-Base/Connecting-camera-and-LCD-to-i-MX-RT-EVKs/tac-p/1122184). 

You will see the result of the inference on the LCD screen as well as the serial terminal. The result printed
on the LCD screen has a minimum threshold applied to it. 
